/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.datazone;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.datazone.CfnConnection;
import software.amazon.awscdk.services.datazone.CfnConnectionProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_datazone.CfnConnection")
public class CfnConnection
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnConnection.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnConnection(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnConnection(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnConnection(@NotNull Construct scope, @NotNull String id, @NotNull CfnConnectionProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrConnectionId() {
        return (String)Kernel.get((Object)this, (String)"attrConnectionId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrDomainId() {
        return (String)Kernel.get((Object)this, (String)"attrDomainId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrDomainUnitId() {
        return (String)Kernel.get((Object)this, (String)"attrDomainUnitId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrEnvironmentId() {
        return (String)Kernel.get((Object)this, (String)"attrEnvironmentId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrEnvironmentUserRole() {
        return (String)Kernel.get((Object)this, (String)"attrEnvironmentUserRole", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrProjectId() {
        return (String)Kernel.get((Object)this, (String)"attrProjectId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrType() {
        return (String)Kernel.get((Object)this, (String)"attrType", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public String getDomainIdentifier() {
        return (String)Kernel.get((Object)this, (String)"domainIdentifier", (NativeType)NativeType.forClass(String.class));
    }

    public void setDomainIdentifier(@NotNull String value) {
        Kernel.set((Object)this, (String)"domainIdentifier", (Object)Objects.requireNonNull(value, "domainIdentifier is required"));
    }

    @NotNull
    public String getEnvironmentIdentifier() {
        return (String)Kernel.get((Object)this, (String)"environmentIdentifier", (NativeType)NativeType.forClass(String.class));
    }

    public void setEnvironmentIdentifier(@NotNull String value) {
        Kernel.set((Object)this, (String)"environmentIdentifier", (Object)Objects.requireNonNull(value, "environmentIdentifier is required"));
    }

    @NotNull
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@NotNull String value) {
        Kernel.set((Object)this, (String)"name", (Object)Objects.requireNonNull(value, "name is required"));
    }

    @Nullable
    public Object getAwsLocation() {
        return Kernel.get((Object)this, (String)"awsLocation", (NativeType)NativeType.forClass(Object.class));
    }

    public void setAwsLocation(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"awsLocation", (Object)value);
    }

    public void setAwsLocation(@Nullable AwsLocationProperty value) {
        Kernel.set((Object)this, (String)"awsLocation", (Object)value);
    }

    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)this, (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@Nullable String value) {
        Kernel.set((Object)this, (String)"description", (Object)value);
    }

    @Nullable
    public Object getProps() {
        return Kernel.get((Object)this, (String)"props", (NativeType)NativeType.forClass(Object.class));
    }

    public void setProps(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"props", (Object)value);
    }

    public void setProps(@Nullable ConnectionPropertiesInputProperty value) {
        Kernel.set((Object)this, (String)"props", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnConnection> {
        private final Construct scope;
        private final String id;
        private final CfnConnectionProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnConnectionProps.Builder();
        }

        public Builder domainIdentifier(String domainIdentifier) {
            this.props.domainIdentifier(domainIdentifier);
            return this;
        }

        public Builder environmentIdentifier(String environmentIdentifier) {
            this.props.environmentIdentifier(environmentIdentifier);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder awsLocation(IResolvable awsLocation) {
            this.props.awsLocation(awsLocation);
            return this;
        }

        public Builder awsLocation(AwsLocationProperty awsLocation) {
            this.props.awsLocation(awsLocation);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder props(IResolvable props) {
            this.props.props(props);
            return this;
        }

        public Builder props(ConnectionPropertiesInputProperty props) {
            this.props.props(props);
            return this;
        }

        public CfnConnection build() {
            return new CfnConnection(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_datazone.CfnConnection.UsernamePasswordProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface UsernamePasswordProperty
    extends JsiiSerializable {
        @NotNull
        public String getPassword();

        @NotNull
        public String getUsername();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<UsernamePasswordProperty> {
            String password;
            String username;

            public Builder password(String password) {
                this.password = password;
                return this;
            }

            public Builder username(String username) {
                this.username = username;
                return this;
            }

            public UsernamePasswordProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_datazone.CfnConnection.SparkGluePropertiesInputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SparkGluePropertiesInputProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAdditionalArgs() {
            return null;
        }

        @Nullable
        default public String getGlueConnectionName() {
            return null;
        }

        @Nullable
        default public String getGlueVersion() {
            return null;
        }

        @Nullable
        default public Number getIdleTimeout() {
            return null;
        }

        @Nullable
        default public String getJavaVirtualEnv() {
            return null;
        }

        @Nullable
        default public Number getNumberOfWorkers() {
            return null;
        }

        @Nullable
        default public String getPythonVirtualEnv() {
            return null;
        }

        @Nullable
        default public String getWorkerType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SparkGluePropertiesInputProperty> {
            Object additionalArgs;
            String glueConnectionName;
            String glueVersion;
            Number idleTimeout;
            String javaVirtualEnv;
            Number numberOfWorkers;
            String pythonVirtualEnv;
            String workerType;

            public Builder additionalArgs(IResolvable additionalArgs) {
                this.additionalArgs = additionalArgs;
                return this;
            }

            public Builder additionalArgs(SparkGlueArgsProperty additionalArgs) {
                this.additionalArgs = additionalArgs;
                return this;
            }

            public Builder glueConnectionName(String glueConnectionName) {
                this.glueConnectionName = glueConnectionName;
                return this;
            }

            public Builder glueVersion(String glueVersion) {
                this.glueVersion = glueVersion;
                return this;
            }

            public Builder idleTimeout(Number idleTimeout) {
                this.idleTimeout = idleTimeout;
                return this;
            }

            public Builder javaVirtualEnv(String javaVirtualEnv) {
                this.javaVirtualEnv = javaVirtualEnv;
                return this;
            }

            public Builder numberOfWorkers(Number numberOfWorkers) {
                this.numberOfWorkers = numberOfWorkers;
                return this;
            }

            public Builder pythonVirtualEnv(String pythonVirtualEnv) {
                this.pythonVirtualEnv = pythonVirtualEnv;
                return this;
            }

            public Builder workerType(String workerType) {
                this.workerType = workerType;
                return this;
            }

            public SparkGluePropertiesInputProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_datazone.CfnConnection.SparkGlueArgsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SparkGlueArgsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getConnection() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SparkGlueArgsProperty> {
            String connection;

            public Builder connection(String connection) {
                this.connection = connection;
                return this;
            }

            public SparkGlueArgsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_datazone.CfnConnection.SparkEmrPropertiesInputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SparkEmrPropertiesInputProperty
    extends JsiiSerializable {
        @Nullable
        default public String getComputeArn() {
            return null;
        }

        @Nullable
        default public String getInstanceProfileArn() {
            return null;
        }

        @Nullable
        default public String getJavaVirtualEnv() {
            return null;
        }

        @Nullable
        default public String getLogUri() {
            return null;
        }

        @Nullable
        default public String getPythonVirtualEnv() {
            return null;
        }

        @Nullable
        default public String getRuntimeRole() {
            return null;
        }

        @Nullable
        default public String getTrustedCertificatesS3Uri() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SparkEmrPropertiesInputProperty> {
            String computeArn;
            String instanceProfileArn;
            String javaVirtualEnv;
            String logUri;
            String pythonVirtualEnv;
            String runtimeRole;
            String trustedCertificatesS3Uri;

            public Builder computeArn(String computeArn) {
                this.computeArn = computeArn;
                return this;
            }

            public Builder instanceProfileArn(String instanceProfileArn) {
                this.instanceProfileArn = instanceProfileArn;
                return this;
            }

            public Builder javaVirtualEnv(String javaVirtualEnv) {
                this.javaVirtualEnv = javaVirtualEnv;
                return this;
            }

            public Builder logUri(String logUri) {
                this.logUri = logUri;
                return this;
            }

            public Builder pythonVirtualEnv(String pythonVirtualEnv) {
                this.pythonVirtualEnv = pythonVirtualEnv;
                return this;
            }

            public Builder runtimeRole(String runtimeRole) {
                this.runtimeRole = runtimeRole;
                return this;
            }

            public Builder trustedCertificatesS3Uri(String trustedCertificatesS3Uri) {
                this.trustedCertificatesS3Uri = trustedCertificatesS3Uri;
                return this;
            }

            public SparkEmrPropertiesInputProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_datazone.CfnConnection.RedshiftStoragePropertiesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RedshiftStoragePropertiesProperty
    extends JsiiSerializable {
        @Nullable
        default public String getClusterName() {
            return null;
        }

        @Nullable
        default public String getWorkgroupName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RedshiftStoragePropertiesProperty> {
            String clusterName;
            String workgroupName;

            public Builder clusterName(String clusterName) {
                this.clusterName = clusterName;
                return this;
            }

            public Builder workgroupName(String workgroupName) {
                this.workgroupName = workgroupName;
                return this;
            }

            public RedshiftStoragePropertiesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_datazone.CfnConnection.RedshiftPropertiesInputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RedshiftPropertiesInputProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCredentials() {
            return null;
        }

        @Nullable
        default public String getDatabaseName() {
            return null;
        }

        @Nullable
        default public String getHost() {
            return null;
        }

        @Nullable
        default public Object getLineageSync() {
            return null;
        }

        @Nullable
        default public Number getPort() {
            return null;
        }

        @Nullable
        default public Object getStorage() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RedshiftPropertiesInputProperty> {
            Object credentials;
            String databaseName;
            String host;
            Object lineageSync;
            Number port;
            Object storage;

            public Builder credentials(IResolvable credentials) {
                this.credentials = credentials;
                return this;
            }

            public Builder credentials(RedshiftCredentialsProperty credentials) {
                this.credentials = credentials;
                return this;
            }

            public Builder databaseName(String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            public Builder host(String host) {
                this.host = host;
                return this;
            }

            public Builder lineageSync(IResolvable lineageSync) {
                this.lineageSync = lineageSync;
                return this;
            }

            public Builder lineageSync(RedshiftLineageSyncConfigurationInputProperty lineageSync) {
                this.lineageSync = lineageSync;
                return this;
            }

            public Builder port(Number port) {
                this.port = port;
                return this;
            }

            public Builder storage(IResolvable storage) {
                this.storage = storage;
                return this;
            }

            public Builder storage(RedshiftStoragePropertiesProperty storage) {
                this.storage = storage;
                return this;
            }

            public RedshiftPropertiesInputProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_datazone.CfnConnection.RedshiftLineageSyncConfigurationInputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RedshiftLineageSyncConfigurationInputProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getEnabled() {
            return null;
        }

        @Nullable
        default public Object getSchedule() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RedshiftLineageSyncConfigurationInputProperty> {
            Object enabled;
            Object schedule;

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder schedule(IResolvable schedule) {
                this.schedule = schedule;
                return this;
            }

            public Builder schedule(LineageSyncScheduleProperty schedule) {
                this.schedule = schedule;
                return this;
            }

            public RedshiftLineageSyncConfigurationInputProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_datazone.CfnConnection.RedshiftCredentialsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RedshiftCredentialsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getSecretArn() {
            return null;
        }

        @Nullable
        default public Object getUsernamePassword() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RedshiftCredentialsProperty> {
            String secretArn;
            Object usernamePassword;

            public Builder secretArn(String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            public Builder usernamePassword(IResolvable usernamePassword) {
                this.usernamePassword = usernamePassword;
                return this;
            }

            public Builder usernamePassword(UsernamePasswordProperty usernamePassword) {
                this.usernamePassword = usernamePassword;
                return this;
            }

            public RedshiftCredentialsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_datazone.CfnConnection.PhysicalConnectionRequirementsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PhysicalConnectionRequirementsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAvailabilityZone() {
            return null;
        }

        @Nullable
        default public List<String> getSecurityGroupIdList() {
            return null;
        }

        @Nullable
        default public String getSubnetId() {
            return null;
        }

        @Nullable
        default public List<String> getSubnetIdList() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PhysicalConnectionRequirementsProperty> {
            String availabilityZone;
            List<String> securityGroupIdList;
            String subnetId;
            List<String> subnetIdList;

            public Builder availabilityZone(String availabilityZone) {
                this.availabilityZone = availabilityZone;
                return this;
            }

            public Builder securityGroupIdList(List<String> securityGroupIdList) {
                this.securityGroupIdList = securityGroupIdList;
                return this;
            }

            public Builder subnetId(String subnetId) {
                this.subnetId = subnetId;
                return this;
            }

            public Builder subnetIdList(List<String> subnetIdList) {
                this.subnetIdList = subnetIdList;
                return this;
            }

            public PhysicalConnectionRequirementsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_datazone.CfnConnection.OAuth2PropertiesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OAuth2PropertiesProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAuthorizationCodeProperties() {
            return null;
        }

        @Nullable
        default public Object getOAuth2ClientApplication() {
            return null;
        }

        @Nullable
        default public Object getOAuth2Credentials() {
            return null;
        }

        @Nullable
        default public String getOAuth2GrantType() {
            return null;
        }

        @Nullable
        default public String getTokenUrl() {
            return null;
        }

        @Nullable
        default public Object getTokenUrlParametersMap() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OAuth2PropertiesProperty> {
            Object authorizationCodeProperties;
            Object oAuth2ClientApplication;
            Object oAuth2Credentials;
            String oAuth2GrantType;
            String tokenUrl;
            Object tokenUrlParametersMap;

            public Builder authorizationCodeProperties(IResolvable authorizationCodeProperties) {
                this.authorizationCodeProperties = authorizationCodeProperties;
                return this;
            }

            public Builder authorizationCodeProperties(AuthorizationCodePropertiesProperty authorizationCodeProperties) {
                this.authorizationCodeProperties = authorizationCodeProperties;
                return this;
            }

            public Builder oAuth2ClientApplication(IResolvable oAuth2ClientApplication) {
                this.oAuth2ClientApplication = oAuth2ClientApplication;
                return this;
            }

            public Builder oAuth2ClientApplication(OAuth2ClientApplicationProperty oAuth2ClientApplication) {
                this.oAuth2ClientApplication = oAuth2ClientApplication;
                return this;
            }

            public Builder oAuth2Credentials(IResolvable oAuth2Credentials) {
                this.oAuth2Credentials = oAuth2Credentials;
                return this;
            }

            public Builder oAuth2Credentials(GlueOAuth2CredentialsProperty oAuth2Credentials) {
                this.oAuth2Credentials = oAuth2Credentials;
                return this;
            }

            public Builder oAuth2GrantType(String oAuth2GrantType) {
                this.oAuth2GrantType = oAuth2GrantType;
                return this;
            }

            public Builder tokenUrl(String tokenUrl) {
                this.tokenUrl = tokenUrl;
                return this;
            }

            public Builder tokenUrlParametersMap(Map<String, String> tokenUrlParametersMap) {
                this.tokenUrlParametersMap = tokenUrlParametersMap;
                return this;
            }

            public Builder tokenUrlParametersMap(IResolvable tokenUrlParametersMap) {
                this.tokenUrlParametersMap = tokenUrlParametersMap;
                return this;
            }

            public OAuth2PropertiesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_datazone.CfnConnection.OAuth2ClientApplicationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OAuth2ClientApplicationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAwsManagedClientApplicationReference() {
            return null;
        }

        @Nullable
        default public String getUserManagedClientApplicationClientId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OAuth2ClientApplicationProperty> {
            String awsManagedClientApplicationReference;
            String userManagedClientApplicationClientId;

            public Builder awsManagedClientApplicationReference(String awsManagedClientApplicationReference) {
                this.awsManagedClientApplicationReference = awsManagedClientApplicationReference;
                return this;
            }

            public Builder userManagedClientApplicationClientId(String userManagedClientApplicationClientId) {
                this.userManagedClientApplicationClientId = userManagedClientApplicationClientId;
                return this;
            }

            public OAuth2ClientApplicationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_datazone.CfnConnection.LineageSyncScheduleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LineageSyncScheduleProperty
    extends JsiiSerializable {
        @Nullable
        default public String getSchedule() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LineageSyncScheduleProperty> {
            String schedule;

            public Builder schedule(String schedule) {
                this.schedule = schedule;
                return this;
            }

            public LineageSyncScheduleProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_datazone.CfnConnection.IamPropertiesInputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IamPropertiesInputProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getGlueLineageSyncEnabled() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<IamPropertiesInputProperty> {
            Object glueLineageSyncEnabled;

            public Builder glueLineageSyncEnabled(Boolean glueLineageSyncEnabled) {
                this.glueLineageSyncEnabled = glueLineageSyncEnabled;
                return this;
            }

            public Builder glueLineageSyncEnabled(IResolvable glueLineageSyncEnabled) {
                this.glueLineageSyncEnabled = glueLineageSyncEnabled;
                return this;
            }

            public IamPropertiesInputProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_datazone.CfnConnection.HyperPodPropertiesInputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HyperPodPropertiesInputProperty
    extends JsiiSerializable {
        @NotNull
        public String getClusterName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HyperPodPropertiesInputProperty> {
            String clusterName;

            public Builder clusterName(String clusterName) {
                this.clusterName = clusterName;
                return this;
            }

            public HyperPodPropertiesInputProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_datazone.CfnConnection.GluePropertiesInputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GluePropertiesInputProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getGlueConnectionInput() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GluePropertiesInputProperty> {
            Object glueConnectionInput;

            public Builder glueConnectionInput(IResolvable glueConnectionInput) {
                this.glueConnectionInput = glueConnectionInput;
                return this;
            }

            public Builder glueConnectionInput(GlueConnectionInputProperty glueConnectionInput) {
                this.glueConnectionInput = glueConnectionInput;
                return this;
            }

            public GluePropertiesInputProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_datazone.CfnConnection.GlueOAuth2CredentialsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GlueOAuth2CredentialsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAccessToken() {
            return null;
        }

        @Nullable
        default public String getJwtToken() {
            return null;
        }

        @Nullable
        default public String getRefreshToken() {
            return null;
        }

        @Nullable
        default public String getUserManagedClientApplicationClientSecret() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GlueOAuth2CredentialsProperty> {
            String accessToken;
            String jwtToken;
            String refreshToken;
            String userManagedClientApplicationClientSecret;

            public Builder accessToken(String accessToken) {
                this.accessToken = accessToken;
                return this;
            }

            public Builder jwtToken(String jwtToken) {
                this.jwtToken = jwtToken;
                return this;
            }

            public Builder refreshToken(String refreshToken) {
                this.refreshToken = refreshToken;
                return this;
            }

            public Builder userManagedClientApplicationClientSecret(String userManagedClientApplicationClientSecret) {
                this.userManagedClientApplicationClientSecret = userManagedClientApplicationClientSecret;
                return this;
            }

            public GlueOAuth2CredentialsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_datazone.CfnConnection.GlueConnectionInputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GlueConnectionInputProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAthenaProperties() {
            return null;
        }

        @Nullable
        default public Object getAuthenticationConfiguration() {
            return null;
        }

        @Nullable
        default public Object getConnectionProperties() {
            return null;
        }

        @Nullable
        default public String getConnectionType() {
            return null;
        }

        @Nullable
        default public String getDescription() {
            return null;
        }

        @Nullable
        default public String getMatchCriteria() {
            return null;
        }

        @Nullable
        default public String getName() {
            return null;
        }

        @Nullable
        default public Object getPhysicalConnectionRequirements() {
            return null;
        }

        @Nullable
        default public Object getPythonProperties() {
            return null;
        }

        @Nullable
        default public Object getSparkProperties() {
            return null;
        }

        @Nullable
        default public Object getValidateCredentials() {
            return null;
        }

        @Nullable
        default public List<String> getValidateForComputeEnvironments() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GlueConnectionInputProperty> {
            Object athenaProperties;
            Object authenticationConfiguration;
            Object connectionProperties;
            String connectionType;
            String description;
            String matchCriteria;
            String name;
            Object physicalConnectionRequirements;
            Object pythonProperties;
            Object sparkProperties;
            Object validateCredentials;
            List<String> validateForComputeEnvironments;

            public Builder athenaProperties(Map<String, String> athenaProperties) {
                this.athenaProperties = athenaProperties;
                return this;
            }

            public Builder athenaProperties(IResolvable athenaProperties) {
                this.athenaProperties = athenaProperties;
                return this;
            }

            public Builder authenticationConfiguration(IResolvable authenticationConfiguration) {
                this.authenticationConfiguration = authenticationConfiguration;
                return this;
            }

            public Builder authenticationConfiguration(AuthenticationConfigurationInputProperty authenticationConfiguration) {
                this.authenticationConfiguration = authenticationConfiguration;
                return this;
            }

            public Builder connectionProperties(Map<String, String> connectionProperties) {
                this.connectionProperties = connectionProperties;
                return this;
            }

            public Builder connectionProperties(IResolvable connectionProperties) {
                this.connectionProperties = connectionProperties;
                return this;
            }

            public Builder connectionType(String connectionType) {
                this.connectionType = connectionType;
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder matchCriteria(String matchCriteria) {
                this.matchCriteria = matchCriteria;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder physicalConnectionRequirements(IResolvable physicalConnectionRequirements) {
                this.physicalConnectionRequirements = physicalConnectionRequirements;
                return this;
            }

            public Builder physicalConnectionRequirements(PhysicalConnectionRequirementsProperty physicalConnectionRequirements) {
                this.physicalConnectionRequirements = physicalConnectionRequirements;
                return this;
            }

            public Builder pythonProperties(Map<String, String> pythonProperties) {
                this.pythonProperties = pythonProperties;
                return this;
            }

            public Builder pythonProperties(IResolvable pythonProperties) {
                this.pythonProperties = pythonProperties;
                return this;
            }

            public Builder sparkProperties(Map<String, String> sparkProperties) {
                this.sparkProperties = sparkProperties;
                return this;
            }

            public Builder sparkProperties(IResolvable sparkProperties) {
                this.sparkProperties = sparkProperties;
                return this;
            }

            public Builder validateCredentials(Boolean validateCredentials) {
                this.validateCredentials = validateCredentials;
                return this;
            }

            public Builder validateCredentials(IResolvable validateCredentials) {
                this.validateCredentials = validateCredentials;
                return this;
            }

            public Builder validateForComputeEnvironments(List<String> validateForComputeEnvironments) {
                this.validateForComputeEnvironments = validateForComputeEnvironments;
                return this;
            }

            public GlueConnectionInputProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_datazone.CfnConnection.ConnectionPropertiesInputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConnectionPropertiesInputProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAthenaProperties() {
            return null;
        }

        @Nullable
        default public Object getGlueProperties() {
            return null;
        }

        @Nullable
        default public Object getHyperPodProperties() {
            return null;
        }

        @Nullable
        default public Object getIamProperties() {
            return null;
        }

        @Nullable
        default public Object getRedshiftProperties() {
            return null;
        }

        @Nullable
        default public Object getSparkEmrProperties() {
            return null;
        }

        @Nullable
        default public Object getSparkGlueProperties() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConnectionPropertiesInputProperty> {
            Object athenaProperties;
            Object glueProperties;
            Object hyperPodProperties;
            Object iamProperties;
            Object redshiftProperties;
            Object sparkEmrProperties;
            Object sparkGlueProperties;

            public Builder athenaProperties(IResolvable athenaProperties) {
                this.athenaProperties = athenaProperties;
                return this;
            }

            public Builder athenaProperties(AthenaPropertiesInputProperty athenaProperties) {
                this.athenaProperties = athenaProperties;
                return this;
            }

            public Builder glueProperties(IResolvable glueProperties) {
                this.glueProperties = glueProperties;
                return this;
            }

            public Builder glueProperties(GluePropertiesInputProperty glueProperties) {
                this.glueProperties = glueProperties;
                return this;
            }

            public Builder hyperPodProperties(IResolvable hyperPodProperties) {
                this.hyperPodProperties = hyperPodProperties;
                return this;
            }

            public Builder hyperPodProperties(HyperPodPropertiesInputProperty hyperPodProperties) {
                this.hyperPodProperties = hyperPodProperties;
                return this;
            }

            public Builder iamProperties(IResolvable iamProperties) {
                this.iamProperties = iamProperties;
                return this;
            }

            public Builder iamProperties(IamPropertiesInputProperty iamProperties) {
                this.iamProperties = iamProperties;
                return this;
            }

            public Builder redshiftProperties(IResolvable redshiftProperties) {
                this.redshiftProperties = redshiftProperties;
                return this;
            }

            public Builder redshiftProperties(RedshiftPropertiesInputProperty redshiftProperties) {
                this.redshiftProperties = redshiftProperties;
                return this;
            }

            public Builder sparkEmrProperties(IResolvable sparkEmrProperties) {
                this.sparkEmrProperties = sparkEmrProperties;
                return this;
            }

            public Builder sparkEmrProperties(SparkEmrPropertiesInputProperty sparkEmrProperties) {
                this.sparkEmrProperties = sparkEmrProperties;
                return this;
            }

            public Builder sparkGlueProperties(IResolvable sparkGlueProperties) {
                this.sparkGlueProperties = sparkGlueProperties;
                return this;
            }

            public Builder sparkGlueProperties(SparkGluePropertiesInputProperty sparkGlueProperties) {
                this.sparkGlueProperties = sparkGlueProperties;
                return this;
            }

            public ConnectionPropertiesInputProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_datazone.CfnConnection.BasicAuthenticationCredentialsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BasicAuthenticationCredentialsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getPassword() {
            return null;
        }

        @Nullable
        default public String getUserName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BasicAuthenticationCredentialsProperty> {
            String password;
            String userName;

            public Builder password(String password) {
                this.password = password;
                return this;
            }

            public Builder userName(String userName) {
                this.userName = userName;
                return this;
            }

            public BasicAuthenticationCredentialsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_datazone.CfnConnection.AwsLocationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AwsLocationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAccessRole() {
            return null;
        }

        @Nullable
        default public String getAwsAccountId() {
            return null;
        }

        @Nullable
        default public String getAwsRegion() {
            return null;
        }

        @Nullable
        default public String getIamConnectionId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AwsLocationProperty> {
            String accessRole;
            String awsAccountId;
            String awsRegion;
            String iamConnectionId;

            public Builder accessRole(String accessRole) {
                this.accessRole = accessRole;
                return this;
            }

            public Builder awsAccountId(String awsAccountId) {
                this.awsAccountId = awsAccountId;
                return this;
            }

            public Builder awsRegion(String awsRegion) {
                this.awsRegion = awsRegion;
                return this;
            }

            public Builder iamConnectionId(String iamConnectionId) {
                this.iamConnectionId = iamConnectionId;
                return this;
            }

            public AwsLocationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_datazone.CfnConnection.AuthorizationCodePropertiesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AuthorizationCodePropertiesProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAuthorizationCode() {
            return null;
        }

        @Nullable
        default public String getRedirectUri() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AuthorizationCodePropertiesProperty> {
            String authorizationCode;
            String redirectUri;

            public Builder authorizationCode(String authorizationCode) {
                this.authorizationCode = authorizationCode;
                return this;
            }

            public Builder redirectUri(String redirectUri) {
                this.redirectUri = redirectUri;
                return this;
            }

            public AuthorizationCodePropertiesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_datazone.CfnConnection.AuthenticationConfigurationInputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AuthenticationConfigurationInputProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAuthenticationType() {
            return null;
        }

        @Nullable
        default public Object getBasicAuthenticationCredentials() {
            return null;
        }

        @Nullable
        default public Object getCustomAuthenticationCredentials() {
            return null;
        }

        @Nullable
        default public String getKmsKeyArn() {
            return null;
        }

        @Nullable
        default public Object getOAuth2Properties() {
            return null;
        }

        @Nullable
        default public String getSecretArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AuthenticationConfigurationInputProperty> {
            String authenticationType;
            Object basicAuthenticationCredentials;
            Object customAuthenticationCredentials;
            String kmsKeyArn;
            Object oAuth2Properties;
            String secretArn;

            public Builder authenticationType(String authenticationType) {
                this.authenticationType = authenticationType;
                return this;
            }

            public Builder basicAuthenticationCredentials(IResolvable basicAuthenticationCredentials) {
                this.basicAuthenticationCredentials = basicAuthenticationCredentials;
                return this;
            }

            public Builder basicAuthenticationCredentials(BasicAuthenticationCredentialsProperty basicAuthenticationCredentials) {
                this.basicAuthenticationCredentials = basicAuthenticationCredentials;
                return this;
            }

            public Builder customAuthenticationCredentials(Map<String, String> customAuthenticationCredentials) {
                this.customAuthenticationCredentials = customAuthenticationCredentials;
                return this;
            }

            public Builder customAuthenticationCredentials(IResolvable customAuthenticationCredentials) {
                this.customAuthenticationCredentials = customAuthenticationCredentials;
                return this;
            }

            public Builder kmsKeyArn(String kmsKeyArn) {
                this.kmsKeyArn = kmsKeyArn;
                return this;
            }

            public Builder oAuth2Properties(IResolvable oAuth2Properties) {
                this.oAuth2Properties = oAuth2Properties;
                return this;
            }

            public Builder oAuth2Properties(OAuth2PropertiesProperty oAuth2Properties) {
                this.oAuth2Properties = oAuth2Properties;
                return this;
            }

            public Builder secretArn(String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            public AuthenticationConfigurationInputProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_datazone.CfnConnection.AthenaPropertiesInputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AthenaPropertiesInputProperty
    extends JsiiSerializable {
        @NotNull
        public String getWorkgroupName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AthenaPropertiesInputProperty> {
            String workgroupName;

            public Builder workgroupName(String workgroupName) {
                this.workgroupName = workgroupName;
                return this;
            }

            public AthenaPropertiesInputProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

