/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.glue;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.glue.CfnCrawler;
import software.amazon.awscdk.services.glue.CfnCrawlerProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_glue.CfnCrawler")
public class CfnCrawler
extends CfnResource
implements IInspectable,
ITaggable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnCrawler.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnCrawler(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCrawler(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnCrawler(@NotNull Construct scope, @NotNull String id, @NotNull CfnCrawlerProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @Override
    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public String getRole() {
        return (String)Kernel.get((Object)this, (String)"role", (NativeType)NativeType.forClass(String.class));
    }

    public void setRole(@NotNull String value) {
        Kernel.set((Object)this, (String)"role", (Object)Objects.requireNonNull(value, "role is required"));
    }

    @NotNull
    public Object getTargets() {
        return Kernel.get((Object)this, (String)"targets", (NativeType)NativeType.forClass(Object.class));
    }

    public void setTargets(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"targets", (Object)Objects.requireNonNull(value, "targets is required"));
    }

    public void setTargets(@NotNull TargetsProperty value) {
        Kernel.set((Object)this, (String)"targets", (Object)Objects.requireNonNull(value, "targets is required"));
    }

    @Nullable
    public List<String> getClassifiers() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"classifiers", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setClassifiers(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"classifiers", value);
    }

    @Nullable
    public String getConfiguration() {
        return (String)Kernel.get((Object)this, (String)"configuration", (NativeType)NativeType.forClass(String.class));
    }

    public void setConfiguration(@Nullable String value) {
        Kernel.set((Object)this, (String)"configuration", (Object)value);
    }

    @Nullable
    public String getCrawlerSecurityConfiguration() {
        return (String)Kernel.get((Object)this, (String)"crawlerSecurityConfiguration", (NativeType)NativeType.forClass(String.class));
    }

    public void setCrawlerSecurityConfiguration(@Nullable String value) {
        Kernel.set((Object)this, (String)"crawlerSecurityConfiguration", (Object)value);
    }

    @Nullable
    public String getDatabaseName() {
        return (String)Kernel.get((Object)this, (String)"databaseName", (NativeType)NativeType.forClass(String.class));
    }

    public void setDatabaseName(@Nullable String value) {
        Kernel.set((Object)this, (String)"databaseName", (Object)value);
    }

    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)this, (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@Nullable String value) {
        Kernel.set((Object)this, (String)"description", (Object)value);
    }

    @Nullable
    public Object getLakeFormationConfiguration() {
        return Kernel.get((Object)this, (String)"lakeFormationConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setLakeFormationConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"lakeFormationConfiguration", (Object)value);
    }

    public void setLakeFormationConfiguration(@Nullable LakeFormationConfigurationProperty value) {
        Kernel.set((Object)this, (String)"lakeFormationConfiguration", (Object)value);
    }

    @Nullable
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@Nullable String value) {
        Kernel.set((Object)this, (String)"name", (Object)value);
    }

    @Nullable
    public Object getRecrawlPolicy() {
        return Kernel.get((Object)this, (String)"recrawlPolicy", (NativeType)NativeType.forClass(Object.class));
    }

    public void setRecrawlPolicy(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"recrawlPolicy", (Object)value);
    }

    public void setRecrawlPolicy(@Nullable RecrawlPolicyProperty value) {
        Kernel.set((Object)this, (String)"recrawlPolicy", (Object)value);
    }

    @Nullable
    public Object getSchedule() {
        return Kernel.get((Object)this, (String)"schedule", (NativeType)NativeType.forClass(Object.class));
    }

    public void setSchedule(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"schedule", (Object)value);
    }

    public void setSchedule(@Nullable ScheduleProperty value) {
        Kernel.set((Object)this, (String)"schedule", (Object)value);
    }

    @Nullable
    public Object getSchemaChangePolicy() {
        return Kernel.get((Object)this, (String)"schemaChangePolicy", (NativeType)NativeType.forClass(Object.class));
    }

    public void setSchemaChangePolicy(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"schemaChangePolicy", (Object)value);
    }

    public void setSchemaChangePolicy(@Nullable SchemaChangePolicyProperty value) {
        Kernel.set((Object)this, (String)"schemaChangePolicy", (Object)value);
    }

    @Nullable
    public String getTablePrefix() {
        return (String)Kernel.get((Object)this, (String)"tablePrefix", (NativeType)NativeType.forClass(String.class));
    }

    public void setTablePrefix(@Nullable String value) {
        Kernel.set((Object)this, (String)"tablePrefix", (Object)value);
    }

    @Nullable
    public Object getTagsRaw() {
        return Kernel.get((Object)this, (String)"tagsRaw", (NativeType)NativeType.forClass(Object.class));
    }

    public void setTagsRaw(@Nullable Object value) {
        Kernel.set((Object)this, (String)"tagsRaw", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnCrawler> {
        private final Construct scope;
        private final String id;
        private final CfnCrawlerProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnCrawlerProps.Builder();
        }

        public Builder role(String role) {
            this.props.role(role);
            return this;
        }

        public Builder targets(IResolvable targets) {
            this.props.targets(targets);
            return this;
        }

        public Builder targets(TargetsProperty targets) {
            this.props.targets(targets);
            return this;
        }

        public Builder classifiers(List<String> classifiers) {
            this.props.classifiers(classifiers);
            return this;
        }

        public Builder configuration(String configuration) {
            this.props.configuration(configuration);
            return this;
        }

        public Builder crawlerSecurityConfiguration(String crawlerSecurityConfiguration) {
            this.props.crawlerSecurityConfiguration(crawlerSecurityConfiguration);
            return this;
        }

        public Builder databaseName(String databaseName) {
            this.props.databaseName(databaseName);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder lakeFormationConfiguration(IResolvable lakeFormationConfiguration) {
            this.props.lakeFormationConfiguration(lakeFormationConfiguration);
            return this;
        }

        public Builder lakeFormationConfiguration(LakeFormationConfigurationProperty lakeFormationConfiguration) {
            this.props.lakeFormationConfiguration(lakeFormationConfiguration);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder recrawlPolicy(IResolvable recrawlPolicy) {
            this.props.recrawlPolicy(recrawlPolicy);
            return this;
        }

        public Builder recrawlPolicy(RecrawlPolicyProperty recrawlPolicy) {
            this.props.recrawlPolicy(recrawlPolicy);
            return this;
        }

        public Builder schedule(IResolvable schedule) {
            this.props.schedule(schedule);
            return this;
        }

        public Builder schedule(ScheduleProperty schedule) {
            this.props.schedule(schedule);
            return this;
        }

        public Builder schemaChangePolicy(IResolvable schemaChangePolicy) {
            this.props.schemaChangePolicy(schemaChangePolicy);
            return this;
        }

        public Builder schemaChangePolicy(SchemaChangePolicyProperty schemaChangePolicy) {
            this.props.schemaChangePolicy(schemaChangePolicy);
            return this;
        }

        public Builder tablePrefix(String tablePrefix) {
            this.props.tablePrefix(tablePrefix);
            return this;
        }

        public Builder tags(Object tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnCrawler build() {
            return new CfnCrawler(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_glue.CfnCrawler.TargetsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TargetsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCatalogTargets() {
            return null;
        }

        @Nullable
        default public Object getDeltaTargets() {
            return null;
        }

        @Nullable
        default public Object getDynamoDbTargets() {
            return null;
        }

        @Nullable
        default public Object getHudiTargets() {
            return null;
        }

        @Nullable
        default public Object getIcebergTargets() {
            return null;
        }

        @Nullable
        default public Object getJdbcTargets() {
            return null;
        }

        @Nullable
        default public Object getMongoDbTargets() {
            return null;
        }

        @Nullable
        default public Object getS3Targets() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TargetsProperty> {
            Object catalogTargets;
            Object deltaTargets;
            Object dynamoDbTargets;
            Object hudiTargets;
            Object icebergTargets;
            Object jdbcTargets;
            Object mongoDbTargets;
            Object s3Targets;

            public Builder catalogTargets(IResolvable catalogTargets) {
                this.catalogTargets = catalogTargets;
                return this;
            }

            public Builder catalogTargets(List<? extends Object> catalogTargets) {
                this.catalogTargets = catalogTargets;
                return this;
            }

            public Builder deltaTargets(IResolvable deltaTargets) {
                this.deltaTargets = deltaTargets;
                return this;
            }

            public Builder deltaTargets(List<? extends Object> deltaTargets) {
                this.deltaTargets = deltaTargets;
                return this;
            }

            public Builder dynamoDbTargets(IResolvable dynamoDbTargets) {
                this.dynamoDbTargets = dynamoDbTargets;
                return this;
            }

            public Builder dynamoDbTargets(List<? extends Object> dynamoDbTargets) {
                this.dynamoDbTargets = dynamoDbTargets;
                return this;
            }

            public Builder hudiTargets(IResolvable hudiTargets) {
                this.hudiTargets = hudiTargets;
                return this;
            }

            public Builder hudiTargets(List<? extends Object> hudiTargets) {
                this.hudiTargets = hudiTargets;
                return this;
            }

            public Builder icebergTargets(IResolvable icebergTargets) {
                this.icebergTargets = icebergTargets;
                return this;
            }

            public Builder icebergTargets(List<? extends Object> icebergTargets) {
                this.icebergTargets = icebergTargets;
                return this;
            }

            public Builder jdbcTargets(IResolvable jdbcTargets) {
                this.jdbcTargets = jdbcTargets;
                return this;
            }

            public Builder jdbcTargets(List<? extends Object> jdbcTargets) {
                this.jdbcTargets = jdbcTargets;
                return this;
            }

            public Builder mongoDbTargets(IResolvable mongoDbTargets) {
                this.mongoDbTargets = mongoDbTargets;
                return this;
            }

            public Builder mongoDbTargets(List<? extends Object> mongoDbTargets) {
                this.mongoDbTargets = mongoDbTargets;
                return this;
            }

            public Builder s3Targets(IResolvable s3Targets) {
                this.s3Targets = s3Targets;
                return this;
            }

            public Builder s3Targets(List<? extends Object> s3Targets) {
                this.s3Targets = s3Targets;
                return this;
            }

            public TargetsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_glue.CfnCrawler.SchemaChangePolicyProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SchemaChangePolicyProperty
    extends JsiiSerializable {
        @Nullable
        default public String getDeleteBehavior() {
            return null;
        }

        @Nullable
        default public String getUpdateBehavior() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SchemaChangePolicyProperty> {
            String deleteBehavior;
            String updateBehavior;

            public Builder deleteBehavior(String deleteBehavior) {
                this.deleteBehavior = deleteBehavior;
                return this;
            }

            public Builder updateBehavior(String updateBehavior) {
                this.updateBehavior = updateBehavior;
                return this;
            }

            public SchemaChangePolicyProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_glue.CfnCrawler.ScheduleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ScheduleProperty
    extends JsiiSerializable {
        @Nullable
        default public String getScheduleExpression() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ScheduleProperty> {
            String scheduleExpression;

            public Builder scheduleExpression(String scheduleExpression) {
                this.scheduleExpression = scheduleExpression;
                return this;
            }

            public ScheduleProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_glue.CfnCrawler.S3TargetProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3TargetProperty
    extends JsiiSerializable {
        @Nullable
        default public String getConnectionName() {
            return null;
        }

        @Nullable
        default public String getDlqEventQueueArn() {
            return null;
        }

        @Nullable
        default public String getEventQueueArn() {
            return null;
        }

        @Nullable
        default public List<String> getExclusions() {
            return null;
        }

        @Nullable
        default public String getPath() {
            return null;
        }

        @Nullable
        default public Number getSampleSize() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3TargetProperty> {
            String connectionName;
            String dlqEventQueueArn;
            String eventQueueArn;
            List<String> exclusions;
            String path;
            Number sampleSize;

            public Builder connectionName(String connectionName) {
                this.connectionName = connectionName;
                return this;
            }

            public Builder dlqEventQueueArn(String dlqEventQueueArn) {
                this.dlqEventQueueArn = dlqEventQueueArn;
                return this;
            }

            public Builder eventQueueArn(String eventQueueArn) {
                this.eventQueueArn = eventQueueArn;
                return this;
            }

            public Builder exclusions(List<String> exclusions) {
                this.exclusions = exclusions;
                return this;
            }

            public Builder path(String path) {
                this.path = path;
                return this;
            }

            public Builder sampleSize(Number sampleSize) {
                this.sampleSize = sampleSize;
                return this;
            }

            public S3TargetProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_glue.CfnCrawler.RecrawlPolicyProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RecrawlPolicyProperty
    extends JsiiSerializable {
        @Nullable
        default public String getRecrawlBehavior() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RecrawlPolicyProperty> {
            String recrawlBehavior;

            public Builder recrawlBehavior(String recrawlBehavior) {
                this.recrawlBehavior = recrawlBehavior;
                return this;
            }

            public RecrawlPolicyProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_glue.CfnCrawler.MongoDBTargetProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MongoDBTargetProperty
    extends JsiiSerializable {
        @Nullable
        default public String getConnectionName() {
            return null;
        }

        @Nullable
        default public String getPath() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MongoDBTargetProperty> {
            String connectionName;
            String path;

            public Builder connectionName(String connectionName) {
                this.connectionName = connectionName;
                return this;
            }

            public Builder path(String path) {
                this.path = path;
                return this;
            }

            public MongoDBTargetProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_glue.CfnCrawler.LakeFormationConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LakeFormationConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAccountId() {
            return null;
        }

        @Nullable
        default public Object getUseLakeFormationCredentials() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LakeFormationConfigurationProperty> {
            String accountId;
            Object useLakeFormationCredentials;

            public Builder accountId(String accountId) {
                this.accountId = accountId;
                return this;
            }

            public Builder useLakeFormationCredentials(Boolean useLakeFormationCredentials) {
                this.useLakeFormationCredentials = useLakeFormationCredentials;
                return this;
            }

            public Builder useLakeFormationCredentials(IResolvable useLakeFormationCredentials) {
                this.useLakeFormationCredentials = useLakeFormationCredentials;
                return this;
            }

            public LakeFormationConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_glue.CfnCrawler.JdbcTargetProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface JdbcTargetProperty
    extends JsiiSerializable {
        @Nullable
        default public String getConnectionName() {
            return null;
        }

        @Nullable
        default public List<String> getEnableAdditionalMetadata() {
            return null;
        }

        @Nullable
        default public List<String> getExclusions() {
            return null;
        }

        @Nullable
        default public String getPath() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<JdbcTargetProperty> {
            String connectionName;
            List<String> enableAdditionalMetadata;
            List<String> exclusions;
            String path;

            public Builder connectionName(String connectionName) {
                this.connectionName = connectionName;
                return this;
            }

            public Builder enableAdditionalMetadata(List<String> enableAdditionalMetadata) {
                this.enableAdditionalMetadata = enableAdditionalMetadata;
                return this;
            }

            public Builder exclusions(List<String> exclusions) {
                this.exclusions = exclusions;
                return this;
            }

            public Builder path(String path) {
                this.path = path;
                return this;
            }

            public JdbcTargetProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_glue.CfnCrawler.IcebergTargetProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IcebergTargetProperty
    extends JsiiSerializable {
        @Nullable
        default public String getConnectionName() {
            return null;
        }

        @Nullable
        default public List<String> getExclusions() {
            return null;
        }

        @Nullable
        default public Number getMaximumTraversalDepth() {
            return null;
        }

        @Nullable
        default public List<String> getPaths() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<IcebergTargetProperty> {
            String connectionName;
            List<String> exclusions;
            Number maximumTraversalDepth;
            List<String> paths;

            public Builder connectionName(String connectionName) {
                this.connectionName = connectionName;
                return this;
            }

            public Builder exclusions(List<String> exclusions) {
                this.exclusions = exclusions;
                return this;
            }

            public Builder maximumTraversalDepth(Number maximumTraversalDepth) {
                this.maximumTraversalDepth = maximumTraversalDepth;
                return this;
            }

            public Builder paths(List<String> paths) {
                this.paths = paths;
                return this;
            }

            public IcebergTargetProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_glue.CfnCrawler.HudiTargetProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HudiTargetProperty
    extends JsiiSerializable {
        @Nullable
        default public String getConnectionName() {
            return null;
        }

        @Nullable
        default public List<String> getExclusions() {
            return null;
        }

        @Nullable
        default public Number getMaximumTraversalDepth() {
            return null;
        }

        @Nullable
        default public List<String> getPaths() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HudiTargetProperty> {
            String connectionName;
            List<String> exclusions;
            Number maximumTraversalDepth;
            List<String> paths;

            public Builder connectionName(String connectionName) {
                this.connectionName = connectionName;
                return this;
            }

            public Builder exclusions(List<String> exclusions) {
                this.exclusions = exclusions;
                return this;
            }

            public Builder maximumTraversalDepth(Number maximumTraversalDepth) {
                this.maximumTraversalDepth = maximumTraversalDepth;
                return this;
            }

            public Builder paths(List<String> paths) {
                this.paths = paths;
                return this;
            }

            public HudiTargetProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_glue.CfnCrawler.DynamoDBTargetProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DynamoDBTargetProperty
    extends JsiiSerializable {
        @Nullable
        default public String getPath() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DynamoDBTargetProperty> {
            String path;

            public Builder path(String path) {
                this.path = path;
                return this;
            }

            public DynamoDBTargetProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_glue.CfnCrawler.DeltaTargetProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DeltaTargetProperty
    extends JsiiSerializable {
        @Nullable
        default public String getConnectionName() {
            return null;
        }

        @Nullable
        default public Object getCreateNativeDeltaTable() {
            return null;
        }

        @Nullable
        default public List<String> getDeltaTables() {
            return null;
        }

        @Nullable
        default public Object getWriteManifest() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DeltaTargetProperty> {
            String connectionName;
            Object createNativeDeltaTable;
            List<String> deltaTables;
            Object writeManifest;

            public Builder connectionName(String connectionName) {
                this.connectionName = connectionName;
                return this;
            }

            public Builder createNativeDeltaTable(Boolean createNativeDeltaTable) {
                this.createNativeDeltaTable = createNativeDeltaTable;
                return this;
            }

            public Builder createNativeDeltaTable(IResolvable createNativeDeltaTable) {
                this.createNativeDeltaTable = createNativeDeltaTable;
                return this;
            }

            public Builder deltaTables(List<String> deltaTables) {
                this.deltaTables = deltaTables;
                return this;
            }

            public Builder writeManifest(Boolean writeManifest) {
                this.writeManifest = writeManifest;
                return this;
            }

            public Builder writeManifest(IResolvable writeManifest) {
                this.writeManifest = writeManifest;
                return this;
            }

            public DeltaTargetProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_glue.CfnCrawler.CatalogTargetProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CatalogTargetProperty
    extends JsiiSerializable {
        @Nullable
        default public String getConnectionName() {
            return null;
        }

        @Nullable
        default public String getDatabaseName() {
            return null;
        }

        @Nullable
        default public String getDlqEventQueueArn() {
            return null;
        }

        @Nullable
        default public String getEventQueueArn() {
            return null;
        }

        @Nullable
        default public List<String> getTables() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CatalogTargetProperty> {
            String connectionName;
            String databaseName;
            String dlqEventQueueArn;
            String eventQueueArn;
            List<String> tables;

            public Builder connectionName(String connectionName) {
                this.connectionName = connectionName;
                return this;
            }

            public Builder databaseName(String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            public Builder dlqEventQueueArn(String dlqEventQueueArn) {
                this.dlqEventQueueArn = dlqEventQueueArn;
                return this;
            }

            public Builder eventQueueArn(String eventQueueArn) {
                this.eventQueueArn = eventQueueArn;
                return this;
            }

            public Builder tables(List<String> tables) {
                this.tables = tables;
                return this;
            }

            public CatalogTargetProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

