/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.lambda.eventsources;

import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.lambda.IEventSourceDlq;
import software.amazon.awscdk.services.lambda.StartingPosition;
import software.amazon.awscdk.services.lambda.eventsources.AuthenticationMethod;
import software.amazon.awscdk.services.lambda.eventsources.KafkaEventSourceProps;
import software.amazon.awscdk.services.lambda.eventsources.ProvisionedPollerConfig;
import software.amazon.awscdk.services.lambda.eventsources.SelfManagedKafkaEventSourceProps;
import software.amazon.awscdk.services.secretsmanager.ISecret;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_lambda_event_sources.SelfManagedKafkaEventSourceProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface SelfManagedKafkaEventSourceProps
extends JsiiSerializable,
KafkaEventSourceProps {
    @NotNull
    public List<String> getBootstrapServers();

    @Nullable
    default public AuthenticationMethod getAuthenticationMethod() {
        return null;
    }

    @Nullable
    default public ISecret getRootCACertificate() {
        return null;
    }

    @Nullable
    default public ISecurityGroup getSecurityGroup() {
        return null;
    }

    @Nullable
    default public IVpc getVpc() {
        return null;
    }

    @Nullable
    default public SubnetSelection getVpcSubnets() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<SelfManagedKafkaEventSourceProps> {
        List<String> bootstrapServers;
        AuthenticationMethod authenticationMethod;
        ISecret rootCaCertificate;
        ISecurityGroup securityGroup;
        IVpc vpc;
        SubnetSelection vpcSubnets;
        String topic;
        String consumerGroupId;
        IKey filterEncryption;
        List<Map<String, Object>> filters;
        IEventSourceDlq onFailure;
        ISecret secret;
        Number startingPositionTimestamp;
        StartingPosition startingPosition;
        Number batchSize;
        Boolean enabled;
        Duration maxBatchingWindow;
        ProvisionedPollerConfig provisionedPollerConfig;

        public Builder bootstrapServers(List<String> bootstrapServers) {
            this.bootstrapServers = bootstrapServers;
            return this;
        }

        public Builder authenticationMethod(AuthenticationMethod authenticationMethod) {
            this.authenticationMethod = authenticationMethod;
            return this;
        }

        public Builder rootCaCertificate(ISecret rootCaCertificate) {
            this.rootCaCertificate = rootCaCertificate;
            return this;
        }

        public Builder securityGroup(ISecurityGroup securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        public Builder vpcSubnets(SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        public Builder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public Builder consumerGroupId(String consumerGroupId) {
            this.consumerGroupId = consumerGroupId;
            return this;
        }

        public Builder filterEncryption(IKey filterEncryption) {
            this.filterEncryption = filterEncryption;
            return this;
        }

        public Builder filters(List<? extends Map<String, ? extends Object>> filters) {
            this.filters = filters;
            return this;
        }

        public Builder onFailure(IEventSourceDlq onFailure) {
            this.onFailure = onFailure;
            return this;
        }

        public Builder secret(ISecret secret) {
            this.secret = secret;
            return this;
        }

        public Builder startingPositionTimestamp(Number startingPositionTimestamp) {
            this.startingPositionTimestamp = startingPositionTimestamp;
            return this;
        }

        public Builder startingPosition(StartingPosition startingPosition) {
            this.startingPosition = startingPosition;
            return this;
        }

        public Builder batchSize(Number batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder maxBatchingWindow(Duration maxBatchingWindow) {
            this.maxBatchingWindow = maxBatchingWindow;
            return this;
        }

        public Builder provisionedPollerConfig(ProvisionedPollerConfig provisionedPollerConfig) {
            this.provisionedPollerConfig = provisionedPollerConfig;
            return this;
        }

        public SelfManagedKafkaEventSourceProps build() {
            return new Jsii.Proxy(this);
        }
    }
}

