package software.amazon.awscdk;

/**
 * Includes API for attaching annotations such as warning messages to constructs.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.*;
 * import software.constructs.Construct;
 * import software.constructs.IConstruct;
 * public class MyAspect implements IAspect {
 *     public void visit(IConstruct node) {
 *         if (node instanceof CfnResource &amp;&amp; node.getCfnResourceType() == "Foo::Bar") {
 *             this.error(node, "we do not want a Foo::Bar resource");
 *         }
 *     }
 *     public void error(IConstruct node, String message) {
 *         Annotations.of(node).addError(message);
 *     }
 * }
 * public class MyStack extends Stack {
 *     public MyStack(Construct scope, String id) {
 *         super(scope, id);
 *         Stack stack = new Stack();
 *         CfnResource.Builder.create(stack, "Foo")
 *                 .type("Foo::Bar")
 *                 .properties(Map.of(
 *                         "Fred", "Thud"))
 *                 .build();
 *         Aspects.of(stack).add(new MyAspect());
 *     }
 * }
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:32.729Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.Annotations")
public class Annotations extends software.amazon.jsii.JsiiObject {

    protected Annotations(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Annotations(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Returns the annotations API for a construct scope.
     * <p>
     * @param scope The scope. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.Annotations of(final @org.jetbrains.annotations.NotNull software.constructs.IConstruct scope) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.Annotations.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Annotations.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
    }

    /**
     * Acknowledge a warning. When a warning is acknowledged for a scope all warnings that match the id will be ignored.
     * <p>
     * The acknowledgement will apply to all child scopes
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * Construct myConstruct;
     * Annotations.of(myConstruct).acknowledgeWarning("SomeWarningId", "This warning can be ignored because...");
     * </pre></blockquote>
     * <p>
     * @param id <ul><li>the id of the warning message to acknowledge.</li></ul> This parameter is required.
     * @param message optional message to explain the reason for acknowledgement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void acknowledgeWarning(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable java.lang.String message) {
        software.amazon.jsii.Kernel.call(this, "acknowledgeWarning", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), message });
    }

    /**
     * Acknowledge a warning. When a warning is acknowledged for a scope all warnings that match the id will be ignored.
     * <p>
     * The acknowledgement will apply to all child scopes
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * Construct myConstruct;
     * Annotations.of(myConstruct).acknowledgeWarning("SomeWarningId", "This warning can be ignored because...");
     * </pre></blockquote>
     * <p>
     * @param id <ul><li>the id of the warning message to acknowledge.</li></ul> This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void acknowledgeWarning(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        software.amazon.jsii.Kernel.call(this, "acknowledgeWarning", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Adds a deprecation warning for a specific API.
     * <p>
     * Deprecations will be added only once per construct as a warning and will be
     * deduplicated based on the <code>api</code>.
     * <p>
     * If the environment variable <code>CDK_BLOCK_DEPRECATIONS</code> is set, this method
     * will throw an error instead with the deprecation message.
     * <p>
     * @param api The API being deprecated in the format <code>module.Class.property</code> (e.g. <code>&#64;aws-cdk/core.Construct.node</code>). This parameter is required.
     * @param message The deprecation message to display, with information about alternatives. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addDeprecation(final @org.jetbrains.annotations.NotNull java.lang.String api, final @org.jetbrains.annotations.NotNull java.lang.String message) {
        software.amazon.jsii.Kernel.call(this, "addDeprecation", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(api, "api is required"), java.util.Objects.requireNonNull(message, "message is required") });
    }

    /**
     * Adds an { "error": <message> } metadata entry to this construct.
     * <p>
     * The toolkit will fail deployment of any stack that has errors reported against it.
     * <p>
     * @param message The error message. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addError(final @org.jetbrains.annotations.NotNull java.lang.String message) {
        software.amazon.jsii.Kernel.call(this, "addError", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(message, "message is required") });
    }

    /**
     * Adds an info metadata entry to this construct.
     * <p>
     * The CLI will display the info message when apps are synthesized.
     * <p>
     * @param message The info message. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addInfo(final @org.jetbrains.annotations.NotNull java.lang.String message) {
        software.amazon.jsii.Kernel.call(this, "addInfo", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(message, "message is required") });
    }

    /**
     * Adds a warning metadata entry to this construct. Prefer using <code>addWarningV2</code>.
     * <p>
     * The CLI will display the warning when an app is synthesized, or fail if run
     * in <code>--strict</code> mode.
     * <p>
     * Warnings added by this call cannot be acknowledged. This will block users from
     * running in <code>--strict</code> mode until the deal with the warning, which makes it
     * effectively not very different from <code>addError</code>. Prefer using <code>addWarningV2</code> instead.
     * <p>
     * @param message The warning message. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addWarning(final @org.jetbrains.annotations.NotNull java.lang.String message) {
        software.amazon.jsii.Kernel.call(this, "addWarning", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(message, "message is required") });
    }

    /**
     * Adds an acknowledgeable warning metadata entry to this construct.
     * <p>
     * The CLI will display the warning when an app is synthesized, or fail if run
     * in <code>--strict</code> mode.
     * <p>
     * If the warning is acknowledged using <code>acknowledgeWarning()</code>, it will not be shown by
     * the CLI, and will not cause <code>--strict</code> mode to fail synthesis.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * Construct myConstruct;
     * Annotations.of(myConstruct).addWarningV2("my-library:Construct.someWarning", "Some message explaining the warning");
     * </pre></blockquote>
     * <p>
     * @param id the unique identifier for the warning. This parameter is required.
     * @param message The warning message. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addWarningV2(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String message) {
        software.amazon.jsii.Kernel.call(this, "addWarningV2", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(message, "message is required") });
    }
}
