package software.amazon.awscdk;

/**
 * Synthesizer that reuses bootstrap roles from a different region.
 * <p>
 * A special synthesizer that behaves similarly to <code>DefaultStackSynthesizer</code>,
 * but doesn't require bootstrapping the environment it operates in. Instead,
 * it will re-use the Roles that were created for a different region (which
 * is possible because IAM is a global service).
 * <p>
 * However, it will not assume asset buckets or repositories have been created,
 * and therefore does not support assets.
 * <p>
 * The name is poorly chosen -- it does still require bootstrapping, it just
 * does not support assets.
 * <p>
 * Used by the CodePipeline construct for the support stacks needed for
 * cross-region replication S3 buckets. App builders do not need to use this
 * synthesizer directly.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * BootstraplessSynthesizer bootstraplessSynthesizer = BootstraplessSynthesizer.Builder.create()
 *         .cloudFormationExecutionRoleArn("cloudFormationExecutionRoleArn")
 *         .deployRoleArn("deployRoleArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:32.744Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.BootstraplessSynthesizer")
public class BootstraplessSynthesizer extends software.amazon.awscdk.DefaultStackSynthesizer {

    protected BootstraplessSynthesizer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected BootstraplessSynthesizer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public BootstraplessSynthesizer(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.BootstraplessSynthesizerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { props });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public BootstraplessSynthesizer() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Register a Docker Image Asset.
     * <p>
     * Returns the parameters that can be used to refer to the asset inside the template.
     * <p>
     * The synthesizer must rely on some out-of-band mechanism to make sure the given files
     * are actually placed in the returned location before the deployment happens. This can
     * be by writing the instructions to the asset manifest (for use by the <code>cdk-assets</code> tool),
     * by relying on the CLI to upload files (legacy behavior), or some other operator controlled
     * mechanism.
     * <p>
     * @param _asset This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.DockerImageAssetLocation addDockerImageAsset(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.DockerImageAssetSource _asset) {
        return software.amazon.jsii.Kernel.call(this, "addDockerImageAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.DockerImageAssetLocation.class), new Object[] { java.util.Objects.requireNonNull(_asset, "_asset is required") });
    }

    /**
     * Register a File Asset.
     * <p>
     * Returns the parameters that can be used to refer to the asset inside the template.
     * <p>
     * The synthesizer must rely on some out-of-band mechanism to make sure the given files
     * are actually placed in the returned location before the deployment happens. This can
     * be by writing the instructions to the asset manifest (for use by the <code>cdk-assets</code> tool),
     * by relying on the CLI to upload files (legacy behavior), or some other operator controlled
     * mechanism.
     * <p>
     * @param _asset This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.FileAssetLocation addFileAsset(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.FileAssetSource _asset) {
        return software.amazon.jsii.Kernel.call(this, "addFileAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.FileAssetLocation.class), new Object[] { java.util.Objects.requireNonNull(_asset, "_asset is required") });
    }

    /**
     * Synthesize the associated stack to the session.
     * <p>
     * @param session This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void synthesize(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.ISynthesisSession session) {
        software.amazon.jsii.Kernel.call(this, "synthesize", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(session, "session is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.BootstraplessSynthesizer}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.BootstraplessSynthesizer> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private software.amazon.awscdk.BootstraplessSynthesizerProps.Builder props;

        private Builder() {
        }

        /**
         * The CFN execution Role ARN to use.
         * <p>
         * Default: - No CloudFormation role (use CLI credentials)
         * <p>
         * @return {@code this}
         * @param cloudFormationExecutionRoleArn The CFN execution Role ARN to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudFormationExecutionRoleArn(final java.lang.String cloudFormationExecutionRoleArn) {
            this.props().cloudFormationExecutionRoleArn(cloudFormationExecutionRoleArn);
            return this;
        }

        /**
         * The deploy Role ARN to use.
         * <p>
         * Default: - No deploy role (use CLI credentials)
         * <p>
         * @return {@code this}
         * @param deployRoleArn The deploy Role ARN to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deployRoleArn(final java.lang.String deployRoleArn) {
            this.props().deployRoleArn(deployRoleArn);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.BootstraplessSynthesizer}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.BootstraplessSynthesizer build() {
            return new software.amazon.awscdk.BootstraplessSynthesizer(
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.BootstraplessSynthesizerProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.BootstraplessSynthesizerProps.Builder();
            }
            return this.props;
        }
    }
}
