package software.amazon.awscdk;

/**
 * Configuration properties for DefaultStackSynthesizer.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * MyStack.Builder.create(app, "MyStack")
 *         .synthesizer(DefaultStackSynthesizer.Builder.create()
 *                 .fileAssetsBucketName("amzn-s3-demo-bucket")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:32.868Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.DefaultStackSynthesizerProps")
@software.amazon.jsii.Jsii.Proxy(DefaultStackSynthesizerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DefaultStackSynthesizerProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Bootstrap stack version SSM parameter.
     * <p>
     * The placeholder <code>${Qualifier}</code> will be replaced with the value of qualifier.
     * <p>
     * Default: DefaultStackSynthesizer.DEFAULT_BOOTSTRAP_STACK_VERSION_SSM_PARAMETER
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBootstrapStackVersionSsmParameter() {
        return null;
    }

    /**
     * bucketPrefix to use while storing S3 Assets.
     * <p>
     * Default: - DefaultStackSynthesizer.DEFAULT_FILE_ASSET_PREFIX
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBucketPrefix() {
        return null;
    }

    /**
     * The role CloudFormation will assume when deploying the Stack.
     * <p>
     * You must supply this if you have given a non-standard name to the execution role.
     * <p>
     * The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
     * be replaced with the values of qualifier and the stack's account and region,
     * respectively.
     * <p>
     * Default: DefaultStackSynthesizer.DEFAULT_CLOUDFORMATION_ROLE_ARN
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCloudFormationExecutionRole() {
        return null;
    }

    /**
     * Additional options to pass to STS when assuming the deploy role.
     * <p>
     * <ul>
     * <li><code>RoleArn</code> should not be used. Use the dedicated <code>deployRoleArn</code> property instead.</li>
     * <li><code>ExternalId</code> should not be used. Use the dedicated <code>deployRoleExternalId</code> instead.</li>
     * <li><code>TransitiveTagKeys</code> defaults to use all keys (if any) specified in <code>Tags</code>. E.g, all tags are transitive by default.</li>
     * </ul>
     * <p>
     * Default: - No additional options.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/STS.html#assumeRole-property">https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/STS.html#assumeRole-property</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> getDeployRoleAdditionalOptions() {
        return null;
    }

    /**
     * The role to assume to initiate a deployment in this environment.
     * <p>
     * You must supply this if you have given a non-standard name to the publishing role.
     * <p>
     * The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
     * be replaced with the values of qualifier and the stack's account and region,
     * respectively.
     * <p>
     * Default: DefaultStackSynthesizer.DEFAULT_DEPLOY_ROLE_ARN
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDeployRoleArn() {
        return null;
    }

    /**
     * External ID to use when assuming role for cloudformation deployments.
     * <p>
     * Default: - No external ID
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDeployRoleExternalId() {
        return null;
    }

    /**
     * A prefix to use while tagging and uploading Docker images to ECR.
     * <p>
     * This does not add any separators - the source hash will be appended to
     * this string directly.
     * <p>
     * Default: - DefaultStackSynthesizer.DEFAULT_DOCKER_ASSET_PREFIX
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDockerTagPrefix() {
        return null;
    }

    /**
     * External ID to use when assuming role for file asset publishing.
     * <p>
     * Default: - No external ID
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFileAssetPublishingExternalId() {
        return null;
    }

    /**
     * Additional options to pass to STS when assuming the file asset publishing.
     * <p>
     * <ul>
     * <li><code>RoleArn</code> should not be used. Use the dedicated <code>fileAssetPublishingRoleArn</code> property instead.</li>
     * <li><code>ExternalId</code> should not be used. Use the dedicated <code>fileAssetPublishingExternalId</code> instead.</li>
     * <li><code>TransitiveTagKeys</code> defaults to use all keys (if any) specified in <code>Tags</code>. E.g, all tags are transitive by default.</li>
     * </ul>
     * <p>
     * Default: - No additional options.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/STS.html#assumeRole-property">https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/STS.html#assumeRole-property</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> getFileAssetPublishingRoleAdditionalOptions() {
        return null;
    }

    /**
     * The role to use to publish file assets to the S3 bucket in this environment.
     * <p>
     * You must supply this if you have given a non-standard name to the publishing role.
     * <p>
     * The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
     * be replaced with the values of qualifier and the stack's account and region,
     * respectively.
     * <p>
     * Default: DefaultStackSynthesizer.DEFAULT_FILE_ASSET_PUBLISHING_ROLE_ARN
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFileAssetPublishingRoleArn() {
        return null;
    }

    /**
     * Name of the S3 bucket to hold file assets.
     * <p>
     * You must supply this if you have given a non-standard name to the staging bucket.
     * <p>
     * The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
     * be replaced with the values of qualifier and the stack's account and region,
     * respectively.
     * <p>
     * Default: DefaultStackSynthesizer.DEFAULT_FILE_ASSETS_BUCKET_NAME
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFileAssetsBucketName() {
        return null;
    }

    /**
     * Whether to add a Rule to the stack template verifying the bootstrap stack version.
     * <p>
     * This generally should be left set to <code>true</code>, unless you explicitly
     * want to be able to deploy to an unbootstrapped environment.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getGenerateBootstrapVersionRule() {
        return null;
    }

    /**
     * External ID to use when assuming role for image asset publishing.
     * <p>
     * Default: - No external ID
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getImageAssetPublishingExternalId() {
        return null;
    }

    /**
     * Additional options to pass to STS when assuming the image asset publishing.
     * <p>
     * <ul>
     * <li><code>RoleArn</code> should not be used. Use the dedicated <code>imageAssetPublishingRoleArn</code> property instead.</li>
     * <li><code>ExternalId</code> should not be used. Use the dedicated <code>imageAssetPublishingExternalId</code> instead.</li>
     * <li><code>TransitiveTagKeys</code> defaults to use all keys (if any) specified in <code>Tags</code>. E.g, all tags are transitive by default.</li>
     * </ul>
     * <p>
     * Default: - No additional options.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/STS.html#assumeRole-property">https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/STS.html#assumeRole-property</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> getImageAssetPublishingRoleAdditionalOptions() {
        return null;
    }

    /**
     * The role to use to publish image assets to the ECR repository in this environment.
     * <p>
     * You must supply this if you have given a non-standard name to the publishing role.
     * <p>
     * The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
     * be replaced with the values of qualifier and the stack's account and region,
     * respectively.
     * <p>
     * Default: DefaultStackSynthesizer.DEFAULT_IMAGE_ASSET_PUBLISHING_ROLE_ARN
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getImageAssetPublishingRoleArn() {
        return null;
    }

    /**
     * Name of the ECR repository to hold Docker Image assets.
     * <p>
     * You must supply this if you have given a non-standard name to the ECR repository.
     * <p>
     * The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
     * be replaced with the values of qualifier and the stack's account and region,
     * respectively.
     * <p>
     * Default: DefaultStackSynthesizer.DEFAULT_IMAGE_ASSETS_REPOSITORY_NAME
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getImageAssetsRepositoryName() {
        return null;
    }

    /**
     * Additional options to pass to STS when assuming the lookup role.
     * <p>
     * <ul>
     * <li><code>RoleArn</code> should not be used. Use the dedicated <code>lookupRoleArn</code> property instead.</li>
     * <li><code>ExternalId</code> should not be used. Use the dedicated <code>lookupRoleExternalId</code> instead.</li>
     * <li><code>TransitiveTagKeys</code> defaults to use all keys (if any) specified in <code>Tags</code>. E.g, all tags are transitive by default.</li>
     * </ul>
     * <p>
     * Default: - No additional options.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/STS.html#assumeRole-property">https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/STS.html#assumeRole-property</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> getLookupRoleAdditionalOptions() {
        return null;
    }

    /**
     * The role to use to look up values from the target AWS account during synthesis.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLookupRoleArn() {
        return null;
    }

    /**
     * External ID to use when assuming lookup role.
     * <p>
     * Default: - No external ID
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLookupRoleExternalId() {
        return null;
    }

    /**
     * Qualifier to disambiguate multiple environments in the same account.
     * <p>
     * You can use this and leave the other naming properties empty if you have deployed
     * the bootstrap environment with standard names but only different qualifiers.
     * <p>
     * Default: - Value of context key '@aws-cdk/core:bootstrapQualifier' if set, otherwise `DefaultStackSynthesizer.DEFAULT_QUALIFIER`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getQualifier() {
        return null;
    }

    /**
     * Use the bootstrapped lookup role for (read-only) stack operations.
     * <p>
     * Use the lookup role when performing a <code>cdk diff</code>. If set to <code>false</code>, the
     * <code>deploy role</code> credentials will be used to perform a <code>cdk diff</code>.
     * <p>
     * Requires bootstrap stack version 8.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getUseLookupRoleForStackOperations() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DefaultStackSynthesizerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DefaultStackSynthesizerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DefaultStackSynthesizerProps> {
        java.lang.String bootstrapStackVersionSsmParameter;
        java.lang.String bucketPrefix;
        java.lang.String cloudFormationExecutionRole;
        java.util.Map<java.lang.String, java.lang.Object> deployRoleAdditionalOptions;
        java.lang.String deployRoleArn;
        java.lang.String deployRoleExternalId;
        java.lang.String dockerTagPrefix;
        java.lang.String fileAssetPublishingExternalId;
        java.util.Map<java.lang.String, java.lang.Object> fileAssetPublishingRoleAdditionalOptions;
        java.lang.String fileAssetPublishingRoleArn;
        java.lang.String fileAssetsBucketName;
        java.lang.Boolean generateBootstrapVersionRule;
        java.lang.String imageAssetPublishingExternalId;
        java.util.Map<java.lang.String, java.lang.Object> imageAssetPublishingRoleAdditionalOptions;
        java.lang.String imageAssetPublishingRoleArn;
        java.lang.String imageAssetsRepositoryName;
        java.util.Map<java.lang.String, java.lang.Object> lookupRoleAdditionalOptions;
        java.lang.String lookupRoleArn;
        java.lang.String lookupRoleExternalId;
        java.lang.String qualifier;
        java.lang.Boolean useLookupRoleForStackOperations;

        /**
         * Sets the value of {@link DefaultStackSynthesizerProps#getBootstrapStackVersionSsmParameter}
         * @param bootstrapStackVersionSsmParameter Bootstrap stack version SSM parameter.
         *                                          The placeholder <code>${Qualifier}</code> will be replaced with the value of qualifier.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bootstrapStackVersionSsmParameter(java.lang.String bootstrapStackVersionSsmParameter) {
            this.bootstrapStackVersionSsmParameter = bootstrapStackVersionSsmParameter;
            return this;
        }

        /**
         * Sets the value of {@link DefaultStackSynthesizerProps#getBucketPrefix}
         * @param bucketPrefix bucketPrefix to use while storing S3 Assets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketPrefix(java.lang.String bucketPrefix) {
            this.bucketPrefix = bucketPrefix;
            return this;
        }

        /**
         * Sets the value of {@link DefaultStackSynthesizerProps#getCloudFormationExecutionRole}
         * @param cloudFormationExecutionRole The role CloudFormation will assume when deploying the Stack.
         *                                    You must supply this if you have given a non-standard name to the execution role.
         *                                    <p>
         *                                    The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
         *                                    be replaced with the values of qualifier and the stack's account and region,
         *                                    respectively.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudFormationExecutionRole(java.lang.String cloudFormationExecutionRole) {
            this.cloudFormationExecutionRole = cloudFormationExecutionRole;
            return this;
        }

        /**
         * Sets the value of {@link DefaultStackSynthesizerProps#getDeployRoleAdditionalOptions}
         * @param deployRoleAdditionalOptions Additional options to pass to STS when assuming the deploy role.
         *                                    <ul>
         *                                    <li><code>RoleArn</code> should not be used. Use the dedicated <code>deployRoleArn</code> property instead.</li>
         *                                    <li><code>ExternalId</code> should not be used. Use the dedicated <code>deployRoleExternalId</code> instead.</li>
         *                                    <li><code>TransitiveTagKeys</code> defaults to use all keys (if any) specified in <code>Tags</code>. E.g, all tags are transitive by default.</li>
         *                                    </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder deployRoleAdditionalOptions(java.util.Map<java.lang.String, ? extends java.lang.Object> deployRoleAdditionalOptions) {
            this.deployRoleAdditionalOptions = (java.util.Map<java.lang.String, java.lang.Object>)deployRoleAdditionalOptions;
            return this;
        }

        /**
         * Sets the value of {@link DefaultStackSynthesizerProps#getDeployRoleArn}
         * @param deployRoleArn The role to assume to initiate a deployment in this environment.
         *                      You must supply this if you have given a non-standard name to the publishing role.
         *                      <p>
         *                      The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
         *                      be replaced with the values of qualifier and the stack's account and region,
         *                      respectively.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deployRoleArn(java.lang.String deployRoleArn) {
            this.deployRoleArn = deployRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link DefaultStackSynthesizerProps#getDeployRoleExternalId}
         * @param deployRoleExternalId External ID to use when assuming role for cloudformation deployments.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deployRoleExternalId(java.lang.String deployRoleExternalId) {
            this.deployRoleExternalId = deployRoleExternalId;
            return this;
        }

        /**
         * Sets the value of {@link DefaultStackSynthesizerProps#getDockerTagPrefix}
         * @param dockerTagPrefix A prefix to use while tagging and uploading Docker images to ECR.
         *                        This does not add any separators - the source hash will be appended to
         *                        this string directly.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dockerTagPrefix(java.lang.String dockerTagPrefix) {
            this.dockerTagPrefix = dockerTagPrefix;
            return this;
        }

        /**
         * Sets the value of {@link DefaultStackSynthesizerProps#getFileAssetPublishingExternalId}
         * @param fileAssetPublishingExternalId External ID to use when assuming role for file asset publishing.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileAssetPublishingExternalId(java.lang.String fileAssetPublishingExternalId) {
            this.fileAssetPublishingExternalId = fileAssetPublishingExternalId;
            return this;
        }

        /**
         * Sets the value of {@link DefaultStackSynthesizerProps#getFileAssetPublishingRoleAdditionalOptions}
         * @param fileAssetPublishingRoleAdditionalOptions Additional options to pass to STS when assuming the file asset publishing.
         *                                                 <ul>
         *                                                 <li><code>RoleArn</code> should not be used. Use the dedicated <code>fileAssetPublishingRoleArn</code> property instead.</li>
         *                                                 <li><code>ExternalId</code> should not be used. Use the dedicated <code>fileAssetPublishingExternalId</code> instead.</li>
         *                                                 <li><code>TransitiveTagKeys</code> defaults to use all keys (if any) specified in <code>Tags</code>. E.g, all tags are transitive by default.</li>
         *                                                 </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder fileAssetPublishingRoleAdditionalOptions(java.util.Map<java.lang.String, ? extends java.lang.Object> fileAssetPublishingRoleAdditionalOptions) {
            this.fileAssetPublishingRoleAdditionalOptions = (java.util.Map<java.lang.String, java.lang.Object>)fileAssetPublishingRoleAdditionalOptions;
            return this;
        }

        /**
         * Sets the value of {@link DefaultStackSynthesizerProps#getFileAssetPublishingRoleArn}
         * @param fileAssetPublishingRoleArn The role to use to publish file assets to the S3 bucket in this environment.
         *                                   You must supply this if you have given a non-standard name to the publishing role.
         *                                   <p>
         *                                   The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
         *                                   be replaced with the values of qualifier and the stack's account and region,
         *                                   respectively.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileAssetPublishingRoleArn(java.lang.String fileAssetPublishingRoleArn) {
            this.fileAssetPublishingRoleArn = fileAssetPublishingRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link DefaultStackSynthesizerProps#getFileAssetsBucketName}
         * @param fileAssetsBucketName Name of the S3 bucket to hold file assets.
         *                             You must supply this if you have given a non-standard name to the staging bucket.
         *                             <p>
         *                             The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
         *                             be replaced with the values of qualifier and the stack's account and region,
         *                             respectively.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileAssetsBucketName(java.lang.String fileAssetsBucketName) {
            this.fileAssetsBucketName = fileAssetsBucketName;
            return this;
        }

        /**
         * Sets the value of {@link DefaultStackSynthesizerProps#getGenerateBootstrapVersionRule}
         * @param generateBootstrapVersionRule Whether to add a Rule to the stack template verifying the bootstrap stack version.
         *                                     This generally should be left set to <code>true</code>, unless you explicitly
         *                                     want to be able to deploy to an unbootstrapped environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder generateBootstrapVersionRule(java.lang.Boolean generateBootstrapVersionRule) {
            this.generateBootstrapVersionRule = generateBootstrapVersionRule;
            return this;
        }

        /**
         * Sets the value of {@link DefaultStackSynthesizerProps#getImageAssetPublishingExternalId}
         * @param imageAssetPublishingExternalId External ID to use when assuming role for image asset publishing.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageAssetPublishingExternalId(java.lang.String imageAssetPublishingExternalId) {
            this.imageAssetPublishingExternalId = imageAssetPublishingExternalId;
            return this;
        }

        /**
         * Sets the value of {@link DefaultStackSynthesizerProps#getImageAssetPublishingRoleAdditionalOptions}
         * @param imageAssetPublishingRoleAdditionalOptions Additional options to pass to STS when assuming the image asset publishing.
         *                                                  <ul>
         *                                                  <li><code>RoleArn</code> should not be used. Use the dedicated <code>imageAssetPublishingRoleArn</code> property instead.</li>
         *                                                  <li><code>ExternalId</code> should not be used. Use the dedicated <code>imageAssetPublishingExternalId</code> instead.</li>
         *                                                  <li><code>TransitiveTagKeys</code> defaults to use all keys (if any) specified in <code>Tags</code>. E.g, all tags are transitive by default.</li>
         *                                                  </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder imageAssetPublishingRoleAdditionalOptions(java.util.Map<java.lang.String, ? extends java.lang.Object> imageAssetPublishingRoleAdditionalOptions) {
            this.imageAssetPublishingRoleAdditionalOptions = (java.util.Map<java.lang.String, java.lang.Object>)imageAssetPublishingRoleAdditionalOptions;
            return this;
        }

        /**
         * Sets the value of {@link DefaultStackSynthesizerProps#getImageAssetPublishingRoleArn}
         * @param imageAssetPublishingRoleArn The role to use to publish image assets to the ECR repository in this environment.
         *                                    You must supply this if you have given a non-standard name to the publishing role.
         *                                    <p>
         *                                    The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
         *                                    be replaced with the values of qualifier and the stack's account and region,
         *                                    respectively.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageAssetPublishingRoleArn(java.lang.String imageAssetPublishingRoleArn) {
            this.imageAssetPublishingRoleArn = imageAssetPublishingRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link DefaultStackSynthesizerProps#getImageAssetsRepositoryName}
         * @param imageAssetsRepositoryName Name of the ECR repository to hold Docker Image assets.
         *                                  You must supply this if you have given a non-standard name to the ECR repository.
         *                                  <p>
         *                                  The placeholders <code>${Qualifier}</code>, <code>${AWS::AccountId}</code> and <code>${AWS::Region}</code> will
         *                                  be replaced with the values of qualifier and the stack's account and region,
         *                                  respectively.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageAssetsRepositoryName(java.lang.String imageAssetsRepositoryName) {
            this.imageAssetsRepositoryName = imageAssetsRepositoryName;
            return this;
        }

        /**
         * Sets the value of {@link DefaultStackSynthesizerProps#getLookupRoleAdditionalOptions}
         * @param lookupRoleAdditionalOptions Additional options to pass to STS when assuming the lookup role.
         *                                    <ul>
         *                                    <li><code>RoleArn</code> should not be used. Use the dedicated <code>lookupRoleArn</code> property instead.</li>
         *                                    <li><code>ExternalId</code> should not be used. Use the dedicated <code>lookupRoleExternalId</code> instead.</li>
         *                                    <li><code>TransitiveTagKeys</code> defaults to use all keys (if any) specified in <code>Tags</code>. E.g, all tags are transitive by default.</li>
         *                                    </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder lookupRoleAdditionalOptions(java.util.Map<java.lang.String, ? extends java.lang.Object> lookupRoleAdditionalOptions) {
            this.lookupRoleAdditionalOptions = (java.util.Map<java.lang.String, java.lang.Object>)lookupRoleAdditionalOptions;
            return this;
        }

        /**
         * Sets the value of {@link DefaultStackSynthesizerProps#getLookupRoleArn}
         * @param lookupRoleArn The role to use to look up values from the target AWS account during synthesis.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lookupRoleArn(java.lang.String lookupRoleArn) {
            this.lookupRoleArn = lookupRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link DefaultStackSynthesizerProps#getLookupRoleExternalId}
         * @param lookupRoleExternalId External ID to use when assuming lookup role.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lookupRoleExternalId(java.lang.String lookupRoleExternalId) {
            this.lookupRoleExternalId = lookupRoleExternalId;
            return this;
        }

        /**
         * Sets the value of {@link DefaultStackSynthesizerProps#getQualifier}
         * @param qualifier Qualifier to disambiguate multiple environments in the same account.
         *                  You can use this and leave the other naming properties empty if you have deployed
         *                  the bootstrap environment with standard names but only different qualifiers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder qualifier(java.lang.String qualifier) {
            this.qualifier = qualifier;
            return this;
        }

        /**
         * Sets the value of {@link DefaultStackSynthesizerProps#getUseLookupRoleForStackOperations}
         * @param useLookupRoleForStackOperations Use the bootstrapped lookup role for (read-only) stack operations.
         *                                        Use the lookup role when performing a <code>cdk diff</code>. If set to <code>false</code>, the
         *                                        <code>deploy role</code> credentials will be used to perform a <code>cdk diff</code>.
         *                                        <p>
         *                                        Requires bootstrap stack version 8.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useLookupRoleForStackOperations(java.lang.Boolean useLookupRoleForStackOperations) {
            this.useLookupRoleForStackOperations = useLookupRoleForStackOperations;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DefaultStackSynthesizerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DefaultStackSynthesizerProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DefaultStackSynthesizerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DefaultStackSynthesizerProps {
        private final java.lang.String bootstrapStackVersionSsmParameter;
        private final java.lang.String bucketPrefix;
        private final java.lang.String cloudFormationExecutionRole;
        private final java.util.Map<java.lang.String, java.lang.Object> deployRoleAdditionalOptions;
        private final java.lang.String deployRoleArn;
        private final java.lang.String deployRoleExternalId;
        private final java.lang.String dockerTagPrefix;
        private final java.lang.String fileAssetPublishingExternalId;
        private final java.util.Map<java.lang.String, java.lang.Object> fileAssetPublishingRoleAdditionalOptions;
        private final java.lang.String fileAssetPublishingRoleArn;
        private final java.lang.String fileAssetsBucketName;
        private final java.lang.Boolean generateBootstrapVersionRule;
        private final java.lang.String imageAssetPublishingExternalId;
        private final java.util.Map<java.lang.String, java.lang.Object> imageAssetPublishingRoleAdditionalOptions;
        private final java.lang.String imageAssetPublishingRoleArn;
        private final java.lang.String imageAssetsRepositoryName;
        private final java.util.Map<java.lang.String, java.lang.Object> lookupRoleAdditionalOptions;
        private final java.lang.String lookupRoleArn;
        private final java.lang.String lookupRoleExternalId;
        private final java.lang.String qualifier;
        private final java.lang.Boolean useLookupRoleForStackOperations;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.bootstrapStackVersionSsmParameter = software.amazon.jsii.Kernel.get(this, "bootstrapStackVersionSsmParameter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.bucketPrefix = software.amazon.jsii.Kernel.get(this, "bucketPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cloudFormationExecutionRole = software.amazon.jsii.Kernel.get(this, "cloudFormationExecutionRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deployRoleAdditionalOptions = software.amazon.jsii.Kernel.get(this, "deployRoleAdditionalOptions", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.deployRoleArn = software.amazon.jsii.Kernel.get(this, "deployRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deployRoleExternalId = software.amazon.jsii.Kernel.get(this, "deployRoleExternalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dockerTagPrefix = software.amazon.jsii.Kernel.get(this, "dockerTagPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.fileAssetPublishingExternalId = software.amazon.jsii.Kernel.get(this, "fileAssetPublishingExternalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.fileAssetPublishingRoleAdditionalOptions = software.amazon.jsii.Kernel.get(this, "fileAssetPublishingRoleAdditionalOptions", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.fileAssetPublishingRoleArn = software.amazon.jsii.Kernel.get(this, "fileAssetPublishingRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.fileAssetsBucketName = software.amazon.jsii.Kernel.get(this, "fileAssetsBucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.generateBootstrapVersionRule = software.amazon.jsii.Kernel.get(this, "generateBootstrapVersionRule", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.imageAssetPublishingExternalId = software.amazon.jsii.Kernel.get(this, "imageAssetPublishingExternalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.imageAssetPublishingRoleAdditionalOptions = software.amazon.jsii.Kernel.get(this, "imageAssetPublishingRoleAdditionalOptions", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.imageAssetPublishingRoleArn = software.amazon.jsii.Kernel.get(this, "imageAssetPublishingRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.imageAssetsRepositoryName = software.amazon.jsii.Kernel.get(this, "imageAssetsRepositoryName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.lookupRoleAdditionalOptions = software.amazon.jsii.Kernel.get(this, "lookupRoleAdditionalOptions", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.lookupRoleArn = software.amazon.jsii.Kernel.get(this, "lookupRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.lookupRoleExternalId = software.amazon.jsii.Kernel.get(this, "lookupRoleExternalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.qualifier = software.amazon.jsii.Kernel.get(this, "qualifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.useLookupRoleForStackOperations = software.amazon.jsii.Kernel.get(this, "useLookupRoleForStackOperations", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bootstrapStackVersionSsmParameter = builder.bootstrapStackVersionSsmParameter;
            this.bucketPrefix = builder.bucketPrefix;
            this.cloudFormationExecutionRole = builder.cloudFormationExecutionRole;
            this.deployRoleAdditionalOptions = (java.util.Map<java.lang.String, java.lang.Object>)builder.deployRoleAdditionalOptions;
            this.deployRoleArn = builder.deployRoleArn;
            this.deployRoleExternalId = builder.deployRoleExternalId;
            this.dockerTagPrefix = builder.dockerTagPrefix;
            this.fileAssetPublishingExternalId = builder.fileAssetPublishingExternalId;
            this.fileAssetPublishingRoleAdditionalOptions = (java.util.Map<java.lang.String, java.lang.Object>)builder.fileAssetPublishingRoleAdditionalOptions;
            this.fileAssetPublishingRoleArn = builder.fileAssetPublishingRoleArn;
            this.fileAssetsBucketName = builder.fileAssetsBucketName;
            this.generateBootstrapVersionRule = builder.generateBootstrapVersionRule;
            this.imageAssetPublishingExternalId = builder.imageAssetPublishingExternalId;
            this.imageAssetPublishingRoleAdditionalOptions = (java.util.Map<java.lang.String, java.lang.Object>)builder.imageAssetPublishingRoleAdditionalOptions;
            this.imageAssetPublishingRoleArn = builder.imageAssetPublishingRoleArn;
            this.imageAssetsRepositoryName = builder.imageAssetsRepositoryName;
            this.lookupRoleAdditionalOptions = (java.util.Map<java.lang.String, java.lang.Object>)builder.lookupRoleAdditionalOptions;
            this.lookupRoleArn = builder.lookupRoleArn;
            this.lookupRoleExternalId = builder.lookupRoleExternalId;
            this.qualifier = builder.qualifier;
            this.useLookupRoleForStackOperations = builder.useLookupRoleForStackOperations;
        }

        @Override
        public final java.lang.String getBootstrapStackVersionSsmParameter() {
            return this.bootstrapStackVersionSsmParameter;
        }

        @Override
        public final java.lang.String getBucketPrefix() {
            return this.bucketPrefix;
        }

        @Override
        public final java.lang.String getCloudFormationExecutionRole() {
            return this.cloudFormationExecutionRole;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getDeployRoleAdditionalOptions() {
            return this.deployRoleAdditionalOptions;
        }

        @Override
        public final java.lang.String getDeployRoleArn() {
            return this.deployRoleArn;
        }

        @Override
        public final java.lang.String getDeployRoleExternalId() {
            return this.deployRoleExternalId;
        }

        @Override
        public final java.lang.String getDockerTagPrefix() {
            return this.dockerTagPrefix;
        }

        @Override
        public final java.lang.String getFileAssetPublishingExternalId() {
            return this.fileAssetPublishingExternalId;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getFileAssetPublishingRoleAdditionalOptions() {
            return this.fileAssetPublishingRoleAdditionalOptions;
        }

        @Override
        public final java.lang.String getFileAssetPublishingRoleArn() {
            return this.fileAssetPublishingRoleArn;
        }

        @Override
        public final java.lang.String getFileAssetsBucketName() {
            return this.fileAssetsBucketName;
        }

        @Override
        public final java.lang.Boolean getGenerateBootstrapVersionRule() {
            return this.generateBootstrapVersionRule;
        }

        @Override
        public final java.lang.String getImageAssetPublishingExternalId() {
            return this.imageAssetPublishingExternalId;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getImageAssetPublishingRoleAdditionalOptions() {
            return this.imageAssetPublishingRoleAdditionalOptions;
        }

        @Override
        public final java.lang.String getImageAssetPublishingRoleArn() {
            return this.imageAssetPublishingRoleArn;
        }

        @Override
        public final java.lang.String getImageAssetsRepositoryName() {
            return this.imageAssetsRepositoryName;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getLookupRoleAdditionalOptions() {
            return this.lookupRoleAdditionalOptions;
        }

        @Override
        public final java.lang.String getLookupRoleArn() {
            return this.lookupRoleArn;
        }

        @Override
        public final java.lang.String getLookupRoleExternalId() {
            return this.lookupRoleExternalId;
        }

        @Override
        public final java.lang.String getQualifier() {
            return this.qualifier;
        }

        @Override
        public final java.lang.Boolean getUseLookupRoleForStackOperations() {
            return this.useLookupRoleForStackOperations;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBootstrapStackVersionSsmParameter() != null) {
                data.set("bootstrapStackVersionSsmParameter", om.valueToTree(this.getBootstrapStackVersionSsmParameter()));
            }
            if (this.getBucketPrefix() != null) {
                data.set("bucketPrefix", om.valueToTree(this.getBucketPrefix()));
            }
            if (this.getCloudFormationExecutionRole() != null) {
                data.set("cloudFormationExecutionRole", om.valueToTree(this.getCloudFormationExecutionRole()));
            }
            if (this.getDeployRoleAdditionalOptions() != null) {
                data.set("deployRoleAdditionalOptions", om.valueToTree(this.getDeployRoleAdditionalOptions()));
            }
            if (this.getDeployRoleArn() != null) {
                data.set("deployRoleArn", om.valueToTree(this.getDeployRoleArn()));
            }
            if (this.getDeployRoleExternalId() != null) {
                data.set("deployRoleExternalId", om.valueToTree(this.getDeployRoleExternalId()));
            }
            if (this.getDockerTagPrefix() != null) {
                data.set("dockerTagPrefix", om.valueToTree(this.getDockerTagPrefix()));
            }
            if (this.getFileAssetPublishingExternalId() != null) {
                data.set("fileAssetPublishingExternalId", om.valueToTree(this.getFileAssetPublishingExternalId()));
            }
            if (this.getFileAssetPublishingRoleAdditionalOptions() != null) {
                data.set("fileAssetPublishingRoleAdditionalOptions", om.valueToTree(this.getFileAssetPublishingRoleAdditionalOptions()));
            }
            if (this.getFileAssetPublishingRoleArn() != null) {
                data.set("fileAssetPublishingRoleArn", om.valueToTree(this.getFileAssetPublishingRoleArn()));
            }
            if (this.getFileAssetsBucketName() != null) {
                data.set("fileAssetsBucketName", om.valueToTree(this.getFileAssetsBucketName()));
            }
            if (this.getGenerateBootstrapVersionRule() != null) {
                data.set("generateBootstrapVersionRule", om.valueToTree(this.getGenerateBootstrapVersionRule()));
            }
            if (this.getImageAssetPublishingExternalId() != null) {
                data.set("imageAssetPublishingExternalId", om.valueToTree(this.getImageAssetPublishingExternalId()));
            }
            if (this.getImageAssetPublishingRoleAdditionalOptions() != null) {
                data.set("imageAssetPublishingRoleAdditionalOptions", om.valueToTree(this.getImageAssetPublishingRoleAdditionalOptions()));
            }
            if (this.getImageAssetPublishingRoleArn() != null) {
                data.set("imageAssetPublishingRoleArn", om.valueToTree(this.getImageAssetPublishingRoleArn()));
            }
            if (this.getImageAssetsRepositoryName() != null) {
                data.set("imageAssetsRepositoryName", om.valueToTree(this.getImageAssetsRepositoryName()));
            }
            if (this.getLookupRoleAdditionalOptions() != null) {
                data.set("lookupRoleAdditionalOptions", om.valueToTree(this.getLookupRoleAdditionalOptions()));
            }
            if (this.getLookupRoleArn() != null) {
                data.set("lookupRoleArn", om.valueToTree(this.getLookupRoleArn()));
            }
            if (this.getLookupRoleExternalId() != null) {
                data.set("lookupRoleExternalId", om.valueToTree(this.getLookupRoleExternalId()));
            }
            if (this.getQualifier() != null) {
                data.set("qualifier", om.valueToTree(this.getQualifier()));
            }
            if (this.getUseLookupRoleForStackOperations() != null) {
                data.set("useLookupRoleForStackOperations", om.valueToTree(this.getUseLookupRoleForStackOperations()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.DefaultStackSynthesizerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DefaultStackSynthesizerProps.Jsii$Proxy that = (DefaultStackSynthesizerProps.Jsii$Proxy) o;

            if (this.bootstrapStackVersionSsmParameter != null ? !this.bootstrapStackVersionSsmParameter.equals(that.bootstrapStackVersionSsmParameter) : that.bootstrapStackVersionSsmParameter != null) return false;
            if (this.bucketPrefix != null ? !this.bucketPrefix.equals(that.bucketPrefix) : that.bucketPrefix != null) return false;
            if (this.cloudFormationExecutionRole != null ? !this.cloudFormationExecutionRole.equals(that.cloudFormationExecutionRole) : that.cloudFormationExecutionRole != null) return false;
            if (this.deployRoleAdditionalOptions != null ? !this.deployRoleAdditionalOptions.equals(that.deployRoleAdditionalOptions) : that.deployRoleAdditionalOptions != null) return false;
            if (this.deployRoleArn != null ? !this.deployRoleArn.equals(that.deployRoleArn) : that.deployRoleArn != null) return false;
            if (this.deployRoleExternalId != null ? !this.deployRoleExternalId.equals(that.deployRoleExternalId) : that.deployRoleExternalId != null) return false;
            if (this.dockerTagPrefix != null ? !this.dockerTagPrefix.equals(that.dockerTagPrefix) : that.dockerTagPrefix != null) return false;
            if (this.fileAssetPublishingExternalId != null ? !this.fileAssetPublishingExternalId.equals(that.fileAssetPublishingExternalId) : that.fileAssetPublishingExternalId != null) return false;
            if (this.fileAssetPublishingRoleAdditionalOptions != null ? !this.fileAssetPublishingRoleAdditionalOptions.equals(that.fileAssetPublishingRoleAdditionalOptions) : that.fileAssetPublishingRoleAdditionalOptions != null) return false;
            if (this.fileAssetPublishingRoleArn != null ? !this.fileAssetPublishingRoleArn.equals(that.fileAssetPublishingRoleArn) : that.fileAssetPublishingRoleArn != null) return false;
            if (this.fileAssetsBucketName != null ? !this.fileAssetsBucketName.equals(that.fileAssetsBucketName) : that.fileAssetsBucketName != null) return false;
            if (this.generateBootstrapVersionRule != null ? !this.generateBootstrapVersionRule.equals(that.generateBootstrapVersionRule) : that.generateBootstrapVersionRule != null) return false;
            if (this.imageAssetPublishingExternalId != null ? !this.imageAssetPublishingExternalId.equals(that.imageAssetPublishingExternalId) : that.imageAssetPublishingExternalId != null) return false;
            if (this.imageAssetPublishingRoleAdditionalOptions != null ? !this.imageAssetPublishingRoleAdditionalOptions.equals(that.imageAssetPublishingRoleAdditionalOptions) : that.imageAssetPublishingRoleAdditionalOptions != null) return false;
            if (this.imageAssetPublishingRoleArn != null ? !this.imageAssetPublishingRoleArn.equals(that.imageAssetPublishingRoleArn) : that.imageAssetPublishingRoleArn != null) return false;
            if (this.imageAssetsRepositoryName != null ? !this.imageAssetsRepositoryName.equals(that.imageAssetsRepositoryName) : that.imageAssetsRepositoryName != null) return false;
            if (this.lookupRoleAdditionalOptions != null ? !this.lookupRoleAdditionalOptions.equals(that.lookupRoleAdditionalOptions) : that.lookupRoleAdditionalOptions != null) return false;
            if (this.lookupRoleArn != null ? !this.lookupRoleArn.equals(that.lookupRoleArn) : that.lookupRoleArn != null) return false;
            if (this.lookupRoleExternalId != null ? !this.lookupRoleExternalId.equals(that.lookupRoleExternalId) : that.lookupRoleExternalId != null) return false;
            if (this.qualifier != null ? !this.qualifier.equals(that.qualifier) : that.qualifier != null) return false;
            return this.useLookupRoleForStackOperations != null ? this.useLookupRoleForStackOperations.equals(that.useLookupRoleForStackOperations) : that.useLookupRoleForStackOperations == null;
        }

        @Override
        public final int hashCode() {
            int result = this.bootstrapStackVersionSsmParameter != null ? this.bootstrapStackVersionSsmParameter.hashCode() : 0;
            result = 31 * result + (this.bucketPrefix != null ? this.bucketPrefix.hashCode() : 0);
            result = 31 * result + (this.cloudFormationExecutionRole != null ? this.cloudFormationExecutionRole.hashCode() : 0);
            result = 31 * result + (this.deployRoleAdditionalOptions != null ? this.deployRoleAdditionalOptions.hashCode() : 0);
            result = 31 * result + (this.deployRoleArn != null ? this.deployRoleArn.hashCode() : 0);
            result = 31 * result + (this.deployRoleExternalId != null ? this.deployRoleExternalId.hashCode() : 0);
            result = 31 * result + (this.dockerTagPrefix != null ? this.dockerTagPrefix.hashCode() : 0);
            result = 31 * result + (this.fileAssetPublishingExternalId != null ? this.fileAssetPublishingExternalId.hashCode() : 0);
            result = 31 * result + (this.fileAssetPublishingRoleAdditionalOptions != null ? this.fileAssetPublishingRoleAdditionalOptions.hashCode() : 0);
            result = 31 * result + (this.fileAssetPublishingRoleArn != null ? this.fileAssetPublishingRoleArn.hashCode() : 0);
            result = 31 * result + (this.fileAssetsBucketName != null ? this.fileAssetsBucketName.hashCode() : 0);
            result = 31 * result + (this.generateBootstrapVersionRule != null ? this.generateBootstrapVersionRule.hashCode() : 0);
            result = 31 * result + (this.imageAssetPublishingExternalId != null ? this.imageAssetPublishingExternalId.hashCode() : 0);
            result = 31 * result + (this.imageAssetPublishingRoleAdditionalOptions != null ? this.imageAssetPublishingRoleAdditionalOptions.hashCode() : 0);
            result = 31 * result + (this.imageAssetPublishingRoleArn != null ? this.imageAssetPublishingRoleArn.hashCode() : 0);
            result = 31 * result + (this.imageAssetsRepositoryName != null ? this.imageAssetsRepositoryName.hashCode() : 0);
            result = 31 * result + (this.lookupRoleAdditionalOptions != null ? this.lookupRoleAdditionalOptions.hashCode() : 0);
            result = 31 * result + (this.lookupRoleArn != null ? this.lookupRoleArn.hashCode() : 0);
            result = 31 * result + (this.lookupRoleExternalId != null ? this.lookupRoleExternalId.hashCode() : 0);
            result = 31 * result + (this.qualifier != null ? this.qualifier.hashCode() : 0);
            result = 31 * result + (this.useLookupRoleForStackOperations != null ? this.useLookupRoleForStackOperations.hashCode() : 0);
            return result;
        }
    }
}
