package software.amazon.awscdk;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * Object dummyValue;
 * Object props;
 * GetContextValueOptions getContextValueOptions = GetContextValueOptions.builder()
 *         .dummyValue(dummyValue)
 *         .provider("provider")
 *         // the properties below are optional
 *         .ignoreErrorOnMissingContext(false)
 *         .includeEnvironment(false)
 *         .mustExist(false)
 *         .props(Map.of(
 *                 "propsKey", props))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:32.895Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.GetContextValueOptions")
@software.amazon.jsii.Jsii.Proxy(GetContextValueOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface GetContextValueOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.GetContextKeyOptions {

    /**
     * The value to return if the lookup has not yet been performed.
     * <p>
     * Upon first synthesis, the lookups has not yet been performed. The
     * <code>getValue()</code> operation returns this value instead, so that synthesis can
     * proceed. After synthesis completes the first time, the actual lookup will
     * be performed and synthesis will run again with the <em>real</em> value.
     * <p>
     * Dummy values should preferably have valid shapes so that downstream
     * consumers of lookup values don't throw validation exceptions if they
     * encounter a dummy value (or all possible downstream consumers need to
     * effectively check for the well-known shape of the dummy value); throwing an
     * exception would error out the synthesis operation and prevent the lookup
     * and the second, real, synthesis from happening.
     * <p>
     * <h2>Connection to mustExist</h2>
     * <p>
     * <code>dummyValue</code> is also used as the official value to return if the lookup has
     * failed and <code>mustExist == false</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getDummyValue();

    /**
     * (deprecated) Ignore a lookup failure and return the <code>dummyValue</code> instead.
     * <p>
     * <code>mustExist</code> is the recommended alias for this deprecated
     * property (note that its value is reversed).
     * <p>
     * Default: false
     * <p>
     * @deprecated Use mustExist instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIgnoreErrorOnMissingContext() {
        return null;
    }

    /**
     * Whether the resource must exist.
     * <p>
     * If this is set (the default), the query fails if the value or resource we
     * tried to look up doesn't exist.
     * <p>
     * If this is <code>false</code> and the value we tried to look up could not be found, the
     * failure is suppressed and <code>dummyValue</code> is officially returned instead.
     * <p>
     * When this happens, <code>dummyValue</code> is encoded into cached context and it will
     * never be refreshed anymore until the user runs <code>cdk context --reset &lt;key&gt;</code>.
     * <p>
     * Note that it is not possible for the CDK app code to make a distinction
     * between "the lookup has not been performed yet" and "the lookup didn't
     * find anything and we returned a default value instead".
     * <p>
     * <h2>Context providers</h2>
     * <p>
     * This feature must explicitly be supported by context providers. It is
     * currently supported by:
     * <p>
     * <ul>
     * <li>KMS key provider</li>
     * <li>SSM parameter provider</li>
     * </ul>
     * <p>
     * <h2>Note to implementors</h2>
     * <p>
     * The dummy value should not be returned for all SDK lookup failures. For
     * example, "no network" or "no credentials" or "malformed query" should
     * not lead to the dummy value being returned. Only the case of "no such
     * resource" should.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getMustExist() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link GetContextValueOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link GetContextValueOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<GetContextValueOptions> {
        java.lang.Object dummyValue;
        java.lang.Boolean ignoreErrorOnMissingContext;
        java.lang.Boolean mustExist;
        java.lang.String provider;
        java.lang.Boolean includeEnvironment;
        java.util.Map<java.lang.String, java.lang.Object> props;

        /**
         * Sets the value of {@link GetContextValueOptions#getDummyValue}
         * @param dummyValue The value to return if the lookup has not yet been performed. This parameter is required.
         *                   Upon first synthesis, the lookups has not yet been performed. The
         *                   <code>getValue()</code> operation returns this value instead, so that synthesis can
         *                   proceed. After synthesis completes the first time, the actual lookup will
         *                   be performed and synthesis will run again with the <em>real</em> value.
         *                   <p>
         *                   Dummy values should preferably have valid shapes so that downstream
         *                   consumers of lookup values don't throw validation exceptions if they
         *                   encounter a dummy value (or all possible downstream consumers need to
         *                   effectively check for the well-known shape of the dummy value); throwing an
         *                   exception would error out the synthesis operation and prevent the lookup
         *                   and the second, real, synthesis from happening.
         *                   <p>
         *                   <h2>Connection to mustExist</h2>
         *                   <p>
         *                   <code>dummyValue</code> is also used as the official value to return if the lookup has
         *                   failed and <code>mustExist == false</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dummyValue(java.lang.Object dummyValue) {
            this.dummyValue = dummyValue;
            return this;
        }

        /**
         * Sets the value of {@link GetContextValueOptions#getIgnoreErrorOnMissingContext}
         * @param ignoreErrorOnMissingContext Ignore a lookup failure and return the <code>dummyValue</code> instead.
         *                                    <code>mustExist</code> is the recommended alias for this deprecated
         *                                    property (note that its value is reversed).
         * @return {@code this}
         * @deprecated Use mustExist instead
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder ignoreErrorOnMissingContext(java.lang.Boolean ignoreErrorOnMissingContext) {
            this.ignoreErrorOnMissingContext = ignoreErrorOnMissingContext;
            return this;
        }

        /**
         * Sets the value of {@link GetContextValueOptions#getMustExist}
         * @param mustExist Whether the resource must exist.
         *                  If this is set (the default), the query fails if the value or resource we
         *                  tried to look up doesn't exist.
         *                  <p>
         *                  If this is <code>false</code> and the value we tried to look up could not be found, the
         *                  failure is suppressed and <code>dummyValue</code> is officially returned instead.
         *                  <p>
         *                  When this happens, <code>dummyValue</code> is encoded into cached context and it will
         *                  never be refreshed anymore until the user runs <code>cdk context --reset &lt;key&gt;</code>.
         *                  <p>
         *                  Note that it is not possible for the CDK app code to make a distinction
         *                  between "the lookup has not been performed yet" and "the lookup didn't
         *                  find anything and we returned a default value instead".
         *                  <p>
         *                  <h2>Context providers</h2>
         *                  <p>
         *                  This feature must explicitly be supported by context providers. It is
         *                  currently supported by:
         *                  <p>
         *                  <ul>
         *                  <li>KMS key provider</li>
         *                  <li>SSM parameter provider</li>
         *                  </ul>
         *                  <p>
         *                  <h2>Note to implementors</h2>
         *                  <p>
         *                  The dummy value should not be returned for all SDK lookup failures. For
         *                  example, "no network" or "no credentials" or "malformed query" should
         *                  not lead to the dummy value being returned. Only the case of "no such
         *                  resource" should.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mustExist(java.lang.Boolean mustExist) {
            this.mustExist = mustExist;
            return this;
        }

        /**
         * Sets the value of {@link GetContextValueOptions#getProvider}
         * @param provider The context provider to query. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provider(java.lang.String provider) {
            this.provider = provider;
            return this;
        }

        /**
         * Sets the value of {@link GetContextValueOptions#getIncludeEnvironment}
         * @param includeEnvironment Whether to include the stack's account and region automatically.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder includeEnvironment(java.lang.Boolean includeEnvironment) {
            this.includeEnvironment = includeEnvironment;
            return this;
        }

        /**
         * Sets the value of {@link GetContextValueOptions#getProps}
         * @param props Provider-specific properties.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder props(java.util.Map<java.lang.String, ? extends java.lang.Object> props) {
            this.props = (java.util.Map<java.lang.String, java.lang.Object>)props;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GetContextValueOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public GetContextValueOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link GetContextValueOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GetContextValueOptions {
        private final java.lang.Object dummyValue;
        private final java.lang.Boolean ignoreErrorOnMissingContext;
        private final java.lang.Boolean mustExist;
        private final java.lang.String provider;
        private final java.lang.Boolean includeEnvironment;
        private final java.util.Map<java.lang.String, java.lang.Object> props;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.dummyValue = software.amazon.jsii.Kernel.get(this, "dummyValue", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.ignoreErrorOnMissingContext = software.amazon.jsii.Kernel.get(this, "ignoreErrorOnMissingContext", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.mustExist = software.amazon.jsii.Kernel.get(this, "mustExist", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.provider = software.amazon.jsii.Kernel.get(this, "provider", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.includeEnvironment = software.amazon.jsii.Kernel.get(this, "includeEnvironment", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.props = software.amazon.jsii.Kernel.get(this, "props", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.dummyValue = java.util.Objects.requireNonNull(builder.dummyValue, "dummyValue is required");
            this.ignoreErrorOnMissingContext = builder.ignoreErrorOnMissingContext;
            this.mustExist = builder.mustExist;
            this.provider = java.util.Objects.requireNonNull(builder.provider, "provider is required");
            this.includeEnvironment = builder.includeEnvironment;
            this.props = (java.util.Map<java.lang.String, java.lang.Object>)builder.props;
        }

        @Override
        public final java.lang.Object getDummyValue() {
            return this.dummyValue;
        }

        @Override
        public final java.lang.Boolean getIgnoreErrorOnMissingContext() {
            return this.ignoreErrorOnMissingContext;
        }

        @Override
        public final java.lang.Boolean getMustExist() {
            return this.mustExist;
        }

        @Override
        public final java.lang.String getProvider() {
            return this.provider;
        }

        @Override
        public final java.lang.Boolean getIncludeEnvironment() {
            return this.includeEnvironment;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getProps() {
            return this.props;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("dummyValue", om.valueToTree(this.getDummyValue()));
            if (this.getIgnoreErrorOnMissingContext() != null) {
                data.set("ignoreErrorOnMissingContext", om.valueToTree(this.getIgnoreErrorOnMissingContext()));
            }
            if (this.getMustExist() != null) {
                data.set("mustExist", om.valueToTree(this.getMustExist()));
            }
            data.set("provider", om.valueToTree(this.getProvider()));
            if (this.getIncludeEnvironment() != null) {
                data.set("includeEnvironment", om.valueToTree(this.getIncludeEnvironment()));
            }
            if (this.getProps() != null) {
                data.set("props", om.valueToTree(this.getProps()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.GetContextValueOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GetContextValueOptions.Jsii$Proxy that = (GetContextValueOptions.Jsii$Proxy) o;

            if (!dummyValue.equals(that.dummyValue)) return false;
            if (this.ignoreErrorOnMissingContext != null ? !this.ignoreErrorOnMissingContext.equals(that.ignoreErrorOnMissingContext) : that.ignoreErrorOnMissingContext != null) return false;
            if (this.mustExist != null ? !this.mustExist.equals(that.mustExist) : that.mustExist != null) return false;
            if (!provider.equals(that.provider)) return false;
            if (this.includeEnvironment != null ? !this.includeEnvironment.equals(that.includeEnvironment) : that.includeEnvironment != null) return false;
            return this.props != null ? this.props.equals(that.props) : that.props == null;
        }

        @Override
        public final int hashCode() {
            int result = this.dummyValue.hashCode();
            result = 31 * result + (this.ignoreErrorOnMissingContext != null ? this.ignoreErrorOnMissingContext.hashCode() : 0);
            result = 31 * result + (this.mustExist != null ? this.mustExist.hashCode() : 0);
            result = 31 * result + (this.provider.hashCode());
            result = 31 * result + (this.includeEnvironment != null ? this.includeEnvironment.hashCode() : 0);
            result = 31 * result + (this.props != null ? this.props.hashCode() : 0);
            return result;
        }
    }
}
