package software.amazon.awscdk.customresources;

/**
 * Properties used to initialize Logging.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.customresources.*;
 * LoggingProps loggingProps = LoggingProps.builder()
 *         .logApiResponseData(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:48.981Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.custom_resources.LoggingProps")
@software.amazon.jsii.Jsii.Proxy(LoggingProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LoggingProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Whether or not to log data associated with the API call response.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getLogApiResponseData() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LoggingProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LoggingProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LoggingProps> {
        java.lang.Boolean logApiResponseData;

        /**
         * Sets the value of {@link LoggingProps#getLogApiResponseData}
         * @param logApiResponseData Whether or not to log data associated with the API call response.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logApiResponseData(java.lang.Boolean logApiResponseData) {
            this.logApiResponseData = logApiResponseData;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LoggingProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LoggingProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LoggingProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoggingProps {
        private final java.lang.Boolean logApiResponseData;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.logApiResponseData = software.amazon.jsii.Kernel.get(this, "logApiResponseData", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.logApiResponseData = builder.logApiResponseData;
        }

        @Override
        public final java.lang.Boolean getLogApiResponseData() {
            return this.logApiResponseData;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getLogApiResponseData() != null) {
                data.set("logApiResponseData", om.valueToTree(this.getLogApiResponseData()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.custom_resources.LoggingProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LoggingProps.Jsii$Proxy that = (LoggingProps.Jsii$Proxy) o;

            return this.logApiResponseData != null ? this.logApiResponseData.equals(that.logApiResponseData) : that.logApiResponseData == null;
        }

        @Override
        public final int hashCode() {
            int result = this.logApiResponseData != null ? this.logApiResponseData.hashCode() : 0;
            return result;
        }
    }
}
