package software.amazon.awscdk.services.apigateway;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.apigateway.*;
 * Authorizer authorizer;
 * Integration integration;
 * Model model;
 * RequestValidator requestValidator;
 * Resource resource;
 * ResourceProps resourceProps = ResourceProps.builder()
 *         .parent(resource)
 *         .pathPart("pathPart")
 *         // the properties below are optional
 *         .defaultCorsPreflightOptions(CorsOptions.builder()
 *                 .allowOrigins(List.of("allowOrigins"))
 *                 // the properties below are optional
 *                 .allowCredentials(false)
 *                 .allowHeaders(List.of("allowHeaders"))
 *                 .allowMethods(List.of("allowMethods"))
 *                 .disableCache(false)
 *                 .exposeHeaders(List.of("exposeHeaders"))
 *                 .maxAge(Duration.minutes(30))
 *                 .statusCode(123)
 *                 .build())
 *         .defaultIntegration(integration)
 *         .defaultMethodOptions(MethodOptions.builder()
 *                 .apiKeyRequired(false)
 *                 .authorizationScopes(List.of("authorizationScopes"))
 *                 .authorizationType(AuthorizationType.NONE)
 *                 .authorizer(authorizer)
 *                 .methodResponses(List.of(MethodResponse.builder()
 *                         .statusCode("statusCode")
 *                         // the properties below are optional
 *                         .responseModels(Map.of(
 *                                 "responseModelsKey", model))
 *                         .responseParameters(Map.of(
 *                                 "responseParametersKey", false))
 *                         .build()))
 *                 .operationName("operationName")
 *                 .requestModels(Map.of(
 *                         "requestModelsKey", model))
 *                 .requestParameters(Map.of(
 *                         "requestParametersKey", false))
 *                 .requestValidator(requestValidator)
 *                 .requestValidatorOptions(RequestValidatorOptions.builder()
 *                         .requestValidatorName("requestValidatorName")
 *                         .validateRequestBody(false)
 *                         .validateRequestParameters(false)
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:33.359Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigateway.ResourceProps")
@software.amazon.jsii.Jsii.Proxy(ResourceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ResourceProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.apigateway.ResourceOptions {

    /**
     * The parent resource of this resource.
     * <p>
     * You can either pass another
     * <code>Resource</code> object or a <code>RestApi</code> object here.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.IResource getParent();

    /**
     * A path name for the resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPathPart();

    /**
     * @return a {@link Builder} of {@link ResourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ResourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ResourceProps> {
        software.amazon.awscdk.services.apigateway.IResource parent;
        java.lang.String pathPart;
        software.amazon.awscdk.services.apigateway.CorsOptions defaultCorsPreflightOptions;
        software.amazon.awscdk.services.apigateway.Integration defaultIntegration;
        software.amazon.awscdk.services.apigateway.MethodOptions defaultMethodOptions;

        /**
         * Sets the value of {@link ResourceProps#getParent}
         * @param parent The parent resource of this resource. This parameter is required.
         *               You can either pass another
         *               <code>Resource</code> object or a <code>RestApi</code> object here.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parent(software.amazon.awscdk.services.apigateway.IResource parent) {
            this.parent = parent;
            return this;
        }

        /**
         * Sets the value of {@link ResourceProps#getPathPart}
         * @param pathPart A path name for the resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pathPart(java.lang.String pathPart) {
            this.pathPart = pathPart;
            return this;
        }

        /**
         * Sets the value of {@link ResourceProps#getDefaultCorsPreflightOptions}
         * @param defaultCorsPreflightOptions Adds a CORS preflight OPTIONS method to this resource and all child resources.
         *                                    You can add CORS at the resource-level using <code>addCorsPreflight</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultCorsPreflightOptions(software.amazon.awscdk.services.apigateway.CorsOptions defaultCorsPreflightOptions) {
            this.defaultCorsPreflightOptions = defaultCorsPreflightOptions;
            return this;
        }

        /**
         * Sets the value of {@link ResourceProps#getDefaultIntegration}
         * @param defaultIntegration An integration to use as a default for all methods created within this API unless an integration is specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultIntegration(software.amazon.awscdk.services.apigateway.Integration defaultIntegration) {
            this.defaultIntegration = defaultIntegration;
            return this;
        }

        /**
         * Sets the value of {@link ResourceProps#getDefaultMethodOptions}
         * @param defaultMethodOptions Method options to use as a default for all methods created within this API unless custom options are specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultMethodOptions(software.amazon.awscdk.services.apigateway.MethodOptions defaultMethodOptions) {
            this.defaultMethodOptions = defaultMethodOptions;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ResourceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ResourceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ResourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourceProps {
        private final software.amazon.awscdk.services.apigateway.IResource parent;
        private final java.lang.String pathPart;
        private final software.amazon.awscdk.services.apigateway.CorsOptions defaultCorsPreflightOptions;
        private final software.amazon.awscdk.services.apigateway.Integration defaultIntegration;
        private final software.amazon.awscdk.services.apigateway.MethodOptions defaultMethodOptions;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.parent = software.amazon.jsii.Kernel.get(this, "parent", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.IResource.class));
            this.pathPart = software.amazon.jsii.Kernel.get(this, "pathPart", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.defaultCorsPreflightOptions = software.amazon.jsii.Kernel.get(this, "defaultCorsPreflightOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.CorsOptions.class));
            this.defaultIntegration = software.amazon.jsii.Kernel.get(this, "defaultIntegration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.Integration.class));
            this.defaultMethodOptions = software.amazon.jsii.Kernel.get(this, "defaultMethodOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.MethodOptions.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.parent = java.util.Objects.requireNonNull(builder.parent, "parent is required");
            this.pathPart = java.util.Objects.requireNonNull(builder.pathPart, "pathPart is required");
            this.defaultCorsPreflightOptions = builder.defaultCorsPreflightOptions;
            this.defaultIntegration = builder.defaultIntegration;
            this.defaultMethodOptions = builder.defaultMethodOptions;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.IResource getParent() {
            return this.parent;
        }

        @Override
        public final java.lang.String getPathPart() {
            return this.pathPart;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.CorsOptions getDefaultCorsPreflightOptions() {
            return this.defaultCorsPreflightOptions;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.Integration getDefaultIntegration() {
            return this.defaultIntegration;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.MethodOptions getDefaultMethodOptions() {
            return this.defaultMethodOptions;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("parent", om.valueToTree(this.getParent()));
            data.set("pathPart", om.valueToTree(this.getPathPart()));
            if (this.getDefaultCorsPreflightOptions() != null) {
                data.set("defaultCorsPreflightOptions", om.valueToTree(this.getDefaultCorsPreflightOptions()));
            }
            if (this.getDefaultIntegration() != null) {
                data.set("defaultIntegration", om.valueToTree(this.getDefaultIntegration()));
            }
            if (this.getDefaultMethodOptions() != null) {
                data.set("defaultMethodOptions", om.valueToTree(this.getDefaultMethodOptions()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigateway.ResourceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ResourceProps.Jsii$Proxy that = (ResourceProps.Jsii$Proxy) o;

            if (!parent.equals(that.parent)) return false;
            if (!pathPart.equals(that.pathPart)) return false;
            if (this.defaultCorsPreflightOptions != null ? !this.defaultCorsPreflightOptions.equals(that.defaultCorsPreflightOptions) : that.defaultCorsPreflightOptions != null) return false;
            if (this.defaultIntegration != null ? !this.defaultIntegration.equals(that.defaultIntegration) : that.defaultIntegration != null) return false;
            return this.defaultMethodOptions != null ? this.defaultMethodOptions.equals(that.defaultMethodOptions) : that.defaultMethodOptions == null;
        }

        @Override
        public final int hashCode() {
            int result = this.parent.hashCode();
            result = 31 * result + (this.pathPart.hashCode());
            result = 31 * result + (this.defaultCorsPreflightOptions != null ? this.defaultCorsPreflightOptions.hashCode() : 0);
            result = 31 * result + (this.defaultIntegration != null ? this.defaultIntegration.hashCode() : 0);
            result = 31 * result + (this.defaultMethodOptions != null ? this.defaultMethodOptions.hashCode() : 0);
            return result;
        }
    }
}
