package software.amazon.awscdk.services.apigatewayv2;

/**
 * Route class that creates the Route for API Gateway HTTP API.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigatewayv2.*;
 * HttpApi httpApi;
 * IHttpRouteAuthorizer httpRouteAuthorizer;
 * HttpRouteIntegration httpRouteIntegration;
 * HttpRouteKey httpRouteKey;
 * HttpRoute httpRoute = HttpRoute.Builder.create(this, "MyHttpRoute")
 *         .httpApi(httpApi)
 *         .integration(httpRouteIntegration)
 *         .routeKey(httpRouteKey)
 *         // the properties below are optional
 *         .authorizationScopes(List.of("authorizationScopes"))
 *         .authorizer(httpRouteAuthorizer)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:33.479Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.HttpRoute")
public class HttpRoute extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.apigatewayv2.IHttpRoute {

    protected HttpRoute(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected HttpRoute(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public HttpRoute(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.HttpRouteProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Grant access to invoke the route.
     * <p>
     * This method requires that the authorizer of the route is undefined or is
     * an <code>HttpIamAuthorizer</code>.
     * <p>
     * @param grantee This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantInvoke(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.GrantInvokeOptions options) {
        return software.amazon.jsii.Kernel.call(this, "grantInvoke", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required"), options });
    }

    /**
     * Grant access to invoke the route.
     * <p>
     * This method requires that the authorizer of the route is undefined or is
     * an <code>HttpIamAuthorizer</code>.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantInvoke(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantInvoke", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * The HTTP API associated with this route.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.IHttpApi getHttpApi() {
        return software.amazon.jsii.Kernel.get(this, "httpApi", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.IHttpApi.class));
    }

    /**
     * Returns the arn of the route.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRouteArn() {
        return software.amazon.jsii.Kernel.get(this, "routeArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Id of the Route.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRouteId() {
        return software.amazon.jsii.Kernel.get(this, "routeId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns the path component of this HTTP route, <code>undefined</code> if the path is the catch-all route.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPath() {
        return software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apigatewayv2.HttpRoute}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apigatewayv2.HttpRoute> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.apigatewayv2.HttpRouteProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.apigatewayv2.HttpRouteProps.Builder();
        }

        /**
         * The integration to be configured on this route.
         * <p>
         * @return {@code this}
         * @param integration The integration to be configured on this route. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integration(final software.amazon.awscdk.services.apigatewayv2.HttpRouteIntegration integration) {
            this.props.integration(integration);
            return this;
        }

        /**
         * the API the route is associated with.
         * <p>
         * @return {@code this}
         * @param httpApi the API the route is associated with. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpApi(final software.amazon.awscdk.services.apigatewayv2.IHttpApi httpApi) {
            this.props.httpApi(httpApi);
            return this;
        }

        /**
         * The key to this route.
         * <p>
         * This is a combination of an HTTP method and an HTTP path.
         * <p>
         * @return {@code this}
         * @param routeKey The key to this route. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routeKey(final software.amazon.awscdk.services.apigatewayv2.HttpRouteKey routeKey) {
            this.props.routeKey(routeKey);
            return this;
        }

        /**
         * The list of OIDC scopes to include in the authorization.
         * <p>
         * These scopes will be merged with the scopes from the attached authorizer
         * <p>
         * Default: - no additional authorization scopes
         * <p>
         * @return {@code this}
         * @param authorizationScopes The list of OIDC scopes to include in the authorization. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizationScopes(final java.util.List<java.lang.String> authorizationScopes) {
            this.props.authorizationScopes(authorizationScopes);
            return this;
        }

        /**
         * Authorizer for a WebSocket API or an HTTP API.
         * <p>
         * Default: - No authorizer
         * <p>
         * @return {@code this}
         * @param authorizer Authorizer for a WebSocket API or an HTTP API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizer(final software.amazon.awscdk.services.apigatewayv2.IHttpRouteAuthorizer authorizer) {
            this.props.authorizer(authorizer);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.apigatewayv2.HttpRoute}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.apigatewayv2.HttpRoute build() {
            return new software.amazon.awscdk.services.apigatewayv2.HttpRoute(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
