package software.amazon.awscdk.services.apigatewayv2;

/**
 * The attributes used to import existing WebSocketStage.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigatewayv2.*;
 * WebSocketApi webSocketApi;
 * WebSocketStageAttributes webSocketStageAttributes = WebSocketStageAttributes.builder()
 *         .api(webSocketApi)
 *         .stageName("stageName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:33.541Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.WebSocketStageAttributes")
@software.amazon.jsii.Jsii.Proxy(WebSocketStageAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface WebSocketStageAttributes extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.apigatewayv2.StageAttributes {

    /**
     * The API to which this stage is associated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.IWebSocketApi getApi();

    /**
     * @return a {@link Builder} of {@link WebSocketStageAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link WebSocketStageAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<WebSocketStageAttributes> {
        software.amazon.awscdk.services.apigatewayv2.IWebSocketApi api;
        java.lang.String stageName;

        /**
         * Sets the value of {@link WebSocketStageAttributes#getApi}
         * @param api The API to which this stage is associated. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder api(software.amazon.awscdk.services.apigatewayv2.IWebSocketApi api) {
            this.api = api;
            return this;
        }

        /**
         * Sets the value of {@link WebSocketStageAttributes#getStageName}
         * @param stageName The name of the stage. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stageName(java.lang.String stageName) {
            this.stageName = stageName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link WebSocketStageAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public WebSocketStageAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link WebSocketStageAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WebSocketStageAttributes {
        private final software.amazon.awscdk.services.apigatewayv2.IWebSocketApi api;
        private final java.lang.String stageName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.api = software.amazon.jsii.Kernel.get(this, "api", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.IWebSocketApi.class));
            this.stageName = software.amazon.jsii.Kernel.get(this, "stageName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.api = java.util.Objects.requireNonNull(builder.api, "api is required");
            this.stageName = java.util.Objects.requireNonNull(builder.stageName, "stageName is required");
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.IWebSocketApi getApi() {
            return this.api;
        }

        @Override
        public final java.lang.String getStageName() {
            return this.stageName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("api", om.valueToTree(this.getApi()));
            data.set("stageName", om.valueToTree(this.getStageName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigatewayv2.WebSocketStageAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            WebSocketStageAttributes.Jsii$Proxy that = (WebSocketStageAttributes.Jsii$Proxy) o;

            if (!api.equals(that.api)) return false;
            return this.stageName.equals(that.stageName);
        }

        @Override
        public final int hashCode() {
            int result = this.api.hashCode();
            result = 31 * result + (this.stageName.hashCode());
            return result;
        }
    }
}
