package software.amazon.awscdk.services.apigatewayv2;

/**
 * Properties to initialize an instance of <code>WebSocketStage</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.aws_apigatewayv2_integrations.WebSocketLambdaIntegration;
 * Function messageHandler;
 * WebSocketApi webSocketApi = new WebSocketApi(this, "mywsapi");
 * WebSocketStage.Builder.create(this, "mystage")
 *         .webSocketApi(webSocketApi)
 *         .stageName("dev")
 *         .autoDeploy(true)
 *         .build();
 * webSocketApi.addRoute("sendMessage", WebSocketRouteOptions.builder()
 *         .integration(new WebSocketLambdaIntegration("SendMessageIntegration", messageHandler))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:33.541Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.WebSocketStageProps")
@software.amazon.jsii.Jsii.Proxy(WebSocketStageProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface WebSocketStageProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.apigatewayv2.StageOptions {

    /**
     * The name of the stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStageName();

    /**
     * The WebSocket API to which this stage is associated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.IWebSocketApi getWebSocketApi();

    /**
     * @return a {@link Builder} of {@link WebSocketStageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link WebSocketStageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<WebSocketStageProps> {
        java.lang.String stageName;
        software.amazon.awscdk.services.apigatewayv2.IWebSocketApi webSocketApi;
        java.lang.Boolean autoDeploy;
        java.lang.String description;
        java.lang.Boolean detailedMetricsEnabled;
        software.amazon.awscdk.services.apigatewayv2.DomainMappingOptions domainMapping;
        software.amazon.awscdk.services.apigatewayv2.ThrottleSettings throttle;

        /**
         * Sets the value of {@link WebSocketStageProps#getStageName}
         * @param stageName The name of the stage. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stageName(java.lang.String stageName) {
            this.stageName = stageName;
            return this;
        }

        /**
         * Sets the value of {@link WebSocketStageProps#getWebSocketApi}
         * @param webSocketApi The WebSocket API to which this stage is associated. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder webSocketApi(software.amazon.awscdk.services.apigatewayv2.IWebSocketApi webSocketApi) {
            this.webSocketApi = webSocketApi;
            return this;
        }

        /**
         * Sets the value of {@link WebSocketStageProps#getAutoDeploy}
         * @param autoDeploy Whether updates to an API automatically trigger a new deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoDeploy(java.lang.Boolean autoDeploy) {
            this.autoDeploy = autoDeploy;
            return this;
        }

        /**
         * Sets the value of {@link WebSocketStageProps#getDescription}
         * @param description The description for the API stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link WebSocketStageProps#getDetailedMetricsEnabled}
         * @param detailedMetricsEnabled Specifies whether detailed metrics are enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder detailedMetricsEnabled(java.lang.Boolean detailedMetricsEnabled) {
            this.detailedMetricsEnabled = detailedMetricsEnabled;
            return this;
        }

        /**
         * Sets the value of {@link WebSocketStageProps#getDomainMapping}
         * @param domainMapping The options for custom domain and api mapping.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainMapping(software.amazon.awscdk.services.apigatewayv2.DomainMappingOptions domainMapping) {
            this.domainMapping = domainMapping;
            return this;
        }

        /**
         * Sets the value of {@link WebSocketStageProps#getThrottle}
         * @param throttle Throttle settings for the routes of this stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder throttle(software.amazon.awscdk.services.apigatewayv2.ThrottleSettings throttle) {
            this.throttle = throttle;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link WebSocketStageProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public WebSocketStageProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link WebSocketStageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WebSocketStageProps {
        private final java.lang.String stageName;
        private final software.amazon.awscdk.services.apigatewayv2.IWebSocketApi webSocketApi;
        private final java.lang.Boolean autoDeploy;
        private final java.lang.String description;
        private final java.lang.Boolean detailedMetricsEnabled;
        private final software.amazon.awscdk.services.apigatewayv2.DomainMappingOptions domainMapping;
        private final software.amazon.awscdk.services.apigatewayv2.ThrottleSettings throttle;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.stageName = software.amazon.jsii.Kernel.get(this, "stageName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.webSocketApi = software.amazon.jsii.Kernel.get(this, "webSocketApi", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.IWebSocketApi.class));
            this.autoDeploy = software.amazon.jsii.Kernel.get(this, "autoDeploy", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.detailedMetricsEnabled = software.amazon.jsii.Kernel.get(this, "detailedMetricsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.domainMapping = software.amazon.jsii.Kernel.get(this, "domainMapping", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.DomainMappingOptions.class));
            this.throttle = software.amazon.jsii.Kernel.get(this, "throttle", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.ThrottleSettings.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.stageName = java.util.Objects.requireNonNull(builder.stageName, "stageName is required");
            this.webSocketApi = java.util.Objects.requireNonNull(builder.webSocketApi, "webSocketApi is required");
            this.autoDeploy = builder.autoDeploy;
            this.description = builder.description;
            this.detailedMetricsEnabled = builder.detailedMetricsEnabled;
            this.domainMapping = builder.domainMapping;
            this.throttle = builder.throttle;
        }

        @Override
        public final java.lang.String getStageName() {
            return this.stageName;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.IWebSocketApi getWebSocketApi() {
            return this.webSocketApi;
        }

        @Override
        public final java.lang.Boolean getAutoDeploy() {
            return this.autoDeploy;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Boolean getDetailedMetricsEnabled() {
            return this.detailedMetricsEnabled;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.DomainMappingOptions getDomainMapping() {
            return this.domainMapping;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.ThrottleSettings getThrottle() {
            return this.throttle;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("stageName", om.valueToTree(this.getStageName()));
            data.set("webSocketApi", om.valueToTree(this.getWebSocketApi()));
            if (this.getAutoDeploy() != null) {
                data.set("autoDeploy", om.valueToTree(this.getAutoDeploy()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getDetailedMetricsEnabled() != null) {
                data.set("detailedMetricsEnabled", om.valueToTree(this.getDetailedMetricsEnabled()));
            }
            if (this.getDomainMapping() != null) {
                data.set("domainMapping", om.valueToTree(this.getDomainMapping()));
            }
            if (this.getThrottle() != null) {
                data.set("throttle", om.valueToTree(this.getThrottle()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigatewayv2.WebSocketStageProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            WebSocketStageProps.Jsii$Proxy that = (WebSocketStageProps.Jsii$Proxy) o;

            if (!stageName.equals(that.stageName)) return false;
            if (!webSocketApi.equals(that.webSocketApi)) return false;
            if (this.autoDeploy != null ? !this.autoDeploy.equals(that.autoDeploy) : that.autoDeploy != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.detailedMetricsEnabled != null ? !this.detailedMetricsEnabled.equals(that.detailedMetricsEnabled) : that.detailedMetricsEnabled != null) return false;
            if (this.domainMapping != null ? !this.domainMapping.equals(that.domainMapping) : that.domainMapping != null) return false;
            return this.throttle != null ? this.throttle.equals(that.throttle) : that.throttle == null;
        }

        @Override
        public final int hashCode() {
            int result = this.stageName.hashCode();
            result = 31 * result + (this.webSocketApi.hashCode());
            result = 31 * result + (this.autoDeploy != null ? this.autoDeploy.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.detailedMetricsEnabled != null ? this.detailedMetricsEnabled.hashCode() : 0);
            result = 31 * result + (this.domainMapping != null ? this.domainMapping.hashCode() : 0);
            result = 31 * result + (this.throttle != null ? this.throttle.hashCode() : 0);
            return result;
        }
    }
}
