package software.amazon.awscdk.services.appconfig;

/**
 * The configuration type.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Application application;
 * HostedConfiguration.Builder.create(this, "MyHostedConfiguration")
 *         .application(application)
 *         .content(ConfigurationContent.fromInlineText("This is my configuration content."))
 *         .type(ConfigurationType.FEATURE_FLAGS)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:33.625Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appconfig.ConfigurationType")
public enum ConfigurationType {
    /**
     * Freeform configuration profile.
     * <p>
     * Allows you to store your data in the AWS AppConfig
     * hosted configuration store or another Systems Manager capability or AWS service that integrates
     * with AWS AppConfig.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-free-form-configurations-creating.html">https://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-free-form-configurations-creating.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    FREEFORM,
    /**
     * Feature flag configuration profile.
     * <p>
     * This configuration stores its data
     * in the AWS AppConfig hosted configuration store and the URI is simply hosted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    FEATURE_FLAGS,
}
