package software.amazon.awscdk.services.appsync;

/**
 * Basic properties for an AppSync resolver.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Build a data source for AppSync to access the database.
 * GraphqlApi api;
 * // Create username and password secret for DB Cluster
 * DatabaseSecret secret = DatabaseSecret.Builder.create(this, "AuroraSecret")
 *         .username("clusteradmin")
 *         .build();
 * // The VPC to place the cluster in
 * Vpc vpc = new Vpc(this, "AuroraVpc");
 * // Create the serverless cluster, provide all values needed to customise the database.
 * ServerlessCluster cluster = ServerlessCluster.Builder.create(this, "AuroraCluster")
 *         .engine(DatabaseClusterEngine.AURORA_MYSQL)
 *         .vpc(vpc)
 *         .credentials(Map.of("username", "clusteradmin"))
 *         .clusterIdentifier("db-endpoint-test")
 *         .defaultDatabaseName("demos")
 *         .build();
 * RdsDataSource rdsDS = api.addRdsDataSource("rds", cluster, secret, "demos");
 * // Set up a resolver for an RDS query.
 * rdsDS.createResolver("QueryGetDemosRdsResolver", BaseResolverProps.builder()
 *         .typeName("Query")
 *         .fieldName("getDemosRds")
 *         .requestMappingTemplate(MappingTemplate.fromString("\n  {\n    \"version\": \"2018-05-29\",\n    \"statements\": [\n      \"SELECT * FROM demos\"\n    ]\n  }\n  "))
 *         .responseMappingTemplate(MappingTemplate.fromString("\n    $utils.toJson($utils.rds.toJsonObject($ctx.result)[0])\n  "))
 *         .build());
 * // Set up a resolver for an RDS mutation.
 * rdsDS.createResolver("MutationAddDemoRdsResolver", BaseResolverProps.builder()
 *         .typeName("Mutation")
 *         .fieldName("addDemoRds")
 *         .requestMappingTemplate(MappingTemplate.fromString("\n  {\n    \"version\": \"2018-05-29\",\n    \"statements\": [\n      \"INSERT INTO demos VALUES (:id, :version)\",\n      \"SELECT * WHERE id = :id\"\n    ],\n    \"variableMap\": {\n      \":id\": $util.toJson($util.autoId()),\n      \":version\": $util.toJson($ctx.args.version)\n    }\n  }\n  "))
 *         .responseMappingTemplate(MappingTemplate.fromString("\n    $utils.toJson($utils.rds.toJsonObject($ctx.result)[1][0])\n  "))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:34.189Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.BaseResolverProps")
@software.amazon.jsii.Jsii.Proxy(BaseResolverProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BaseResolverProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * name of the GraphQL field in the given type this resolver is attached to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFieldName();

    /**
     * name of the GraphQL type this resolver is attached to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTypeName();

    /**
     * The caching configuration for this resolver.
     * <p>
     * Default: - No caching configuration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.CachingConfig getCachingConfig() {
        return null;
    }

    /**
     * The function code.
     * <p>
     * Default: - no code is used
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.Code getCode() {
        return null;
    }

    /**
     * The maximum number of elements per batch, when using batch invoke.
     * <p>
     * Default: - No max batch size
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxBatchSize() {
        return null;
    }

    /**
     * configuration of the pipeline resolver.
     * <p>
     * Default: - no pipeline resolver configuration
     * An empty array | undefined sets resolver to be of kind, unit
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.appsync.IAppsyncFunction> getPipelineConfig() {
        return null;
    }

    /**
     * The request mapping template for this resolver.
     * <p>
     * Default: - No mapping template
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.MappingTemplate getRequestMappingTemplate() {
        return null;
    }

    /**
     * The response mapping template for this resolver.
     * <p>
     * Default: - No mapping template
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.MappingTemplate getResponseMappingTemplate() {
        return null;
    }

    /**
     * The functions runtime.
     * <p>
     * Default: - no function runtime, VTL mapping templates used
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.FunctionRuntime getRuntime() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BaseResolverProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BaseResolverProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BaseResolverProps> {
        java.lang.String fieldName;
        java.lang.String typeName;
        software.amazon.awscdk.services.appsync.CachingConfig cachingConfig;
        software.amazon.awscdk.services.appsync.Code code;
        java.lang.Number maxBatchSize;
        java.util.List<software.amazon.awscdk.services.appsync.IAppsyncFunction> pipelineConfig;
        software.amazon.awscdk.services.appsync.MappingTemplate requestMappingTemplate;
        software.amazon.awscdk.services.appsync.MappingTemplate responseMappingTemplate;
        software.amazon.awscdk.services.appsync.FunctionRuntime runtime;

        /**
         * Sets the value of {@link BaseResolverProps#getFieldName}
         * @param fieldName name of the GraphQL field in the given type this resolver is attached to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fieldName(java.lang.String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        /**
         * Sets the value of {@link BaseResolverProps#getTypeName}
         * @param typeName name of the GraphQL type this resolver is attached to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder typeName(java.lang.String typeName) {
            this.typeName = typeName;
            return this;
        }

        /**
         * Sets the value of {@link BaseResolverProps#getCachingConfig}
         * @param cachingConfig The caching configuration for this resolver.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cachingConfig(software.amazon.awscdk.services.appsync.CachingConfig cachingConfig) {
            this.cachingConfig = cachingConfig;
            return this;
        }

        /**
         * Sets the value of {@link BaseResolverProps#getCode}
         * @param code The function code.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder code(software.amazon.awscdk.services.appsync.Code code) {
            this.code = code;
            return this;
        }

        /**
         * Sets the value of {@link BaseResolverProps#getMaxBatchSize}
         * @param maxBatchSize The maximum number of elements per batch, when using batch invoke.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxBatchSize(java.lang.Number maxBatchSize) {
            this.maxBatchSize = maxBatchSize;
            return this;
        }

        /**
         * Sets the value of {@link BaseResolverProps#getPipelineConfig}
         * @param pipelineConfig configuration of the pipeline resolver.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder pipelineConfig(java.util.List<? extends software.amazon.awscdk.services.appsync.IAppsyncFunction> pipelineConfig) {
            this.pipelineConfig = (java.util.List<software.amazon.awscdk.services.appsync.IAppsyncFunction>)pipelineConfig;
            return this;
        }

        /**
         * Sets the value of {@link BaseResolverProps#getRequestMappingTemplate}
         * @param requestMappingTemplate The request mapping template for this resolver.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestMappingTemplate(software.amazon.awscdk.services.appsync.MappingTemplate requestMappingTemplate) {
            this.requestMappingTemplate = requestMappingTemplate;
            return this;
        }

        /**
         * Sets the value of {@link BaseResolverProps#getResponseMappingTemplate}
         * @param responseMappingTemplate The response mapping template for this resolver.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder responseMappingTemplate(software.amazon.awscdk.services.appsync.MappingTemplate responseMappingTemplate) {
            this.responseMappingTemplate = responseMappingTemplate;
            return this;
        }

        /**
         * Sets the value of {@link BaseResolverProps#getRuntime}
         * @param runtime The functions runtime.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtime(software.amazon.awscdk.services.appsync.FunctionRuntime runtime) {
            this.runtime = runtime;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BaseResolverProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BaseResolverProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BaseResolverProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BaseResolverProps {
        private final java.lang.String fieldName;
        private final java.lang.String typeName;
        private final software.amazon.awscdk.services.appsync.CachingConfig cachingConfig;
        private final software.amazon.awscdk.services.appsync.Code code;
        private final java.lang.Number maxBatchSize;
        private final java.util.List<software.amazon.awscdk.services.appsync.IAppsyncFunction> pipelineConfig;
        private final software.amazon.awscdk.services.appsync.MappingTemplate requestMappingTemplate;
        private final software.amazon.awscdk.services.appsync.MappingTemplate responseMappingTemplate;
        private final software.amazon.awscdk.services.appsync.FunctionRuntime runtime;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.fieldName = software.amazon.jsii.Kernel.get(this, "fieldName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.typeName = software.amazon.jsii.Kernel.get(this, "typeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cachingConfig = software.amazon.jsii.Kernel.get(this, "cachingConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.CachingConfig.class));
            this.code = software.amazon.jsii.Kernel.get(this, "code", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.Code.class));
            this.maxBatchSize = software.amazon.jsii.Kernel.get(this, "maxBatchSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.pipelineConfig = software.amazon.jsii.Kernel.get(this, "pipelineConfig", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.IAppsyncFunction.class)));
            this.requestMappingTemplate = software.amazon.jsii.Kernel.get(this, "requestMappingTemplate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.MappingTemplate.class));
            this.responseMappingTemplate = software.amazon.jsii.Kernel.get(this, "responseMappingTemplate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.MappingTemplate.class));
            this.runtime = software.amazon.jsii.Kernel.get(this, "runtime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.FunctionRuntime.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.fieldName = java.util.Objects.requireNonNull(builder.fieldName, "fieldName is required");
            this.typeName = java.util.Objects.requireNonNull(builder.typeName, "typeName is required");
            this.cachingConfig = builder.cachingConfig;
            this.code = builder.code;
            this.maxBatchSize = builder.maxBatchSize;
            this.pipelineConfig = (java.util.List<software.amazon.awscdk.services.appsync.IAppsyncFunction>)builder.pipelineConfig;
            this.requestMappingTemplate = builder.requestMappingTemplate;
            this.responseMappingTemplate = builder.responseMappingTemplate;
            this.runtime = builder.runtime;
        }

        @Override
        public final java.lang.String getFieldName() {
            return this.fieldName;
        }

        @Override
        public final java.lang.String getTypeName() {
            return this.typeName;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.CachingConfig getCachingConfig() {
            return this.cachingConfig;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.Code getCode() {
            return this.code;
        }

        @Override
        public final java.lang.Number getMaxBatchSize() {
            return this.maxBatchSize;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.appsync.IAppsyncFunction> getPipelineConfig() {
            return this.pipelineConfig;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.MappingTemplate getRequestMappingTemplate() {
            return this.requestMappingTemplate;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.MappingTemplate getResponseMappingTemplate() {
            return this.responseMappingTemplate;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.FunctionRuntime getRuntime() {
            return this.runtime;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("fieldName", om.valueToTree(this.getFieldName()));
            data.set("typeName", om.valueToTree(this.getTypeName()));
            if (this.getCachingConfig() != null) {
                data.set("cachingConfig", om.valueToTree(this.getCachingConfig()));
            }
            if (this.getCode() != null) {
                data.set("code", om.valueToTree(this.getCode()));
            }
            if (this.getMaxBatchSize() != null) {
                data.set("maxBatchSize", om.valueToTree(this.getMaxBatchSize()));
            }
            if (this.getPipelineConfig() != null) {
                data.set("pipelineConfig", om.valueToTree(this.getPipelineConfig()));
            }
            if (this.getRequestMappingTemplate() != null) {
                data.set("requestMappingTemplate", om.valueToTree(this.getRequestMappingTemplate()));
            }
            if (this.getResponseMappingTemplate() != null) {
                data.set("responseMappingTemplate", om.valueToTree(this.getResponseMappingTemplate()));
            }
            if (this.getRuntime() != null) {
                data.set("runtime", om.valueToTree(this.getRuntime()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.BaseResolverProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BaseResolverProps.Jsii$Proxy that = (BaseResolverProps.Jsii$Proxy) o;

            if (!fieldName.equals(that.fieldName)) return false;
            if (!typeName.equals(that.typeName)) return false;
            if (this.cachingConfig != null ? !this.cachingConfig.equals(that.cachingConfig) : that.cachingConfig != null) return false;
            if (this.code != null ? !this.code.equals(that.code) : that.code != null) return false;
            if (this.maxBatchSize != null ? !this.maxBatchSize.equals(that.maxBatchSize) : that.maxBatchSize != null) return false;
            if (this.pipelineConfig != null ? !this.pipelineConfig.equals(that.pipelineConfig) : that.pipelineConfig != null) return false;
            if (this.requestMappingTemplate != null ? !this.requestMappingTemplate.equals(that.requestMappingTemplate) : that.requestMappingTemplate != null) return false;
            if (this.responseMappingTemplate != null ? !this.responseMappingTemplate.equals(that.responseMappingTemplate) : that.responseMappingTemplate != null) return false;
            return this.runtime != null ? this.runtime.equals(that.runtime) : that.runtime == null;
        }

        @Override
        public final int hashCode() {
            int result = this.fieldName.hashCode();
            result = 31 * result + (this.typeName.hashCode());
            result = 31 * result + (this.cachingConfig != null ? this.cachingConfig.hashCode() : 0);
            result = 31 * result + (this.code != null ? this.code.hashCode() : 0);
            result = 31 * result + (this.maxBatchSize != null ? this.maxBatchSize.hashCode() : 0);
            result = 31 * result + (this.pipelineConfig != null ? this.pipelineConfig.hashCode() : 0);
            result = 31 * result + (this.requestMappingTemplate != null ? this.requestMappingTemplate.hashCode() : 0);
            result = 31 * result + (this.responseMappingTemplate != null ? this.responseMappingTemplate.hashCode() : 0);
            result = 31 * result + (this.runtime != null ? this.runtime.hashCode() : 0);
            return result;
        }
    }
}
