package software.amazon.awscdk.services.appsync;

/**
 * Logging configuration for AppSync.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.logs.*;
 * GraphqlApi.Builder.create(this, "api")
 *         .authorizationConfig(AuthorizationConfig.builder().build())
 *         .name("myApi")
 *         .definition(Definition.fromFile(join(__dirname, "myApi.graphql")))
 *         .logConfig(LogConfig.builder()
 *                 .fieldLogLevel(FieldLogLevel.INFO)
 *                 .retention(RetentionDays.ONE_WEEK)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:34.303Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.LogConfig")
@software.amazon.jsii.Jsii.Proxy(LogConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LogConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * exclude verbose content.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getExcludeVerboseContent() {
        return null;
    }

    /**
     * log level for fields.
     * <p>
     * Default: - Use AppSync default
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.FieldLogLevel getFieldLogLevel() {
        return null;
    }

    /**
     * The number of days log events are kept in CloudWatch Logs.
     * <p>
     * By default AppSync keeps the logs infinitely. When updating this property,
     * unsetting it doesn't remove the log retention policy.
     * To remove the retention policy, set the value to <code>INFINITE</code>
     * <p>
     * Default: RetentionDays.INFINITE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.RetentionDays getRetention() {
        return null;
    }

    /**
     * The role for CloudWatch Logs.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LogConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LogConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LogConfig> {
        java.lang.Object excludeVerboseContent;
        software.amazon.awscdk.services.appsync.FieldLogLevel fieldLogLevel;
        software.amazon.awscdk.services.logs.RetentionDays retention;
        software.amazon.awscdk.services.iam.IRole role;

        /**
         * Sets the value of {@link LogConfig#getExcludeVerboseContent}
         * @param excludeVerboseContent exclude verbose content.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excludeVerboseContent(java.lang.Boolean excludeVerboseContent) {
            this.excludeVerboseContent = excludeVerboseContent;
            return this;
        }

        /**
         * Sets the value of {@link LogConfig#getExcludeVerboseContent}
         * @param excludeVerboseContent exclude verbose content.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excludeVerboseContent(software.amazon.awscdk.IResolvable excludeVerboseContent) {
            this.excludeVerboseContent = excludeVerboseContent;
            return this;
        }

        /**
         * Sets the value of {@link LogConfig#getFieldLogLevel}
         * @param fieldLogLevel log level for fields.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fieldLogLevel(software.amazon.awscdk.services.appsync.FieldLogLevel fieldLogLevel) {
            this.fieldLogLevel = fieldLogLevel;
            return this;
        }

        /**
         * Sets the value of {@link LogConfig#getRetention}
         * @param retention The number of days log events are kept in CloudWatch Logs.
         *                  By default AppSync keeps the logs infinitely. When updating this property,
         *                  unsetting it doesn't remove the log retention policy.
         *                  To remove the retention policy, set the value to <code>INFINITE</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retention(software.amazon.awscdk.services.logs.RetentionDays retention) {
            this.retention = retention;
            return this;
        }

        /**
         * Sets the value of {@link LogConfig#getRole}
         * @param role The role for CloudWatch Logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LogConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LogConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LogConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LogConfig {
        private final java.lang.Object excludeVerboseContent;
        private final software.amazon.awscdk.services.appsync.FieldLogLevel fieldLogLevel;
        private final software.amazon.awscdk.services.logs.RetentionDays retention;
        private final software.amazon.awscdk.services.iam.IRole role;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.excludeVerboseContent = software.amazon.jsii.Kernel.get(this, "excludeVerboseContent", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.fieldLogLevel = software.amazon.jsii.Kernel.get(this, "fieldLogLevel", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.FieldLogLevel.class));
            this.retention = software.amazon.jsii.Kernel.get(this, "retention", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.RetentionDays.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.excludeVerboseContent = builder.excludeVerboseContent;
            this.fieldLogLevel = builder.fieldLogLevel;
            this.retention = builder.retention;
            this.role = builder.role;
        }

        @Override
        public final java.lang.Object getExcludeVerboseContent() {
            return this.excludeVerboseContent;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.FieldLogLevel getFieldLogLevel() {
            return this.fieldLogLevel;
        }

        @Override
        public final software.amazon.awscdk.services.logs.RetentionDays getRetention() {
            return this.retention;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getExcludeVerboseContent() != null) {
                data.set("excludeVerboseContent", om.valueToTree(this.getExcludeVerboseContent()));
            }
            if (this.getFieldLogLevel() != null) {
                data.set("fieldLogLevel", om.valueToTree(this.getFieldLogLevel()));
            }
            if (this.getRetention() != null) {
                data.set("retention", om.valueToTree(this.getRetention()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.LogConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LogConfig.Jsii$Proxy that = (LogConfig.Jsii$Proxy) o;

            if (this.excludeVerboseContent != null ? !this.excludeVerboseContent.equals(that.excludeVerboseContent) : that.excludeVerboseContent != null) return false;
            if (this.fieldLogLevel != null ? !this.fieldLogLevel.equals(that.fieldLogLevel) : that.fieldLogLevel != null) return false;
            if (this.retention != null ? !this.retention.equals(that.retention) : that.retention != null) return false;
            return this.role != null ? this.role.equals(that.role) : that.role == null;
        }

        @Override
        public final int hashCode() {
            int result = this.excludeVerboseContent != null ? this.excludeVerboseContent.hashCode() : 0;
            result = 31 * result + (this.fieldLogLevel != null ? this.fieldLogLevel.hashCode() : 0);
            result = 31 * result + (this.retention != null ? this.retention.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            return result;
        }
    }
}
