package software.amazon.awscdk.services.backup;

/**
 * Properties for a BackupPlanCopyAction.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.backup.*;
 * BackupVault backupVault;
 * BackupPlanCopyActionProps backupPlanCopyActionProps = BackupPlanCopyActionProps.builder()
 *         .destinationBackupVault(backupVault)
 *         // the properties below are optional
 *         .deleteAfter(Duration.minutes(30))
 *         .moveToColdStorageAfter(Duration.minutes(30))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:34.608Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_backup.BackupPlanCopyActionProps")
@software.amazon.jsii.Jsii.Proxy(BackupPlanCopyActionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BackupPlanCopyActionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Destination Vault for recovery points to be copied into.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.backup.IBackupVault getDestinationBackupVault();

    /**
     * Specifies the duration after creation that a copied recovery point is deleted from the destination vault.
     * <p>
     * Must be at least 90 days greater than <code>moveToColdStorageAfter</code>, if specified.
     * <p>
     * Default: - recovery point is never deleted
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getDeleteAfter() {
        return null;
    }

    /**
     * Specifies the duration after creation that a copied recovery point is moved to cold storage.
     * <p>
     * Default: - recovery point is never moved to cold storage
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getMoveToColdStorageAfter() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BackupPlanCopyActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BackupPlanCopyActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BackupPlanCopyActionProps> {
        software.amazon.awscdk.services.backup.IBackupVault destinationBackupVault;
        software.amazon.awscdk.Duration deleteAfter;
        software.amazon.awscdk.Duration moveToColdStorageAfter;

        /**
         * Sets the value of {@link BackupPlanCopyActionProps#getDestinationBackupVault}
         * @param destinationBackupVault Destination Vault for recovery points to be copied into. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationBackupVault(software.amazon.awscdk.services.backup.IBackupVault destinationBackupVault) {
            this.destinationBackupVault = destinationBackupVault;
            return this;
        }

        /**
         * Sets the value of {@link BackupPlanCopyActionProps#getDeleteAfter}
         * @param deleteAfter Specifies the duration after creation that a copied recovery point is deleted from the destination vault.
         *                    Must be at least 90 days greater than <code>moveToColdStorageAfter</code>, if specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deleteAfter(software.amazon.awscdk.Duration deleteAfter) {
            this.deleteAfter = deleteAfter;
            return this;
        }

        /**
         * Sets the value of {@link BackupPlanCopyActionProps#getMoveToColdStorageAfter}
         * @param moveToColdStorageAfter Specifies the duration after creation that a copied recovery point is moved to cold storage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder moveToColdStorageAfter(software.amazon.awscdk.Duration moveToColdStorageAfter) {
            this.moveToColdStorageAfter = moveToColdStorageAfter;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BackupPlanCopyActionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BackupPlanCopyActionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BackupPlanCopyActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BackupPlanCopyActionProps {
        private final software.amazon.awscdk.services.backup.IBackupVault destinationBackupVault;
        private final software.amazon.awscdk.Duration deleteAfter;
        private final software.amazon.awscdk.Duration moveToColdStorageAfter;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.destinationBackupVault = software.amazon.jsii.Kernel.get(this, "destinationBackupVault", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.backup.IBackupVault.class));
            this.deleteAfter = software.amazon.jsii.Kernel.get(this, "deleteAfter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.moveToColdStorageAfter = software.amazon.jsii.Kernel.get(this, "moveToColdStorageAfter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.destinationBackupVault = java.util.Objects.requireNonNull(builder.destinationBackupVault, "destinationBackupVault is required");
            this.deleteAfter = builder.deleteAfter;
            this.moveToColdStorageAfter = builder.moveToColdStorageAfter;
        }

        @Override
        public final software.amazon.awscdk.services.backup.IBackupVault getDestinationBackupVault() {
            return this.destinationBackupVault;
        }

        @Override
        public final software.amazon.awscdk.Duration getDeleteAfter() {
            return this.deleteAfter;
        }

        @Override
        public final software.amazon.awscdk.Duration getMoveToColdStorageAfter() {
            return this.moveToColdStorageAfter;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("destinationBackupVault", om.valueToTree(this.getDestinationBackupVault()));
            if (this.getDeleteAfter() != null) {
                data.set("deleteAfter", om.valueToTree(this.getDeleteAfter()));
            }
            if (this.getMoveToColdStorageAfter() != null) {
                data.set("moveToColdStorageAfter", om.valueToTree(this.getMoveToColdStorageAfter()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_backup.BackupPlanCopyActionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BackupPlanCopyActionProps.Jsii$Proxy that = (BackupPlanCopyActionProps.Jsii$Proxy) o;

            if (!destinationBackupVault.equals(that.destinationBackupVault)) return false;
            if (this.deleteAfter != null ? !this.deleteAfter.equals(that.deleteAfter) : that.deleteAfter != null) return false;
            return this.moveToColdStorageAfter != null ? this.moveToColdStorageAfter.equals(that.moveToColdStorageAfter) : that.moveToColdStorageAfter == null;
        }

        @Override
        public final int hashCode() {
            int result = this.destinationBackupVault.hashCode();
            result = 31 * result + (this.deleteAfter != null ? this.deleteAfter.hashCode() : 0);
            result = 31 * result + (this.moveToColdStorageAfter != null ? this.moveToColdStorageAfter.hashCode() : 0);
            return result;
        }
    }
}
