package software.amazon.awscdk.services.backup;

/**
 * Backup vault events.
 * <p>
 * Some events are no longer supported and will not return
 * statuses or notifications.
 * <p>
 * @see <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_PutBackupVaultNotifications.html#API_PutBackupVaultNotifications_RequestBody">https://docs.aws.amazon.com/aws-backup/latest/devguide/API_PutBackupVaultNotifications.html#API_PutBackupVaultNotifications_RequestBody</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:34.615Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_backup.BackupVaultEvents")
public enum BackupVaultEvents {
    /**
     * BACKUP_JOB_STARTED.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BACKUP_JOB_STARTED,
    /**
     * BACKUP_JOB_COMPLETED.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BACKUP_JOB_COMPLETED,
    /**
     * BACKUP_JOB_SUCCESSFUL.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BACKUP_JOB_SUCCESSFUL,
    /**
     * BACKUP_JOB_FAILED.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BACKUP_JOB_FAILED,
    /**
     * BACKUP_JOB_EXPIRED.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BACKUP_JOB_EXPIRED,
    /**
     * RESTORE_JOB_STARTED.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    RESTORE_JOB_STARTED,
    /**
     * RESTORE_JOB_COMPLETED.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    RESTORE_JOB_COMPLETED,
    /**
     * RESTORE_JOB_SUCCESSFUL.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    RESTORE_JOB_SUCCESSFUL,
    /**
     * RESTORE_JOB_FAILED.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    RESTORE_JOB_FAILED,
    /**
     * COPY_JOB_STARTED.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COPY_JOB_STARTED,
    /**
     * COPY_JOB_SUCCESSFUL.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COPY_JOB_SUCCESSFUL,
    /**
     * COPY_JOB_FAILED.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COPY_JOB_FAILED,
    /**
     * RECOVERY_POINT_MODIFIED.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    RECOVERY_POINT_MODIFIED,
    /**
     * BACKUP_PLAN_CREATED.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BACKUP_PLAN_CREATED,
    /**
     * BACKUP_PLAN_MODIFIED.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BACKUP_PLAN_MODIFIED,
    /**
     * S3_BACKUP_OBJECT_FAILED.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    S3_BACKUP_OBJECT_FAILED,
    /**
     * BACKUP_PLAN_MODIFIED.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    S3_RESTORE_OBJECT_FAILED,
}
