package software.amazon.awscdk.services.batch;

/**
 * Fairshare SchedulingPolicy configuration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * FairshareSchedulingPolicy fairsharePolicy = FairshareSchedulingPolicy.Builder.create(this, "myFairsharePolicy")
 *         .shareDecay(Duration.minutes(5))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:34.807Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.FairshareSchedulingPolicyProps")
@software.amazon.jsii.Jsii.Proxy(FairshareSchedulingPolicyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FairshareSchedulingPolicyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Used to calculate the percentage of the maximum available vCPU to reserve for share identifiers not present in the Queue.
     * <p>
     * The percentage reserved is defined by the Scheduler as:
     * <code>(computeReservation/100)^ActiveFairShares</code> where <code>ActiveFairShares</code> is the number of active fair share identifiers.
     * <p>
     * For example, a computeReservation value of 50 indicates that AWS Batch reserves 50% of the
     * maximum available vCPU if there's only one fair share identifier.
     * It reserves 25% if there are two fair share identifiers.
     * It reserves 12.5% if there are three fair share identifiers.
     * <p>
     * A computeReservation value of 25 indicates that AWS Batch should reserve 25% of the
     * maximum available vCPU if there's only one fair share identifier,
     * 6.25% if there are two fair share identifiers,
     * and 1.56% if there are three fair share identifiers.
     * <p>
     * Default: - no vCPU is reserved
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getComputeReservation() {
        return null;
    }

    /**
     * The name of this SchedulingPolicy.
     * <p>
     * Default: - generated by CloudFormation
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSchedulingPolicyName() {
        return null;
    }

    /**
     * The amount of time to use to measure the usage of each job.
     * <p>
     * The usage is used to calculate a fair share percentage for each fair share identifier currently in the Queue.
     * A value of zero (0) indicates that only current usage is measured.
     * The decay is linear and gives preference to newer jobs.
     * <p>
     * The maximum supported value is 604800 seconds (1 week).
     * <p>
     * Default: - 0: only the current job usage is considered
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getShareDecay() {
        return null;
    }

    /**
     * The shares that this Scheduling Policy applies to.
     * <p>
     * <em>Note</em>: It is possible to submit Jobs to the queue with Share Identifiers that
     * are not recognized by the Scheduling Policy.
     * <p>
     * Default: - no shares
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.batch.Share> getShares() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link FairshareSchedulingPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FairshareSchedulingPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FairshareSchedulingPolicyProps> {
        java.lang.Number computeReservation;
        java.lang.String schedulingPolicyName;
        software.amazon.awscdk.Duration shareDecay;
        java.util.List<software.amazon.awscdk.services.batch.Share> shares;

        /**
         * Sets the value of {@link FairshareSchedulingPolicyProps#getComputeReservation}
         * @param computeReservation Used to calculate the percentage of the maximum available vCPU to reserve for share identifiers not present in the Queue.
         *                           The percentage reserved is defined by the Scheduler as:
         *                           <code>(computeReservation/100)^ActiveFairShares</code> where <code>ActiveFairShares</code> is the number of active fair share identifiers.
         *                           <p>
         *                           For example, a computeReservation value of 50 indicates that AWS Batch reserves 50% of the
         *                           maximum available vCPU if there's only one fair share identifier.
         *                           It reserves 25% if there are two fair share identifiers.
         *                           It reserves 12.5% if there are three fair share identifiers.
         *                           <p>
         *                           A computeReservation value of 25 indicates that AWS Batch should reserve 25% of the
         *                           maximum available vCPU if there's only one fair share identifier,
         *                           6.25% if there are two fair share identifiers,
         *                           and 1.56% if there are three fair share identifiers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computeReservation(java.lang.Number computeReservation) {
            this.computeReservation = computeReservation;
            return this;
        }

        /**
         * Sets the value of {@link FairshareSchedulingPolicyProps#getSchedulingPolicyName}
         * @param schedulingPolicyName The name of this SchedulingPolicy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedulingPolicyName(java.lang.String schedulingPolicyName) {
            this.schedulingPolicyName = schedulingPolicyName;
            return this;
        }

        /**
         * Sets the value of {@link FairshareSchedulingPolicyProps#getShareDecay}
         * @param shareDecay The amount of time to use to measure the usage of each job.
         *                   The usage is used to calculate a fair share percentage for each fair share identifier currently in the Queue.
         *                   A value of zero (0) indicates that only current usage is measured.
         *                   The decay is linear and gives preference to newer jobs.
         *                   <p>
         *                   The maximum supported value is 604800 seconds (1 week).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder shareDecay(software.amazon.awscdk.Duration shareDecay) {
            this.shareDecay = shareDecay;
            return this;
        }

        /**
         * Sets the value of {@link FairshareSchedulingPolicyProps#getShares}
         * @param shares The shares that this Scheduling Policy applies to.
         *               <em>Note</em>: It is possible to submit Jobs to the queue with Share Identifiers that
         *               are not recognized by the Scheduling Policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder shares(java.util.List<? extends software.amazon.awscdk.services.batch.Share> shares) {
            this.shares = (java.util.List<software.amazon.awscdk.services.batch.Share>)shares;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FairshareSchedulingPolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FairshareSchedulingPolicyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FairshareSchedulingPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FairshareSchedulingPolicyProps {
        private final java.lang.Number computeReservation;
        private final java.lang.String schedulingPolicyName;
        private final software.amazon.awscdk.Duration shareDecay;
        private final java.util.List<software.amazon.awscdk.services.batch.Share> shares;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.computeReservation = software.amazon.jsii.Kernel.get(this, "computeReservation", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.schedulingPolicyName = software.amazon.jsii.Kernel.get(this, "schedulingPolicyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.shareDecay = software.amazon.jsii.Kernel.get(this, "shareDecay", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.shares = software.amazon.jsii.Kernel.get(this, "shares", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.Share.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.computeReservation = builder.computeReservation;
            this.schedulingPolicyName = builder.schedulingPolicyName;
            this.shareDecay = builder.shareDecay;
            this.shares = (java.util.List<software.amazon.awscdk.services.batch.Share>)builder.shares;
        }

        @Override
        public final java.lang.Number getComputeReservation() {
            return this.computeReservation;
        }

        @Override
        public final java.lang.String getSchedulingPolicyName() {
            return this.schedulingPolicyName;
        }

        @Override
        public final software.amazon.awscdk.Duration getShareDecay() {
            return this.shareDecay;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.batch.Share> getShares() {
            return this.shares;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getComputeReservation() != null) {
                data.set("computeReservation", om.valueToTree(this.getComputeReservation()));
            }
            if (this.getSchedulingPolicyName() != null) {
                data.set("schedulingPolicyName", om.valueToTree(this.getSchedulingPolicyName()));
            }
            if (this.getShareDecay() != null) {
                data.set("shareDecay", om.valueToTree(this.getShareDecay()));
            }
            if (this.getShares() != null) {
                data.set("shares", om.valueToTree(this.getShares()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.FairshareSchedulingPolicyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FairshareSchedulingPolicyProps.Jsii$Proxy that = (FairshareSchedulingPolicyProps.Jsii$Proxy) o;

            if (this.computeReservation != null ? !this.computeReservation.equals(that.computeReservation) : that.computeReservation != null) return false;
            if (this.schedulingPolicyName != null ? !this.schedulingPolicyName.equals(that.schedulingPolicyName) : that.schedulingPolicyName != null) return false;
            if (this.shareDecay != null ? !this.shareDecay.equals(that.shareDecay) : that.shareDecay != null) return false;
            return this.shares != null ? this.shares.equals(that.shares) : that.shares == null;
        }

        @Override
        public final int hashCode() {
            int result = this.computeReservation != null ? this.computeReservation.hashCode() : 0;
            result = 31 * result + (this.schedulingPolicyName != null ? this.schedulingPolicyName.hashCode() : 0);
            result = 31 * result + (this.shareDecay != null ? this.shareDecay.hashCode() : 0);
            result = 31 * result + (this.shares != null ? this.shares.hashCode() : 0);
            return result;
        }
    }
}
