package software.amazon.awscdk.services.cloudformation;

/**
 * The <code>AWS::CloudFormation::Stack</code> resource nests a stack as a resource in a top-level template.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html">Embed stacks within other stacks using nested stacks</a> in the <em>AWS CloudFormation User Guide</em> .
 * <p>
 * You can add output values from a nested stack within the containing template. You use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-getatt.html">GetAtt</a> function with the nested stack's logical name and the name of the output value in the nested stack in the format <code>Outputs. *NestedStackOutputName*</code> .
 * <p>
 * We strongly recommend that updates to nested stacks are run from the parent stack.
 * <p>
 * When you apply template changes to update a top-level stack, CloudFormation updates the top-level stack and initiates an update to its nested stacks. CloudFormation updates the resources of modified nested stacks, but doesn't update the resources of unmodified nested stacks.
 * <p>
 * You must acknowledge IAM capabilities for nested stacks that contain IAM resources. Also, verify that you have cancel update stack permissions, which is required if an update rolls back. For more information about IAM and CloudFormation , see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/control-access-with-iam.html">Controlling access with AWS Identity and Access Management</a> in the <em>AWS CloudFormation User Guide</em> .
 * <p>
 * <blockquote>
 * <p>
 * A subset of <code>AWS::CloudFormation::Stack</code> resource type properties listed below are available to customers using CloudFormation , AWS CDK , and Cloud Control  to configure.
 * <p>
 * <ul>
 * <li><code>NotificationARNs</code></li>
 * <li><code>Parameters</code></li>
 * <li><code>Tags</code></li>
 * <li><code>TemplateURL</code></li>
 * <li><code>TimeoutInMinutes</code></li>
 * </ul>
 * <p>
 * These properties can be configured only when using Cloud Control  . This is because the below properties are set by the parent stack, and thus cannot be configured using CloudFormation or AWS CDK but only Cloud Control  .
 * <p>
 * <ul>
 * <li><code>Capabilities</code></li>
 * <li><code>Description</code></li>
 * <li><code>DisableRollback</code></li>
 * <li><code>EnableTerminationProtection</code></li>
 * <li><code>RoleARN</code></li>
 * <li><code>StackName</code></li>
 * <li><code>StackPolicyBody</code></li>
 * <li><code>StackPolicyURL</code></li>
 * <li><code>StackStatusReason</code></li>
 * <li><code>TemplateBody</code></li>
 * </ul>
 * <p>
 * Customers that configure <code>AWS::CloudFormation::Stack</code> using CloudFormation and AWS CDK can do so for nesting a CloudFormation stack as a resource in their top-level template.
 * <p>
 * These read-only properties can be accessed only when using Cloud Control  .
 * <p>
 * <ul>
 * <li><code>ChangeSetId</code></li>
 * <li><code>CreationTime</code></li>
 * <li><code>LastUpdateTime</code></li>
 * <li><code>Outputs</code></li>
 * <li><code>ParentId</code></li>
 * <li><code>RootId</code></li>
 * <li><code>StackId</code></li>
 * <li><code>StackStatus</code></li>
 * </ul>
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudformation.*;
 * CfnStack cfnStack = CfnStack.Builder.create(this, "MyCfnStack")
 *         .notificationArns(List.of("notificationArns"))
 *         .parameters(Map.of(
 *                 "parametersKey", "parameters"))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .templateUrl("templateUrl")
 *         .timeoutInMinutes(123)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stack.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stack.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:35.308Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudformation.CfnStack")
public class CfnStack extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnStack(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnStack(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudformation.CfnStack.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnStack(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudformation.CfnStackProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnStack(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * Returns the unique ID of the change set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrChangeSetId() {
        return software.amazon.jsii.Kernel.get(this, "attrChangeSetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns The time at which the stack was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreationTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreationTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns the time the stack was last updated.
     * <p>
     * This will only be returned if the stack has been updated at least once.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLastUpdateTime() {
        return software.amazon.jsii.Kernel.get(this, "attrLastUpdateTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns a list of output structures.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrOutputs() {
        return software.amazon.jsii.Kernel.get(this, "attrOutputs", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * For nested stacks--stacks created as resources for another stack--returns the stack ID of the direct parent of this stack.
     * <p>
     * For the first level of nested stacks, the root stack is also the parent stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrParentId() {
        return software.amazon.jsii.Kernel.get(this, "attrParentId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * For nested stacks--stacks created as resources for another stack--returns the stack ID of the top-level stack to which the nested stack ultimately belongs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrRootId() {
        return software.amazon.jsii.Kernel.get(this, "attrRootId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns the unique identifier of the stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStackId() {
        return software.amazon.jsii.Kernel.get(this, "attrStackId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns a success or failure message associated with the stack status.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStackStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrStackStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The Amazon SNS topic ARNs to publish stack related events.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getNotificationArns() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "notificationArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The Amazon SNS topic ARNs to publish stack related events.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNotificationArns(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "notificationArns", value);
    }

    /**
     * The set value pairs that represent the parameters passed to CloudFormation when this nested stack is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
        return software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The set value pairs that represent the parameters passed to CloudFormation when this nested stack is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setParameters(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "parameters", value);
    }

    /**
     * The set value pairs that represent the parameters passed to CloudFormation when this nested stack is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setParameters(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "parameters", value);
    }

    /**
     * Key-value pairs to associate with this stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Key-value pairs to associate with this stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * The URL of a file containing the template body.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTemplateUrl() {
        return software.amazon.jsii.Kernel.get(this, "templateUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The URL of a file containing the template body.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTemplateUrl(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "templateUrl", value);
    }

    /**
     * The length of time, in minutes, that CloudFormation waits for the nested stack to reach the <code>CREATE_COMPLETE</code> state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getTimeoutInMinutes() {
        return software.amazon.jsii.Kernel.get(this, "timeoutInMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The length of time, in minutes, that CloudFormation waits for the nested stack to reach the <code>CREATE_COMPLETE</code> state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTimeoutInMinutes(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "timeoutInMinutes", value);
    }
    /**
     * The Output data type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudformation.*;
     * OutputProperty outputProperty = OutputProperty.builder()
     *         .description("description")
     *         .exportName("exportName")
     *         .outputKey("outputKey")
     *         .outputValue("outputValue")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-stack-output.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-stack-output.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudformation.CfnStack.OutputProperty")
    @software.amazon.jsii.Jsii.Proxy(OutputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OutputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * User defined description associated with the output.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-stack-output.html#cfn-cloudformation-stack-output-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-stack-output.html#cfn-cloudformation-stack-output-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * The name of the export associated with the output.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-stack-output.html#cfn-cloudformation-stack-output-exportname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-stack-output.html#cfn-cloudformation-stack-output-exportname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExportName() {
            return null;
        }

        /**
         * The key associated with the output.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-stack-output.html#cfn-cloudformation-stack-output-outputkey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-stack-output.html#cfn-cloudformation-stack-output-outputkey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOutputKey() {
            return null;
        }

        /**
         * The value associated with the output.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-stack-output.html#cfn-cloudformation-stack-output-outputvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudformation-stack-output.html#cfn-cloudformation-stack-output-outputvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOutputValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OutputProperty> {
            java.lang.String description;
            java.lang.String exportName;
            java.lang.String outputKey;
            java.lang.String outputValue;

            /**
             * Sets the value of {@link OutputProperty#getDescription}
             * @param description User defined description associated with the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link OutputProperty#getExportName}
             * @param exportName The name of the export associated with the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exportName(java.lang.String exportName) {
                this.exportName = exportName;
                return this;
            }

            /**
             * Sets the value of {@link OutputProperty#getOutputKey}
             * @param outputKey The key associated with the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputKey(java.lang.String outputKey) {
                this.outputKey = outputKey;
                return this;
            }

            /**
             * Sets the value of {@link OutputProperty#getOutputValue}
             * @param outputValue The value associated with the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputValue(java.lang.String outputValue) {
                this.outputValue = outputValue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OutputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OutputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OutputProperty {
            private final java.lang.String description;
            private final java.lang.String exportName;
            private final java.lang.String outputKey;
            private final java.lang.String outputValue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.exportName = software.amazon.jsii.Kernel.get(this, "exportName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.outputKey = software.amazon.jsii.Kernel.get(this, "outputKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.outputValue = software.amazon.jsii.Kernel.get(this, "outputValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.description = builder.description;
                this.exportName = builder.exportName;
                this.outputKey = builder.outputKey;
                this.outputValue = builder.outputValue;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.String getExportName() {
                return this.exportName;
            }

            @Override
            public final java.lang.String getOutputKey() {
                return this.outputKey;
            }

            @Override
            public final java.lang.String getOutputValue() {
                return this.outputValue;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getExportName() != null) {
                    data.set("exportName", om.valueToTree(this.getExportName()));
                }
                if (this.getOutputKey() != null) {
                    data.set("outputKey", om.valueToTree(this.getOutputKey()));
                }
                if (this.getOutputValue() != null) {
                    data.set("outputValue", om.valueToTree(this.getOutputValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudformation.CfnStack.OutputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OutputProperty.Jsii$Proxy that = (OutputProperty.Jsii$Proxy) o;

                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.exportName != null ? !this.exportName.equals(that.exportName) : that.exportName != null) return false;
                if (this.outputKey != null ? !this.outputKey.equals(that.outputKey) : that.outputKey != null) return false;
                return this.outputValue != null ? this.outputValue.equals(that.outputValue) : that.outputValue == null;
            }

            @Override
            public final int hashCode() {
                int result = this.description != null ? this.description.hashCode() : 0;
                result = 31 * result + (this.exportName != null ? this.exportName.hashCode() : 0);
                result = 31 * result + (this.outputKey != null ? this.outputKey.hashCode() : 0);
                result = 31 * result + (this.outputValue != null ? this.outputValue.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cloudformation.CfnStack}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudformation.CfnStack> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.cloudformation.CfnStackProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The Amazon SNS topic ARNs to publish stack related events.
         * <p>
         * You can find your Amazon SNS topic ARNs using the Amazon SNS console or your Command Line Interface (CLI).
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stack.html#cfn-cloudformation-stack-notificationarns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stack.html#cfn-cloudformation-stack-notificationarns</a>
         * @param notificationArns The Amazon SNS topic ARNs to publish stack related events. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationArns(final java.util.List<java.lang.String> notificationArns) {
            this.props().notificationArns(notificationArns);
            return this;
        }

        /**
         * The set value pairs that represent the parameters passed to CloudFormation when this nested stack is created.
         * <p>
         * Each parameter has a name corresponding to a parameter defined in the embedded template and a value representing the value that you want to set for the parameter.
         * <p>
         * <blockquote>
         * <p>
         * If you use the <code>Ref</code> function to pass a parameter value to a nested stack, comma-delimited list parameters must be of type <code>String</code> . In other words, you can't pass values that are of type <code>CommaDelimitedList</code> to nested stacks.
         * <p>
         * </blockquote>
         * <p>
         * Required if the nested stack requires input parameters.
         * <p>
         * Whether an update causes interruptions depends on the resources that are being updated. An update never causes a nested stack to be replaced.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stack.html#cfn-cloudformation-stack-parameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stack.html#cfn-cloudformation-stack-parameters</a>
         * @param parameters The set value pairs that represent the parameters passed to CloudFormation when this nested stack is created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(final java.util.Map<java.lang.String, java.lang.String> parameters) {
            this.props().parameters(parameters);
            return this;
        }
        /**
         * The set value pairs that represent the parameters passed to CloudFormation when this nested stack is created.
         * <p>
         * Each parameter has a name corresponding to a parameter defined in the embedded template and a value representing the value that you want to set for the parameter.
         * <p>
         * <blockquote>
         * <p>
         * If you use the <code>Ref</code> function to pass a parameter value to a nested stack, comma-delimited list parameters must be of type <code>String</code> . In other words, you can't pass values that are of type <code>CommaDelimitedList</code> to nested stacks.
         * <p>
         * </blockquote>
         * <p>
         * Required if the nested stack requires input parameters.
         * <p>
         * Whether an update causes interruptions depends on the resources that are being updated. An update never causes a nested stack to be replaced.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stack.html#cfn-cloudformation-stack-parameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stack.html#cfn-cloudformation-stack-parameters</a>
         * @param parameters The set value pairs that represent the parameters passed to CloudFormation when this nested stack is created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(final software.amazon.awscdk.IResolvable parameters) {
            this.props().parameters(parameters);
            return this;
        }

        /**
         * Key-value pairs to associate with this stack.
         * <p>
         * CloudFormation also propagates these tags to the resources created in the stack. A maximum number of 50 tags can be specified.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stack.html#cfn-cloudformation-stack-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stack.html#cfn-cloudformation-stack-tags</a>
         * @param tags Key-value pairs to associate with this stack. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * The URL of a file containing the template body.
         * <p>
         * The URL must point to a template (max size: 1 MB) that's located in an Amazon S3 bucket. The location for an Amazon S3 bucket must start with <code>https://</code> .
         * <p>
         * Whether an update causes interruptions depends on the resources that are being updated. An update never causes a nested stack to be replaced.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stack.html#cfn-cloudformation-stack-templateurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stack.html#cfn-cloudformation-stack-templateurl</a>
         * @param templateUrl The URL of a file containing the template body. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templateUrl(final java.lang.String templateUrl) {
            this.props().templateUrl(templateUrl);
            return this;
        }

        /**
         * The length of time, in minutes, that CloudFormation waits for the nested stack to reach the <code>CREATE_COMPLETE</code> state.
         * <p>
         * The default is no timeout. When CloudFormation detects that the nested stack has reached the <code>CREATE_COMPLETE</code> state, it marks the nested stack resource as <code>CREATE_COMPLETE</code> in the parent stack and resumes creating the parent stack. If the timeout period expires before the nested stack reaches <code>CREATE_COMPLETE</code> , CloudFormation marks the nested stack as failed and rolls back both the nested stack and parent stack.
         * <p>
         * Updates aren't supported.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stack.html#cfn-cloudformation-stack-timeoutinminutes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stack.html#cfn-cloudformation-stack-timeoutinminutes</a>
         * @param timeoutInMinutes The length of time, in minutes, that CloudFormation waits for the nested stack to reach the <code>CREATE_COMPLETE</code> state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeoutInMinutes(final java.lang.Number timeoutInMinutes) {
            this.props().timeoutInMinutes(timeoutInMinutes);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cloudformation.CfnStack}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cloudformation.CfnStack build() {
            return new software.amazon.awscdk.services.cloudformation.CfnStack(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.cloudformation.CfnStackProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.cloudformation.CfnStackProps.Builder();
            }
            return this.props;
        }
    }
}
