package software.amazon.awscdk.services.cloudfront;

/**
 * Represents a Lambda function version and event type when using Lambda&#64;Edge.
 * <p>
 * The type of the <code>AddBehaviorOptions.edgeLambdas</code> property.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudfront.*;
 * import software.amazon.awscdk.services.lambda.*;
 * Version version;
 * EdgeLambda edgeLambda = EdgeLambda.builder()
 *         .eventType(LambdaEdgeEventType.ORIGIN_REQUEST)
 *         .functionVersion(version)
 *         // the properties below are optional
 *         .includeBody(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:35.485Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.EdgeLambda")
@software.amazon.jsii.Jsii.Proxy(EdgeLambda.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EdgeLambda extends software.amazon.jsii.JsiiSerializable {

    /**
     * The type of event in response to which should the function be invoked.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.LambdaEdgeEventType getEventType();

    /**
     * The version of the Lambda function that will be invoked.
     * <p>
     * <strong>Note</strong>: it's not possible to use the '$LATEST' function version for Lambda&#64;Edge!
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IVersion getFunctionVersion();

    /**
     * Allows a Lambda function to have read access to the body content.
     * <p>
     * Only valid for "request" event types (<code>ORIGIN_REQUEST</code> or <code>VIEWER_REQUEST</code>).
     * See https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/lambda-include-body-access.html
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIncludeBody() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link EdgeLambda}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EdgeLambda}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EdgeLambda> {
        software.amazon.awscdk.services.cloudfront.LambdaEdgeEventType eventType;
        software.amazon.awscdk.services.lambda.IVersion functionVersion;
        java.lang.Boolean includeBody;

        /**
         * Sets the value of {@link EdgeLambda#getEventType}
         * @param eventType The type of event in response to which should the function be invoked. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventType(software.amazon.awscdk.services.cloudfront.LambdaEdgeEventType eventType) {
            this.eventType = eventType;
            return this;
        }

        /**
         * Sets the value of {@link EdgeLambda#getFunctionVersion}
         * @param functionVersion The version of the Lambda function that will be invoked. This parameter is required.
         *                        <strong>Note</strong>: it's not possible to use the '$LATEST' function version for Lambda&#64;Edge!
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder functionVersion(software.amazon.awscdk.services.lambda.IVersion functionVersion) {
            this.functionVersion = functionVersion;
            return this;
        }

        /**
         * Sets the value of {@link EdgeLambda#getIncludeBody}
         * @param includeBody Allows a Lambda function to have read access to the body content.
         *                    Only valid for "request" event types (<code>ORIGIN_REQUEST</code> or <code>VIEWER_REQUEST</code>).
         *                    See https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/lambda-include-body-access.html
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder includeBody(java.lang.Boolean includeBody) {
            this.includeBody = includeBody;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EdgeLambda}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EdgeLambda build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EdgeLambda}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EdgeLambda {
        private final software.amazon.awscdk.services.cloudfront.LambdaEdgeEventType eventType;
        private final software.amazon.awscdk.services.lambda.IVersion functionVersion;
        private final java.lang.Boolean includeBody;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.eventType = software.amazon.jsii.Kernel.get(this, "eventType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.LambdaEdgeEventType.class));
            this.functionVersion = software.amazon.jsii.Kernel.get(this, "functionVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IVersion.class));
            this.includeBody = software.amazon.jsii.Kernel.get(this, "includeBody", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.eventType = java.util.Objects.requireNonNull(builder.eventType, "eventType is required");
            this.functionVersion = java.util.Objects.requireNonNull(builder.functionVersion, "functionVersion is required");
            this.includeBody = builder.includeBody;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.LambdaEdgeEventType getEventType() {
            return this.eventType;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.IVersion getFunctionVersion() {
            return this.functionVersion;
        }

        @Override
        public final java.lang.Boolean getIncludeBody() {
            return this.includeBody;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("eventType", om.valueToTree(this.getEventType()));
            data.set("functionVersion", om.valueToTree(this.getFunctionVersion()));
            if (this.getIncludeBody() != null) {
                data.set("includeBody", om.valueToTree(this.getIncludeBody()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.EdgeLambda"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EdgeLambda.Jsii$Proxy that = (EdgeLambda.Jsii$Proxy) o;

            if (!eventType.equals(that.eventType)) return false;
            if (!functionVersion.equals(that.functionVersion)) return false;
            return this.includeBody != null ? this.includeBody.equals(that.includeBody) : that.includeBody == null;
        }

        @Override
        public final int hashCode() {
            int result = this.eventType.hashCode();
            result = 31 * result + (this.functionVersion.hashCode());
            result = 31 * result + (this.includeBody != null ? this.includeBody.hashCode() : 0);
            return result;
        }
    }
}
