package software.amazon.awscdk.services.cloudfront;

/**
 * A Response Headers Policy configuration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Using an existing managed response headers policy
 * S3Origin bucketOrigin;
 * Distribution.Builder.create(this, "myDistManagedPolicy")
 *         .defaultBehavior(BehaviorOptions.builder()
 *                 .origin(bucketOrigin)
 *                 .responseHeadersPolicy(ResponseHeadersPolicy.CORS_ALLOW_ALL_ORIGINS)
 *                 .build())
 *         .build();
 * // Creating a custom response headers policy -- all parameters optional
 * ResponseHeadersPolicy myResponseHeadersPolicy = ResponseHeadersPolicy.Builder.create(this, "ResponseHeadersPolicy")
 *         .responseHeadersPolicyName("MyPolicy")
 *         .comment("A default policy")
 *         .corsBehavior(ResponseHeadersCorsBehavior.builder()
 *                 .accessControlAllowCredentials(false)
 *                 .accessControlAllowHeaders(List.of("X-Custom-Header-1", "X-Custom-Header-2"))
 *                 .accessControlAllowMethods(List.of("GET", "POST"))
 *                 .accessControlAllowOrigins(List.of("*"))
 *                 .accessControlExposeHeaders(List.of("X-Custom-Header-1", "X-Custom-Header-2"))
 *                 .accessControlMaxAge(Duration.seconds(600))
 *                 .originOverride(true)
 *                 .build())
 *         .customHeadersBehavior(ResponseCustomHeadersBehavior.builder()
 *                 .customHeaders(List.of(ResponseCustomHeader.builder().header("X-Amz-Date").value("some-value").override(true).build(), ResponseCustomHeader.builder().header("X-Amz-Security-Token").value("some-value").override(false).build()))
 *                 .build())
 *         .securityHeadersBehavior(ResponseSecurityHeadersBehavior.builder()
 *                 .contentSecurityPolicy(ResponseHeadersContentSecurityPolicy.builder().contentSecurityPolicy("default-src https:;").override(true).build())
 *                 .contentTypeOptions(ResponseHeadersContentTypeOptions.builder().override(true).build())
 *                 .frameOptions(ResponseHeadersFrameOptions.builder().frameOption(HeadersFrameOption.DENY).override(true).build())
 *                 .referrerPolicy(ResponseHeadersReferrerPolicy.builder().referrerPolicy(HeadersReferrerPolicy.NO_REFERRER).override(true).build())
 *                 .strictTransportSecurity(ResponseHeadersStrictTransportSecurity.builder().accessControlMaxAge(Duration.seconds(600)).includeSubdomains(true).override(true).build())
 *                 .xssProtection(ResponseHeadersXSSProtection.builder().protection(true).modeBlock(false).reportUri("https://example.com/csp-report").override(true).build())
 *                 .build())
 *         .removeHeaders(List.of("Server"))
 *         .serverTimingSamplingRate(50)
 *         .build();
 * Distribution.Builder.create(this, "myDistCustomPolicy")
 *         .defaultBehavior(BehaviorOptions.builder()
 *                 .origin(bucketOrigin)
 *                 .responseHeadersPolicy(myResponseHeadersPolicy)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:35.525Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.ResponseHeadersPolicy")
public class ResponseHeadersPolicy extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.cloudfront.IResponseHeadersPolicy {

    protected ResponseHeadersPolicy(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ResponseHeadersPolicy(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CORS_ALLOW_ALL_ORIGINS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudfront.ResponseHeadersPolicy.class, "CORS_ALLOW_ALL_ORIGINS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IResponseHeadersPolicy.class));
        CORS_ALLOW_ALL_ORIGINS_AND_SECURITY_HEADERS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudfront.ResponseHeadersPolicy.class, "CORS_ALLOW_ALL_ORIGINS_AND_SECURITY_HEADERS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IResponseHeadersPolicy.class));
        CORS_ALLOW_ALL_ORIGINS_WITH_PREFLIGHT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudfront.ResponseHeadersPolicy.class, "CORS_ALLOW_ALL_ORIGINS_WITH_PREFLIGHT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IResponseHeadersPolicy.class));
        CORS_ALLOW_ALL_ORIGINS_WITH_PREFLIGHT_AND_SECURITY_HEADERS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudfront.ResponseHeadersPolicy.class, "CORS_ALLOW_ALL_ORIGINS_WITH_PREFLIGHT_AND_SECURITY_HEADERS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IResponseHeadersPolicy.class));
        SECURITY_HEADERS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudfront.ResponseHeadersPolicy.class, "SECURITY_HEADERS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IResponseHeadersPolicy.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ResponseHeadersPolicy(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.ResponseHeadersPolicyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ResponseHeadersPolicy(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Import an existing Response Headers Policy from its ID.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param responseHeadersPolicyId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.IResponseHeadersPolicy fromResponseHeadersPolicyId(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String responseHeadersPolicyId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.ResponseHeadersPolicy.class, "fromResponseHeadersPolicyId", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IResponseHeadersPolicy.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(responseHeadersPolicyId, "responseHeadersPolicyId is required") });
    }

    /**
     * Use this managed policy to allow simple CORS requests from any origin.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cloudfront.IResponseHeadersPolicy CORS_ALLOW_ALL_ORIGINS;

    /**
     * Use this managed policy to allow simple CORS requests from any origin and add a set of security headers to all responses that CloudFront sends to viewers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cloudfront.IResponseHeadersPolicy CORS_ALLOW_ALL_ORIGINS_AND_SECURITY_HEADERS;

    /**
     * Use this managed policy to allow CORS requests from any origin, including preflight requests.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cloudfront.IResponseHeadersPolicy CORS_ALLOW_ALL_ORIGINS_WITH_PREFLIGHT;

    /**
     * Use this managed policy to allow CORS requests from any origin, including preflight requests, and add a set of security headers to all responses that CloudFront sends to viewers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cloudfront.IResponseHeadersPolicy CORS_ALLOW_ALL_ORIGINS_WITH_PREFLIGHT_AND_SECURITY_HEADERS;

    /**
     * Use this managed policy to add a set of security headers to all responses that CloudFront sends to viewers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cloudfront.IResponseHeadersPolicy SECURITY_HEADERS;

    /**
     * The ID of the response headers policy.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getResponseHeadersPolicyId() {
        return software.amazon.jsii.Kernel.get(this, "responseHeadersPolicyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cloudfront.ResponseHeadersPolicy}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudfront.ResponseHeadersPolicy> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.cloudfront.ResponseHeadersPolicyProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * A comment to describe the response headers policy.
         * <p>
         * Default: - no comment
         * <p>
         * @return {@code this}
         * @param comment A comment to describe the response headers policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(final java.lang.String comment) {
            this.props().comment(comment);
            return this;
        }

        /**
         * A configuration for a set of HTTP response headers that are used for cross-origin resource sharing (CORS).
         * <p>
         * Default: - no cors behavior
         * <p>
         * @return {@code this}
         * @param corsBehavior A configuration for a set of HTTP response headers that are used for cross-origin resource sharing (CORS). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder corsBehavior(final software.amazon.awscdk.services.cloudfront.ResponseHeadersCorsBehavior corsBehavior) {
            this.props().corsBehavior(corsBehavior);
            return this;
        }

        /**
         * A configuration for a set of custom HTTP response headers.
         * <p>
         * Default: - no custom headers behavior
         * <p>
         * @return {@code this}
         * @param customHeadersBehavior A configuration for a set of custom HTTP response headers. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customHeadersBehavior(final software.amazon.awscdk.services.cloudfront.ResponseCustomHeadersBehavior customHeadersBehavior) {
            this.props().customHeadersBehavior(customHeadersBehavior);
            return this;
        }

        /**
         * A list of HTTP response headers that CloudFront removes from HTTP responses that it sends to viewers.
         * <p>
         * Default: - no headers are removed
         * <p>
         * @return {@code this}
         * @param removeHeaders A list of HTTP response headers that CloudFront removes from HTTP responses that it sends to viewers. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removeHeaders(final java.util.List<java.lang.String> removeHeaders) {
            this.props().removeHeaders(removeHeaders);
            return this;
        }

        /**
         * A unique name to identify the response headers policy.
         * <p>
         * Default: - generated from the `id`
         * <p>
         * @return {@code this}
         * @param responseHeadersPolicyName A unique name to identify the response headers policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder responseHeadersPolicyName(final java.lang.String responseHeadersPolicyName) {
            this.props().responseHeadersPolicyName(responseHeadersPolicyName);
            return this;
        }

        /**
         * A configuration for a set of security-related HTTP response headers.
         * <p>
         * Default: - no security headers behavior
         * <p>
         * @return {@code this}
         * @param securityHeadersBehavior A configuration for a set of security-related HTTP response headers. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityHeadersBehavior(final software.amazon.awscdk.services.cloudfront.ResponseSecurityHeadersBehavior securityHeadersBehavior) {
            this.props().securityHeadersBehavior(securityHeadersBehavior);
            return this;
        }

        /**
         * The percentage of responses that you want CloudFront to add the Server-Timing header to.
         * <p>
         * Default: - no Server-Timing header is added to HTTP responses
         * <p>
         * @return {@code this}
         * @param serverTimingSamplingRate The percentage of responses that you want CloudFront to add the Server-Timing header to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverTimingSamplingRate(final java.lang.Number serverTimingSamplingRate) {
            this.props().serverTimingSamplingRate(serverTimingSamplingRate);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cloudfront.ResponseHeadersPolicy}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cloudfront.ResponseHeadersPolicy build() {
            return new software.amazon.awscdk.services.cloudfront.ResponseHeadersPolicy(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.cloudfront.ResponseHeadersPolicyProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.cloudfront.ResponseHeadersPolicyProps.Builder();
            }
            return this.props;
        }
    }
}
