package software.amazon.awscdk.services.codebuild;

/**
 * A CodeBuild image running aarch64 Linux.
 * <p>
 * This class has a bunch of public constants that represent the CodeBuild ARM images.
 * <p>
 * You can also specify a custom image using the static method:
 * <p>
 * <ul>
 * <li>LinuxBuildImage.fromEcrRepository(repo[, tag])</li>
 * <li>LinuxBuildImage.fromDockerRegistry(image[, { secretsManagerCredentials }])</li>
 * </ul>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.codebuild.*;
 * IBuildImage linuxArmBuildImage = LinuxArmBuildImage.fromCodeBuildImageId("id");
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-available.html">https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-available.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:35.870Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.LinuxArmBuildImage")
public class LinuxArmBuildImage extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codebuild.IBuildImage {

    protected LinuxArmBuildImage(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LinuxArmBuildImage(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        AMAZON_LINUX_2_STANDARD_1_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxArmBuildImage.class, "AMAZON_LINUX_2_STANDARD_1_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        AMAZON_LINUX_2_STANDARD_2_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxArmBuildImage.class, "AMAZON_LINUX_2_STANDARD_2_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        AMAZON_LINUX_2_STANDARD_3_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxArmBuildImage.class, "AMAZON_LINUX_2_STANDARD_3_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        AMAZON_LINUX_2023_STANDARD_2_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxArmBuildImage.class, "AMAZON_LINUX_2023_STANDARD_2_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
        AMAZON_LINUX_2023_STANDARD_3_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxArmBuildImage.class, "AMAZON_LINUX_2023_STANDARD_3_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class));
    }

    /**
     * Uses a Docker image provided by CodeBuild.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * "aws/codebuild/amazonlinux2-aarch64-standard:1.0";
     * </pre></blockquote>
     * <p>
     * @return A Docker image provided by CodeBuild.
     * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-available.html">https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-available.html</a>
     * @param id The image identifier. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.IBuildImage fromCodeBuildImageId(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.LinuxArmBuildImage.class, "fromCodeBuildImageId", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * @return a aarch-64 Linux build image from a Docker Hub image.
     * @param name This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.IBuildImage fromDockerRegistry(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.DockerImageOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.LinuxArmBuildImage.class, "fromDockerRegistry", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required"), options });
    }

    /**
     * @return a aarch-64 Linux build image from a Docker Hub image.
     * @param name This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.IBuildImage fromDockerRegistry(final @org.jetbrains.annotations.NotNull java.lang.String name) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.LinuxArmBuildImage.class, "fromDockerRegistry", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * Returns an ARM image running Linux from an ECR repository.
     * <p>
     * NOTE: if the repository is external (i.e. imported), then we won't be able to add
     * a resource policy statement for it so CodeBuild can pull the image.
     * <p>
     * @return An aarch64 Linux build image from an ECR repository.
     * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-ecr.html">https://docs.aws.amazon.com/codebuild/latest/userguide/sample-ecr.html</a>
     * @param repository The ECR repository. This parameter is required.
     * @param tagOrDigest Image tag or digest (default "latest", digests must start with <code>sha256:</code>).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.IBuildImage fromEcrRepository(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.IRepository repository, final @org.jetbrains.annotations.Nullable java.lang.String tagOrDigest) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.LinuxArmBuildImage.class, "fromEcrRepository", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class), new Object[] { java.util.Objects.requireNonNull(repository, "repository is required"), tagOrDigest });
    }

    /**
     * Returns an ARM image running Linux from an ECR repository.
     * <p>
     * NOTE: if the repository is external (i.e. imported), then we won't be able to add
     * a resource policy statement for it so CodeBuild can pull the image.
     * <p>
     * @return An aarch64 Linux build image from an ECR repository.
     * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-ecr.html">https://docs.aws.amazon.com/codebuild/latest/userguide/sample-ecr.html</a>
     * @param repository The ECR repository. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.IBuildImage fromEcrRepository(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.IRepository repository) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.LinuxArmBuildImage.class, "fromEcrRepository", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.IBuildImage.class), new Object[] { java.util.Objects.requireNonNull(repository, "repository is required") });
    }

    /**
     * Make a buildspec to run the indicated script.
     * <p>
     * @param entrypoint This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.BuildSpec runScriptBuildspec(final @org.jetbrains.annotations.NotNull java.lang.String entrypoint) {
        return software.amazon.jsii.Kernel.call(this, "runScriptBuildspec", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.BuildSpec.class), new Object[] { java.util.Objects.requireNonNull(entrypoint, "entrypoint is required") });
    }

    /**
     * Validates by checking the BuildEnvironments' images are not Lambda ComputeTypes.
     * <p>
     * @param buildEnvironment BuildEnvironment. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> validate(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.BuildEnvironment buildEnvironment) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "validate", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(buildEnvironment, "buildEnvironment is required") }));
    }

    /**
     * (deprecated) Image "aws/codebuild/amazonlinux2-aarch64-standard:1.0".
     * <p>
     * @deprecated Use {@link LinuxArmBuildImage.AMAZON_LINUX_2_STANDARD_3_0 } instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.codebuild.IBuildImage AMAZON_LINUX_2_STANDARD_1_0;

    /**
     * Image "aws/codebuild/amazonlinux2-aarch64-standard:2.0" based on Amazon Linux 2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage AMAZON_LINUX_2_STANDARD_2_0;

    /**
     * Image "aws/codebuild/amazonlinux2-aarch64-standard:3.0" based on Amazon Linux 2023.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage AMAZON_LINUX_2_STANDARD_3_0;

    /**
     * Image "aws/codebuild/amazonlinux-aarch64-standard:2.0" based on Amazon Linux 2023.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage AMAZON_LINUX_2023_STANDARD_2_0;

    /**
     * Image "aws/codebuild/amazonlinux-aarch64-standard:3.0" based on Amazon Linux 2023.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage AMAZON_LINUX_2023_STANDARD_3_0;

    /**
     * The default <code>ComputeType</code> to use with this image, if one was not specified in <code>BuildEnvironment#computeType</code> explicitly.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.ComputeType getDefaultComputeType() {
        return software.amazon.jsii.Kernel.get(this, "defaultComputeType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.ComputeType.class));
    }

    /**
     * The Docker image identifier that the build environment uses.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getImageId() {
        return software.amazon.jsii.Kernel.get(this, "imageId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of build environment.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of principal that CodeBuild will use to pull this build Docker image.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.ImagePullPrincipalType getImagePullPrincipalType() {
        return software.amazon.jsii.Kernel.get(this, "imagePullPrincipalType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.ImagePullPrincipalType.class));
    }

    /**
     * An optional ECR repository that the image is hosted in.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecr.IRepository getRepository() {
        return software.amazon.jsii.Kernel.get(this, "repository", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecr.IRepository.class));
    }

    /**
     * The secretsManagerCredentials for access to a private registry.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.secretsmanager.ISecret getSecretsManagerCredentials() {
        return software.amazon.jsii.Kernel.get(this, "secretsManagerCredentials", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.ISecret.class));
    }
}
