package software.amazon.awscdk.services.codecommit;

/**
 * Properties for defining a <code>CfnRepository</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.codecommit.*;
 * CfnRepositoryProps cfnRepositoryProps = CfnRepositoryProps.builder()
 *         .repositoryName("repositoryName")
 *         // the properties below are optional
 *         .code(CodeProperty.builder()
 *                 .s3(S3Property.builder()
 *                         .bucket("bucket")
 *                         .key("key")
 *                         // the properties below are optional
 *                         .objectVersion("objectVersion")
 *                         .build())
 *                 // the properties below are optional
 *                 .branchName("branchName")
 *                 .build())
 *         .kmsKeyId("kmsKeyId")
 *         .repositoryDescription("repositoryDescription")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .triggers(List.of(RepositoryTriggerProperty.builder()
 *                 .destinationArn("destinationArn")
 *                 .events(List.of("events"))
 *                 .name("name")
 *                 // the properties below are optional
 *                 .branches(List.of("branches"))
 *                 .customData("customData")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:35.909Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codecommit.CfnRepositoryProps")
@software.amazon.jsii.Jsii.Proxy(CfnRepositoryProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnRepositoryProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the new repository to be created.
     * <p>
     * <blockquote>
     * <p>
     * The repository name must be unique across the calling AWS account . Repository names are limited to 100 alphanumeric, dash, and underscore characters, and cannot include certain characters. For more information about the limits on repository names, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">Quotas</a> in the <em>AWS CodeCommit User Guide</em> . The suffix .git is prohibited.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html#cfn-codecommit-repository-repositoryname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html#cfn-codecommit-repository-repositoryname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRepositoryName();

    /**
     * Information about code to be committed to a repository after it is created in an AWS CloudFormation stack.
     * <p>
     * Information about code is only used in resource creation. Updates to a stack will not reflect changes made to code properties after initial resource creation.
     * <p>
     * <blockquote>
     * <p>
     * You can only use this property to add code when creating a repository with a AWS CloudFormation template at creation time. This property cannot be used for updating code to an existing repository.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html#cfn-codecommit-repository-code">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html#cfn-codecommit-repository-code</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCode() {
        return null;
    }

    /**
     * The ID of the AWS Key Management Service encryption key used to encrypt and decrypt the repository.
     * <p>
     * <blockquote>
     * <p>
     * The input can be the full ARN, the key ID, or the key alias. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/find-cmk-id-arn.html">Finding the key ID and key ARN</a> .
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html#cfn-codecommit-repository-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html#cfn-codecommit-repository-kmskeyid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return null;
    }

    /**
     * A comment or description about the new repository.
     * <p>
     * <blockquote>
     * <p>
     * The description field for a repository accepts all HTML characters and all valid Unicode characters. Applications that do not HTML-encode the description and display it in a webpage can expose users to potentially malicious code. Make sure that you HTML-encode the description field in any application that uses this API to display the repository description on a webpage.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html#cfn-codecommit-repository-repositorydescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html#cfn-codecommit-repository-repositorydescription</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRepositoryDescription() {
        return null;
    }

    /**
     * One or more tag key-value pairs to use when tagging this repository.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html#cfn-codecommit-repository-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html#cfn-codecommit-repository-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The JSON block of configuration information for each trigger.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html#cfn-codecommit-repository-triggers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html#cfn-codecommit-repository-triggers</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTriggers() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnRepositoryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnRepositoryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnRepositoryProps> {
        java.lang.String repositoryName;
        java.lang.Object code;
        java.lang.String kmsKeyId;
        java.lang.String repositoryDescription;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Object triggers;

        /**
         * Sets the value of {@link CfnRepositoryProps#getRepositoryName}
         * @param repositoryName The name of the new repository to be created. This parameter is required.
         *                       <blockquote>
         *                       <p>
         *                       The repository name must be unique across the calling AWS account . Repository names are limited to 100 alphanumeric, dash, and underscore characters, and cannot include certain characters. For more information about the limits on repository names, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">Quotas</a> in the <em>AWS CodeCommit User Guide</em> . The suffix .git is prohibited.
         *                       <p>
         *                       </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repositoryName(java.lang.String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        /**
         * Sets the value of {@link CfnRepositoryProps#getCode}
         * @param code Information about code to be committed to a repository after it is created in an AWS CloudFormation stack.
         *             Information about code is only used in resource creation. Updates to a stack will not reflect changes made to code properties after initial resource creation.
         *             <p>
         *             <blockquote>
         *             <p>
         *             You can only use this property to add code when creating a repository with a AWS CloudFormation template at creation time. This property cannot be used for updating code to an existing repository.
         *             <p>
         *             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder code(software.amazon.awscdk.IResolvable code) {
            this.code = code;
            return this;
        }

        /**
         * Sets the value of {@link CfnRepositoryProps#getCode}
         * @param code Information about code to be committed to a repository after it is created in an AWS CloudFormation stack.
         *             Information about code is only used in resource creation. Updates to a stack will not reflect changes made to code properties after initial resource creation.
         *             <p>
         *             <blockquote>
         *             <p>
         *             You can only use this property to add code when creating a repository with a AWS CloudFormation template at creation time. This property cannot be used for updating code to an existing repository.
         *             <p>
         *             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder code(software.amazon.awscdk.services.codecommit.CfnRepository.CodeProperty code) {
            this.code = code;
            return this;
        }

        /**
         * Sets the value of {@link CfnRepositoryProps#getKmsKeyId}
         * @param kmsKeyId The ID of the AWS Key Management Service encryption key used to encrypt and decrypt the repository.
         *                 <blockquote>
         *                 <p>
         *                 The input can be the full ARN, the key ID, or the key alias. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/find-cmk-id-arn.html">Finding the key ID and key ARN</a> .
         *                 <p>
         *                 </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(java.lang.String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnRepositoryProps#getRepositoryDescription}
         * @param repositoryDescription A comment or description about the new repository.
         *                              <blockquote>
         *                              <p>
         *                              The description field for a repository accepts all HTML characters and all valid Unicode characters. Applications that do not HTML-encode the description and display it in a webpage can expose users to potentially malicious code. Make sure that you HTML-encode the description field in any application that uses this API to display the repository description on a webpage.
         *                              <p>
         *                              </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repositoryDescription(java.lang.String repositoryDescription) {
            this.repositoryDescription = repositoryDescription;
            return this;
        }

        /**
         * Sets the value of {@link CfnRepositoryProps#getTags}
         * @param tags One or more tag key-value pairs to use when tagging this repository.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnRepositoryProps#getTriggers}
         * @param triggers The JSON block of configuration information for each trigger.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder triggers(software.amazon.awscdk.IResolvable triggers) {
            this.triggers = triggers;
            return this;
        }

        /**
         * Sets the value of {@link CfnRepositoryProps#getTriggers}
         * @param triggers The JSON block of configuration information for each trigger.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder triggers(java.util.List<? extends java.lang.Object> triggers) {
            this.triggers = triggers;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnRepositoryProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnRepositoryProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnRepositoryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnRepositoryProps {
        private final java.lang.String repositoryName;
        private final java.lang.Object code;
        private final java.lang.String kmsKeyId;
        private final java.lang.String repositoryDescription;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Object triggers;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.repositoryName = software.amazon.jsii.Kernel.get(this, "repositoryName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.code = software.amazon.jsii.Kernel.get(this, "code", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.repositoryDescription = software.amazon.jsii.Kernel.get(this, "repositoryDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.triggers = software.amazon.jsii.Kernel.get(this, "triggers", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.repositoryName = java.util.Objects.requireNonNull(builder.repositoryName, "repositoryName is required");
            this.code = builder.code;
            this.kmsKeyId = builder.kmsKeyId;
            this.repositoryDescription = builder.repositoryDescription;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.triggers = builder.triggers;
        }

        @Override
        public final java.lang.String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final java.lang.Object getCode() {
            return this.code;
        }

        @Override
        public final java.lang.String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final java.lang.String getRepositoryDescription() {
            return this.repositoryDescription;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getTriggers() {
            return this.triggers;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("repositoryName", om.valueToTree(this.getRepositoryName()));
            if (this.getCode() != null) {
                data.set("code", om.valueToTree(this.getCode()));
            }
            if (this.getKmsKeyId() != null) {
                data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
            }
            if (this.getRepositoryDescription() != null) {
                data.set("repositoryDescription", om.valueToTree(this.getRepositoryDescription()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTriggers() != null) {
                data.set("triggers", om.valueToTree(this.getTriggers()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codecommit.CfnRepositoryProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnRepositoryProps.Jsii$Proxy that = (CfnRepositoryProps.Jsii$Proxy) o;

            if (!repositoryName.equals(that.repositoryName)) return false;
            if (this.code != null ? !this.code.equals(that.code) : that.code != null) return false;
            if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
            if (this.repositoryDescription != null ? !this.repositoryDescription.equals(that.repositoryDescription) : that.repositoryDescription != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.triggers != null ? this.triggers.equals(that.triggers) : that.triggers == null;
        }

        @Override
        public final int hashCode() {
            int result = this.repositoryName.hashCode();
            result = 31 * result + (this.code != null ? this.code.hashCode() : 0);
            result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
            result = 31 * result + (this.repositoryDescription != null ? this.repositoryDescription.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.triggers != null ? this.triggers.hashCode() : 0);
            return result;
        }
    }
}
