package software.amazon.awscdk.services.codepipeline;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.codepipeline.*;
 * import software.amazon.awscdk.services.iam.*;
 * Artifact artifact;
 * Resource resource;
 * Role role;
 * ActionProperties actionProperties = ActionProperties.builder()
 *         .actionName("actionName")
 *         .artifactBounds(ActionArtifactBounds.builder()
 *                 .maxInputs(123)
 *                 .maxOutputs(123)
 *                 .minInputs(123)
 *                 .minOutputs(123)
 *                 .build())
 *         .category(ActionCategory.SOURCE)
 *         .provider("provider")
 *         // the properties below are optional
 *         .account("account")
 *         .commands(List.of("commands"))
 *         .inputs(List.of(artifact))
 *         .outputs(List.of(artifact))
 *         .outputVariables(List.of("outputVariables"))
 *         .owner("owner")
 *         .region("region")
 *         .resource(resource)
 *         .role(role)
 *         .runOrder(123)
 *         .timeout(Duration.minutes(30))
 *         .variablesNamespace("variablesNamespace")
 *         .version("version")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:36.034Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.ActionProperties")
@software.amazon.jsii.Jsii.Proxy(ActionProperties.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ActionProperties extends software.amazon.jsii.JsiiSerializable {

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getActionName();

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.ActionArtifactBounds getArtifactBounds();

    /**
     * The category of the action.
     * <p>
     * The category defines which action type the owner
     * (the entity that performs the action) performs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.ActionCategory getCategory();

    /**
     * The service provider that the action calls.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getProvider();

    /**
     * The account the Action is supposed to live in.
     * <p>
     * For Actions backed by resources,
     * this is inferred from the Stack <code>resource</code> is part of.
     * However, some Actions, like the CloudFormation ones,
     * are not backed by any resource, and they still might want to be cross-account.
     * In general, a concrete Action class should specify either <code>resource</code>,
     * or <code>account</code> - but not both.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAccount() {
        return null;
    }

    /**
     * Shell commands for the Commands action to run.
     * <p>
     * Default: - no commands
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCommands() {
        return null;
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.codepipeline.Artifact> getInputs() {
        return null;
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.codepipeline.Artifact> getOutputs() {
        return null;
    }

    /**
     * The names of the variables in your environment that you want to export.
     * <p>
     * Default: - no output variables
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getOutputVariables() {
        return null;
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOwner() {
        return null;
    }

    /**
     * The AWS region the given Action resides in.
     * <p>
     * Note that a cross-region Pipeline requires replication buckets to function correctly.
     * You can provide their names with the <code>PipelineProps#crossRegionReplicationBuckets</code> property.
     * If you don't, the CodePipeline Construct will create new Stacks in your CDK app containing those buckets,
     * that you will need to <code>cdk deploy</code> before deploying the main, Pipeline-containing Stack.
     * <p>
     * Default: the Action resides in the same region as the Pipeline
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
        return null;
    }

    /**
     * The optional resource that is backing this Action.
     * <p>
     * This is used for automatically handling Actions backed by
     * resources from a different account and/or region.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResource getResource() {
        return null;
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * The order in which AWS CodePipeline runs this action. For more information, see the AWS CodePipeline User Guide.
     * <p>
     * https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getRunOrder() {
        return null;
    }

    /**
     * A timeout duration that can be applied against the ActionType’s default timeout value specified in Quotas for AWS CodePipeline.
     * <p>
     * This attribute is available only to the <code>ManualApprovalAction</code>.
     * <p>
     * It is configurable up to 86400 minutes (60 days) with a minimum value of 5 minutes.
     * <p>
     * Default: - default timeout value defined by each ActionType
     * <p>
     * @see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/limits.html">https://docs.aws.amazon.com/codepipeline/latest/userguide/limits.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getTimeout() {
        return null;
    }

    /**
     * The name of the namespace to use for variables emitted by this action.
     * <p>
     * Default: - a name will be generated, based on the stage and action names
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVariablesNamespace() {
        return null;
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVersion() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ActionProperties}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ActionProperties}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ActionProperties> {
        java.lang.String actionName;
        software.amazon.awscdk.services.codepipeline.ActionArtifactBounds artifactBounds;
        software.amazon.awscdk.services.codepipeline.ActionCategory category;
        java.lang.String provider;
        java.lang.String account;
        java.util.List<java.lang.String> commands;
        java.util.List<software.amazon.awscdk.services.codepipeline.Artifact> inputs;
        java.util.List<software.amazon.awscdk.services.codepipeline.Artifact> outputs;
        java.util.List<java.lang.String> outputVariables;
        java.lang.String owner;
        java.lang.String region;
        software.amazon.awscdk.IResource resource;
        software.amazon.awscdk.services.iam.IRole role;
        java.lang.Number runOrder;
        software.amazon.awscdk.Duration timeout;
        java.lang.String variablesNamespace;
        java.lang.String version;

        /**
         * Sets the value of {@link ActionProperties#getActionName}
         * @param actionName the value to be set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionName(java.lang.String actionName) {
            this.actionName = actionName;
            return this;
        }

        /**
         * Sets the value of {@link ActionProperties#getArtifactBounds}
         * @param artifactBounds the value to be set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder artifactBounds(software.amazon.awscdk.services.codepipeline.ActionArtifactBounds artifactBounds) {
            this.artifactBounds = artifactBounds;
            return this;
        }

        /**
         * Sets the value of {@link ActionProperties#getCategory}
         * @param category The category of the action. This parameter is required.
         *                 The category defines which action type the owner
         *                 (the entity that performs the action) performs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder category(software.amazon.awscdk.services.codepipeline.ActionCategory category) {
            this.category = category;
            return this;
        }

        /**
         * Sets the value of {@link ActionProperties#getProvider}
         * @param provider The service provider that the action calls. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provider(java.lang.String provider) {
            this.provider = provider;
            return this;
        }

        /**
         * Sets the value of {@link ActionProperties#getAccount}
         * @param account The account the Action is supposed to live in.
         *                For Actions backed by resources,
         *                this is inferred from the Stack <code>resource</code> is part of.
         *                However, some Actions, like the CloudFormation ones,
         *                are not backed by any resource, and they still might want to be cross-account.
         *                In general, a concrete Action class should specify either <code>resource</code>,
         *                or <code>account</code> - but not both.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder account(java.lang.String account) {
            this.account = account;
            return this;
        }

        /**
         * Sets the value of {@link ActionProperties#getCommands}
         * @param commands Shell commands for the Commands action to run.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder commands(java.util.List<java.lang.String> commands) {
            this.commands = commands;
            return this;
        }

        /**
         * Sets the value of {@link ActionProperties#getInputs}
         * @param inputs the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder inputs(java.util.List<? extends software.amazon.awscdk.services.codepipeline.Artifact> inputs) {
            this.inputs = (java.util.List<software.amazon.awscdk.services.codepipeline.Artifact>)inputs;
            return this;
        }

        /**
         * Sets the value of {@link ActionProperties#getOutputs}
         * @param outputs the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder outputs(java.util.List<? extends software.amazon.awscdk.services.codepipeline.Artifact> outputs) {
            this.outputs = (java.util.List<software.amazon.awscdk.services.codepipeline.Artifact>)outputs;
            return this;
        }

        /**
         * Sets the value of {@link ActionProperties#getOutputVariables}
         * @param outputVariables The names of the variables in your environment that you want to export.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputVariables(java.util.List<java.lang.String> outputVariables) {
            this.outputVariables = outputVariables;
            return this;
        }

        /**
         * Sets the value of {@link ActionProperties#getOwner}
         * @param owner the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder owner(java.lang.String owner) {
            this.owner = owner;
            return this;
        }

        /**
         * Sets the value of {@link ActionProperties#getRegion}
         * @param region The AWS region the given Action resides in.
         *               Note that a cross-region Pipeline requires replication buckets to function correctly.
         *               You can provide their names with the <code>PipelineProps#crossRegionReplicationBuckets</code> property.
         *               If you don't, the CodePipeline Construct will create new Stacks in your CDK app containing those buckets,
         *               that you will need to <code>cdk deploy</code> before deploying the main, Pipeline-containing Stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Sets the value of {@link ActionProperties#getResource}
         * @param resource The optional resource that is backing this Action.
         *                 This is used for automatically handling Actions backed by
         *                 resources from a different account and/or region.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resource(software.amazon.awscdk.IResource resource) {
            this.resource = resource;
            return this;
        }

        /**
         * Sets the value of {@link ActionProperties#getRole}
         * @param role the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link ActionProperties#getRunOrder}
         * @param runOrder The order in which AWS CodePipeline runs this action. For more information, see the AWS CodePipeline User Guide.
         *                 https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runOrder(java.lang.Number runOrder) {
            this.runOrder = runOrder;
            return this;
        }

        /**
         * Sets the value of {@link ActionProperties#getTimeout}
         * @param timeout A timeout duration that can be applied against the ActionType’s default timeout value specified in Quotas for AWS CodePipeline.
         *                This attribute is available only to the <code>ManualApprovalAction</code>.
         *                <p>
         *                It is configurable up to 86400 minutes (60 days) with a minimum value of 5 minutes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(software.amazon.awscdk.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Sets the value of {@link ActionProperties#getVariablesNamespace}
         * @param variablesNamespace The name of the namespace to use for variables emitted by this action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variablesNamespace(java.lang.String variablesNamespace) {
            this.variablesNamespace = variablesNamespace;
            return this;
        }

        /**
         * Sets the value of {@link ActionProperties#getVersion}
         * @param version the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder version(java.lang.String version) {
            this.version = version;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ActionProperties}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ActionProperties build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ActionProperties}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ActionProperties {
        private final java.lang.String actionName;
        private final software.amazon.awscdk.services.codepipeline.ActionArtifactBounds artifactBounds;
        private final software.amazon.awscdk.services.codepipeline.ActionCategory category;
        private final java.lang.String provider;
        private final java.lang.String account;
        private final java.util.List<java.lang.String> commands;
        private final java.util.List<software.amazon.awscdk.services.codepipeline.Artifact> inputs;
        private final java.util.List<software.amazon.awscdk.services.codepipeline.Artifact> outputs;
        private final java.util.List<java.lang.String> outputVariables;
        private final java.lang.String owner;
        private final java.lang.String region;
        private final software.amazon.awscdk.IResource resource;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final java.lang.Number runOrder;
        private final software.amazon.awscdk.Duration timeout;
        private final java.lang.String variablesNamespace;
        private final java.lang.String version;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.actionName = software.amazon.jsii.Kernel.get(this, "actionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.artifactBounds = software.amazon.jsii.Kernel.get(this, "artifactBounds", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.ActionArtifactBounds.class));
            this.category = software.amazon.jsii.Kernel.get(this, "category", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.ActionCategory.class));
            this.provider = software.amazon.jsii.Kernel.get(this, "provider", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.account = software.amazon.jsii.Kernel.get(this, "account", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.commands = software.amazon.jsii.Kernel.get(this, "commands", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.inputs = software.amazon.jsii.Kernel.get(this, "inputs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.Artifact.class)));
            this.outputs = software.amazon.jsii.Kernel.get(this, "outputs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.Artifact.class)));
            this.outputVariables = software.amazon.jsii.Kernel.get(this, "outputVariables", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.owner = software.amazon.jsii.Kernel.get(this, "owner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resource = software.amazon.jsii.Kernel.get(this, "resource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResource.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.runOrder = software.amazon.jsii.Kernel.get(this, "runOrder", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.variablesNamespace = software.amazon.jsii.Kernel.get(this, "variablesNamespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.actionName = java.util.Objects.requireNonNull(builder.actionName, "actionName is required");
            this.artifactBounds = java.util.Objects.requireNonNull(builder.artifactBounds, "artifactBounds is required");
            this.category = java.util.Objects.requireNonNull(builder.category, "category is required");
            this.provider = java.util.Objects.requireNonNull(builder.provider, "provider is required");
            this.account = builder.account;
            this.commands = builder.commands;
            this.inputs = (java.util.List<software.amazon.awscdk.services.codepipeline.Artifact>)builder.inputs;
            this.outputs = (java.util.List<software.amazon.awscdk.services.codepipeline.Artifact>)builder.outputs;
            this.outputVariables = builder.outputVariables;
            this.owner = builder.owner;
            this.region = builder.region;
            this.resource = builder.resource;
            this.role = builder.role;
            this.runOrder = builder.runOrder;
            this.timeout = builder.timeout;
            this.variablesNamespace = builder.variablesNamespace;
            this.version = builder.version;
        }

        @Override
        public final java.lang.String getActionName() {
            return this.actionName;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.ActionArtifactBounds getArtifactBounds() {
            return this.artifactBounds;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.ActionCategory getCategory() {
            return this.category;
        }

        @Override
        public final java.lang.String getProvider() {
            return this.provider;
        }

        @Override
        public final java.lang.String getAccount() {
            return this.account;
        }

        @Override
        public final java.util.List<java.lang.String> getCommands() {
            return this.commands;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.codepipeline.Artifact> getInputs() {
            return this.inputs;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.codepipeline.Artifact> getOutputs() {
            return this.outputs;
        }

        @Override
        public final java.util.List<java.lang.String> getOutputVariables() {
            return this.outputVariables;
        }

        @Override
        public final java.lang.String getOwner() {
            return this.owner;
        }

        @Override
        public final java.lang.String getRegion() {
            return this.region;
        }

        @Override
        public final software.amazon.awscdk.IResource getResource() {
            return this.resource;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final java.lang.Number getRunOrder() {
            return this.runOrder;
        }

        @Override
        public final software.amazon.awscdk.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        public final java.lang.String getVariablesNamespace() {
            return this.variablesNamespace;
        }

        @Override
        public final java.lang.String getVersion() {
            return this.version;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("actionName", om.valueToTree(this.getActionName()));
            data.set("artifactBounds", om.valueToTree(this.getArtifactBounds()));
            data.set("category", om.valueToTree(this.getCategory()));
            data.set("provider", om.valueToTree(this.getProvider()));
            if (this.getAccount() != null) {
                data.set("account", om.valueToTree(this.getAccount()));
            }
            if (this.getCommands() != null) {
                data.set("commands", om.valueToTree(this.getCommands()));
            }
            if (this.getInputs() != null) {
                data.set("inputs", om.valueToTree(this.getInputs()));
            }
            if (this.getOutputs() != null) {
                data.set("outputs", om.valueToTree(this.getOutputs()));
            }
            if (this.getOutputVariables() != null) {
                data.set("outputVariables", om.valueToTree(this.getOutputVariables()));
            }
            if (this.getOwner() != null) {
                data.set("owner", om.valueToTree(this.getOwner()));
            }
            if (this.getRegion() != null) {
                data.set("region", om.valueToTree(this.getRegion()));
            }
            if (this.getResource() != null) {
                data.set("resource", om.valueToTree(this.getResource()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getRunOrder() != null) {
                data.set("runOrder", om.valueToTree(this.getRunOrder()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }
            if (this.getVariablesNamespace() != null) {
                data.set("variablesNamespace", om.valueToTree(this.getVariablesNamespace()));
            }
            if (this.getVersion() != null) {
                data.set("version", om.valueToTree(this.getVersion()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.ActionProperties"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ActionProperties.Jsii$Proxy that = (ActionProperties.Jsii$Proxy) o;

            if (!actionName.equals(that.actionName)) return false;
            if (!artifactBounds.equals(that.artifactBounds)) return false;
            if (!category.equals(that.category)) return false;
            if (!provider.equals(that.provider)) return false;
            if (this.account != null ? !this.account.equals(that.account) : that.account != null) return false;
            if (this.commands != null ? !this.commands.equals(that.commands) : that.commands != null) return false;
            if (this.inputs != null ? !this.inputs.equals(that.inputs) : that.inputs != null) return false;
            if (this.outputs != null ? !this.outputs.equals(that.outputs) : that.outputs != null) return false;
            if (this.outputVariables != null ? !this.outputVariables.equals(that.outputVariables) : that.outputVariables != null) return false;
            if (this.owner != null ? !this.owner.equals(that.owner) : that.owner != null) return false;
            if (this.region != null ? !this.region.equals(that.region) : that.region != null) return false;
            if (this.resource != null ? !this.resource.equals(that.resource) : that.resource != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (this.runOrder != null ? !this.runOrder.equals(that.runOrder) : that.runOrder != null) return false;
            if (this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null) return false;
            if (this.variablesNamespace != null ? !this.variablesNamespace.equals(that.variablesNamespace) : that.variablesNamespace != null) return false;
            return this.version != null ? this.version.equals(that.version) : that.version == null;
        }

        @Override
        public final int hashCode() {
            int result = this.actionName.hashCode();
            result = 31 * result + (this.artifactBounds.hashCode());
            result = 31 * result + (this.category.hashCode());
            result = 31 * result + (this.provider.hashCode());
            result = 31 * result + (this.account != null ? this.account.hashCode() : 0);
            result = 31 * result + (this.commands != null ? this.commands.hashCode() : 0);
            result = 31 * result + (this.inputs != null ? this.inputs.hashCode() : 0);
            result = 31 * result + (this.outputs != null ? this.outputs.hashCode() : 0);
            result = 31 * result + (this.outputVariables != null ? this.outputVariables.hashCode() : 0);
            result = 31 * result + (this.owner != null ? this.owner.hashCode() : 0);
            result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
            result = 31 * result + (this.resource != null ? this.resource.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.runOrder != null ? this.runOrder.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            result = 31 * result + (this.variablesNamespace != null ? this.variablesNamespace.hashCode() : 0);
            result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
            return result;
        }
    }
}
