package software.amazon.awscdk.services.codepipeline;

/**
 * Git push filter for trigger.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.codepipeline.*;
 * GitPushFilter gitPushFilter = GitPushFilter.builder()
 *         .branchesExcludes(List.of("branchesExcludes"))
 *         .branchesIncludes(List.of("branchesIncludes"))
 *         .filePathsExcludes(List.of("filePathsExcludes"))
 *         .filePathsIncludes(List.of("filePathsIncludes"))
 *         .tagsExcludes(List.of("tagsExcludes"))
 *         .tagsIncludes(List.of("tagsIncludes"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:36.080Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.GitPushFilter")
@software.amazon.jsii.Jsii.Proxy(GitPushFilter.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface GitPushFilter extends software.amazon.jsii.JsiiSerializable {

    /**
     * The list of patterns of Git branches that, when pull request events occurs, are to be excluded from starting the pipeline.
     * <p>
     * You can filter with glob patterns. The <code>branchesExcludes</code> takes priority
     * over the <code>branchesIncludes</code>.
     * <p>
     * Maximum length of this array is 8.
     * <p>
     * Default: - no branches.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getBranchesExcludes() {
        return null;
    }

    /**
     * The list of patterns of Git branches that, when pull request events occurs, are to be included as criteria that starts the pipeline.
     * <p>
     * You can filter with glob patterns. The <code>branchesExcludes</code> takes priority
     * over the <code>branchesIncludes</code>.
     * <p>
     * Maximum length of this array is 8.
     * <p>
     * Default: - no branches.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getBranchesIncludes() {
        return null;
    }

    /**
     * The list of patterns of Git repository file paths that, when pull request events occurs, are to be excluded from starting the pipeline.
     * <p>
     * You can filter with glob patterns. The <code>filePathsExcludes</code> takes priority
     * over the <code>filePathsIncludes</code>.
     * <p>
     * Maximum length of this array is 8.
     * <p>
     * Default: - no filePaths.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getFilePathsExcludes() {
        return null;
    }

    /**
     * The list of patterns of Git repository file paths that, when pull request events occurs, are to be included as criteria that starts the pipeline.
     * <p>
     * You can filter with glob patterns. The <code>filePathsExcludes</code> takes priority
     * over the <code>filePathsIncludes</code>.
     * <p>
     * Maximum length of this array is 8.
     * <p>
     * Default: - no filePaths.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getFilePathsIncludes() {
        return null;
    }

    /**
     * The list of patterns of Git tags that, when pushed, are to be excluded from starting the pipeline.
     * <p>
     * You can filter with glob patterns. The <code>tagsExcludes</code> takes priority
     * over the <code>tagsIncludes</code>.
     * <p>
     * Maximum length of this array is 8.
     * <p>
     * Default: - no tags.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTagsExcludes() {
        return null;
    }

    /**
     * The list of patterns of Git tags that, when pushed, are to be included as criteria that starts the pipeline.
     * <p>
     * You can filter with glob patterns. The <code>tagsExcludes</code> takes priority
     * over the <code>tagsIncludes</code>.
     * <p>
     * Maximum length of this array is 8.
     * <p>
     * Default: - no tags.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTagsIncludes() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link GitPushFilter}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link GitPushFilter}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<GitPushFilter> {
        java.util.List<java.lang.String> branchesExcludes;
        java.util.List<java.lang.String> branchesIncludes;
        java.util.List<java.lang.String> filePathsExcludes;
        java.util.List<java.lang.String> filePathsIncludes;
        java.util.List<java.lang.String> tagsExcludes;
        java.util.List<java.lang.String> tagsIncludes;

        /**
         * Sets the value of {@link GitPushFilter#getBranchesExcludes}
         * @param branchesExcludes The list of patterns of Git branches that, when pull request events occurs, are to be excluded from starting the pipeline.
         *                         You can filter with glob patterns. The <code>branchesExcludes</code> takes priority
         *                         over the <code>branchesIncludes</code>.
         *                         <p>
         *                         Maximum length of this array is 8.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder branchesExcludes(java.util.List<java.lang.String> branchesExcludes) {
            this.branchesExcludes = branchesExcludes;
            return this;
        }

        /**
         * Sets the value of {@link GitPushFilter#getBranchesIncludes}
         * @param branchesIncludes The list of patterns of Git branches that, when pull request events occurs, are to be included as criteria that starts the pipeline.
         *                         You can filter with glob patterns. The <code>branchesExcludes</code> takes priority
         *                         over the <code>branchesIncludes</code>.
         *                         <p>
         *                         Maximum length of this array is 8.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder branchesIncludes(java.util.List<java.lang.String> branchesIncludes) {
            this.branchesIncludes = branchesIncludes;
            return this;
        }

        /**
         * Sets the value of {@link GitPushFilter#getFilePathsExcludes}
         * @param filePathsExcludes The list of patterns of Git repository file paths that, when pull request events occurs, are to be excluded from starting the pipeline.
         *                          You can filter with glob patterns. The <code>filePathsExcludes</code> takes priority
         *                          over the <code>filePathsIncludes</code>.
         *                          <p>
         *                          Maximum length of this array is 8.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filePathsExcludes(java.util.List<java.lang.String> filePathsExcludes) {
            this.filePathsExcludes = filePathsExcludes;
            return this;
        }

        /**
         * Sets the value of {@link GitPushFilter#getFilePathsIncludes}
         * @param filePathsIncludes The list of patterns of Git repository file paths that, when pull request events occurs, are to be included as criteria that starts the pipeline.
         *                          You can filter with glob patterns. The <code>filePathsExcludes</code> takes priority
         *                          over the <code>filePathsIncludes</code>.
         *                          <p>
         *                          Maximum length of this array is 8.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filePathsIncludes(java.util.List<java.lang.String> filePathsIncludes) {
            this.filePathsIncludes = filePathsIncludes;
            return this;
        }

        /**
         * Sets the value of {@link GitPushFilter#getTagsExcludes}
         * @param tagsExcludes The list of patterns of Git tags that, when pushed, are to be excluded from starting the pipeline.
         *                     You can filter with glob patterns. The <code>tagsExcludes</code> takes priority
         *                     over the <code>tagsIncludes</code>.
         *                     <p>
         *                     Maximum length of this array is 8.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tagsExcludes(java.util.List<java.lang.String> tagsExcludes) {
            this.tagsExcludes = tagsExcludes;
            return this;
        }

        /**
         * Sets the value of {@link GitPushFilter#getTagsIncludes}
         * @param tagsIncludes The list of patterns of Git tags that, when pushed, are to be included as criteria that starts the pipeline.
         *                     You can filter with glob patterns. The <code>tagsExcludes</code> takes priority
         *                     over the <code>tagsIncludes</code>.
         *                     <p>
         *                     Maximum length of this array is 8.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tagsIncludes(java.util.List<java.lang.String> tagsIncludes) {
            this.tagsIncludes = tagsIncludes;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GitPushFilter}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public GitPushFilter build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link GitPushFilter}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GitPushFilter {
        private final java.util.List<java.lang.String> branchesExcludes;
        private final java.util.List<java.lang.String> branchesIncludes;
        private final java.util.List<java.lang.String> filePathsExcludes;
        private final java.util.List<java.lang.String> filePathsIncludes;
        private final java.util.List<java.lang.String> tagsExcludes;
        private final java.util.List<java.lang.String> tagsIncludes;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.branchesExcludes = software.amazon.jsii.Kernel.get(this, "branchesExcludes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.branchesIncludes = software.amazon.jsii.Kernel.get(this, "branchesIncludes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.filePathsExcludes = software.amazon.jsii.Kernel.get(this, "filePathsExcludes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.filePathsIncludes = software.amazon.jsii.Kernel.get(this, "filePathsIncludes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.tagsExcludes = software.amazon.jsii.Kernel.get(this, "tagsExcludes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.tagsIncludes = software.amazon.jsii.Kernel.get(this, "tagsIncludes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.branchesExcludes = builder.branchesExcludes;
            this.branchesIncludes = builder.branchesIncludes;
            this.filePathsExcludes = builder.filePathsExcludes;
            this.filePathsIncludes = builder.filePathsIncludes;
            this.tagsExcludes = builder.tagsExcludes;
            this.tagsIncludes = builder.tagsIncludes;
        }

        @Override
        public final java.util.List<java.lang.String> getBranchesExcludes() {
            return this.branchesExcludes;
        }

        @Override
        public final java.util.List<java.lang.String> getBranchesIncludes() {
            return this.branchesIncludes;
        }

        @Override
        public final java.util.List<java.lang.String> getFilePathsExcludes() {
            return this.filePathsExcludes;
        }

        @Override
        public final java.util.List<java.lang.String> getFilePathsIncludes() {
            return this.filePathsIncludes;
        }

        @Override
        public final java.util.List<java.lang.String> getTagsExcludes() {
            return this.tagsExcludes;
        }

        @Override
        public final java.util.List<java.lang.String> getTagsIncludes() {
            return this.tagsIncludes;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBranchesExcludes() != null) {
                data.set("branchesExcludes", om.valueToTree(this.getBranchesExcludes()));
            }
            if (this.getBranchesIncludes() != null) {
                data.set("branchesIncludes", om.valueToTree(this.getBranchesIncludes()));
            }
            if (this.getFilePathsExcludes() != null) {
                data.set("filePathsExcludes", om.valueToTree(this.getFilePathsExcludes()));
            }
            if (this.getFilePathsIncludes() != null) {
                data.set("filePathsIncludes", om.valueToTree(this.getFilePathsIncludes()));
            }
            if (this.getTagsExcludes() != null) {
                data.set("tagsExcludes", om.valueToTree(this.getTagsExcludes()));
            }
            if (this.getTagsIncludes() != null) {
                data.set("tagsIncludes", om.valueToTree(this.getTagsIncludes()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.GitPushFilter"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GitPushFilter.Jsii$Proxy that = (GitPushFilter.Jsii$Proxy) o;

            if (this.branchesExcludes != null ? !this.branchesExcludes.equals(that.branchesExcludes) : that.branchesExcludes != null) return false;
            if (this.branchesIncludes != null ? !this.branchesIncludes.equals(that.branchesIncludes) : that.branchesIncludes != null) return false;
            if (this.filePathsExcludes != null ? !this.filePathsExcludes.equals(that.filePathsExcludes) : that.filePathsExcludes != null) return false;
            if (this.filePathsIncludes != null ? !this.filePathsIncludes.equals(that.filePathsIncludes) : that.filePathsIncludes != null) return false;
            if (this.tagsExcludes != null ? !this.tagsExcludes.equals(that.tagsExcludes) : that.tagsExcludes != null) return false;
            return this.tagsIncludes != null ? this.tagsIncludes.equals(that.tagsIncludes) : that.tagsIncludes == null;
        }

        @Override
        public final int hashCode() {
            int result = this.branchesExcludes != null ? this.branchesExcludes.hashCode() : 0;
            result = 31 * result + (this.branchesIncludes != null ? this.branchesIncludes.hashCode() : 0);
            result = 31 * result + (this.filePathsExcludes != null ? this.filePathsExcludes.hashCode() : 0);
            result = 31 * result + (this.filePathsIncludes != null ? this.filePathsIncludes.hashCode() : 0);
            result = 31 * result + (this.tagsExcludes != null ? this.tagsExcludes.hashCode() : 0);
            result = 31 * result + (this.tagsIncludes != null ? this.tagsIncludes.hashCode() : 0);
            return result;
        }
    }
}
