package software.amazon.awscdk.services.codepipeline.actions;

/**
 * The CodePipeline variables emitted by the ECR build and publish Action.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.codepipeline.actions.*;
 * EcrBuildAndPublishVariables ecrBuildAndPublishVariables = EcrBuildAndPublishVariables.builder()
 *         .ecrImageDigestId("ecrImageDigestId")
 *         .ecrRepositoryName("ecrRepositoryName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:36.173Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline_actions.EcrBuildAndPublishVariables")
@software.amazon.jsii.Jsii.Proxy(EcrBuildAndPublishVariables.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EcrBuildAndPublishVariables extends software.amazon.jsii.JsiiSerializable {

    /**
     * The sha256 digest of the image manifest.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEcrImageDigestId();

    /**
     * The name of the Amazon ECR repository where the image was pushed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEcrRepositoryName();

    /**
     * @return a {@link Builder} of {@link EcrBuildAndPublishVariables}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EcrBuildAndPublishVariables}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EcrBuildAndPublishVariables> {
        java.lang.String ecrImageDigestId;
        java.lang.String ecrRepositoryName;

        /**
         * Sets the value of {@link EcrBuildAndPublishVariables#getEcrImageDigestId}
         * @param ecrImageDigestId The sha256 digest of the image manifest. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ecrImageDigestId(java.lang.String ecrImageDigestId) {
            this.ecrImageDigestId = ecrImageDigestId;
            return this;
        }

        /**
         * Sets the value of {@link EcrBuildAndPublishVariables#getEcrRepositoryName}
         * @param ecrRepositoryName The name of the Amazon ECR repository where the image was pushed. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ecrRepositoryName(java.lang.String ecrRepositoryName) {
            this.ecrRepositoryName = ecrRepositoryName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EcrBuildAndPublishVariables}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EcrBuildAndPublishVariables build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EcrBuildAndPublishVariables}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EcrBuildAndPublishVariables {
        private final java.lang.String ecrImageDigestId;
        private final java.lang.String ecrRepositoryName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.ecrImageDigestId = software.amazon.jsii.Kernel.get(this, "ecrImageDigestId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ecrRepositoryName = software.amazon.jsii.Kernel.get(this, "ecrRepositoryName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.ecrImageDigestId = java.util.Objects.requireNonNull(builder.ecrImageDigestId, "ecrImageDigestId is required");
            this.ecrRepositoryName = java.util.Objects.requireNonNull(builder.ecrRepositoryName, "ecrRepositoryName is required");
        }

        @Override
        public final java.lang.String getEcrImageDigestId() {
            return this.ecrImageDigestId;
        }

        @Override
        public final java.lang.String getEcrRepositoryName() {
            return this.ecrRepositoryName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("ecrImageDigestId", om.valueToTree(this.getEcrImageDigestId()));
            data.set("ecrRepositoryName", om.valueToTree(this.getEcrRepositoryName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline_actions.EcrBuildAndPublishVariables"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EcrBuildAndPublishVariables.Jsii$Proxy that = (EcrBuildAndPublishVariables.Jsii$Proxy) o;

            if (!ecrImageDigestId.equals(that.ecrImageDigestId)) return false;
            return this.ecrRepositoryName.equals(that.ecrRepositoryName);
        }

        @Override
        public final int hashCode() {
            int result = this.ecrImageDigestId.hashCode();
            result = 31 * result + (this.ecrRepositoryName.hashCode());
            return result;
        }
    }
}
