package software.amazon.awscdk.services.codepipeline.actions;

/**
 * The type of the Jenkins Action that determines its CodePipeline Category - Build, or Test.
 * <p>
 * Note that a Jenkins provider, even if it has the same name,
 * must be separately registered for each type.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * JenkinsProvider jenkinsProvider;
 * JenkinsAction buildAction = JenkinsAction.Builder.create()
 *         .actionName("JenkinsBuild")
 *         .jenkinsProvider(jenkinsProvider)
 *         .projectName("MyProject")
 *         .type(JenkinsActionType.BUILD)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:36.200Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline_actions.JenkinsActionType")
public enum JenkinsActionType {
    /**
     * The Action will have the Build Category.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BUILD,
    /**
     * The Action will have the Test Category.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TEST,
}
