package software.amazon.awscdk.services.codestarnotifications;

/**
 * A new notification rule.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.codestarnotifications.*;
 * import software.amazon.awscdk.services.codebuild.*;
 * import software.amazon.awscdk.services.sns.*;
 * import software.amazon.awscdk.services.chatbot.*;
 * PipelineProject project = new PipelineProject(this, "MyProject");
 * Topic topic = new Topic(this, "MyTopic1");
 * SlackChannelConfiguration slack = SlackChannelConfiguration.Builder.create(this, "MySlackChannel")
 *         .slackChannelConfigurationName("YOUR_CHANNEL_NAME")
 *         .slackWorkspaceId("YOUR_SLACK_WORKSPACE_ID")
 *         .slackChannelId("YOUR_SLACK_CHANNEL_ID")
 *         .build();
 * NotificationRule rule = NotificationRule.Builder.create(this, "NotificationRule")
 *         .source(project)
 *         .events(List.of("codebuild-project-build-state-succeeded", "codebuild-project-build-state-failed"))
 *         .targets(List.of(topic))
 *         .notificationRuleName("MyNotificationRuleName")
 *         .enabled(true) // The default is true
 *         .detailType(DetailType.FULL) // The default is FULL
 *         .createdBy("Jone Doe")
 *         .build();
 * rule.addTarget(slack);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:36.247Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codestarnotifications.NotificationRule")
public class NotificationRule extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.codestarnotifications.INotificationRule {

    protected NotificationRule(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected NotificationRule(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public NotificationRule(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.NotificationRuleProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import an existing notification rule provided an ARN.
     * <p>
     * @param scope The parent creating construct. This parameter is required.
     * @param id The construct's name. This parameter is required.
     * @param notificationRuleArn Notification rule ARN (i.e. arn:aws:codestar-notifications:::notificationrule/01234abcde). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule fromNotificationRuleArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String notificationRuleArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codestarnotifications.NotificationRule.class, "fromNotificationRuleArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRule.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(notificationRuleArn, "notificationRuleArn is required") });
    }

    /**
     * Adds target to notification rule.
     * <p>
     * @param target The SNS topic or AWS Chatbot Slack target. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.Boolean addTarget(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target) {
        return software.amazon.jsii.Kernel.call(this, "addTarget", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { java.util.Objects.requireNonNull(target, "target is required") });
    }

    /**
     * The ARN of the notification rule (i.e. arn:aws:codestar-notifications:::notificationrule/01234abcde).
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getNotificationRuleArn() {
        return software.amazon.jsii.Kernel.get(this, "notificationRuleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.codestarnotifications.NotificationRule}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codestarnotifications.NotificationRule> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.codestarnotifications.NotificationRuleProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.codestarnotifications.NotificationRuleProps.Builder();
        }

        /**
         * The name or email alias of the person who created the notification rule.
         * <p>
         * If not specified, it means that the creator's alias is not provided.
         * <p>
         * Default: - No alias provided
         * <p>
         * @return {@code this}
         * @param createdBy The name or email alias of the person who created the notification rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder createdBy(final java.lang.String createdBy) {
            this.props.createdBy(createdBy);
            return this;
        }

        /**
         * The level of detail to include in the notifications for this resource.
         * <p>
         * BASIC will include only the contents of the event as it would appear in AWS CloudWatch.
         * FULL will include any supplemental information provided by AWS CodeStar Notifications and/or the service for the resource for which the notification is created.
         * <p>
         * Default: DetailType.FULL
         * <p>
         * @return {@code this}
         * @param detailType The level of detail to include in the notifications for this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder detailType(final software.amazon.awscdk.services.codestarnotifications.DetailType detailType) {
            this.props.detailType(detailType);
            return this;
        }

        /**
         * The status of the notification rule.
         * <p>
         * If the enabled is set to DISABLED, notifications aren't sent for the notification rule.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param enabled The status of the notification rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(final java.lang.Boolean enabled) {
            this.props.enabled(enabled);
            return this;
        }

        /**
         * The name for the notification rule.
         * <p>
         * Notification rule names must be unique in your AWS account.
         * <p>
         * Default: - generated from the `id`
         * <p>
         * @return {@code this}
         * @param notificationRuleName The name for the notification rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationRuleName(final java.lang.String notificationRuleName) {
            this.props.notificationRuleName(notificationRuleName);
            return this;
        }

        /**
         * A list of event types associated with this notification rule.
         * <p>
         * For a complete list of event types and IDs, see Notification concepts in the Developer Tools Console User Guide.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#concepts-api">https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#concepts-api</a>
         * @param events A list of event types associated with this notification rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder events(final java.util.List<java.lang.String> events) {
            this.props.events(events);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the resource to associate with the notification rule.
         * <p>
         * Currently, Supported sources include pipelines in AWS CodePipeline, build projects in AWS CodeBuild, and repositories in AWS CodeCommit in this L2 constructor.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestarnotifications-notificationrule.html#cfn-codestarnotifications-notificationrule-resource">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codestarnotifications-notificationrule.html#cfn-codestarnotifications-notificationrule-resource</a>
         * @param source The Amazon Resource Name (ARN) of the resource to associate with the notification rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder source(final software.amazon.awscdk.services.codestarnotifications.INotificationRuleSource source) {
            this.props.source(source);
            return this;
        }

        /**
         * The targets to register for the notification destination.
         * <p>
         * Default: - No targets are added to the rule. Use `addTarget()` to add a target.
         * <p>
         * @return {@code this}
         * @param targets The targets to register for the notification destination. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targets(final java.util.List<? extends software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget> targets) {
            this.props.targets(targets);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.codestarnotifications.NotificationRule}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.codestarnotifications.NotificationRule build() {
            return new software.amazon.awscdk.services.codestarnotifications.NotificationRule(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
