package software.amazon.awscdk.services.cognito;

/**
 * Properties for defining a <code>CfnUserPoolRiskConfigurationAttachment</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cognito.*;
 * CfnUserPoolRiskConfigurationAttachmentProps cfnUserPoolRiskConfigurationAttachmentProps = CfnUserPoolRiskConfigurationAttachmentProps.builder()
 *         .clientId("clientId")
 *         .userPoolId("userPoolId")
 *         // the properties below are optional
 *         .accountTakeoverRiskConfiguration(AccountTakeoverRiskConfigurationTypeProperty.builder()
 *                 .actions(AccountTakeoverActionsTypeProperty.builder()
 *                         .highAction(AccountTakeoverActionTypeProperty.builder()
 *                                 .eventAction("eventAction")
 *                                 .notify(false)
 *                                 .build())
 *                         .lowAction(AccountTakeoverActionTypeProperty.builder()
 *                                 .eventAction("eventAction")
 *                                 .notify(false)
 *                                 .build())
 *                         .mediumAction(AccountTakeoverActionTypeProperty.builder()
 *                                 .eventAction("eventAction")
 *                                 .notify(false)
 *                                 .build())
 *                         .build())
 *                 // the properties below are optional
 *                 .notifyConfiguration(NotifyConfigurationTypeProperty.builder()
 *                         .sourceArn("sourceArn")
 *                         // the properties below are optional
 *                         .blockEmail(NotifyEmailTypeProperty.builder()
 *                                 .subject("subject")
 *                                 // the properties below are optional
 *                                 .htmlBody("htmlBody")
 *                                 .textBody("textBody")
 *                                 .build())
 *                         .from("from")
 *                         .mfaEmail(NotifyEmailTypeProperty.builder()
 *                                 .subject("subject")
 *                                 // the properties below are optional
 *                                 .htmlBody("htmlBody")
 *                                 .textBody("textBody")
 *                                 .build())
 *                         .noActionEmail(NotifyEmailTypeProperty.builder()
 *                                 .subject("subject")
 *                                 // the properties below are optional
 *                                 .htmlBody("htmlBody")
 *                                 .textBody("textBody")
 *                                 .build())
 *                         .replyTo("replyTo")
 *                         .build())
 *                 .build())
 *         .compromisedCredentialsRiskConfiguration(CompromisedCredentialsRiskConfigurationTypeProperty.builder()
 *                 .actions(CompromisedCredentialsActionsTypeProperty.builder()
 *                         .eventAction("eventAction")
 *                         .build())
 *                 // the properties below are optional
 *                 .eventFilter(List.of("eventFilter"))
 *                 .build())
 *         .riskExceptionConfiguration(RiskExceptionConfigurationTypeProperty.builder()
 *                 .blockedIpRangeList(List.of("blockedIpRangeList"))
 *                 .skippedIpRangeList(List.of("skippedIpRangeList"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:36.359Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.CfnUserPoolRiskConfigurationAttachmentProps")
@software.amazon.jsii.Jsii.Proxy(CfnUserPoolRiskConfigurationAttachmentProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnUserPoolRiskConfigurationAttachmentProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The app client where this configuration is applied.
     * <p>
     * When this parameter isn't present, the risk configuration applies to all user pool app clients that don't have client-level settings.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-clientid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-clientid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getClientId();

    /**
     * The ID of the user pool that has the risk configuration applied.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-userpoolid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-userpoolid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getUserPoolId();

    /**
     * The settings for automated responses and notification templates for adaptive authentication with threat protection.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-accounttakeoverriskconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-accounttakeoverriskconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAccountTakeoverRiskConfiguration() {
        return null;
    }

    /**
     * Settings for compromised-credentials actions and authentication types with threat protection in full-function <code>ENFORCED</code> mode.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-compromisedcredentialsriskconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-compromisedcredentialsriskconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCompromisedCredentialsRiskConfiguration() {
        return null;
    }

    /**
     * Exceptions to the risk evaluation configuration, including always-allow and always-block IP address ranges.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-riskexceptionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html#cfn-cognito-userpoolriskconfigurationattachment-riskexceptionconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRiskExceptionConfiguration() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnUserPoolRiskConfigurationAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnUserPoolRiskConfigurationAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnUserPoolRiskConfigurationAttachmentProps> {
        java.lang.String clientId;
        java.lang.String userPoolId;
        java.lang.Object accountTakeoverRiskConfiguration;
        java.lang.Object compromisedCredentialsRiskConfiguration;
        java.lang.Object riskExceptionConfiguration;

        /**
         * Sets the value of {@link CfnUserPoolRiskConfigurationAttachmentProps#getClientId}
         * @param clientId The app client where this configuration is applied. This parameter is required.
         *                 When this parameter isn't present, the risk configuration applies to all user pool app clients that don't have client-level settings.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientId(java.lang.String clientId) {
            this.clientId = clientId;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolRiskConfigurationAttachmentProps#getUserPoolId}
         * @param userPoolId The ID of the user pool that has the risk configuration applied. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPoolId(java.lang.String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolRiskConfigurationAttachmentProps#getAccountTakeoverRiskConfiguration}
         * @param accountTakeoverRiskConfiguration The settings for automated responses and notification templates for adaptive authentication with threat protection.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accountTakeoverRiskConfiguration(software.amazon.awscdk.IResolvable accountTakeoverRiskConfiguration) {
            this.accountTakeoverRiskConfiguration = accountTakeoverRiskConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolRiskConfigurationAttachmentProps#getAccountTakeoverRiskConfiguration}
         * @param accountTakeoverRiskConfiguration The settings for automated responses and notification templates for adaptive authentication with threat protection.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accountTakeoverRiskConfiguration(software.amazon.awscdk.services.cognito.CfnUserPoolRiskConfigurationAttachment.AccountTakeoverRiskConfigurationTypeProperty accountTakeoverRiskConfiguration) {
            this.accountTakeoverRiskConfiguration = accountTakeoverRiskConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolRiskConfigurationAttachmentProps#getCompromisedCredentialsRiskConfiguration}
         * @param compromisedCredentialsRiskConfiguration Settings for compromised-credentials actions and authentication types with threat protection in full-function <code>ENFORCED</code> mode.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compromisedCredentialsRiskConfiguration(software.amazon.awscdk.IResolvable compromisedCredentialsRiskConfiguration) {
            this.compromisedCredentialsRiskConfiguration = compromisedCredentialsRiskConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolRiskConfigurationAttachmentProps#getCompromisedCredentialsRiskConfiguration}
         * @param compromisedCredentialsRiskConfiguration Settings for compromised-credentials actions and authentication types with threat protection in full-function <code>ENFORCED</code> mode.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compromisedCredentialsRiskConfiguration(software.amazon.awscdk.services.cognito.CfnUserPoolRiskConfigurationAttachment.CompromisedCredentialsRiskConfigurationTypeProperty compromisedCredentialsRiskConfiguration) {
            this.compromisedCredentialsRiskConfiguration = compromisedCredentialsRiskConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolRiskConfigurationAttachmentProps#getRiskExceptionConfiguration}
         * @param riskExceptionConfiguration Exceptions to the risk evaluation configuration, including always-allow and always-block IP address ranges.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder riskExceptionConfiguration(software.amazon.awscdk.IResolvable riskExceptionConfiguration) {
            this.riskExceptionConfiguration = riskExceptionConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolRiskConfigurationAttachmentProps#getRiskExceptionConfiguration}
         * @param riskExceptionConfiguration Exceptions to the risk evaluation configuration, including always-allow and always-block IP address ranges.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder riskExceptionConfiguration(software.amazon.awscdk.services.cognito.CfnUserPoolRiskConfigurationAttachment.RiskExceptionConfigurationTypeProperty riskExceptionConfiguration) {
            this.riskExceptionConfiguration = riskExceptionConfiguration;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnUserPoolRiskConfigurationAttachmentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnUserPoolRiskConfigurationAttachmentProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnUserPoolRiskConfigurationAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnUserPoolRiskConfigurationAttachmentProps {
        private final java.lang.String clientId;
        private final java.lang.String userPoolId;
        private final java.lang.Object accountTakeoverRiskConfiguration;
        private final java.lang.Object compromisedCredentialsRiskConfiguration;
        private final java.lang.Object riskExceptionConfiguration;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.clientId = software.amazon.jsii.Kernel.get(this, "clientId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.userPoolId = software.amazon.jsii.Kernel.get(this, "userPoolId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.accountTakeoverRiskConfiguration = software.amazon.jsii.Kernel.get(this, "accountTakeoverRiskConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.compromisedCredentialsRiskConfiguration = software.amazon.jsii.Kernel.get(this, "compromisedCredentialsRiskConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.riskExceptionConfiguration = software.amazon.jsii.Kernel.get(this, "riskExceptionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.clientId = java.util.Objects.requireNonNull(builder.clientId, "clientId is required");
            this.userPoolId = java.util.Objects.requireNonNull(builder.userPoolId, "userPoolId is required");
            this.accountTakeoverRiskConfiguration = builder.accountTakeoverRiskConfiguration;
            this.compromisedCredentialsRiskConfiguration = builder.compromisedCredentialsRiskConfiguration;
            this.riskExceptionConfiguration = builder.riskExceptionConfiguration;
        }

        @Override
        public final java.lang.String getClientId() {
            return this.clientId;
        }

        @Override
        public final java.lang.String getUserPoolId() {
            return this.userPoolId;
        }

        @Override
        public final java.lang.Object getAccountTakeoverRiskConfiguration() {
            return this.accountTakeoverRiskConfiguration;
        }

        @Override
        public final java.lang.Object getCompromisedCredentialsRiskConfiguration() {
            return this.compromisedCredentialsRiskConfiguration;
        }

        @Override
        public final java.lang.Object getRiskExceptionConfiguration() {
            return this.riskExceptionConfiguration;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("clientId", om.valueToTree(this.getClientId()));
            data.set("userPoolId", om.valueToTree(this.getUserPoolId()));
            if (this.getAccountTakeoverRiskConfiguration() != null) {
                data.set("accountTakeoverRiskConfiguration", om.valueToTree(this.getAccountTakeoverRiskConfiguration()));
            }
            if (this.getCompromisedCredentialsRiskConfiguration() != null) {
                data.set("compromisedCredentialsRiskConfiguration", om.valueToTree(this.getCompromisedCredentialsRiskConfiguration()));
            }
            if (this.getRiskExceptionConfiguration() != null) {
                data.set("riskExceptionConfiguration", om.valueToTree(this.getRiskExceptionConfiguration()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.CfnUserPoolRiskConfigurationAttachmentProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnUserPoolRiskConfigurationAttachmentProps.Jsii$Proxy that = (CfnUserPoolRiskConfigurationAttachmentProps.Jsii$Proxy) o;

            if (!clientId.equals(that.clientId)) return false;
            if (!userPoolId.equals(that.userPoolId)) return false;
            if (this.accountTakeoverRiskConfiguration != null ? !this.accountTakeoverRiskConfiguration.equals(that.accountTakeoverRiskConfiguration) : that.accountTakeoverRiskConfiguration != null) return false;
            if (this.compromisedCredentialsRiskConfiguration != null ? !this.compromisedCredentialsRiskConfiguration.equals(that.compromisedCredentialsRiskConfiguration) : that.compromisedCredentialsRiskConfiguration != null) return false;
            return this.riskExceptionConfiguration != null ? this.riskExceptionConfiguration.equals(that.riskExceptionConfiguration) : that.riskExceptionConfiguration == null;
        }

        @Override
        public final int hashCode() {
            int result = this.clientId.hashCode();
            result = 31 * result + (this.userPoolId.hashCode());
            result = 31 * result + (this.accountTakeoverRiskConfiguration != null ? this.accountTakeoverRiskConfiguration.hashCode() : 0);
            result = 31 * result + (this.compromisedCredentialsRiskConfiguration != null ? this.compromisedCredentialsRiskConfiguration.hashCode() : 0);
            result = 31 * result + (this.riskExceptionConfiguration != null ? this.riskExceptionConfiguration.hashCode() : 0);
            return result;
        }
    }
}
