package software.amazon.awscdk.services.config;

/**
 * Properties for defining a <code>CfnConfigurationAggregator</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.config.*;
 * CfnConfigurationAggregatorProps cfnConfigurationAggregatorProps = CfnConfigurationAggregatorProps.builder()
 *         .accountAggregationSources(List.of(AccountAggregationSourceProperty.builder()
 *                 .accountIds(List.of("accountIds"))
 *                 // the properties below are optional
 *                 .allAwsRegions(false)
 *                 .awsRegions(List.of("awsRegions"))
 *                 .build()))
 *         .configurationAggregatorName("configurationAggregatorName")
 *         .organizationAggregationSource(OrganizationAggregationSourceProperty.builder()
 *                 .roleArn("roleArn")
 *                 // the properties below are optional
 *                 .allAwsRegions(false)
 *                 .awsRegions(List.of("awsRegions"))
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationaggregator.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationaggregator.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:36.499Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_config.CfnConfigurationAggregatorProps")
@software.amazon.jsii.Jsii.Proxy(CfnConfigurationAggregatorProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnConfigurationAggregatorProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Provides a list of source accounts and regions to be aggregated.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationaggregator.html#cfn-config-configurationaggregator-accountaggregationsources">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationaggregator.html#cfn-config-configurationaggregator-accountaggregationsources</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAccountAggregationSources() {
        return null;
    }

    /**
     * The name of the aggregator.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationaggregator.html#cfn-config-configurationaggregator-configurationaggregatorname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationaggregator.html#cfn-config-configurationaggregator-configurationaggregatorname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getConfigurationAggregatorName() {
        return null;
    }

    /**
     * Provides an organization and list of regions to be aggregated.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationaggregator.html#cfn-config-configurationaggregator-organizationaggregationsource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationaggregator.html#cfn-config-configurationaggregator-organizationaggregationsource</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getOrganizationAggregationSource() {
        return null;
    }

    /**
     * An array of tag object.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationaggregator.html#cfn-config-configurationaggregator-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationaggregator.html#cfn-config-configurationaggregator-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnConfigurationAggregatorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnConfigurationAggregatorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnConfigurationAggregatorProps> {
        java.lang.Object accountAggregationSources;
        java.lang.String configurationAggregatorName;
        java.lang.Object organizationAggregationSource;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnConfigurationAggregatorProps#getAccountAggregationSources}
         * @param accountAggregationSources Provides a list of source accounts and regions to be aggregated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accountAggregationSources(software.amazon.awscdk.IResolvable accountAggregationSources) {
            this.accountAggregationSources = accountAggregationSources;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigurationAggregatorProps#getAccountAggregationSources}
         * @param accountAggregationSources Provides a list of source accounts and regions to be aggregated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accountAggregationSources(java.util.List<? extends java.lang.Object> accountAggregationSources) {
            this.accountAggregationSources = accountAggregationSources;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigurationAggregatorProps#getConfigurationAggregatorName}
         * @param configurationAggregatorName The name of the aggregator.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationAggregatorName(java.lang.String configurationAggregatorName) {
            this.configurationAggregatorName = configurationAggregatorName;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigurationAggregatorProps#getOrganizationAggregationSource}
         * @param organizationAggregationSource Provides an organization and list of regions to be aggregated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder organizationAggregationSource(software.amazon.awscdk.IResolvable organizationAggregationSource) {
            this.organizationAggregationSource = organizationAggregationSource;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigurationAggregatorProps#getOrganizationAggregationSource}
         * @param organizationAggregationSource Provides an organization and list of regions to be aggregated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder organizationAggregationSource(software.amazon.awscdk.services.config.CfnConfigurationAggregator.OrganizationAggregationSourceProperty organizationAggregationSource) {
            this.organizationAggregationSource = organizationAggregationSource;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigurationAggregatorProps#getTags}
         * @param tags An array of tag object.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnConfigurationAggregatorProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnConfigurationAggregatorProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnConfigurationAggregatorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnConfigurationAggregatorProps {
        private final java.lang.Object accountAggregationSources;
        private final java.lang.String configurationAggregatorName;
        private final java.lang.Object organizationAggregationSource;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.accountAggregationSources = software.amazon.jsii.Kernel.get(this, "accountAggregationSources", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.configurationAggregatorName = software.amazon.jsii.Kernel.get(this, "configurationAggregatorName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.organizationAggregationSource = software.amazon.jsii.Kernel.get(this, "organizationAggregationSource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.accountAggregationSources = builder.accountAggregationSources;
            this.configurationAggregatorName = builder.configurationAggregatorName;
            this.organizationAggregationSource = builder.organizationAggregationSource;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getAccountAggregationSources() {
            return this.accountAggregationSources;
        }

        @Override
        public final java.lang.String getConfigurationAggregatorName() {
            return this.configurationAggregatorName;
        }

        @Override
        public final java.lang.Object getOrganizationAggregationSource() {
            return this.organizationAggregationSource;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAccountAggregationSources() != null) {
                data.set("accountAggregationSources", om.valueToTree(this.getAccountAggregationSources()));
            }
            if (this.getConfigurationAggregatorName() != null) {
                data.set("configurationAggregatorName", om.valueToTree(this.getConfigurationAggregatorName()));
            }
            if (this.getOrganizationAggregationSource() != null) {
                data.set("organizationAggregationSource", om.valueToTree(this.getOrganizationAggregationSource()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_config.CfnConfigurationAggregatorProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnConfigurationAggregatorProps.Jsii$Proxy that = (CfnConfigurationAggregatorProps.Jsii$Proxy) o;

            if (this.accountAggregationSources != null ? !this.accountAggregationSources.equals(that.accountAggregationSources) : that.accountAggregationSources != null) return false;
            if (this.configurationAggregatorName != null ? !this.configurationAggregatorName.equals(that.configurationAggregatorName) : that.configurationAggregatorName != null) return false;
            if (this.organizationAggregationSource != null ? !this.organizationAggregationSource.equals(that.organizationAggregationSource) : that.organizationAggregationSource != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.accountAggregationSources != null ? this.accountAggregationSources.hashCode() : 0;
            result = 31 * result + (this.configurationAggregatorName != null ? this.configurationAggregatorName.hashCode() : 0);
            result = 31 * result + (this.organizationAggregationSource != null ? this.organizationAggregationSource.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
