package software.amazon.awscdk.services.config;

/**
 * Construction properties for a CustomPolicy.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * String samplePolicyText = "\n# This rule checks if point in time recovery (PITR) is enabled on active Amazon DynamoDB tables\nlet status = ['ACTIVE']\n\nrule tableisactive when\n    resourceType == \"AWS::DynamoDB::Table\" {\n    configuration.tableStatus == %status\n}\n\nrule checkcompliance when\n    resourceType == \"AWS::DynamoDB::Table\"\n    tableisactive {\n        let pitr = supplementaryConfiguration.ContinuousBackupsDescription.pointInTimeRecoveryDescription.pointInTimeRecoveryStatus\n        %pitr == \"ENABLED\"\n}\n";
 * CustomPolicy.Builder.create(this, "Custom")
 *         .policyText(samplePolicyText)
 *         .enableDebugLog(true)
 *         .ruleScope(RuleScope.fromResources(List.of(ResourceType.DYNAMODB_TABLE)))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:36.539Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_config.CustomPolicyProps")
@software.amazon.jsii.Jsii.Proxy(CustomPolicyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CustomPolicyProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.config.RuleProps {

    /**
     * The policy definition containing the logic for your AWS Config Custom Policy rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPolicyText();

    /**
     * The boolean expression for enabling debug logging for your AWS Config Custom Policy rule.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableDebugLog() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CustomPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CustomPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CustomPolicyProps> {
        java.lang.String policyText;
        java.lang.Boolean enableDebugLog;
        java.lang.String configRuleName;
        java.lang.String description;
        software.amazon.awscdk.services.config.EvaluationMode evaluationModes;
        java.util.Map<java.lang.String, java.lang.Object> inputParameters;
        software.amazon.awscdk.services.config.MaximumExecutionFrequency maximumExecutionFrequency;
        software.amazon.awscdk.services.config.RuleScope ruleScope;

        /**
         * Sets the value of {@link CustomPolicyProps#getPolicyText}
         * @param policyText The policy definition containing the logic for your AWS Config Custom Policy rule. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyText(java.lang.String policyText) {
            this.policyText = policyText;
            return this;
        }

        /**
         * Sets the value of {@link CustomPolicyProps#getEnableDebugLog}
         * @param enableDebugLog The boolean expression for enabling debug logging for your AWS Config Custom Policy rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableDebugLog(java.lang.Boolean enableDebugLog) {
            this.enableDebugLog = enableDebugLog;
            return this;
        }

        /**
         * Sets the value of {@link CustomPolicyProps#getConfigRuleName}
         * @param configRuleName A name for the AWS Config rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configRuleName(java.lang.String configRuleName) {
            this.configRuleName = configRuleName;
            return this;
        }

        /**
         * Sets the value of {@link CustomPolicyProps#getDescription}
         * @param description A description about this AWS Config rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CustomPolicyProps#getEvaluationModes}
         * @param evaluationModes The modes the AWS Config rule can be evaluated in.
         *                        The valid values are distinct objects.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder evaluationModes(software.amazon.awscdk.services.config.EvaluationMode evaluationModes) {
            this.evaluationModes = evaluationModes;
            return this;
        }

        /**
         * Sets the value of {@link CustomPolicyProps#getInputParameters}
         * @param inputParameters Input parameter values that are passed to the AWS Config rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder inputParameters(java.util.Map<java.lang.String, ? extends java.lang.Object> inputParameters) {
            this.inputParameters = (java.util.Map<java.lang.String, java.lang.Object>)inputParameters;
            return this;
        }

        /**
         * Sets the value of {@link CustomPolicyProps#getMaximumExecutionFrequency}
         * @param maximumExecutionFrequency The maximum frequency at which the AWS Config rule runs evaluations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maximumExecutionFrequency(software.amazon.awscdk.services.config.MaximumExecutionFrequency maximumExecutionFrequency) {
            this.maximumExecutionFrequency = maximumExecutionFrequency;
            return this;
        }

        /**
         * Sets the value of {@link CustomPolicyProps#getRuleScope}
         * @param ruleScope Defines which resources trigger an evaluation for an AWS Config rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleScope(software.amazon.awscdk.services.config.RuleScope ruleScope) {
            this.ruleScope = ruleScope;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CustomPolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CustomPolicyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CustomPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomPolicyProps {
        private final java.lang.String policyText;
        private final java.lang.Boolean enableDebugLog;
        private final java.lang.String configRuleName;
        private final java.lang.String description;
        private final software.amazon.awscdk.services.config.EvaluationMode evaluationModes;
        private final java.util.Map<java.lang.String, java.lang.Object> inputParameters;
        private final software.amazon.awscdk.services.config.MaximumExecutionFrequency maximumExecutionFrequency;
        private final software.amazon.awscdk.services.config.RuleScope ruleScope;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.policyText = software.amazon.jsii.Kernel.get(this, "policyText", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enableDebugLog = software.amazon.jsii.Kernel.get(this, "enableDebugLog", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.configRuleName = software.amazon.jsii.Kernel.get(this, "configRuleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.evaluationModes = software.amazon.jsii.Kernel.get(this, "evaluationModes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.EvaluationMode.class));
            this.inputParameters = software.amazon.jsii.Kernel.get(this, "inputParameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.maximumExecutionFrequency = software.amazon.jsii.Kernel.get(this, "maximumExecutionFrequency", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.MaximumExecutionFrequency.class));
            this.ruleScope = software.amazon.jsii.Kernel.get(this, "ruleScope", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.config.RuleScope.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.policyText = java.util.Objects.requireNonNull(builder.policyText, "policyText is required");
            this.enableDebugLog = builder.enableDebugLog;
            this.configRuleName = builder.configRuleName;
            this.description = builder.description;
            this.evaluationModes = builder.evaluationModes;
            this.inputParameters = (java.util.Map<java.lang.String, java.lang.Object>)builder.inputParameters;
            this.maximumExecutionFrequency = builder.maximumExecutionFrequency;
            this.ruleScope = builder.ruleScope;
        }

        @Override
        public final java.lang.String getPolicyText() {
            return this.policyText;
        }

        @Override
        public final java.lang.Boolean getEnableDebugLog() {
            return this.enableDebugLog;
        }

        @Override
        public final java.lang.String getConfigRuleName() {
            return this.configRuleName;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final software.amazon.awscdk.services.config.EvaluationMode getEvaluationModes() {
            return this.evaluationModes;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getInputParameters() {
            return this.inputParameters;
        }

        @Override
        public final software.amazon.awscdk.services.config.MaximumExecutionFrequency getMaximumExecutionFrequency() {
            return this.maximumExecutionFrequency;
        }

        @Override
        public final software.amazon.awscdk.services.config.RuleScope getRuleScope() {
            return this.ruleScope;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("policyText", om.valueToTree(this.getPolicyText()));
            if (this.getEnableDebugLog() != null) {
                data.set("enableDebugLog", om.valueToTree(this.getEnableDebugLog()));
            }
            if (this.getConfigRuleName() != null) {
                data.set("configRuleName", om.valueToTree(this.getConfigRuleName()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEvaluationModes() != null) {
                data.set("evaluationModes", om.valueToTree(this.getEvaluationModes()));
            }
            if (this.getInputParameters() != null) {
                data.set("inputParameters", om.valueToTree(this.getInputParameters()));
            }
            if (this.getMaximumExecutionFrequency() != null) {
                data.set("maximumExecutionFrequency", om.valueToTree(this.getMaximumExecutionFrequency()));
            }
            if (this.getRuleScope() != null) {
                data.set("ruleScope", om.valueToTree(this.getRuleScope()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_config.CustomPolicyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CustomPolicyProps.Jsii$Proxy that = (CustomPolicyProps.Jsii$Proxy) o;

            if (!policyText.equals(that.policyText)) return false;
            if (this.enableDebugLog != null ? !this.enableDebugLog.equals(that.enableDebugLog) : that.enableDebugLog != null) return false;
            if (this.configRuleName != null ? !this.configRuleName.equals(that.configRuleName) : that.configRuleName != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.evaluationModes != null ? !this.evaluationModes.equals(that.evaluationModes) : that.evaluationModes != null) return false;
            if (this.inputParameters != null ? !this.inputParameters.equals(that.inputParameters) : that.inputParameters != null) return false;
            if (this.maximumExecutionFrequency != null ? !this.maximumExecutionFrequency.equals(that.maximumExecutionFrequency) : that.maximumExecutionFrequency != null) return false;
            return this.ruleScope != null ? this.ruleScope.equals(that.ruleScope) : that.ruleScope == null;
        }

        @Override
        public final int hashCode() {
            int result = this.policyText.hashCode();
            result = 31 * result + (this.enableDebugLog != null ? this.enableDebugLog.hashCode() : 0);
            result = 31 * result + (this.configRuleName != null ? this.configRuleName.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.evaluationModes != null ? this.evaluationModes.hashCode() : 0);
            result = 31 * result + (this.inputParameters != null ? this.inputParameters.hashCode() : 0);
            result = 31 * result + (this.maximumExecutionFrequency != null ? this.maximumExecutionFrequency.hashCode() : 0);
            result = 31 * result + (this.ruleScope != null ? this.ruleScope.hashCode() : 0);
            return result;
        }
    }
}
