package software.amazon.awscdk.services.customerprofiles;

/**
 * Specifies the rules to perform an action based on customer ingested data.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.customerprofiles.*;
 * CfnEventTrigger cfnEventTrigger = CfnEventTrigger.Builder.create(this, "MyCfnEventTrigger")
 *         .domainName("domainName")
 *         .eventTriggerConditions(List.of(EventTriggerConditionProperty.builder()
 *                 .eventTriggerDimensions(List.of(EventTriggerDimensionProperty.builder()
 *                         .objectAttributes(List.of(ObjectAttributeProperty.builder()
 *                                 .comparisonOperator("comparisonOperator")
 *                                 .values(List.of("values"))
 *                                 // the properties below are optional
 *                                 .fieldName("fieldName")
 *                                 .source("source")
 *                                 .build()))
 *                         .build()))
 *                 .logicalOperator("logicalOperator")
 *                 .build()))
 *         .eventTriggerName("eventTriggerName")
 *         .objectTypeName("objectTypeName")
 *         // the properties below are optional
 *         .description("description")
 *         .eventTriggerLimits(EventTriggerLimitsProperty.builder()
 *                 .eventExpiration(123)
 *                 .periods(List.of(PeriodProperty.builder()
 *                         .unit("unit")
 *                         .value(123)
 *                         // the properties below are optional
 *                         .maxInvocationsPerProfile(123)
 *                         .unlimited(false)
 *                         .build()))
 *                 .build())
 *         .segmentFilter("segmentFilter")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-eventtrigger.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-eventtrigger.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:36.732Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_customerprofiles.CfnEventTrigger")
public class CfnEventTrigger extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnEventTrigger(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnEventTrigger(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.customerprofiles.CfnEventTrigger.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnEventTrigger(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.customerprofiles.CfnEventTriggerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The timestamp of when the event trigger was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The timestamp of when the event trigger was most recently updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLastUpdatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrLastUpdatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The unique name of the domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDomainName() {
        return software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique name of the domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDomainName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "domainName", java.util.Objects.requireNonNull(value, "domainName is required"));
    }

    /**
     * A list of conditions that determine when an event should trigger the destination.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getEventTriggerConditions() {
        return software.amazon.jsii.Kernel.get(this, "eventTriggerConditions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of conditions that determine when an event should trigger the destination.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEventTriggerConditions(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "eventTriggerConditions", java.util.Objects.requireNonNull(value, "eventTriggerConditions is required"));
    }

    /**
     * A list of conditions that determine when an event should trigger the destination.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEventTriggerConditions(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.customerprofiles.CfnEventTrigger.EventTriggerConditionProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.customerprofiles.CfnEventTrigger.EventTriggerConditionProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "eventTriggerConditions", java.util.Objects.requireNonNull(value, "eventTriggerConditions is required"));
    }

    /**
     * The unique name of the event trigger.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getEventTriggerName() {
        return software.amazon.jsii.Kernel.get(this, "eventTriggerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique name of the event trigger.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEventTriggerName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "eventTriggerName", java.util.Objects.requireNonNull(value, "eventTriggerName is required"));
    }

    /**
     * The unique name of the object type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getObjectTypeName() {
        return software.amazon.jsii.Kernel.get(this, "objectTypeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique name of the object type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setObjectTypeName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "objectTypeName", java.util.Objects.requireNonNull(value, "objectTypeName is required"));
    }

    /**
     * The description of the event trigger.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the event trigger.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * Defines limits controlling whether an event triggers the destination, based on ingestion latency and the number of invocations per profile over specific time periods.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEventTriggerLimits() {
        return software.amazon.jsii.Kernel.get(this, "eventTriggerLimits", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Defines limits controlling whether an event triggers the destination, based on ingestion latency and the number of invocations per profile over specific time periods.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEventTriggerLimits(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "eventTriggerLimits", value);
    }

    /**
     * Defines limits controlling whether an event triggers the destination, based on ingestion latency and the number of invocations per profile over specific time periods.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEventTriggerLimits(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.customerprofiles.CfnEventTrigger.EventTriggerLimitsProperty value) {
        software.amazon.jsii.Kernel.set(this, "eventTriggerLimits", value);
    }

    /**
     * The destination is triggered only for profiles that meet the criteria of a segment definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSegmentFilter() {
        return software.amazon.jsii.Kernel.get(this, "segmentFilter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The destination is triggered only for profiles that meet the criteria of a segment definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSegmentFilter(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "segmentFilter", value);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * Specifies the circumstances under which the event should trigger the destination.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.customerprofiles.*;
     * EventTriggerConditionProperty eventTriggerConditionProperty = EventTriggerConditionProperty.builder()
     *         .eventTriggerDimensions(List.of(EventTriggerDimensionProperty.builder()
     *                 .objectAttributes(List.of(ObjectAttributeProperty.builder()
     *                         .comparisonOperator("comparisonOperator")
     *                         .values(List.of("values"))
     *                         // the properties below are optional
     *                         .fieldName("fieldName")
     *                         .source("source")
     *                         .build()))
     *                 .build()))
     *         .logicalOperator("logicalOperator")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-eventtrigger-eventtriggercondition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-eventtrigger-eventtriggercondition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_customerprofiles.CfnEventTrigger.EventTriggerConditionProperty")
    @software.amazon.jsii.Jsii.Proxy(EventTriggerConditionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EventTriggerConditionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of dimensions to be evaluated for the event.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-eventtrigger-eventtriggercondition.html#cfn-customerprofiles-eventtrigger-eventtriggercondition-eventtriggerdimensions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-eventtrigger-eventtriggercondition.html#cfn-customerprofiles-eventtrigger-eventtriggercondition-eventtriggerdimensions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEventTriggerDimensions();

        /**
         * The operator used to combine multiple dimensions.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-eventtrigger-eventtriggercondition.html#cfn-customerprofiles-eventtrigger-eventtriggercondition-logicaloperator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-eventtrigger-eventtriggercondition.html#cfn-customerprofiles-eventtrigger-eventtriggercondition-logicaloperator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLogicalOperator();

        /**
         * @return a {@link Builder} of {@link EventTriggerConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EventTriggerConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EventTriggerConditionProperty> {
            java.lang.Object eventTriggerDimensions;
            java.lang.String logicalOperator;

            /**
             * Sets the value of {@link EventTriggerConditionProperty#getEventTriggerDimensions}
             * @param eventTriggerDimensions A list of dimensions to be evaluated for the event. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventTriggerDimensions(software.amazon.awscdk.IResolvable eventTriggerDimensions) {
                this.eventTriggerDimensions = eventTriggerDimensions;
                return this;
            }

            /**
             * Sets the value of {@link EventTriggerConditionProperty#getEventTriggerDimensions}
             * @param eventTriggerDimensions A list of dimensions to be evaluated for the event. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventTriggerDimensions(java.util.List<? extends java.lang.Object> eventTriggerDimensions) {
                this.eventTriggerDimensions = eventTriggerDimensions;
                return this;
            }

            /**
             * Sets the value of {@link EventTriggerConditionProperty#getLogicalOperator}
             * @param logicalOperator The operator used to combine multiple dimensions. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logicalOperator(java.lang.String logicalOperator) {
                this.logicalOperator = logicalOperator;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EventTriggerConditionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EventTriggerConditionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EventTriggerConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventTriggerConditionProperty {
            private final java.lang.Object eventTriggerDimensions;
            private final java.lang.String logicalOperator;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.eventTriggerDimensions = software.amazon.jsii.Kernel.get(this, "eventTriggerDimensions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.logicalOperator = software.amazon.jsii.Kernel.get(this, "logicalOperator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.eventTriggerDimensions = java.util.Objects.requireNonNull(builder.eventTriggerDimensions, "eventTriggerDimensions is required");
                this.logicalOperator = java.util.Objects.requireNonNull(builder.logicalOperator, "logicalOperator is required");
            }

            @Override
            public final java.lang.Object getEventTriggerDimensions() {
                return this.eventTriggerDimensions;
            }

            @Override
            public final java.lang.String getLogicalOperator() {
                return this.logicalOperator;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("eventTriggerDimensions", om.valueToTree(this.getEventTriggerDimensions()));
                data.set("logicalOperator", om.valueToTree(this.getLogicalOperator()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_customerprofiles.CfnEventTrigger.EventTriggerConditionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EventTriggerConditionProperty.Jsii$Proxy that = (EventTriggerConditionProperty.Jsii$Proxy) o;

                if (!eventTriggerDimensions.equals(that.eventTriggerDimensions)) return false;
                return this.logicalOperator.equals(that.logicalOperator);
            }

            @Override
            public final int hashCode() {
                int result = this.eventTriggerDimensions.hashCode();
                result = 31 * result + (this.logicalOperator.hashCode());
                return result;
            }
        }
    }
    /**
     * A specific event dimension to be assessed.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.customerprofiles.*;
     * EventTriggerDimensionProperty eventTriggerDimensionProperty = EventTriggerDimensionProperty.builder()
     *         .objectAttributes(List.of(ObjectAttributeProperty.builder()
     *                 .comparisonOperator("comparisonOperator")
     *                 .values(List.of("values"))
     *                 // the properties below are optional
     *                 .fieldName("fieldName")
     *                 .source("source")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-eventtrigger-eventtriggerdimension.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-eventtrigger-eventtriggerdimension.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_customerprofiles.CfnEventTrigger.EventTriggerDimensionProperty")
    @software.amazon.jsii.Jsii.Proxy(EventTriggerDimensionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EventTriggerDimensionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of object attributes to be evaluated.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-eventtrigger-eventtriggerdimension.html#cfn-customerprofiles-eventtrigger-eventtriggerdimension-objectattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-eventtrigger-eventtriggerdimension.html#cfn-customerprofiles-eventtrigger-eventtriggerdimension-objectattributes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getObjectAttributes();

        /**
         * @return a {@link Builder} of {@link EventTriggerDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EventTriggerDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EventTriggerDimensionProperty> {
            java.lang.Object objectAttributes;

            /**
             * Sets the value of {@link EventTriggerDimensionProperty#getObjectAttributes}
             * @param objectAttributes A list of object attributes to be evaluated. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder objectAttributes(software.amazon.awscdk.IResolvable objectAttributes) {
                this.objectAttributes = objectAttributes;
                return this;
            }

            /**
             * Sets the value of {@link EventTriggerDimensionProperty#getObjectAttributes}
             * @param objectAttributes A list of object attributes to be evaluated. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder objectAttributes(java.util.List<? extends java.lang.Object> objectAttributes) {
                this.objectAttributes = objectAttributes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EventTriggerDimensionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EventTriggerDimensionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EventTriggerDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventTriggerDimensionProperty {
            private final java.lang.Object objectAttributes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.objectAttributes = software.amazon.jsii.Kernel.get(this, "objectAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.objectAttributes = java.util.Objects.requireNonNull(builder.objectAttributes, "objectAttributes is required");
            }

            @Override
            public final java.lang.Object getObjectAttributes() {
                return this.objectAttributes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("objectAttributes", om.valueToTree(this.getObjectAttributes()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_customerprofiles.CfnEventTrigger.EventTriggerDimensionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EventTriggerDimensionProperty.Jsii$Proxy that = (EventTriggerDimensionProperty.Jsii$Proxy) o;

                return this.objectAttributes.equals(that.objectAttributes);
            }

            @Override
            public final int hashCode() {
                int result = this.objectAttributes.hashCode();
                return result;
            }
        }
    }
    /**
     * Defines limits controlling whether an event triggers the destination, based on ingestion latency and the number of invocations per profile over specific time periods.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.customerprofiles.*;
     * EventTriggerLimitsProperty eventTriggerLimitsProperty = EventTriggerLimitsProperty.builder()
     *         .eventExpiration(123)
     *         .periods(List.of(PeriodProperty.builder()
     *                 .unit("unit")
     *                 .value(123)
     *                 // the properties below are optional
     *                 .maxInvocationsPerProfile(123)
     *                 .unlimited(false)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-eventtrigger-eventtriggerlimits.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-eventtrigger-eventtriggerlimits.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_customerprofiles.CfnEventTrigger.EventTriggerLimitsProperty")
    @software.amazon.jsii.Jsii.Proxy(EventTriggerLimitsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EventTriggerLimitsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies that an event will only trigger the destination if it is processed within a certain latency period.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-eventtrigger-eventtriggerlimits.html#cfn-customerprofiles-eventtrigger-eventtriggerlimits-eventexpiration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-eventtrigger-eventtriggerlimits.html#cfn-customerprofiles-eventtrigger-eventtriggerlimits-eventexpiration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getEventExpiration() {
            return null;
        }

        /**
         * A list of time periods during which the limits apply.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-eventtrigger-eventtriggerlimits.html#cfn-customerprofiles-eventtrigger-eventtriggerlimits-periods">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-eventtrigger-eventtriggerlimits.html#cfn-customerprofiles-eventtrigger-eventtriggerlimits-periods</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPeriods() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EventTriggerLimitsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EventTriggerLimitsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EventTriggerLimitsProperty> {
            java.lang.Number eventExpiration;
            java.lang.Object periods;

            /**
             * Sets the value of {@link EventTriggerLimitsProperty#getEventExpiration}
             * @param eventExpiration Specifies that an event will only trigger the destination if it is processed within a certain latency period.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventExpiration(java.lang.Number eventExpiration) {
                this.eventExpiration = eventExpiration;
                return this;
            }

            /**
             * Sets the value of {@link EventTriggerLimitsProperty#getPeriods}
             * @param periods A list of time periods during which the limits apply.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder periods(software.amazon.awscdk.IResolvable periods) {
                this.periods = periods;
                return this;
            }

            /**
             * Sets the value of {@link EventTriggerLimitsProperty#getPeriods}
             * @param periods A list of time periods during which the limits apply.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder periods(java.util.List<? extends java.lang.Object> periods) {
                this.periods = periods;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EventTriggerLimitsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EventTriggerLimitsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EventTriggerLimitsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventTriggerLimitsProperty {
            private final java.lang.Number eventExpiration;
            private final java.lang.Object periods;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.eventExpiration = software.amazon.jsii.Kernel.get(this, "eventExpiration", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.periods = software.amazon.jsii.Kernel.get(this, "periods", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.eventExpiration = builder.eventExpiration;
                this.periods = builder.periods;
            }

            @Override
            public final java.lang.Number getEventExpiration() {
                return this.eventExpiration;
            }

            @Override
            public final java.lang.Object getPeriods() {
                return this.periods;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEventExpiration() != null) {
                    data.set("eventExpiration", om.valueToTree(this.getEventExpiration()));
                }
                if (this.getPeriods() != null) {
                    data.set("periods", om.valueToTree(this.getPeriods()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_customerprofiles.CfnEventTrigger.EventTriggerLimitsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EventTriggerLimitsProperty.Jsii$Proxy that = (EventTriggerLimitsProperty.Jsii$Proxy) o;

                if (this.eventExpiration != null ? !this.eventExpiration.equals(that.eventExpiration) : that.eventExpiration != null) return false;
                return this.periods != null ? this.periods.equals(that.periods) : that.periods == null;
            }

            @Override
            public final int hashCode() {
                int result = this.eventExpiration != null ? this.eventExpiration.hashCode() : 0;
                result = 31 * result + (this.periods != null ? this.periods.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The criteria that a specific object attribute must meet to trigger the destination.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.customerprofiles.*;
     * ObjectAttributeProperty objectAttributeProperty = ObjectAttributeProperty.builder()
     *         .comparisonOperator("comparisonOperator")
     *         .values(List.of("values"))
     *         // the properties below are optional
     *         .fieldName("fieldName")
     *         .source("source")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-eventtrigger-objectattribute.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-eventtrigger-objectattribute.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_customerprofiles.CfnEventTrigger.ObjectAttributeProperty")
    @software.amazon.jsii.Jsii.Proxy(ObjectAttributeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ObjectAttributeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The operator used to compare an attribute against a list of values.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-eventtrigger-objectattribute.html#cfn-customerprofiles-eventtrigger-objectattribute-comparisonoperator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-eventtrigger-objectattribute.html#cfn-customerprofiles-eventtrigger-objectattribute-comparisonoperator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getComparisonOperator();

        /**
         * The amount of time of the specified unit.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-eventtrigger-objectattribute.html#cfn-customerprofiles-eventtrigger-objectattribute-values">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-eventtrigger-objectattribute.html#cfn-customerprofiles-eventtrigger-objectattribute-values</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getValues();

        /**
         * A field defined within an object type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-eventtrigger-objectattribute.html#cfn-customerprofiles-eventtrigger-objectattribute-fieldname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-eventtrigger-objectattribute.html#cfn-customerprofiles-eventtrigger-objectattribute-fieldname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFieldName() {
            return null;
        }

        /**
         * An attribute contained within a source object.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-eventtrigger-objectattribute.html#cfn-customerprofiles-eventtrigger-objectattribute-source">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-eventtrigger-objectattribute.html#cfn-customerprofiles-eventtrigger-objectattribute-source</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSource() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ObjectAttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ObjectAttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ObjectAttributeProperty> {
            java.lang.String comparisonOperator;
            java.util.List<java.lang.String> values;
            java.lang.String fieldName;
            java.lang.String source;

            /**
             * Sets the value of {@link ObjectAttributeProperty#getComparisonOperator}
             * @param comparisonOperator The operator used to compare an attribute against a list of values. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder comparisonOperator(java.lang.String comparisonOperator) {
                this.comparisonOperator = comparisonOperator;
                return this;
            }

            /**
             * Sets the value of {@link ObjectAttributeProperty#getValues}
             * @param values The amount of time of the specified unit. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(java.util.List<java.lang.String> values) {
                this.values = values;
                return this;
            }

            /**
             * Sets the value of {@link ObjectAttributeProperty#getFieldName}
             * @param fieldName A field defined within an object type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldName(java.lang.String fieldName) {
                this.fieldName = fieldName;
                return this;
            }

            /**
             * Sets the value of {@link ObjectAttributeProperty#getSource}
             * @param source An attribute contained within a source object.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(java.lang.String source) {
                this.source = source;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ObjectAttributeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ObjectAttributeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ObjectAttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ObjectAttributeProperty {
            private final java.lang.String comparisonOperator;
            private final java.util.List<java.lang.String> values;
            private final java.lang.String fieldName;
            private final java.lang.String source;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.comparisonOperator = software.amazon.jsii.Kernel.get(this, "comparisonOperator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.fieldName = software.amazon.jsii.Kernel.get(this, "fieldName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.comparisonOperator = java.util.Objects.requireNonNull(builder.comparisonOperator, "comparisonOperator is required");
                this.values = java.util.Objects.requireNonNull(builder.values, "values is required");
                this.fieldName = builder.fieldName;
                this.source = builder.source;
            }

            @Override
            public final java.lang.String getComparisonOperator() {
                return this.comparisonOperator;
            }

            @Override
            public final java.util.List<java.lang.String> getValues() {
                return this.values;
            }

            @Override
            public final java.lang.String getFieldName() {
                return this.fieldName;
            }

            @Override
            public final java.lang.String getSource() {
                return this.source;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("comparisonOperator", om.valueToTree(this.getComparisonOperator()));
                data.set("values", om.valueToTree(this.getValues()));
                if (this.getFieldName() != null) {
                    data.set("fieldName", om.valueToTree(this.getFieldName()));
                }
                if (this.getSource() != null) {
                    data.set("source", om.valueToTree(this.getSource()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_customerprofiles.CfnEventTrigger.ObjectAttributeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ObjectAttributeProperty.Jsii$Proxy that = (ObjectAttributeProperty.Jsii$Proxy) o;

                if (!comparisonOperator.equals(that.comparisonOperator)) return false;
                if (!values.equals(that.values)) return false;
                if (this.fieldName != null ? !this.fieldName.equals(that.fieldName) : that.fieldName != null) return false;
                return this.source != null ? this.source.equals(that.source) : that.source == null;
            }

            @Override
            public final int hashCode() {
                int result = this.comparisonOperator.hashCode();
                result = 31 * result + (this.values.hashCode());
                result = 31 * result + (this.fieldName != null ? this.fieldName.hashCode() : 0);
                result = 31 * result + (this.source != null ? this.source.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines a limit and the time period during which it is enforced.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.customerprofiles.*;
     * PeriodProperty periodProperty = PeriodProperty.builder()
     *         .unit("unit")
     *         .value(123)
     *         // the properties below are optional
     *         .maxInvocationsPerProfile(123)
     *         .unlimited(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-eventtrigger-period.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-eventtrigger-period.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_customerprofiles.CfnEventTrigger.PeriodProperty")
    @software.amazon.jsii.Jsii.Proxy(PeriodProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PeriodProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The unit of time.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-eventtrigger-period.html#cfn-customerprofiles-eventtrigger-period-unit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-eventtrigger-period.html#cfn-customerprofiles-eventtrigger-period-unit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUnit();

        /**
         * The amount of time of the specified unit.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-eventtrigger-period.html#cfn-customerprofiles-eventtrigger-period-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-eventtrigger-period.html#cfn-customerprofiles-eventtrigger-period-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getValue();

        /**
         * The maximum allowed number of destination invocations per profile.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-eventtrigger-period.html#cfn-customerprofiles-eventtrigger-period-maxinvocationsperprofile">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-eventtrigger-period.html#cfn-customerprofiles-eventtrigger-period-maxinvocationsperprofile</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxInvocationsPerProfile() {
            return null;
        }

        /**
         * If set to true, there is no limit on the number of destination invocations per profile.
         * <p>
         * The default is false.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-eventtrigger-period.html#cfn-customerprofiles-eventtrigger-period-unlimited">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-eventtrigger-period.html#cfn-customerprofiles-eventtrigger-period-unlimited</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUnlimited() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PeriodProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PeriodProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PeriodProperty> {
            java.lang.String unit;
            java.lang.Number value;
            java.lang.Number maxInvocationsPerProfile;
            java.lang.Object unlimited;

            /**
             * Sets the value of {@link PeriodProperty#getUnit}
             * @param unit The unit of time. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unit(java.lang.String unit) {
                this.unit = unit;
                return this;
            }

            /**
             * Sets the value of {@link PeriodProperty#getValue}
             * @param value The amount of time of the specified unit. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.Number value) {
                this.value = value;
                return this;
            }

            /**
             * Sets the value of {@link PeriodProperty#getMaxInvocationsPerProfile}
             * @param maxInvocationsPerProfile The maximum allowed number of destination invocations per profile.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxInvocationsPerProfile(java.lang.Number maxInvocationsPerProfile) {
                this.maxInvocationsPerProfile = maxInvocationsPerProfile;
                return this;
            }

            /**
             * Sets the value of {@link PeriodProperty#getUnlimited}
             * @param unlimited If set to true, there is no limit on the number of destination invocations per profile.
             *                  The default is false.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unlimited(java.lang.Boolean unlimited) {
                this.unlimited = unlimited;
                return this;
            }

            /**
             * Sets the value of {@link PeriodProperty#getUnlimited}
             * @param unlimited If set to true, there is no limit on the number of destination invocations per profile.
             *                  The default is false.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unlimited(software.amazon.awscdk.IResolvable unlimited) {
                this.unlimited = unlimited;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PeriodProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PeriodProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PeriodProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PeriodProperty {
            private final java.lang.String unit;
            private final java.lang.Number value;
            private final java.lang.Number maxInvocationsPerProfile;
            private final java.lang.Object unlimited;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.unit = software.amazon.jsii.Kernel.get(this, "unit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maxInvocationsPerProfile = software.amazon.jsii.Kernel.get(this, "maxInvocationsPerProfile", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.unlimited = software.amazon.jsii.Kernel.get(this, "unlimited", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.unit = java.util.Objects.requireNonNull(builder.unit, "unit is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
                this.maxInvocationsPerProfile = builder.maxInvocationsPerProfile;
                this.unlimited = builder.unlimited;
            }

            @Override
            public final java.lang.String getUnit() {
                return this.unit;
            }

            @Override
            public final java.lang.Number getValue() {
                return this.value;
            }

            @Override
            public final java.lang.Number getMaxInvocationsPerProfile() {
                return this.maxInvocationsPerProfile;
            }

            @Override
            public final java.lang.Object getUnlimited() {
                return this.unlimited;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("unit", om.valueToTree(this.getUnit()));
                data.set("value", om.valueToTree(this.getValue()));
                if (this.getMaxInvocationsPerProfile() != null) {
                    data.set("maxInvocationsPerProfile", om.valueToTree(this.getMaxInvocationsPerProfile()));
                }
                if (this.getUnlimited() != null) {
                    data.set("unlimited", om.valueToTree(this.getUnlimited()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_customerprofiles.CfnEventTrigger.PeriodProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PeriodProperty.Jsii$Proxy that = (PeriodProperty.Jsii$Proxy) o;

                if (!unit.equals(that.unit)) return false;
                if (!value.equals(that.value)) return false;
                if (this.maxInvocationsPerProfile != null ? !this.maxInvocationsPerProfile.equals(that.maxInvocationsPerProfile) : that.maxInvocationsPerProfile != null) return false;
                return this.unlimited != null ? this.unlimited.equals(that.unlimited) : that.unlimited == null;
            }

            @Override
            public final int hashCode() {
                int result = this.unit.hashCode();
                result = 31 * result + (this.value.hashCode());
                result = 31 * result + (this.maxInvocationsPerProfile != null ? this.maxInvocationsPerProfile.hashCode() : 0);
                result = 31 * result + (this.unlimited != null ? this.unlimited.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.customerprofiles.CfnEventTrigger}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.customerprofiles.CfnEventTrigger> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.customerprofiles.CfnEventTriggerProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.customerprofiles.CfnEventTriggerProps.Builder();
        }

        /**
         * The unique name of the domain.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-eventtrigger.html#cfn-customerprofiles-eventtrigger-domainname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-eventtrigger.html#cfn-customerprofiles-eventtrigger-domainname</a>
         * @param domainName The unique name of the domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(final java.lang.String domainName) {
            this.props.domainName(domainName);
            return this;
        }

        /**
         * A list of conditions that determine when an event should trigger the destination.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-eventtrigger.html#cfn-customerprofiles-eventtrigger-eventtriggerconditions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-eventtrigger.html#cfn-customerprofiles-eventtrigger-eventtriggerconditions</a>
         * @param eventTriggerConditions A list of conditions that determine when an event should trigger the destination. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventTriggerConditions(final software.amazon.awscdk.IResolvable eventTriggerConditions) {
            this.props.eventTriggerConditions(eventTriggerConditions);
            return this;
        }
        /**
         * A list of conditions that determine when an event should trigger the destination.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-eventtrigger.html#cfn-customerprofiles-eventtrigger-eventtriggerconditions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-eventtrigger.html#cfn-customerprofiles-eventtrigger-eventtriggerconditions</a>
         * @param eventTriggerConditions A list of conditions that determine when an event should trigger the destination. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventTriggerConditions(final java.util.List<? extends java.lang.Object> eventTriggerConditions) {
            this.props.eventTriggerConditions(eventTriggerConditions);
            return this;
        }

        /**
         * The unique name of the event trigger.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-eventtrigger.html#cfn-customerprofiles-eventtrigger-eventtriggername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-eventtrigger.html#cfn-customerprofiles-eventtrigger-eventtriggername</a>
         * @param eventTriggerName The unique name of the event trigger. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventTriggerName(final java.lang.String eventTriggerName) {
            this.props.eventTriggerName(eventTriggerName);
            return this;
        }

        /**
         * The unique name of the object type.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-eventtrigger.html#cfn-customerprofiles-eventtrigger-objecttypename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-eventtrigger.html#cfn-customerprofiles-eventtrigger-objecttypename</a>
         * @param objectTypeName The unique name of the object type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder objectTypeName(final java.lang.String objectTypeName) {
            this.props.objectTypeName(objectTypeName);
            return this;
        }

        /**
         * The description of the event trigger.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-eventtrigger.html#cfn-customerprofiles-eventtrigger-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-eventtrigger.html#cfn-customerprofiles-eventtrigger-description</a>
         * @param description The description of the event trigger. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * Defines limits controlling whether an event triggers the destination, based on ingestion latency and the number of invocations per profile over specific time periods.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-eventtrigger.html#cfn-customerprofiles-eventtrigger-eventtriggerlimits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-eventtrigger.html#cfn-customerprofiles-eventtrigger-eventtriggerlimits</a>
         * @param eventTriggerLimits Defines limits controlling whether an event triggers the destination, based on ingestion latency and the number of invocations per profile over specific time periods. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventTriggerLimits(final software.amazon.awscdk.IResolvable eventTriggerLimits) {
            this.props.eventTriggerLimits(eventTriggerLimits);
            return this;
        }
        /**
         * Defines limits controlling whether an event triggers the destination, based on ingestion latency and the number of invocations per profile over specific time periods.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-eventtrigger.html#cfn-customerprofiles-eventtrigger-eventtriggerlimits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-eventtrigger.html#cfn-customerprofiles-eventtrigger-eventtriggerlimits</a>
         * @param eventTriggerLimits Defines limits controlling whether an event triggers the destination, based on ingestion latency and the number of invocations per profile over specific time periods. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventTriggerLimits(final software.amazon.awscdk.services.customerprofiles.CfnEventTrigger.EventTriggerLimitsProperty eventTriggerLimits) {
            this.props.eventTriggerLimits(eventTriggerLimits);
            return this;
        }

        /**
         * The destination is triggered only for profiles that meet the criteria of a segment definition.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-eventtrigger.html#cfn-customerprofiles-eventtrigger-segmentfilter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-eventtrigger.html#cfn-customerprofiles-eventtrigger-segmentfilter</a>
         * @param segmentFilter The destination is triggered only for profiles that meet the criteria of a segment definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder segmentFilter(final java.lang.String segmentFilter) {
            this.props.segmentFilter(segmentFilter);
            return this;
        }

        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-eventtrigger.html#cfn-customerprofiles-eventtrigger-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-eventtrigger.html#cfn-customerprofiles-eventtrigger-tags</a>
         * @param tags An array of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.customerprofiles.CfnEventTrigger}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.customerprofiles.CfnEventTrigger build() {
            return new software.amazon.awscdk.services.customerprofiles.CfnEventTrigger(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
