package software.amazon.awscdk.services.datasync;

/**
 * Properties for defining a <code>CfnAgent</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.datasync.*;
 * CfnAgentProps cfnAgentProps = CfnAgentProps.builder()
 *         .activationKey("activationKey")
 *         .agentName("agentName")
 *         .securityGroupArns(List.of("securityGroupArns"))
 *         .subnetArns(List.of("subnetArns"))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .vpcEndpointId("vpcEndpointId")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-agent.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-agent.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:36.852Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datasync.CfnAgentProps")
@software.amazon.jsii.Jsii.Proxy(CfnAgentProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAgentProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies your DataSync agent's activation key.
     * <p>
     * If you don't have an activation key, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/activate-agent.html">Activating your agent</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-agent.html#cfn-datasync-agent-activationkey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-agent.html#cfn-datasync-agent-activationkey</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getActivationKey() {
        return null;
    }

    /**
     * Specifies a name for your agent.
     * <p>
     * We recommend specifying a name that you can remember.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-agent.html#cfn-datasync-agent-agentname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-agent.html#cfn-datasync-agent-agentname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAgentName() {
        return null;
    }

    /**
     * The Amazon Resource Names (ARNs) of the security groups used to protect your data transfer task subnets.
     * <p>
     * See <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_Ec2Config.html#DataSync-Type-Ec2Config-SecurityGroupArns">SecurityGroupArns</a> .
     * <p>
     * <em>Pattern</em> : <code>^arn:(aws|aws-cn|aws-us-gov|aws-iso|aws-iso-b):ec2:[a-z\-0-9]*:[0-9]{12}:security-group/.*$</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-agent.html#cfn-datasync-agent-securitygrouparns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-agent.html#cfn-datasync-agent-securitygrouparns</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroupArns() {
        return null;
    }

    /**
     * Specifies the ARN of the subnet where your VPC service endpoint is located.
     * <p>
     * You can only specify one ARN.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-agent.html#cfn-datasync-agent-subnetarns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-agent.html#cfn-datasync-agent-subnetarns</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSubnetArns() {
        return null;
    }

    /**
     * Specifies labels that help you categorize, filter, and search for your AWS resources.
     * <p>
     * We recommend creating at least one tag for your agent.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-agent.html#cfn-datasync-agent-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-agent.html#cfn-datasync-agent-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The ID of the virtual private cloud (VPC) endpoint that the agent has access to.
     * <p>
     * This is the client-side VPC endpoint, powered by AWS PrivateLink . If you don't have an AWS PrivateLink VPC endpoint, see <a href="https://docs.aws.amazon.com//vpc/latest/userguide/endpoint-services-overview.html">AWS PrivateLink and VPC endpoints</a> in the <em>Amazon VPC User Guide</em> .
     * <p>
     * For more information about activating your agent in a private network based on a VPC, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/datasync-in-vpc.html">Using AWS DataSync in a Virtual Private Cloud</a> in the <em>AWS DataSync User Guide.</em>
     * <p>
     * A VPC endpoint ID looks like this: <code>vpce-01234d5aff67890e1</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-agent.html#cfn-datasync-agent-vpcendpointid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-agent.html#cfn-datasync-agent-vpcendpointid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVpcEndpointId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAgentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAgentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAgentProps> {
        java.lang.String activationKey;
        java.lang.String agentName;
        java.util.List<java.lang.String> securityGroupArns;
        java.util.List<java.lang.String> subnetArns;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String vpcEndpointId;

        /**
         * Sets the value of {@link CfnAgentProps#getActivationKey}
         * @param activationKey Specifies your DataSync agent's activation key.
         *                      If you don't have an activation key, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/activate-agent.html">Activating your agent</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder activationKey(java.lang.String activationKey) {
            this.activationKey = activationKey;
            return this;
        }

        /**
         * Sets the value of {@link CfnAgentProps#getAgentName}
         * @param agentName Specifies a name for your agent.
         *                  We recommend specifying a name that you can remember.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder agentName(java.lang.String agentName) {
            this.agentName = agentName;
            return this;
        }

        /**
         * Sets the value of {@link CfnAgentProps#getSecurityGroupArns}
         * @param securityGroupArns The Amazon Resource Names (ARNs) of the security groups used to protect your data transfer task subnets.
         *                          See <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_Ec2Config.html#DataSync-Type-Ec2Config-SecurityGroupArns">SecurityGroupArns</a> .
         *                          <p>
         *                          <em>Pattern</em> : <code>^arn:(aws|aws-cn|aws-us-gov|aws-iso|aws-iso-b):ec2:[a-z\-0-9]*:[0-9]{12}:security-group/.*$</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroupArns(java.util.List<java.lang.String> securityGroupArns) {
            this.securityGroupArns = securityGroupArns;
            return this;
        }

        /**
         * Sets the value of {@link CfnAgentProps#getSubnetArns}
         * @param subnetArns Specifies the ARN of the subnet where your VPC service endpoint is located.
         *                   You can only specify one ARN.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetArns(java.util.List<java.lang.String> subnetArns) {
            this.subnetArns = subnetArns;
            return this;
        }

        /**
         * Sets the value of {@link CfnAgentProps#getTags}
         * @param tags Specifies labels that help you categorize, filter, and search for your AWS resources.
         *             We recommend creating at least one tag for your agent.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnAgentProps#getVpcEndpointId}
         * @param vpcEndpointId The ID of the virtual private cloud (VPC) endpoint that the agent has access to.
         *                      This is the client-side VPC endpoint, powered by AWS PrivateLink . If you don't have an AWS PrivateLink VPC endpoint, see <a href="https://docs.aws.amazon.com//vpc/latest/userguide/endpoint-services-overview.html">AWS PrivateLink and VPC endpoints</a> in the <em>Amazon VPC User Guide</em> .
         *                      <p>
         *                      For more information about activating your agent in a private network based on a VPC, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/datasync-in-vpc.html">Using AWS DataSync in a Virtual Private Cloud</a> in the <em>AWS DataSync User Guide.</em>
         *                      <p>
         *                      A VPC endpoint ID looks like this: <code>vpce-01234d5aff67890e1</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcEndpointId(java.lang.String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAgentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAgentProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAgentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAgentProps {
        private final java.lang.String activationKey;
        private final java.lang.String agentName;
        private final java.util.List<java.lang.String> securityGroupArns;
        private final java.util.List<java.lang.String> subnetArns;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String vpcEndpointId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.activationKey = software.amazon.jsii.Kernel.get(this, "activationKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.agentName = software.amazon.jsii.Kernel.get(this, "agentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.securityGroupArns = software.amazon.jsii.Kernel.get(this, "securityGroupArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.subnetArns = software.amazon.jsii.Kernel.get(this, "subnetArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.vpcEndpointId = software.amazon.jsii.Kernel.get(this, "vpcEndpointId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.activationKey = builder.activationKey;
            this.agentName = builder.agentName;
            this.securityGroupArns = builder.securityGroupArns;
            this.subnetArns = builder.subnetArns;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.vpcEndpointId = builder.vpcEndpointId;
        }

        @Override
        public final java.lang.String getActivationKey() {
            return this.activationKey;
        }

        @Override
        public final java.lang.String getAgentName() {
            return this.agentName;
        }

        @Override
        public final java.util.List<java.lang.String> getSecurityGroupArns() {
            return this.securityGroupArns;
        }

        @Override
        public final java.util.List<java.lang.String> getSubnetArns() {
            return this.subnetArns;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getVpcEndpointId() {
            return this.vpcEndpointId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getActivationKey() != null) {
                data.set("activationKey", om.valueToTree(this.getActivationKey()));
            }
            if (this.getAgentName() != null) {
                data.set("agentName", om.valueToTree(this.getAgentName()));
            }
            if (this.getSecurityGroupArns() != null) {
                data.set("securityGroupArns", om.valueToTree(this.getSecurityGroupArns()));
            }
            if (this.getSubnetArns() != null) {
                data.set("subnetArns", om.valueToTree(this.getSubnetArns()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getVpcEndpointId() != null) {
                data.set("vpcEndpointId", om.valueToTree(this.getVpcEndpointId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datasync.CfnAgentProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAgentProps.Jsii$Proxy that = (CfnAgentProps.Jsii$Proxy) o;

            if (this.activationKey != null ? !this.activationKey.equals(that.activationKey) : that.activationKey != null) return false;
            if (this.agentName != null ? !this.agentName.equals(that.agentName) : that.agentName != null) return false;
            if (this.securityGroupArns != null ? !this.securityGroupArns.equals(that.securityGroupArns) : that.securityGroupArns != null) return false;
            if (this.subnetArns != null ? !this.subnetArns.equals(that.subnetArns) : that.subnetArns != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.vpcEndpointId != null ? this.vpcEndpointId.equals(that.vpcEndpointId) : that.vpcEndpointId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.activationKey != null ? this.activationKey.hashCode() : 0;
            result = 31 * result + (this.agentName != null ? this.agentName.hashCode() : 0);
            result = 31 * result + (this.securityGroupArns != null ? this.securityGroupArns.hashCode() : 0);
            result = 31 * result + (this.subnetArns != null ? this.subnetArns.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.vpcEndpointId != null ? this.vpcEndpointId.hashCode() : 0);
            return result;
        }
    }
}
