package software.amazon.awscdk.services.datasync;

/**
 * Properties for defining a <code>CfnLocationSMB</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.datasync.*;
 * CfnLocationSMBProps cfnLocationSMBProps = CfnLocationSMBProps.builder()
 *         .agentArns(List.of("agentArns"))
 *         // the properties below are optional
 *         .authenticationType("authenticationType")
 *         .dnsIpAddresses(List.of("dnsIpAddresses"))
 *         .domain("domain")
 *         .kerberosKeytab("kerberosKeytab")
 *         .kerberosKrb5Conf("kerberosKrb5Conf")
 *         .kerberosPrincipal("kerberosPrincipal")
 *         .mountOptions(MountOptionsProperty.builder()
 *                 .version("version")
 *                 .build())
 *         .password("password")
 *         .serverHostname("serverHostname")
 *         .subdirectory("subdirectory")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .user("user")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationsmb.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationsmb.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:36.893Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datasync.CfnLocationSMBProps")
@software.amazon.jsii.Jsii.Proxy(CfnLocationSMBProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnLocationSMBProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies the DataSync agent (or agents) that can connect to your SMB file server.
     * <p>
     * You specify an agent by using its Amazon Resource Name (ARN).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationsmb.html#cfn-datasync-locationsmb-agentarns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationsmb.html#cfn-datasync-locationsmb-agentarns</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAgentArns();

    /**
     * Specifies the authentication protocol that DataSync uses to connect to your SMB file server.
     * <p>
     * DataSync supports <code>NTLM</code> (default) and <code>KERBEROS</code> authentication.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-smb-location.html#configuring-smb-permissions">Providing DataSync access to SMB file servers</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationsmb.html#cfn-datasync-locationsmb-authenticationtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationsmb.html#cfn-datasync-locationsmb-authenticationtype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAuthenticationType() {
        return null;
    }

    /**
     * Specifies the IPv4 addresses for the DNS servers that your SMB file server belongs to.
     * <p>
     * This parameter applies only if <code>AuthenticationType</code> is set to <code>KERBEROS</code> .
     * <p>
     * If you have multiple domains in your environment, configuring this parameter makes sure that DataSync connects to the right SMB file server.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationsmb.html#cfn-datasync-locationsmb-dnsipaddresses">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationsmb.html#cfn-datasync-locationsmb-dnsipaddresses</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDnsIpAddresses() {
        return null;
    }

    /**
     * Specifies the Windows domain name that your SMB file server belongs to.
     * <p>
     * This parameter applies only if <code>AuthenticationType</code> is set to <code>NTLM</code> .
     * <p>
     * If you have multiple domains in your environment, configuring this parameter makes sure that DataSync connects to the right file server.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationsmb.html#cfn-datasync-locationsmb-domain">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationsmb.html#cfn-datasync-locationsmb-domain</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDomain() {
        return null;
    }

    /**
     * Specifies your Kerberos key table (keytab) file, which includes mappings between your Kerberos principal and encryption keys.
     * <p>
     * The file must be base64 encoded.
     * <p>
     * To avoid task execution errors, make sure that the Kerberos principal that you use to create the keytab file matches exactly what you specify for <code>KerberosPrincipal</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationsmb.html#cfn-datasync-locationsmb-kerberoskeytab">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationsmb.html#cfn-datasync-locationsmb-kerberoskeytab</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKerberosKeytab() {
        return null;
    }

    /**
     * Specifies a Kerberos configuration file ( <code>krb5.conf</code> ) that defines your Kerberos realm configuration.
     * <p>
     * The file must be base64 encoded.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationsmb.html#cfn-datasync-locationsmb-kerberoskrb5conf">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationsmb.html#cfn-datasync-locationsmb-kerberoskrb5conf</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKerberosKrb5Conf() {
        return null;
    }

    /**
     * Specifies a Kerberos prinicpal, which is an identity in your Kerberos realm that has permission to access the files, folders, and file metadata in your SMB file server.
     * <p>
     * A Kerberos principal might look like <code>HOST/kerberosuser&#64;MYDOMAIN.ORG</code> .
     * <p>
     * Principal names are case sensitive. Your DataSync task execution will fail if the principal that you specify for this parameter doesn’t exactly match the principal that you use to create the keytab file.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationsmb.html#cfn-datasync-locationsmb-kerberosprincipal">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationsmb.html#cfn-datasync-locationsmb-kerberosprincipal</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKerberosPrincipal() {
        return null;
    }

    /**
     * Specifies the version of the SMB protocol that DataSync uses to access your SMB file server.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationsmb.html#cfn-datasync-locationsmb-mountoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationsmb.html#cfn-datasync-locationsmb-mountoptions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMountOptions() {
        return null;
    }

    /**
     * Specifies the password of the user who can mount your SMB file server and has permission to access the files and folders involved in your transfer.
     * <p>
     * This parameter applies only if <code>AuthenticationType</code> is set to <code>NTLM</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationsmb.html#cfn-datasync-locationsmb-password">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationsmb.html#cfn-datasync-locationsmb-password</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPassword() {
        return null;
    }

    /**
     * Specifies the domain name or IP address of the SMB file server that your DataSync agent connects to.
     * <p>
     * Remember the following when configuring this parameter:
     * <p>
     * <ul>
     * <li>You can't specify an IP version 6 (IPv6) address.</li>
     * <li>If you're using Kerberos authentication, you must specify a domain name.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationsmb.html#cfn-datasync-locationsmb-serverhostname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationsmb.html#cfn-datasync-locationsmb-serverhostname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getServerHostname() {
        return null;
    }

    /**
     * Specifies the name of the share exported by your SMB file server where DataSync will read or write data.
     * <p>
     * You can include a subdirectory in the share path (for example, <code>/path/to/subdirectory</code> ). Make sure that other SMB clients in your network can also mount this path.
     * <p>
     * To copy all data in the subdirectory, DataSync must be able to mount the SMB share and access all of its data. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-smb-location.html#configuring-smb-permissions">Providing DataSync access to SMB file servers</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationsmb.html#cfn-datasync-locationsmb-subdirectory">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationsmb.html#cfn-datasync-locationsmb-subdirectory</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSubdirectory() {
        return null;
    }

    /**
     * Specifies labels that help you categorize, filter, and search for your AWS resources.
     * <p>
     * We recommend creating at least a name tag for your location.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationsmb.html#cfn-datasync-locationsmb-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationsmb.html#cfn-datasync-locationsmb-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * Specifies the user that can mount and access the files, folders, and file metadata in your SMB file server.
     * <p>
     * This parameter applies only if <code>AuthenticationType</code> is set to <code>NTLM</code> .
     * <p>
     * For information about choosing a user with the right level of access for your transfer, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-smb-location.html#configuring-smb-permissions">Providing DataSync access to SMB file servers</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationsmb.html#cfn-datasync-locationsmb-user">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationsmb.html#cfn-datasync-locationsmb-user</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getUser() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnLocationSMBProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnLocationSMBProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnLocationSMBProps> {
        java.util.List<java.lang.String> agentArns;
        java.lang.String authenticationType;
        java.util.List<java.lang.String> dnsIpAddresses;
        java.lang.String domain;
        java.lang.String kerberosKeytab;
        java.lang.String kerberosKrb5Conf;
        java.lang.String kerberosPrincipal;
        java.lang.Object mountOptions;
        java.lang.String password;
        java.lang.String serverHostname;
        java.lang.String subdirectory;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String user;

        /**
         * Sets the value of {@link CfnLocationSMBProps#getAgentArns}
         * @param agentArns Specifies the DataSync agent (or agents) that can connect to your SMB file server. This parameter is required.
         *                  You specify an agent by using its Amazon Resource Name (ARN).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder agentArns(java.util.List<java.lang.String> agentArns) {
            this.agentArns = agentArns;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationSMBProps#getAuthenticationType}
         * @param authenticationType Specifies the authentication protocol that DataSync uses to connect to your SMB file server.
         *                           DataSync supports <code>NTLM</code> (default) and <code>KERBEROS</code> authentication.
         *                           <p>
         *                           For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-smb-location.html#configuring-smb-permissions">Providing DataSync access to SMB file servers</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authenticationType(java.lang.String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationSMBProps#getDnsIpAddresses}
         * @param dnsIpAddresses Specifies the IPv4 addresses for the DNS servers that your SMB file server belongs to.
         *                       This parameter applies only if <code>AuthenticationType</code> is set to <code>KERBEROS</code> .
         *                       <p>
         *                       If you have multiple domains in your environment, configuring this parameter makes sure that DataSync connects to the right SMB file server.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dnsIpAddresses(java.util.List<java.lang.String> dnsIpAddresses) {
            this.dnsIpAddresses = dnsIpAddresses;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationSMBProps#getDomain}
         * @param domain Specifies the Windows domain name that your SMB file server belongs to.
         *               This parameter applies only if <code>AuthenticationType</code> is set to <code>NTLM</code> .
         *               <p>
         *               If you have multiple domains in your environment, configuring this parameter makes sure that DataSync connects to the right file server.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domain(java.lang.String domain) {
            this.domain = domain;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationSMBProps#getKerberosKeytab}
         * @param kerberosKeytab Specifies your Kerberos key table (keytab) file, which includes mappings between your Kerberos principal and encryption keys.
         *                       The file must be base64 encoded.
         *                       <p>
         *                       To avoid task execution errors, make sure that the Kerberos principal that you use to create the keytab file matches exactly what you specify for <code>KerberosPrincipal</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kerberosKeytab(java.lang.String kerberosKeytab) {
            this.kerberosKeytab = kerberosKeytab;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationSMBProps#getKerberosKrb5Conf}
         * @param kerberosKrb5Conf Specifies a Kerberos configuration file ( <code>krb5.conf</code> ) that defines your Kerberos realm configuration.
         *                         The file must be base64 encoded.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kerberosKrb5Conf(java.lang.String kerberosKrb5Conf) {
            this.kerberosKrb5Conf = kerberosKrb5Conf;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationSMBProps#getKerberosPrincipal}
         * @param kerberosPrincipal Specifies a Kerberos prinicpal, which is an identity in your Kerberos realm that has permission to access the files, folders, and file metadata in your SMB file server.
         *                          A Kerberos principal might look like <code>HOST/kerberosuser&#64;MYDOMAIN.ORG</code> .
         *                          <p>
         *                          Principal names are case sensitive. Your DataSync task execution will fail if the principal that you specify for this parameter doesn’t exactly match the principal that you use to create the keytab file.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kerberosPrincipal(java.lang.String kerberosPrincipal) {
            this.kerberosPrincipal = kerberosPrincipal;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationSMBProps#getMountOptions}
         * @param mountOptions Specifies the version of the SMB protocol that DataSync uses to access your SMB file server.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mountOptions(software.amazon.awscdk.IResolvable mountOptions) {
            this.mountOptions = mountOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationSMBProps#getMountOptions}
         * @param mountOptions Specifies the version of the SMB protocol that DataSync uses to access your SMB file server.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mountOptions(software.amazon.awscdk.services.datasync.CfnLocationSMB.MountOptionsProperty mountOptions) {
            this.mountOptions = mountOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationSMBProps#getPassword}
         * @param password Specifies the password of the user who can mount your SMB file server and has permission to access the files and folders involved in your transfer.
         *                 This parameter applies only if <code>AuthenticationType</code> is set to <code>NTLM</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder password(java.lang.String password) {
            this.password = password;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationSMBProps#getServerHostname}
         * @param serverHostname Specifies the domain name or IP address of the SMB file server that your DataSync agent connects to.
         *                       Remember the following when configuring this parameter:
         *                       <p>
         *                       <ul>
         *                       <li>You can't specify an IP version 6 (IPv6) address.</li>
         *                       <li>If you're using Kerberos authentication, you must specify a domain name.</li>
         *                       </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverHostname(java.lang.String serverHostname) {
            this.serverHostname = serverHostname;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationSMBProps#getSubdirectory}
         * @param subdirectory Specifies the name of the share exported by your SMB file server where DataSync will read or write data.
         *                     You can include a subdirectory in the share path (for example, <code>/path/to/subdirectory</code> ). Make sure that other SMB clients in your network can also mount this path.
         *                     <p>
         *                     To copy all data in the subdirectory, DataSync must be able to mount the SMB share and access all of its data. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-smb-location.html#configuring-smb-permissions">Providing DataSync access to SMB file servers</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subdirectory(java.lang.String subdirectory) {
            this.subdirectory = subdirectory;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationSMBProps#getTags}
         * @param tags Specifies labels that help you categorize, filter, and search for your AWS resources.
         *             We recommend creating at least a name tag for your location.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationSMBProps#getUser}
         * @param user Specifies the user that can mount and access the files, folders, and file metadata in your SMB file server.
         *             This parameter applies only if <code>AuthenticationType</code> is set to <code>NTLM</code> .
         *             <p>
         *             For information about choosing a user with the right level of access for your transfer, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-smb-location.html#configuring-smb-permissions">Providing DataSync access to SMB file servers</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder user(java.lang.String user) {
            this.user = user;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnLocationSMBProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnLocationSMBProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnLocationSMBProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnLocationSMBProps {
        private final java.util.List<java.lang.String> agentArns;
        private final java.lang.String authenticationType;
        private final java.util.List<java.lang.String> dnsIpAddresses;
        private final java.lang.String domain;
        private final java.lang.String kerberosKeytab;
        private final java.lang.String kerberosKrb5Conf;
        private final java.lang.String kerberosPrincipal;
        private final java.lang.Object mountOptions;
        private final java.lang.String password;
        private final java.lang.String serverHostname;
        private final java.lang.String subdirectory;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String user;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.agentArns = software.amazon.jsii.Kernel.get(this, "agentArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.authenticationType = software.amazon.jsii.Kernel.get(this, "authenticationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dnsIpAddresses = software.amazon.jsii.Kernel.get(this, "dnsIpAddresses", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.domain = software.amazon.jsii.Kernel.get(this, "domain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.kerberosKeytab = software.amazon.jsii.Kernel.get(this, "kerberosKeytab", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.kerberosKrb5Conf = software.amazon.jsii.Kernel.get(this, "kerberosKrb5Conf", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.kerberosPrincipal = software.amazon.jsii.Kernel.get(this, "kerberosPrincipal", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.mountOptions = software.amazon.jsii.Kernel.get(this, "mountOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.password = software.amazon.jsii.Kernel.get(this, "password", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serverHostname = software.amazon.jsii.Kernel.get(this, "serverHostname", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.subdirectory = software.amazon.jsii.Kernel.get(this, "subdirectory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.user = software.amazon.jsii.Kernel.get(this, "user", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.agentArns = java.util.Objects.requireNonNull(builder.agentArns, "agentArns is required");
            this.authenticationType = builder.authenticationType;
            this.dnsIpAddresses = builder.dnsIpAddresses;
            this.domain = builder.domain;
            this.kerberosKeytab = builder.kerberosKeytab;
            this.kerberosKrb5Conf = builder.kerberosKrb5Conf;
            this.kerberosPrincipal = builder.kerberosPrincipal;
            this.mountOptions = builder.mountOptions;
            this.password = builder.password;
            this.serverHostname = builder.serverHostname;
            this.subdirectory = builder.subdirectory;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.user = builder.user;
        }

        @Override
        public final java.util.List<java.lang.String> getAgentArns() {
            return this.agentArns;
        }

        @Override
        public final java.lang.String getAuthenticationType() {
            return this.authenticationType;
        }

        @Override
        public final java.util.List<java.lang.String> getDnsIpAddresses() {
            return this.dnsIpAddresses;
        }

        @Override
        public final java.lang.String getDomain() {
            return this.domain;
        }

        @Override
        public final java.lang.String getKerberosKeytab() {
            return this.kerberosKeytab;
        }

        @Override
        public final java.lang.String getKerberosKrb5Conf() {
            return this.kerberosKrb5Conf;
        }

        @Override
        public final java.lang.String getKerberosPrincipal() {
            return this.kerberosPrincipal;
        }

        @Override
        public final java.lang.Object getMountOptions() {
            return this.mountOptions;
        }

        @Override
        public final java.lang.String getPassword() {
            return this.password;
        }

        @Override
        public final java.lang.String getServerHostname() {
            return this.serverHostname;
        }

        @Override
        public final java.lang.String getSubdirectory() {
            return this.subdirectory;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getUser() {
            return this.user;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("agentArns", om.valueToTree(this.getAgentArns()));
            if (this.getAuthenticationType() != null) {
                data.set("authenticationType", om.valueToTree(this.getAuthenticationType()));
            }
            if (this.getDnsIpAddresses() != null) {
                data.set("dnsIpAddresses", om.valueToTree(this.getDnsIpAddresses()));
            }
            if (this.getDomain() != null) {
                data.set("domain", om.valueToTree(this.getDomain()));
            }
            if (this.getKerberosKeytab() != null) {
                data.set("kerberosKeytab", om.valueToTree(this.getKerberosKeytab()));
            }
            if (this.getKerberosKrb5Conf() != null) {
                data.set("kerberosKrb5Conf", om.valueToTree(this.getKerberosKrb5Conf()));
            }
            if (this.getKerberosPrincipal() != null) {
                data.set("kerberosPrincipal", om.valueToTree(this.getKerberosPrincipal()));
            }
            if (this.getMountOptions() != null) {
                data.set("mountOptions", om.valueToTree(this.getMountOptions()));
            }
            if (this.getPassword() != null) {
                data.set("password", om.valueToTree(this.getPassword()));
            }
            if (this.getServerHostname() != null) {
                data.set("serverHostname", om.valueToTree(this.getServerHostname()));
            }
            if (this.getSubdirectory() != null) {
                data.set("subdirectory", om.valueToTree(this.getSubdirectory()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getUser() != null) {
                data.set("user", om.valueToTree(this.getUser()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datasync.CfnLocationSMBProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnLocationSMBProps.Jsii$Proxy that = (CfnLocationSMBProps.Jsii$Proxy) o;

            if (!agentArns.equals(that.agentArns)) return false;
            if (this.authenticationType != null ? !this.authenticationType.equals(that.authenticationType) : that.authenticationType != null) return false;
            if (this.dnsIpAddresses != null ? !this.dnsIpAddresses.equals(that.dnsIpAddresses) : that.dnsIpAddresses != null) return false;
            if (this.domain != null ? !this.domain.equals(that.domain) : that.domain != null) return false;
            if (this.kerberosKeytab != null ? !this.kerberosKeytab.equals(that.kerberosKeytab) : that.kerberosKeytab != null) return false;
            if (this.kerberosKrb5Conf != null ? !this.kerberosKrb5Conf.equals(that.kerberosKrb5Conf) : that.kerberosKrb5Conf != null) return false;
            if (this.kerberosPrincipal != null ? !this.kerberosPrincipal.equals(that.kerberosPrincipal) : that.kerberosPrincipal != null) return false;
            if (this.mountOptions != null ? !this.mountOptions.equals(that.mountOptions) : that.mountOptions != null) return false;
            if (this.password != null ? !this.password.equals(that.password) : that.password != null) return false;
            if (this.serverHostname != null ? !this.serverHostname.equals(that.serverHostname) : that.serverHostname != null) return false;
            if (this.subdirectory != null ? !this.subdirectory.equals(that.subdirectory) : that.subdirectory != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.user != null ? this.user.equals(that.user) : that.user == null;
        }

        @Override
        public final int hashCode() {
            int result = this.agentArns.hashCode();
            result = 31 * result + (this.authenticationType != null ? this.authenticationType.hashCode() : 0);
            result = 31 * result + (this.dnsIpAddresses != null ? this.dnsIpAddresses.hashCode() : 0);
            result = 31 * result + (this.domain != null ? this.domain.hashCode() : 0);
            result = 31 * result + (this.kerberosKeytab != null ? this.kerberosKeytab.hashCode() : 0);
            result = 31 * result + (this.kerberosKrb5Conf != null ? this.kerberosKrb5Conf.hashCode() : 0);
            result = 31 * result + (this.kerberosPrincipal != null ? this.kerberosPrincipal.hashCode() : 0);
            result = 31 * result + (this.mountOptions != null ? this.mountOptions.hashCode() : 0);
            result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
            result = 31 * result + (this.serverHostname != null ? this.serverHostname.hashCode() : 0);
            result = 31 * result + (this.subdirectory != null ? this.subdirectory.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
            return result;
        }
    }
}
