package software.amazon.awscdk.services.datazone;

/**
 * Properties for defining a <code>CfnConnection</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.datazone.*;
 * CfnConnectionProps cfnConnectionProps = CfnConnectionProps.builder()
 *         .domainIdentifier("domainIdentifier")
 *         .environmentIdentifier("environmentIdentifier")
 *         .name("name")
 *         // the properties below are optional
 *         .awsLocation(AwsLocationProperty.builder()
 *                 .accessRole("accessRole")
 *                 .awsAccountId("awsAccountId")
 *                 .awsRegion("awsRegion")
 *                 .iamConnectionId("iamConnectionId")
 *                 .build())
 *         .description("description")
 *         .props(ConnectionPropertiesInputProperty.builder()
 *                 .athenaProperties(AthenaPropertiesInputProperty.builder()
 *                         .workgroupName("workgroupName")
 *                         .build())
 *                 .glueProperties(GluePropertiesInputProperty.builder()
 *                         .glueConnectionInput(GlueConnectionInputProperty.builder()
 *                                 .athenaProperties(Map.of(
 *                                         "athenaPropertiesKey", "athenaProperties"))
 *                                 .authenticationConfiguration(AuthenticationConfigurationInputProperty.builder()
 *                                         .authenticationType("authenticationType")
 *                                         .basicAuthenticationCredentials(BasicAuthenticationCredentialsProperty.builder()
 *                                                 .password("password")
 *                                                 .userName("userName")
 *                                                 .build())
 *                                         .customAuthenticationCredentials(Map.of(
 *                                                 "customAuthenticationCredentialsKey", "customAuthenticationCredentials"))
 *                                         .kmsKeyArn("kmsKeyArn")
 *                                         .oAuth2Properties(OAuth2PropertiesProperty.builder()
 *                                                 .authorizationCodeProperties(AuthorizationCodePropertiesProperty.builder()
 *                                                         .authorizationCode("authorizationCode")
 *                                                         .redirectUri("redirectUri")
 *                                                         .build())
 *                                                 .oAuth2ClientApplication(OAuth2ClientApplicationProperty.builder()
 *                                                         .awsManagedClientApplicationReference("awsManagedClientApplicationReference")
 *                                                         .userManagedClientApplicationClientId("userManagedClientApplicationClientId")
 *                                                         .build())
 *                                                 .oAuth2Credentials(GlueOAuth2CredentialsProperty.builder()
 *                                                         .accessToken("accessToken")
 *                                                         .jwtToken("jwtToken")
 *                                                         .refreshToken("refreshToken")
 *                                                         .userManagedClientApplicationClientSecret("userManagedClientApplicationClientSecret")
 *                                                         .build())
 *                                                 .oAuth2GrantType("oAuth2GrantType")
 *                                                 .tokenUrl("tokenUrl")
 *                                                 .tokenUrlParametersMap(Map.of(
 *                                                         "tokenUrlParametersMapKey", "tokenUrlParametersMap"))
 *                                                 .build())
 *                                         .secretArn("secretArn")
 *                                         .build())
 *                                 .connectionProperties(Map.of(
 *                                         "connectionPropertiesKey", "connectionProperties"))
 *                                 .connectionType("connectionType")
 *                                 .description("description")
 *                                 .matchCriteria("matchCriteria")
 *                                 .name("name")
 *                                 .physicalConnectionRequirements(PhysicalConnectionRequirementsProperty.builder()
 *                                         .availabilityZone("availabilityZone")
 *                                         .securityGroupIdList(List.of("securityGroupIdList"))
 *                                         .subnetId("subnetId")
 *                                         .subnetIdList(List.of("subnetIdList"))
 *                                         .build())
 *                                 .pythonProperties(Map.of(
 *                                         "pythonPropertiesKey", "pythonProperties"))
 *                                 .sparkProperties(Map.of(
 *                                         "sparkPropertiesKey", "sparkProperties"))
 *                                 .validateCredentials(false)
 *                                 .validateForComputeEnvironments(List.of("validateForComputeEnvironments"))
 *                                 .build())
 *                         .build())
 *                 .hyperPodProperties(HyperPodPropertiesInputProperty.builder()
 *                         .clusterName("clusterName")
 *                         .build())
 *                 .iamProperties(IamPropertiesInputProperty.builder()
 *                         .glueLineageSyncEnabled(false)
 *                         .build())
 *                 .redshiftProperties(RedshiftPropertiesInputProperty.builder()
 *                         .credentials(RedshiftCredentialsProperty.builder()
 *                                 .secretArn("secretArn")
 *                                 .usernamePassword(UsernamePasswordProperty.builder()
 *                                         .password("password")
 *                                         .username("username")
 *                                         .build())
 *                                 .build())
 *                         .databaseName("databaseName")
 *                         .host("host")
 *                         .lineageSync(RedshiftLineageSyncConfigurationInputProperty.builder()
 *                                 .enabled(false)
 *                                 .schedule(LineageSyncScheduleProperty.builder()
 *                                         .schedule("schedule")
 *                                         .build())
 *                                 .build())
 *                         .port(123)
 *                         .storage(RedshiftStoragePropertiesProperty.builder()
 *                                 .clusterName("clusterName")
 *                                 .workgroupName("workgroupName")
 *                                 .build())
 *                         .build())
 *                 .sparkEmrProperties(SparkEmrPropertiesInputProperty.builder()
 *                         .computeArn("computeArn")
 *                         .instanceProfileArn("instanceProfileArn")
 *                         .javaVirtualEnv("javaVirtualEnv")
 *                         .logUri("logUri")
 *                         .pythonVirtualEnv("pythonVirtualEnv")
 *                         .runtimeRole("runtimeRole")
 *                         .trustedCertificatesS3Uri("trustedCertificatesS3Uri")
 *                         .build())
 *                 .sparkGlueProperties(SparkGluePropertiesInputProperty.builder()
 *                         .additionalArgs(SparkGlueArgsProperty.builder()
 *                                 .connection("connection")
 *                                 .build())
 *                         .glueConnectionName("glueConnectionName")
 *                         .glueVersion("glueVersion")
 *                         .idleTimeout(123)
 *                         .javaVirtualEnv("javaVirtualEnv")
 *                         .numberOfWorkers(123)
 *                         .pythonVirtualEnv("pythonVirtualEnv")
 *                         .workerType("workerType")
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-connection.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-connection.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:36.935Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datazone.CfnConnectionProps")
@software.amazon.jsii.Jsii.Proxy(CfnConnectionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnConnectionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the domain where the connection is created.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-connection.html#cfn-datazone-connection-domainidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-connection.html#cfn-datazone-connection-domainidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDomainIdentifier();

    /**
     * The ID of the environment where the connection is created.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-connection.html#cfn-datazone-connection-environmentidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-connection.html#cfn-datazone-connection-environmentidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEnvironmentIdentifier();

    /**
     * The name of the connection.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-connection.html#cfn-datazone-connection-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-connection.html#cfn-datazone-connection-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The location where the connection is created.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-connection.html#cfn-datazone-connection-awslocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-connection.html#cfn-datazone-connection-awslocation</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAwsLocation() {
        return null;
    }

    /**
     * Connection description.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-connection.html#cfn-datazone-connection-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-connection.html#cfn-datazone-connection-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Connection props.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-connection.html#cfn-datazone-connection-props">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datazone-connection.html#cfn-datazone-connection-props</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getProps() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnConnectionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnConnectionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnConnectionProps> {
        java.lang.String domainIdentifier;
        java.lang.String environmentIdentifier;
        java.lang.String name;
        java.lang.Object awsLocation;
        java.lang.String description;
        java.lang.Object props;

        /**
         * Sets the value of {@link CfnConnectionProps#getDomainIdentifier}
         * @param domainIdentifier The ID of the domain where the connection is created. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainIdentifier(java.lang.String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectionProps#getEnvironmentIdentifier}
         * @param environmentIdentifier The ID of the environment where the connection is created. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentIdentifier(java.lang.String environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectionProps#getName}
         * @param name The name of the connection. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectionProps#getAwsLocation}
         * @param awsLocation The location where the connection is created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder awsLocation(software.amazon.awscdk.IResolvable awsLocation) {
            this.awsLocation = awsLocation;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectionProps#getAwsLocation}
         * @param awsLocation The location where the connection is created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder awsLocation(software.amazon.awscdk.services.datazone.CfnConnection.AwsLocationProperty awsLocation) {
            this.awsLocation = awsLocation;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectionProps#getDescription}
         * @param description Connection description.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectionProps#getProps}
         * @param props Connection props.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder props(software.amazon.awscdk.IResolvable props) {
            this.props = props;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectionProps#getProps}
         * @param props Connection props.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder props(software.amazon.awscdk.services.datazone.CfnConnection.ConnectionPropertiesInputProperty props) {
            this.props = props;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnConnectionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnConnectionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnConnectionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnConnectionProps {
        private final java.lang.String domainIdentifier;
        private final java.lang.String environmentIdentifier;
        private final java.lang.String name;
        private final java.lang.Object awsLocation;
        private final java.lang.String description;
        private final java.lang.Object props;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.domainIdentifier = software.amazon.jsii.Kernel.get(this, "domainIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.environmentIdentifier = software.amazon.jsii.Kernel.get(this, "environmentIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.awsLocation = software.amazon.jsii.Kernel.get(this, "awsLocation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.props = software.amazon.jsii.Kernel.get(this, "props", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.domainIdentifier = java.util.Objects.requireNonNull(builder.domainIdentifier, "domainIdentifier is required");
            this.environmentIdentifier = java.util.Objects.requireNonNull(builder.environmentIdentifier, "environmentIdentifier is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.awsLocation = builder.awsLocation;
            this.description = builder.description;
            this.props = builder.props;
        }

        @Override
        public final java.lang.String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        @Override
        public final java.lang.String getEnvironmentIdentifier() {
            return this.environmentIdentifier;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getAwsLocation() {
            return this.awsLocation;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getProps() {
            return this.props;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("domainIdentifier", om.valueToTree(this.getDomainIdentifier()));
            data.set("environmentIdentifier", om.valueToTree(this.getEnvironmentIdentifier()));
            data.set("name", om.valueToTree(this.getName()));
            if (this.getAwsLocation() != null) {
                data.set("awsLocation", om.valueToTree(this.getAwsLocation()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getProps() != null) {
                data.set("props", om.valueToTree(this.getProps()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datazone.CfnConnectionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnConnectionProps.Jsii$Proxy that = (CfnConnectionProps.Jsii$Proxy) o;

            if (!domainIdentifier.equals(that.domainIdentifier)) return false;
            if (!environmentIdentifier.equals(that.environmentIdentifier)) return false;
            if (!name.equals(that.name)) return false;
            if (this.awsLocation != null ? !this.awsLocation.equals(that.awsLocation) : that.awsLocation != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            return this.props != null ? this.props.equals(that.props) : that.props == null;
        }

        @Override
        public final int hashCode() {
            int result = this.domainIdentifier.hashCode();
            result = 31 * result + (this.environmentIdentifier.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.awsLocation != null ? this.awsLocation.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.props != null ? this.props.hashCode() : 0);
            return result;
        }
    }
}
