package software.amazon.awscdk.services.dms;

/**
 * This object provides information about a AWS DMS data migration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.dms.*;
 * CfnDataMigration cfnDataMigration = CfnDataMigration.Builder.create(this, "MyCfnDataMigration")
 *         .dataMigrationType("dataMigrationType")
 *         .migrationProjectIdentifier("migrationProjectIdentifier")
 *         .serviceAccessRoleArn("serviceAccessRoleArn")
 *         // the properties below are optional
 *         .dataMigrationIdentifier("dataMigrationIdentifier")
 *         .dataMigrationName("dataMigrationName")
 *         .dataMigrationSettings(DataMigrationSettingsProperty.builder()
 *                 .cloudwatchLogsEnabled(false)
 *                 .numberOfJobs(123)
 *                 .selectionRules("selectionRules")
 *                 .build())
 *         .sourceDataSettings(List.of(SourceDataSettingsProperty.builder()
 *                 .cdcStartPosition("cdcStartPosition")
 *                 .cdcStartTime("cdcStartTime")
 *                 .cdcStopTime("cdcStopTime")
 *                 .slotName("slotName")
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-datamigration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-datamigration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:37.096Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnDataMigration")
public class CfnDataMigration extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnDataMigration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDataMigration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.dms.CfnDataMigration.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDataMigration(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dms.CfnDataMigrationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) that identifies this replication.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDataMigrationArn() {
        return software.amazon.jsii.Kernel.get(this, "attrDataMigrationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The UTC time when DMS created the data migration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDataMigrationCreateTime() {
        return software.amazon.jsii.Kernel.get(this, "attrDataMigrationCreateTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Specifies whether the data migration is full-load only, change data capture (CDC) only, or full-load and CDC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDataMigrationType() {
        return software.amazon.jsii.Kernel.get(this, "dataMigrationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies whether the data migration is full-load only, change data capture (CDC) only, or full-load and CDC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataMigrationType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dataMigrationType", java.util.Objects.requireNonNull(value, "dataMigrationType is required"));
    }

    /**
     * The property describes an identifier for the migration project.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getMigrationProjectIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "migrationProjectIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The property describes an identifier for the migration project.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMigrationProjectIdentifier(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "migrationProjectIdentifier", java.util.Objects.requireNonNull(value, "migrationProjectIdentifier is required"));
    }

    /**
     * The IAM role that the data migration uses to access AWS resources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getServiceAccessRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "serviceAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The IAM role that the data migration uses to access AWS resources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServiceAccessRoleArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "serviceAccessRoleArn", java.util.Objects.requireNonNull(value, "serviceAccessRoleArn is required"));
    }

    /**
     * The property describes an ARN of the data migration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDataMigrationIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "dataMigrationIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The property describes an ARN of the data migration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataMigrationIdentifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dataMigrationIdentifier", value);
    }

    /**
     * The user-friendly name for the data migration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDataMigrationName() {
        return software.amazon.jsii.Kernel.get(this, "dataMigrationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The user-friendly name for the data migration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataMigrationName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dataMigrationName", value);
    }

    /**
     * Specifies CloudWatch settings and selection rules for the data migration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDataMigrationSettings() {
        return software.amazon.jsii.Kernel.get(this, "dataMigrationSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies CloudWatch settings and selection rules for the data migration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataMigrationSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "dataMigrationSettings", value);
    }

    /**
     * Specifies CloudWatch settings and selection rules for the data migration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataMigrationSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dms.CfnDataMigration.DataMigrationSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "dataMigrationSettings", value);
    }

    /**
     * Specifies information about the data migration's source data provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSourceDataSettings() {
        return software.amazon.jsii.Kernel.get(this, "sourceDataSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies information about the data migration's source data provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceDataSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "sourceDataSettings", value);
    }

    /**
     * Specifies information about the data migration's source data provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceDataSettings(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.dms.CfnDataMigration.SourceDataSettingsProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.dms.CfnDataMigration.SourceDataSettingsProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "sourceDataSettings", value);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * Options for configuring a data migration, including whether to enable CloudWatch logs, and the selection rules to use to include or exclude database objects from the migration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * DataMigrationSettingsProperty dataMigrationSettingsProperty = DataMigrationSettingsProperty.builder()
     *         .cloudwatchLogsEnabled(false)
     *         .numberOfJobs(123)
     *         .selectionRules("selectionRules")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-datamigration-datamigrationsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-datamigration-datamigrationsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnDataMigration.DataMigrationSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(DataMigrationSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataMigrationSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Whether to enable CloudWatch logging for the data migration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-datamigration-datamigrationsettings.html#cfn-dms-datamigration-datamigrationsettings-cloudwatchlogsenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-datamigration-datamigrationsettings.html#cfn-dms-datamigration-datamigrationsettings-cloudwatchlogsenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCloudwatchLogsEnabled() {
            return null;
        }

        /**
         * The number of parallel jobs that trigger parallel threads to unload the tables from the source, and then load them to the target.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-datamigration-datamigrationsettings.html#cfn-dms-datamigration-datamigrationsettings-numberofjobs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-datamigration-datamigrationsettings.html#cfn-dms-datamigration-datamigrationsettings-numberofjobs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getNumberOfJobs() {
            return null;
        }

        /**
         * A JSON-formatted string that defines what objects to include and exclude from the migration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-datamigration-datamigrationsettings.html#cfn-dms-datamigration-datamigrationsettings-selectionrules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-datamigration-datamigrationsettings.html#cfn-dms-datamigration-datamigrationsettings-selectionrules</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSelectionRules() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataMigrationSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataMigrationSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataMigrationSettingsProperty> {
            java.lang.Object cloudwatchLogsEnabled;
            java.lang.Number numberOfJobs;
            java.lang.String selectionRules;

            /**
             * Sets the value of {@link DataMigrationSettingsProperty#getCloudwatchLogsEnabled}
             * @param cloudwatchLogsEnabled Whether to enable CloudWatch logging for the data migration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudwatchLogsEnabled(java.lang.Boolean cloudwatchLogsEnabled) {
                this.cloudwatchLogsEnabled = cloudwatchLogsEnabled;
                return this;
            }

            /**
             * Sets the value of {@link DataMigrationSettingsProperty#getCloudwatchLogsEnabled}
             * @param cloudwatchLogsEnabled Whether to enable CloudWatch logging for the data migration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudwatchLogsEnabled(software.amazon.awscdk.IResolvable cloudwatchLogsEnabled) {
                this.cloudwatchLogsEnabled = cloudwatchLogsEnabled;
                return this;
            }

            /**
             * Sets the value of {@link DataMigrationSettingsProperty#getNumberOfJobs}
             * @param numberOfJobs The number of parallel jobs that trigger parallel threads to unload the tables from the source, and then load them to the target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder numberOfJobs(java.lang.Number numberOfJobs) {
                this.numberOfJobs = numberOfJobs;
                return this;
            }

            /**
             * Sets the value of {@link DataMigrationSettingsProperty#getSelectionRules}
             * @param selectionRules A JSON-formatted string that defines what objects to include and exclude from the migration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder selectionRules(java.lang.String selectionRules) {
                this.selectionRules = selectionRules;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataMigrationSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataMigrationSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataMigrationSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataMigrationSettingsProperty {
            private final java.lang.Object cloudwatchLogsEnabled;
            private final java.lang.Number numberOfJobs;
            private final java.lang.String selectionRules;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cloudwatchLogsEnabled = software.amazon.jsii.Kernel.get(this, "cloudwatchLogsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.numberOfJobs = software.amazon.jsii.Kernel.get(this, "numberOfJobs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.selectionRules = software.amazon.jsii.Kernel.get(this, "selectionRules", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cloudwatchLogsEnabled = builder.cloudwatchLogsEnabled;
                this.numberOfJobs = builder.numberOfJobs;
                this.selectionRules = builder.selectionRules;
            }

            @Override
            public final java.lang.Object getCloudwatchLogsEnabled() {
                return this.cloudwatchLogsEnabled;
            }

            @Override
            public final java.lang.Number getNumberOfJobs() {
                return this.numberOfJobs;
            }

            @Override
            public final java.lang.String getSelectionRules() {
                return this.selectionRules;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCloudwatchLogsEnabled() != null) {
                    data.set("cloudwatchLogsEnabled", om.valueToTree(this.getCloudwatchLogsEnabled()));
                }
                if (this.getNumberOfJobs() != null) {
                    data.set("numberOfJobs", om.valueToTree(this.getNumberOfJobs()));
                }
                if (this.getSelectionRules() != null) {
                    data.set("selectionRules", om.valueToTree(this.getSelectionRules()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dms.CfnDataMigration.DataMigrationSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataMigrationSettingsProperty.Jsii$Proxy that = (DataMigrationSettingsProperty.Jsii$Proxy) o;

                if (this.cloudwatchLogsEnabled != null ? !this.cloudwatchLogsEnabled.equals(that.cloudwatchLogsEnabled) : that.cloudwatchLogsEnabled != null) return false;
                if (this.numberOfJobs != null ? !this.numberOfJobs.equals(that.numberOfJobs) : that.numberOfJobs != null) return false;
                return this.selectionRules != null ? this.selectionRules.equals(that.selectionRules) : that.selectionRules == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cloudwatchLogsEnabled != null ? this.cloudwatchLogsEnabled.hashCode() : 0;
                result = 31 * result + (this.numberOfJobs != null ? this.numberOfJobs.hashCode() : 0);
                result = 31 * result + (this.selectionRules != null ? this.selectionRules.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.dms.*;
     * SourceDataSettingsProperty sourceDataSettingsProperty = SourceDataSettingsProperty.builder()
     *         .cdcStartPosition("cdcStartPosition")
     *         .cdcStartTime("cdcStartTime")
     *         .cdcStopTime("cdcStopTime")
     *         .slotName("slotName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-datamigration-sourcedatasettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-datamigration-sourcedatasettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dms.CfnDataMigration.SourceDataSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(SourceDataSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SourceDataSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The property is a point in the database engine's log that defines a time where you can begin CDC.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-datamigration-sourcedatasettings.html#cfn-dms-datamigration-sourcedatasettings-cdcstartposition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-datamigration-sourcedatasettings.html#cfn-dms-datamigration-sourcedatasettings-cdcstartposition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCdcStartPosition() {
            return null;
        }

        /**
         * The property indicates the start time for a change data capture (CDC) operation.
         * <p>
         * The value is server time in UTC format.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-datamigration-sourcedatasettings.html#cfn-dms-datamigration-sourcedatasettings-cdcstarttime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-datamigration-sourcedatasettings.html#cfn-dms-datamigration-sourcedatasettings-cdcstarttime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCdcStartTime() {
            return null;
        }

        /**
         * The property indicates the stop time for a change data capture (CDC) operation.
         * <p>
         * The value is server time in UTC format.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-datamigration-sourcedatasettings.html#cfn-dms-datamigration-sourcedatasettings-cdcstoptime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-datamigration-sourcedatasettings.html#cfn-dms-datamigration-sourcedatasettings-cdcstoptime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCdcStopTime() {
            return null;
        }

        /**
         * The property sets the name of a previously created logical replication slot for a change data capture (CDC) load of the source instance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-datamigration-sourcedatasettings.html#cfn-dms-datamigration-sourcedatasettings-slotname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-datamigration-sourcedatasettings.html#cfn-dms-datamigration-sourcedatasettings-slotname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSlotName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SourceDataSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SourceDataSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SourceDataSettingsProperty> {
            java.lang.String cdcStartPosition;
            java.lang.String cdcStartTime;
            java.lang.String cdcStopTime;
            java.lang.String slotName;

            /**
             * Sets the value of {@link SourceDataSettingsProperty#getCdcStartPosition}
             * @param cdcStartPosition The property is a point in the database engine's log that defines a time where you can begin CDC.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cdcStartPosition(java.lang.String cdcStartPosition) {
                this.cdcStartPosition = cdcStartPosition;
                return this;
            }

            /**
             * Sets the value of {@link SourceDataSettingsProperty#getCdcStartTime}
             * @param cdcStartTime The property indicates the start time for a change data capture (CDC) operation.
             *                     The value is server time in UTC format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cdcStartTime(java.lang.String cdcStartTime) {
                this.cdcStartTime = cdcStartTime;
                return this;
            }

            /**
             * Sets the value of {@link SourceDataSettingsProperty#getCdcStopTime}
             * @param cdcStopTime The property indicates the stop time for a change data capture (CDC) operation.
             *                    The value is server time in UTC format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cdcStopTime(java.lang.String cdcStopTime) {
                this.cdcStopTime = cdcStopTime;
                return this;
            }

            /**
             * Sets the value of {@link SourceDataSettingsProperty#getSlotName}
             * @param slotName The property sets the name of a previously created logical replication slot for a change data capture (CDC) load of the source instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder slotName(java.lang.String slotName) {
                this.slotName = slotName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceDataSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SourceDataSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SourceDataSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceDataSettingsProperty {
            private final java.lang.String cdcStartPosition;
            private final java.lang.String cdcStartTime;
            private final java.lang.String cdcStopTime;
            private final java.lang.String slotName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cdcStartPosition = software.amazon.jsii.Kernel.get(this, "cdcStartPosition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.cdcStartTime = software.amazon.jsii.Kernel.get(this, "cdcStartTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.cdcStopTime = software.amazon.jsii.Kernel.get(this, "cdcStopTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.slotName = software.amazon.jsii.Kernel.get(this, "slotName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cdcStartPosition = builder.cdcStartPosition;
                this.cdcStartTime = builder.cdcStartTime;
                this.cdcStopTime = builder.cdcStopTime;
                this.slotName = builder.slotName;
            }

            @Override
            public final java.lang.String getCdcStartPosition() {
                return this.cdcStartPosition;
            }

            @Override
            public final java.lang.String getCdcStartTime() {
                return this.cdcStartTime;
            }

            @Override
            public final java.lang.String getCdcStopTime() {
                return this.cdcStopTime;
            }

            @Override
            public final java.lang.String getSlotName() {
                return this.slotName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCdcStartPosition() != null) {
                    data.set("cdcStartPosition", om.valueToTree(this.getCdcStartPosition()));
                }
                if (this.getCdcStartTime() != null) {
                    data.set("cdcStartTime", om.valueToTree(this.getCdcStartTime()));
                }
                if (this.getCdcStopTime() != null) {
                    data.set("cdcStopTime", om.valueToTree(this.getCdcStopTime()));
                }
                if (this.getSlotName() != null) {
                    data.set("slotName", om.valueToTree(this.getSlotName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dms.CfnDataMigration.SourceDataSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SourceDataSettingsProperty.Jsii$Proxy that = (SourceDataSettingsProperty.Jsii$Proxy) o;

                if (this.cdcStartPosition != null ? !this.cdcStartPosition.equals(that.cdcStartPosition) : that.cdcStartPosition != null) return false;
                if (this.cdcStartTime != null ? !this.cdcStartTime.equals(that.cdcStartTime) : that.cdcStartTime != null) return false;
                if (this.cdcStopTime != null ? !this.cdcStopTime.equals(that.cdcStopTime) : that.cdcStopTime != null) return false;
                return this.slotName != null ? this.slotName.equals(that.slotName) : that.slotName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cdcStartPosition != null ? this.cdcStartPosition.hashCode() : 0;
                result = 31 * result + (this.cdcStartTime != null ? this.cdcStartTime.hashCode() : 0);
                result = 31 * result + (this.cdcStopTime != null ? this.cdcStopTime.hashCode() : 0);
                result = 31 * result + (this.slotName != null ? this.slotName.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.dms.CfnDataMigration}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.dms.CfnDataMigration> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.dms.CfnDataMigrationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.dms.CfnDataMigrationProps.Builder();
        }

        /**
         * Specifies whether the data migration is full-load only, change data capture (CDC) only, or full-load and CDC.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-datamigration.html#cfn-dms-datamigration-datamigrationtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-datamigration.html#cfn-dms-datamigration-datamigrationtype</a>
         * @param dataMigrationType Specifies whether the data migration is full-load only, change data capture (CDC) only, or full-load and CDC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataMigrationType(final java.lang.String dataMigrationType) {
            this.props.dataMigrationType(dataMigrationType);
            return this;
        }

        /**
         * The property describes an identifier for the migration project.
         * <p>
         * It is used for describing/deleting/modifying can be name/arn
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-datamigration.html#cfn-dms-datamigration-migrationprojectidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-datamigration.html#cfn-dms-datamigration-migrationprojectidentifier</a>
         * @param migrationProjectIdentifier The property describes an identifier for the migration project. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder migrationProjectIdentifier(final java.lang.String migrationProjectIdentifier) {
            this.props.migrationProjectIdentifier(migrationProjectIdentifier);
            return this;
        }

        /**
         * The IAM role that the data migration uses to access AWS resources.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-datamigration.html#cfn-dms-datamigration-serviceaccessrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-datamigration.html#cfn-dms-datamigration-serviceaccessrolearn</a>
         * @param serviceAccessRoleArn The IAM role that the data migration uses to access AWS resources. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceAccessRoleArn(final java.lang.String serviceAccessRoleArn) {
            this.props.serviceAccessRoleArn(serviceAccessRoleArn);
            return this;
        }

        /**
         * The property describes an ARN of the data migration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-datamigration.html#cfn-dms-datamigration-datamigrationidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-datamigration.html#cfn-dms-datamigration-datamigrationidentifier</a>
         * @param dataMigrationIdentifier The property describes an ARN of the data migration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataMigrationIdentifier(final java.lang.String dataMigrationIdentifier) {
            this.props.dataMigrationIdentifier(dataMigrationIdentifier);
            return this;
        }

        /**
         * The user-friendly name for the data migration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-datamigration.html#cfn-dms-datamigration-datamigrationname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-datamigration.html#cfn-dms-datamigration-datamigrationname</a>
         * @param dataMigrationName The user-friendly name for the data migration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataMigrationName(final java.lang.String dataMigrationName) {
            this.props.dataMigrationName(dataMigrationName);
            return this;
        }

        /**
         * Specifies CloudWatch settings and selection rules for the data migration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-datamigration.html#cfn-dms-datamigration-datamigrationsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-datamigration.html#cfn-dms-datamigration-datamigrationsettings</a>
         * @param dataMigrationSettings Specifies CloudWatch settings and selection rules for the data migration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataMigrationSettings(final software.amazon.awscdk.IResolvable dataMigrationSettings) {
            this.props.dataMigrationSettings(dataMigrationSettings);
            return this;
        }
        /**
         * Specifies CloudWatch settings and selection rules for the data migration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-datamigration.html#cfn-dms-datamigration-datamigrationsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-datamigration.html#cfn-dms-datamigration-datamigrationsettings</a>
         * @param dataMigrationSettings Specifies CloudWatch settings and selection rules for the data migration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataMigrationSettings(final software.amazon.awscdk.services.dms.CfnDataMigration.DataMigrationSettingsProperty dataMigrationSettings) {
            this.props.dataMigrationSettings(dataMigrationSettings);
            return this;
        }

        /**
         * Specifies information about the data migration's source data provider.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-datamigration.html#cfn-dms-datamigration-sourcedatasettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-datamigration.html#cfn-dms-datamigration-sourcedatasettings</a>
         * @param sourceDataSettings Specifies information about the data migration's source data provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceDataSettings(final software.amazon.awscdk.IResolvable sourceDataSettings) {
            this.props.sourceDataSettings(sourceDataSettings);
            return this;
        }
        /**
         * Specifies information about the data migration's source data provider.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-datamigration.html#cfn-dms-datamigration-sourcedatasettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-datamigration.html#cfn-dms-datamigration-sourcedatasettings</a>
         * @param sourceDataSettings Specifies information about the data migration's source data provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceDataSettings(final java.util.List<? extends java.lang.Object> sourceDataSettings) {
            this.props.sourceDataSettings(sourceDataSettings);
            return this;
        }

        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-datamigration.html#cfn-dms-datamigration-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-datamigration.html#cfn-dms-datamigration-tags</a>
         * @param tags An array of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.dms.CfnDataMigration}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.dms.CfnDataMigration build() {
            return new software.amazon.awscdk.services.dms.CfnDataMigration(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
