package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a <code>CfnVPNConnection</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnVPNConnectionProps cfnVPNConnectionProps = CfnVPNConnectionProps.builder()
 *         .customerGatewayId("customerGatewayId")
 *         .type("type")
 *         // the properties below are optional
 *         .enableAcceleration(false)
 *         .localIpv4NetworkCidr("localIpv4NetworkCidr")
 *         .localIpv6NetworkCidr("localIpv6NetworkCidr")
 *         .outsideIpAddressType("outsideIpAddressType")
 *         .remoteIpv4NetworkCidr("remoteIpv4NetworkCidr")
 *         .remoteIpv6NetworkCidr("remoteIpv6NetworkCidr")
 *         .staticRoutesOnly(false)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .transitGatewayId("transitGatewayId")
 *         .transportTransitGatewayAttachmentId("transportTransitGatewayAttachmentId")
 *         .tunnelInsideIpVersion("tunnelInsideIpVersion")
 *         .vpnGatewayId("vpnGatewayId")
 *         .vpnTunnelOptionsSpecifications(List.of(VpnTunnelOptionsSpecificationProperty.builder()
 *                 .dpdTimeoutAction("dpdTimeoutAction")
 *                 .dpdTimeoutSeconds(123)
 *                 .enableTunnelLifecycleControl(false)
 *                 .ikeVersions(List.of(Map.of(
 *                         "value", "value")))
 *                 .logOptions(VpnTunnelLogOptionsSpecificationProperty.builder()
 *                         .cloudwatchLogOptions(CloudwatchLogOptionsSpecificationProperty.builder()
 *                                 .logEnabled(false)
 *                                 .logGroupArn("logGroupArn")
 *                                 .logOutputFormat("logOutputFormat")
 *                                 .build())
 *                         .build())
 *                 .phase1DhGroupNumbers(List.of(Phase1DHGroupNumbersRequestListValueProperty.builder()
 *                         .value(123)
 *                         .build()))
 *                 .phase1EncryptionAlgorithms(List.of(Phase1EncryptionAlgorithmsRequestListValueProperty.builder()
 *                         .value("value")
 *                         .build()))
 *                 .phase1IntegrityAlgorithms(List.of(Phase1IntegrityAlgorithmsRequestListValueProperty.builder()
 *                         .value("value")
 *                         .build()))
 *                 .phase1LifetimeSeconds(123)
 *                 .phase2DhGroupNumbers(List.of(Phase2DHGroupNumbersRequestListValueProperty.builder()
 *                         .value(123)
 *                         .build()))
 *                 .phase2EncryptionAlgorithms(List.of(Phase2EncryptionAlgorithmsRequestListValueProperty.builder()
 *                         .value("value")
 *                         .build()))
 *                 .phase2IntegrityAlgorithms(List.of(Phase2IntegrityAlgorithmsRequestListValueProperty.builder()
 *                         .value("value")
 *                         .build()))
 *                 .phase2LifetimeSeconds(123)
 *                 .preSharedKey("preSharedKey")
 *                 .rekeyFuzzPercentage(123)
 *                 .rekeyMarginTimeSeconds(123)
 *                 .replayWindowSize(123)
 *                 .startupAction("startupAction")
 *                 .tunnelInsideCidr("tunnelInsideCidr")
 *                 .tunnelInsideIpv6Cidr("tunnelInsideIpv6Cidr")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:37.873Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnVPNConnectionProps")
@software.amazon.jsii.Jsii.Proxy(CfnVPNConnectionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnVPNConnectionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the customer gateway at your end of the VPN connection.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-customergatewayid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-customergatewayid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCustomerGatewayId();

    /**
     * The type of VPN connection.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-type</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getType();

    /**
     * Indicate whether to enable acceleration for the VPN connection.
     * <p>
     * Default: <code>false</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-enableacceleration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-enableacceleration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnableAcceleration() {
        return null;
    }

    /**
     * The IPv4 CIDR on the customer gateway (on-premises) side of the VPN connection.
     * <p>
     * Default: <code>0.0.0.0/0</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-localipv4networkcidr">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-localipv4networkcidr</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLocalIpv4NetworkCidr() {
        return null;
    }

    /**
     * The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection.
     * <p>
     * Default: <code>::/0</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-localipv6networkcidr">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-localipv6networkcidr</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLocalIpv6NetworkCidr() {
        return null;
    }

    /**
     * The type of IPv4 address assigned to the outside interface of the customer gateway device.
     * <p>
     * Valid values: <code>PrivateIpv4</code> | <code>PublicIpv4</code>
     * <p>
     * Default: <code>PublicIpv4</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-outsideipaddresstype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-outsideipaddresstype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOutsideIpAddressType() {
        return null;
    }

    /**
     * The IPv4 CIDR on the AWS side of the VPN connection.
     * <p>
     * Default: <code>0.0.0.0/0</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-remoteipv4networkcidr">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-remoteipv4networkcidr</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRemoteIpv4NetworkCidr() {
        return null;
    }

    /**
     * The IPv6 CIDR on the AWS side of the VPN connection.
     * <p>
     * Default: <code>::/0</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-remoteipv6networkcidr">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-remoteipv6networkcidr</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRemoteIpv6NetworkCidr() {
        return null;
    }

    /**
     * Indicates whether the VPN connection uses static routes only.
     * <p>
     * Static routes must be used for devices that don't support BGP.
     * <p>
     * If you are creating a VPN connection for a device that does not support Border Gateway Protocol (BGP), you must specify <code>true</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-staticroutesonly">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-staticroutesonly</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getStaticRoutesOnly() {
        return null;
    }

    /**
     * Any tags assigned to the VPN connection.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The ID of the transit gateway associated with the VPN connection.
     * <p>
     * You must specify either <code>TransitGatewayId</code> or <code>VpnGatewayId</code> , but not both.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-transitgatewayid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-transitgatewayid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTransitGatewayId() {
        return null;
    }

    /**
     * The transit gateway attachment ID to use for the VPN tunnel.
     * <p>
     * Required if <code>OutsideIpAddressType</code> is set to <code>PrivateIpv4</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-transporttransitgatewayattachmentid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-transporttransitgatewayattachmentid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTransportTransitGatewayAttachmentId() {
        return null;
    }

    /**
     * Indicate whether the VPN tunnels process IPv4 or IPv6 traffic.
     * <p>
     * Default: <code>ipv4</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-tunnelinsideipversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-tunnelinsideipversion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTunnelInsideIpVersion() {
        return null;
    }

    /**
     * The ID of the virtual private gateway at the AWS side of the VPN connection.
     * <p>
     * You must specify either <code>TransitGatewayId</code> or <code>VpnGatewayId</code> , but not both.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-vpngatewayid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-vpngatewayid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVpnGatewayId() {
        return null;
    }

    /**
     * The tunnel options for the VPN connection.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-vpntunneloptionsspecifications">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-vpntunneloptionsspecifications</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getVpnTunnelOptionsSpecifications() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnVPNConnectionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnVPNConnectionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnVPNConnectionProps> {
        java.lang.String customerGatewayId;
        java.lang.String type;
        java.lang.Object enableAcceleration;
        java.lang.String localIpv4NetworkCidr;
        java.lang.String localIpv6NetworkCidr;
        java.lang.String outsideIpAddressType;
        java.lang.String remoteIpv4NetworkCidr;
        java.lang.String remoteIpv6NetworkCidr;
        java.lang.Object staticRoutesOnly;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String transitGatewayId;
        java.lang.String transportTransitGatewayAttachmentId;
        java.lang.String tunnelInsideIpVersion;
        java.lang.String vpnGatewayId;
        java.lang.Object vpnTunnelOptionsSpecifications;

        /**
         * Sets the value of {@link CfnVPNConnectionProps#getCustomerGatewayId}
         * @param customerGatewayId The ID of the customer gateway at your end of the VPN connection. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customerGatewayId(java.lang.String customerGatewayId) {
            this.customerGatewayId = customerGatewayId;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPNConnectionProps#getType}
         * @param type The type of VPN connection. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPNConnectionProps#getEnableAcceleration}
         * @param enableAcceleration Indicate whether to enable acceleration for the VPN connection.
         *                           Default: <code>false</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableAcceleration(java.lang.Boolean enableAcceleration) {
            this.enableAcceleration = enableAcceleration;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPNConnectionProps#getEnableAcceleration}
         * @param enableAcceleration Indicate whether to enable acceleration for the VPN connection.
         *                           Default: <code>false</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableAcceleration(software.amazon.awscdk.IResolvable enableAcceleration) {
            this.enableAcceleration = enableAcceleration;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPNConnectionProps#getLocalIpv4NetworkCidr}
         * @param localIpv4NetworkCidr The IPv4 CIDR on the customer gateway (on-premises) side of the VPN connection.
         *                             Default: <code>0.0.0.0/0</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder localIpv4NetworkCidr(java.lang.String localIpv4NetworkCidr) {
            this.localIpv4NetworkCidr = localIpv4NetworkCidr;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPNConnectionProps#getLocalIpv6NetworkCidr}
         * @param localIpv6NetworkCidr The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection.
         *                             Default: <code>::/0</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder localIpv6NetworkCidr(java.lang.String localIpv6NetworkCidr) {
            this.localIpv6NetworkCidr = localIpv6NetworkCidr;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPNConnectionProps#getOutsideIpAddressType}
         * @param outsideIpAddressType The type of IPv4 address assigned to the outside interface of the customer gateway device.
         *                             Valid values: <code>PrivateIpv4</code> | <code>PublicIpv4</code>
         *                             <p>
         *                             Default: <code>PublicIpv4</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outsideIpAddressType(java.lang.String outsideIpAddressType) {
            this.outsideIpAddressType = outsideIpAddressType;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPNConnectionProps#getRemoteIpv4NetworkCidr}
         * @param remoteIpv4NetworkCidr The IPv4 CIDR on the AWS side of the VPN connection.
         *                              Default: <code>0.0.0.0/0</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder remoteIpv4NetworkCidr(java.lang.String remoteIpv4NetworkCidr) {
            this.remoteIpv4NetworkCidr = remoteIpv4NetworkCidr;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPNConnectionProps#getRemoteIpv6NetworkCidr}
         * @param remoteIpv6NetworkCidr The IPv6 CIDR on the AWS side of the VPN connection.
         *                              Default: <code>::/0</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder remoteIpv6NetworkCidr(java.lang.String remoteIpv6NetworkCidr) {
            this.remoteIpv6NetworkCidr = remoteIpv6NetworkCidr;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPNConnectionProps#getStaticRoutesOnly}
         * @param staticRoutesOnly Indicates whether the VPN connection uses static routes only.
         *                         Static routes must be used for devices that don't support BGP.
         *                         <p>
         *                         If you are creating a VPN connection for a device that does not support Border Gateway Protocol (BGP), you must specify <code>true</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder staticRoutesOnly(java.lang.Boolean staticRoutesOnly) {
            this.staticRoutesOnly = staticRoutesOnly;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPNConnectionProps#getStaticRoutesOnly}
         * @param staticRoutesOnly Indicates whether the VPN connection uses static routes only.
         *                         Static routes must be used for devices that don't support BGP.
         *                         <p>
         *                         If you are creating a VPN connection for a device that does not support Border Gateway Protocol (BGP), you must specify <code>true</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder staticRoutesOnly(software.amazon.awscdk.IResolvable staticRoutesOnly) {
            this.staticRoutesOnly = staticRoutesOnly;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPNConnectionProps#getTags}
         * @param tags Any tags assigned to the VPN connection.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPNConnectionProps#getTransitGatewayId}
         * @param transitGatewayId The ID of the transit gateway associated with the VPN connection.
         *                         You must specify either <code>TransitGatewayId</code> or <code>VpnGatewayId</code> , but not both.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transitGatewayId(java.lang.String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPNConnectionProps#getTransportTransitGatewayAttachmentId}
         * @param transportTransitGatewayAttachmentId The transit gateway attachment ID to use for the VPN tunnel.
         *                                            Required if <code>OutsideIpAddressType</code> is set to <code>PrivateIpv4</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transportTransitGatewayAttachmentId(java.lang.String transportTransitGatewayAttachmentId) {
            this.transportTransitGatewayAttachmentId = transportTransitGatewayAttachmentId;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPNConnectionProps#getTunnelInsideIpVersion}
         * @param tunnelInsideIpVersion Indicate whether the VPN tunnels process IPv4 or IPv6 traffic.
         *                              Default: <code>ipv4</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tunnelInsideIpVersion(java.lang.String tunnelInsideIpVersion) {
            this.tunnelInsideIpVersion = tunnelInsideIpVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPNConnectionProps#getVpnGatewayId}
         * @param vpnGatewayId The ID of the virtual private gateway at the AWS side of the VPN connection.
         *                     You must specify either <code>TransitGatewayId</code> or <code>VpnGatewayId</code> , but not both.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpnGatewayId(java.lang.String vpnGatewayId) {
            this.vpnGatewayId = vpnGatewayId;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPNConnectionProps#getVpnTunnelOptionsSpecifications}
         * @param vpnTunnelOptionsSpecifications The tunnel options for the VPN connection.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpnTunnelOptionsSpecifications(software.amazon.awscdk.IResolvable vpnTunnelOptionsSpecifications) {
            this.vpnTunnelOptionsSpecifications = vpnTunnelOptionsSpecifications;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPNConnectionProps#getVpnTunnelOptionsSpecifications}
         * @param vpnTunnelOptionsSpecifications The tunnel options for the VPN connection.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpnTunnelOptionsSpecifications(java.util.List<? extends java.lang.Object> vpnTunnelOptionsSpecifications) {
            this.vpnTunnelOptionsSpecifications = vpnTunnelOptionsSpecifications;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnVPNConnectionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnVPNConnectionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnVPNConnectionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnVPNConnectionProps {
        private final java.lang.String customerGatewayId;
        private final java.lang.String type;
        private final java.lang.Object enableAcceleration;
        private final java.lang.String localIpv4NetworkCidr;
        private final java.lang.String localIpv6NetworkCidr;
        private final java.lang.String outsideIpAddressType;
        private final java.lang.String remoteIpv4NetworkCidr;
        private final java.lang.String remoteIpv6NetworkCidr;
        private final java.lang.Object staticRoutesOnly;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String transitGatewayId;
        private final java.lang.String transportTransitGatewayAttachmentId;
        private final java.lang.String tunnelInsideIpVersion;
        private final java.lang.String vpnGatewayId;
        private final java.lang.Object vpnTunnelOptionsSpecifications;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.customerGatewayId = software.amazon.jsii.Kernel.get(this, "customerGatewayId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enableAcceleration = software.amazon.jsii.Kernel.get(this, "enableAcceleration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.localIpv4NetworkCidr = software.amazon.jsii.Kernel.get(this, "localIpv4NetworkCidr", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.localIpv6NetworkCidr = software.amazon.jsii.Kernel.get(this, "localIpv6NetworkCidr", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.outsideIpAddressType = software.amazon.jsii.Kernel.get(this, "outsideIpAddressType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.remoteIpv4NetworkCidr = software.amazon.jsii.Kernel.get(this, "remoteIpv4NetworkCidr", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.remoteIpv6NetworkCidr = software.amazon.jsii.Kernel.get(this, "remoteIpv6NetworkCidr", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.staticRoutesOnly = software.amazon.jsii.Kernel.get(this, "staticRoutesOnly", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.transitGatewayId = software.amazon.jsii.Kernel.get(this, "transitGatewayId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.transportTransitGatewayAttachmentId = software.amazon.jsii.Kernel.get(this, "transportTransitGatewayAttachmentId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tunnelInsideIpVersion = software.amazon.jsii.Kernel.get(this, "tunnelInsideIpVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vpnGatewayId = software.amazon.jsii.Kernel.get(this, "vpnGatewayId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vpnTunnelOptionsSpecifications = software.amazon.jsii.Kernel.get(this, "vpnTunnelOptionsSpecifications", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.customerGatewayId = java.util.Objects.requireNonNull(builder.customerGatewayId, "customerGatewayId is required");
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.enableAcceleration = builder.enableAcceleration;
            this.localIpv4NetworkCidr = builder.localIpv4NetworkCidr;
            this.localIpv6NetworkCidr = builder.localIpv6NetworkCidr;
            this.outsideIpAddressType = builder.outsideIpAddressType;
            this.remoteIpv4NetworkCidr = builder.remoteIpv4NetworkCidr;
            this.remoteIpv6NetworkCidr = builder.remoteIpv6NetworkCidr;
            this.staticRoutesOnly = builder.staticRoutesOnly;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.transitGatewayId = builder.transitGatewayId;
            this.transportTransitGatewayAttachmentId = builder.transportTransitGatewayAttachmentId;
            this.tunnelInsideIpVersion = builder.tunnelInsideIpVersion;
            this.vpnGatewayId = builder.vpnGatewayId;
            this.vpnTunnelOptionsSpecifications = builder.vpnTunnelOptionsSpecifications;
        }

        @Override
        public final java.lang.String getCustomerGatewayId() {
            return this.customerGatewayId;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        public final java.lang.Object getEnableAcceleration() {
            return this.enableAcceleration;
        }

        @Override
        public final java.lang.String getLocalIpv4NetworkCidr() {
            return this.localIpv4NetworkCidr;
        }

        @Override
        public final java.lang.String getLocalIpv6NetworkCidr() {
            return this.localIpv6NetworkCidr;
        }

        @Override
        public final java.lang.String getOutsideIpAddressType() {
            return this.outsideIpAddressType;
        }

        @Override
        public final java.lang.String getRemoteIpv4NetworkCidr() {
            return this.remoteIpv4NetworkCidr;
        }

        @Override
        public final java.lang.String getRemoteIpv6NetworkCidr() {
            return this.remoteIpv6NetworkCidr;
        }

        @Override
        public final java.lang.Object getStaticRoutesOnly() {
            return this.staticRoutesOnly;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getTransitGatewayId() {
            return this.transitGatewayId;
        }

        @Override
        public final java.lang.String getTransportTransitGatewayAttachmentId() {
            return this.transportTransitGatewayAttachmentId;
        }

        @Override
        public final java.lang.String getTunnelInsideIpVersion() {
            return this.tunnelInsideIpVersion;
        }

        @Override
        public final java.lang.String getVpnGatewayId() {
            return this.vpnGatewayId;
        }

        @Override
        public final java.lang.Object getVpnTunnelOptionsSpecifications() {
            return this.vpnTunnelOptionsSpecifications;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("customerGatewayId", om.valueToTree(this.getCustomerGatewayId()));
            data.set("type", om.valueToTree(this.getType()));
            if (this.getEnableAcceleration() != null) {
                data.set("enableAcceleration", om.valueToTree(this.getEnableAcceleration()));
            }
            if (this.getLocalIpv4NetworkCidr() != null) {
                data.set("localIpv4NetworkCidr", om.valueToTree(this.getLocalIpv4NetworkCidr()));
            }
            if (this.getLocalIpv6NetworkCidr() != null) {
                data.set("localIpv6NetworkCidr", om.valueToTree(this.getLocalIpv6NetworkCidr()));
            }
            if (this.getOutsideIpAddressType() != null) {
                data.set("outsideIpAddressType", om.valueToTree(this.getOutsideIpAddressType()));
            }
            if (this.getRemoteIpv4NetworkCidr() != null) {
                data.set("remoteIpv4NetworkCidr", om.valueToTree(this.getRemoteIpv4NetworkCidr()));
            }
            if (this.getRemoteIpv6NetworkCidr() != null) {
                data.set("remoteIpv6NetworkCidr", om.valueToTree(this.getRemoteIpv6NetworkCidr()));
            }
            if (this.getStaticRoutesOnly() != null) {
                data.set("staticRoutesOnly", om.valueToTree(this.getStaticRoutesOnly()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTransitGatewayId() != null) {
                data.set("transitGatewayId", om.valueToTree(this.getTransitGatewayId()));
            }
            if (this.getTransportTransitGatewayAttachmentId() != null) {
                data.set("transportTransitGatewayAttachmentId", om.valueToTree(this.getTransportTransitGatewayAttachmentId()));
            }
            if (this.getTunnelInsideIpVersion() != null) {
                data.set("tunnelInsideIpVersion", om.valueToTree(this.getTunnelInsideIpVersion()));
            }
            if (this.getVpnGatewayId() != null) {
                data.set("vpnGatewayId", om.valueToTree(this.getVpnGatewayId()));
            }
            if (this.getVpnTunnelOptionsSpecifications() != null) {
                data.set("vpnTunnelOptionsSpecifications", om.valueToTree(this.getVpnTunnelOptionsSpecifications()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnVPNConnectionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnVPNConnectionProps.Jsii$Proxy that = (CfnVPNConnectionProps.Jsii$Proxy) o;

            if (!customerGatewayId.equals(that.customerGatewayId)) return false;
            if (!type.equals(that.type)) return false;
            if (this.enableAcceleration != null ? !this.enableAcceleration.equals(that.enableAcceleration) : that.enableAcceleration != null) return false;
            if (this.localIpv4NetworkCidr != null ? !this.localIpv4NetworkCidr.equals(that.localIpv4NetworkCidr) : that.localIpv4NetworkCidr != null) return false;
            if (this.localIpv6NetworkCidr != null ? !this.localIpv6NetworkCidr.equals(that.localIpv6NetworkCidr) : that.localIpv6NetworkCidr != null) return false;
            if (this.outsideIpAddressType != null ? !this.outsideIpAddressType.equals(that.outsideIpAddressType) : that.outsideIpAddressType != null) return false;
            if (this.remoteIpv4NetworkCidr != null ? !this.remoteIpv4NetworkCidr.equals(that.remoteIpv4NetworkCidr) : that.remoteIpv4NetworkCidr != null) return false;
            if (this.remoteIpv6NetworkCidr != null ? !this.remoteIpv6NetworkCidr.equals(that.remoteIpv6NetworkCidr) : that.remoteIpv6NetworkCidr != null) return false;
            if (this.staticRoutesOnly != null ? !this.staticRoutesOnly.equals(that.staticRoutesOnly) : that.staticRoutesOnly != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.transitGatewayId != null ? !this.transitGatewayId.equals(that.transitGatewayId) : that.transitGatewayId != null) return false;
            if (this.transportTransitGatewayAttachmentId != null ? !this.transportTransitGatewayAttachmentId.equals(that.transportTransitGatewayAttachmentId) : that.transportTransitGatewayAttachmentId != null) return false;
            if (this.tunnelInsideIpVersion != null ? !this.tunnelInsideIpVersion.equals(that.tunnelInsideIpVersion) : that.tunnelInsideIpVersion != null) return false;
            if (this.vpnGatewayId != null ? !this.vpnGatewayId.equals(that.vpnGatewayId) : that.vpnGatewayId != null) return false;
            return this.vpnTunnelOptionsSpecifications != null ? this.vpnTunnelOptionsSpecifications.equals(that.vpnTunnelOptionsSpecifications) : that.vpnTunnelOptionsSpecifications == null;
        }

        @Override
        public final int hashCode() {
            int result = this.customerGatewayId.hashCode();
            result = 31 * result + (this.type.hashCode());
            result = 31 * result + (this.enableAcceleration != null ? this.enableAcceleration.hashCode() : 0);
            result = 31 * result + (this.localIpv4NetworkCidr != null ? this.localIpv4NetworkCidr.hashCode() : 0);
            result = 31 * result + (this.localIpv6NetworkCidr != null ? this.localIpv6NetworkCidr.hashCode() : 0);
            result = 31 * result + (this.outsideIpAddressType != null ? this.outsideIpAddressType.hashCode() : 0);
            result = 31 * result + (this.remoteIpv4NetworkCidr != null ? this.remoteIpv4NetworkCidr.hashCode() : 0);
            result = 31 * result + (this.remoteIpv6NetworkCidr != null ? this.remoteIpv6NetworkCidr.hashCode() : 0);
            result = 31 * result + (this.staticRoutesOnly != null ? this.staticRoutesOnly.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.transitGatewayId != null ? this.transitGatewayId.hashCode() : 0);
            result = 31 * result + (this.transportTransitGatewayAttachmentId != null ? this.transportTransitGatewayAttachmentId.hashCode() : 0);
            result = 31 * result + (this.tunnelInsideIpVersion != null ? this.tunnelInsideIpVersion.hashCode() : 0);
            result = 31 * result + (this.vpnGatewayId != null ? this.vpnGatewayId.hashCode() : 0);
            result = 31 * result + (this.vpnTunnelOptionsSpecifications != null ? this.vpnTunnelOptionsSpecifications.hashCode() : 0);
            return result;
        }
    }
}
