package software.amazon.awscdk.services.ecr;

/**
 * An ECR life cycle rule.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Repository repository;
 * repository.addLifecycleRule(LifecycleRule.builder().tagPrefixList(List.of("prod")).maxImageCount(9999).build());
 * repository.addLifecycleRule(LifecycleRule.builder().maxImageAge(Duration.days(30)).build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:38.144Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecr.LifecycleRule")
@software.amazon.jsii.Jsii.Proxy(LifecycleRule.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LifecycleRule extends software.amazon.jsii.JsiiSerializable {

    /**
     * Describes the purpose of the rule.
     * <p>
     * Default: No description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The maximum age of images to retain. The value must represent a number of days.
     * <p>
     * Specify exactly one of maxImageCount and maxImageAge.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getMaxImageAge() {
        return null;
    }

    /**
     * The maximum number of images to retain.
     * <p>
     * Specify exactly one of maxImageCount and maxImageAge.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxImageCount() {
        return null;
    }

    /**
     * Controls the order in which rules are evaluated (low to high).
     * <p>
     * All rules must have a unique priority, where lower numbers have
     * higher precedence. The first rule that matches is applied to an image.
     * <p>
     * There can only be one rule with a tagStatus of Any, and it must have
     * the highest rulePriority.
     * <p>
     * All rules without a specified priority will have incrementing priorities
     * automatically assigned to them, higher than any rules that DO have priorities.
     * <p>
     * Default: Automatically assigned
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getRulePriority() {
        return null;
    }

    /**
     * Select images that have ALL the given patterns in their tag.
     * <p>
     * There is a maximum limit of four wildcards (<em>) per string.
     * For example, ["<em>test</em>1</em>2<em>3", "test</em>1<em>2</em>3*"] is valid but
     * ["test<em>1</em>2<em>3</em>4<em>5</em>6"] is invalid.
     * <p>
     * Both tagPrefixList and tagPatternList cannot be specified
     * together in a rule.
     * <p>
     * Only if tagStatus == TagStatus.Tagged
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTagPatternList() {
        return null;
    }

    /**
     * Select images that have ALL the given prefixes in their tag.
     * <p>
     * Both tagPrefixList and tagPatternList cannot be specified
     * together in a rule.
     * <p>
     * Only if tagStatus == TagStatus.Tagged
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTagPrefixList() {
        return null;
    }

    /**
     * Select images based on tags.
     * <p>
     * Only one rule is allowed to select untagged images, and it must
     * have the highest rulePriority.
     * <p>
     * Default: TagStatus.Tagged if tagPrefixList or tagPatternList is
     * given, TagStatus.Any otherwise
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecr.TagStatus getTagStatus() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LifecycleRule}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LifecycleRule}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LifecycleRule> {
        java.lang.String description;
        software.amazon.awscdk.Duration maxImageAge;
        java.lang.Number maxImageCount;
        java.lang.Number rulePriority;
        java.util.List<java.lang.String> tagPatternList;
        java.util.List<java.lang.String> tagPrefixList;
        software.amazon.awscdk.services.ecr.TagStatus tagStatus;

        /**
         * Sets the value of {@link LifecycleRule#getDescription}
         * @param description Describes the purpose of the rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link LifecycleRule#getMaxImageAge}
         * @param maxImageAge The maximum age of images to retain. The value must represent a number of days.
         *                    Specify exactly one of maxImageCount and maxImageAge.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxImageAge(software.amazon.awscdk.Duration maxImageAge) {
            this.maxImageAge = maxImageAge;
            return this;
        }

        /**
         * Sets the value of {@link LifecycleRule#getMaxImageCount}
         * @param maxImageCount The maximum number of images to retain.
         *                      Specify exactly one of maxImageCount and maxImageAge.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxImageCount(java.lang.Number maxImageCount) {
            this.maxImageCount = maxImageCount;
            return this;
        }

        /**
         * Sets the value of {@link LifecycleRule#getRulePriority}
         * @param rulePriority Controls the order in which rules are evaluated (low to high).
         *                     All rules must have a unique priority, where lower numbers have
         *                     higher precedence. The first rule that matches is applied to an image.
         *                     <p>
         *                     There can only be one rule with a tagStatus of Any, and it must have
         *                     the highest rulePriority.
         *                     <p>
         *                     All rules without a specified priority will have incrementing priorities
         *                     automatically assigned to them, higher than any rules that DO have priorities.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rulePriority(java.lang.Number rulePriority) {
            this.rulePriority = rulePriority;
            return this;
        }

        /**
         * Sets the value of {@link LifecycleRule#getTagPatternList}
         * @param tagPatternList Select images that have ALL the given patterns in their tag.
         *                       There is a maximum limit of four wildcards (<em>) per string.
         *                       For example, ["<em>test</em>1</em>2<em>3", "test</em>1<em>2</em>3*"] is valid but
         *                       ["test<em>1</em>2<em>3</em>4<em>5</em>6"] is invalid.
         *                       <p>
         *                       Both tagPrefixList and tagPatternList cannot be specified
         *                       together in a rule.
         *                       <p>
         *                       Only if tagStatus == TagStatus.Tagged
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tagPatternList(java.util.List<java.lang.String> tagPatternList) {
            this.tagPatternList = tagPatternList;
            return this;
        }

        /**
         * Sets the value of {@link LifecycleRule#getTagPrefixList}
         * @param tagPrefixList Select images that have ALL the given prefixes in their tag.
         *                      Both tagPrefixList and tagPatternList cannot be specified
         *                      together in a rule.
         *                      <p>
         *                      Only if tagStatus == TagStatus.Tagged
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tagPrefixList(java.util.List<java.lang.String> tagPrefixList) {
            this.tagPrefixList = tagPrefixList;
            return this;
        }

        /**
         * Sets the value of {@link LifecycleRule#getTagStatus}
         * @param tagStatus Select images based on tags.
         *                  Only one rule is allowed to select untagged images, and it must
         *                  have the highest rulePriority.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tagStatus(software.amazon.awscdk.services.ecr.TagStatus tagStatus) {
            this.tagStatus = tagStatus;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LifecycleRule}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LifecycleRule build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LifecycleRule}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LifecycleRule {
        private final java.lang.String description;
        private final software.amazon.awscdk.Duration maxImageAge;
        private final java.lang.Number maxImageCount;
        private final java.lang.Number rulePriority;
        private final java.util.List<java.lang.String> tagPatternList;
        private final java.util.List<java.lang.String> tagPrefixList;
        private final software.amazon.awscdk.services.ecr.TagStatus tagStatus;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maxImageAge = software.amazon.jsii.Kernel.get(this, "maxImageAge", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.maxImageCount = software.amazon.jsii.Kernel.get(this, "maxImageCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.rulePriority = software.amazon.jsii.Kernel.get(this, "rulePriority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.tagPatternList = software.amazon.jsii.Kernel.get(this, "tagPatternList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.tagPrefixList = software.amazon.jsii.Kernel.get(this, "tagPrefixList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.tagStatus = software.amazon.jsii.Kernel.get(this, "tagStatus", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecr.TagStatus.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.description = builder.description;
            this.maxImageAge = builder.maxImageAge;
            this.maxImageCount = builder.maxImageCount;
            this.rulePriority = builder.rulePriority;
            this.tagPatternList = builder.tagPatternList;
            this.tagPrefixList = builder.tagPrefixList;
            this.tagStatus = builder.tagStatus;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final software.amazon.awscdk.Duration getMaxImageAge() {
            return this.maxImageAge;
        }

        @Override
        public final java.lang.Number getMaxImageCount() {
            return this.maxImageCount;
        }

        @Override
        public final java.lang.Number getRulePriority() {
            return this.rulePriority;
        }

        @Override
        public final java.util.List<java.lang.String> getTagPatternList() {
            return this.tagPatternList;
        }

        @Override
        public final java.util.List<java.lang.String> getTagPrefixList() {
            return this.tagPrefixList;
        }

        @Override
        public final software.amazon.awscdk.services.ecr.TagStatus getTagStatus() {
            return this.tagStatus;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getMaxImageAge() != null) {
                data.set("maxImageAge", om.valueToTree(this.getMaxImageAge()));
            }
            if (this.getMaxImageCount() != null) {
                data.set("maxImageCount", om.valueToTree(this.getMaxImageCount()));
            }
            if (this.getRulePriority() != null) {
                data.set("rulePriority", om.valueToTree(this.getRulePriority()));
            }
            if (this.getTagPatternList() != null) {
                data.set("tagPatternList", om.valueToTree(this.getTagPatternList()));
            }
            if (this.getTagPrefixList() != null) {
                data.set("tagPrefixList", om.valueToTree(this.getTagPrefixList()));
            }
            if (this.getTagStatus() != null) {
                data.set("tagStatus", om.valueToTree(this.getTagStatus()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecr.LifecycleRule"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LifecycleRule.Jsii$Proxy that = (LifecycleRule.Jsii$Proxy) o;

            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.maxImageAge != null ? !this.maxImageAge.equals(that.maxImageAge) : that.maxImageAge != null) return false;
            if (this.maxImageCount != null ? !this.maxImageCount.equals(that.maxImageCount) : that.maxImageCount != null) return false;
            if (this.rulePriority != null ? !this.rulePriority.equals(that.rulePriority) : that.rulePriority != null) return false;
            if (this.tagPatternList != null ? !this.tagPatternList.equals(that.tagPatternList) : that.tagPatternList != null) return false;
            if (this.tagPrefixList != null ? !this.tagPrefixList.equals(that.tagPrefixList) : that.tagPrefixList != null) return false;
            return this.tagStatus != null ? this.tagStatus.equals(that.tagStatus) : that.tagStatus == null;
        }

        @Override
        public final int hashCode() {
            int result = this.description != null ? this.description.hashCode() : 0;
            result = 31 * result + (this.maxImageAge != null ? this.maxImageAge.hashCode() : 0);
            result = 31 * result + (this.maxImageCount != null ? this.maxImageCount.hashCode() : 0);
            result = 31 * result + (this.rulePriority != null ? this.rulePriority.hashCode() : 0);
            result = 31 * result + (this.tagPatternList != null ? this.tagPatternList.hashCode() : 0);
            result = 31 * result + (this.tagPrefixList != null ? this.tagPrefixList.hashCode() : 0);
            result = 31 * result + (this.tagStatus != null ? this.tagStatus.hashCode() : 0);
            return result;
        }
    }
}
