package software.amazon.awscdk.services.ecs;

/**
 * The properties to import from the ECS cluster.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.autoscaling.*;
 * import software.amazon.awscdk.services.ec2.*;
 * import software.amazon.awscdk.services.ecs.*;
 * import software.amazon.awscdk.services.kms.*;
 * import software.amazon.awscdk.services.logs.*;
 * import software.amazon.awscdk.services.s3.*;
 * import software.amazon.awscdk.services.servicediscovery.*;
 * AutoScalingGroup autoScalingGroup;
 * Bucket bucket;
 * Key key;
 * LogGroup logGroup;
 * INamespace namespace;
 * SecurityGroup securityGroup;
 * Vpc vpc;
 * ClusterAttributes clusterAttributes = ClusterAttributes.builder()
 *         .clusterName("clusterName")
 *         .vpc(vpc)
 *         // the properties below are optional
 *         .autoscalingGroup(autoScalingGroup)
 *         .clusterArn("clusterArn")
 *         .defaultCloudMapNamespace(namespace)
 *         .executeCommandConfiguration(ExecuteCommandConfiguration.builder()
 *                 .kmsKey(key)
 *                 .logConfiguration(ExecuteCommandLogConfiguration.builder()
 *                         .cloudWatchEncryptionEnabled(false)
 *                         .cloudWatchLogGroup(logGroup)
 *                         .s3Bucket(bucket)
 *                         .s3EncryptionEnabled(false)
 *                         .s3KeyPrefix("s3KeyPrefix")
 *                         .build())
 *                 .logging(ExecuteCommandLogging.NONE)
 *                 .build())
 *         .hasEc2Capacity(false)
 *         .securityGroups(List.of(securityGroup))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:38.353Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.ClusterAttributes")
@software.amazon.jsii.Jsii.Proxy(ClusterAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ClusterAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getClusterName();

    /**
     * The VPC associated with the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc getVpc();

    /**
     * Autoscaling group added to the cluster if capacity is added.
     * <p>
     * Default: - No default autoscaling group
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.autoscaling.IAutoScalingGroup getAutoscalingGroup() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) that identifies the cluster.
     * <p>
     * Default: Derived from clusterName
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getClusterArn() {
        return null;
    }

    /**
     * The AWS Cloud Map namespace to associate with the cluster.
     * <p>
     * Default: - No default namespace
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicediscovery.INamespace getDefaultCloudMapNamespace() {
        return null;
    }

    /**
     * The execute command configuration for the cluster.
     * <p>
     * Default: - none.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.ExecuteCommandConfiguration getExecuteCommandConfiguration() {
        return null;
    }

    /**
     * Specifies whether the cluster has EC2 instance capacity.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getHasEc2Capacity() {
        return null;
    }

    /**
     * The security groups associated with the container instances registered to the cluster.
     * <p>
     * Default: - no security groups
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ClusterAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ClusterAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ClusterAttributes> {
        java.lang.String clusterName;
        software.amazon.awscdk.services.ec2.IVpc vpc;
        software.amazon.awscdk.services.autoscaling.IAutoScalingGroup autoscalingGroup;
        java.lang.String clusterArn;
        software.amazon.awscdk.services.servicediscovery.INamespace defaultCloudMapNamespace;
        software.amazon.awscdk.services.ecs.ExecuteCommandConfiguration executeCommandConfiguration;
        java.lang.Boolean hasEc2Capacity;
        java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;

        /**
         * Sets the value of {@link ClusterAttributes#getClusterName}
         * @param clusterName The name of the cluster. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterName(java.lang.String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        /**
         * Sets the value of {@link ClusterAttributes#getVpc}
         * @param vpc The VPC associated with the cluster. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Sets the value of {@link ClusterAttributes#getAutoscalingGroup}
         * @param autoscalingGroup Autoscaling group added to the cluster if capacity is added.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoscalingGroup(software.amazon.awscdk.services.autoscaling.IAutoScalingGroup autoscalingGroup) {
            this.autoscalingGroup = autoscalingGroup;
            return this;
        }

        /**
         * Sets the value of {@link ClusterAttributes#getClusterArn}
         * @param clusterArn The Amazon Resource Name (ARN) that identifies the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterArn(java.lang.String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        /**
         * Sets the value of {@link ClusterAttributes#getDefaultCloudMapNamespace}
         * @param defaultCloudMapNamespace The AWS Cloud Map namespace to associate with the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultCloudMapNamespace(software.amazon.awscdk.services.servicediscovery.INamespace defaultCloudMapNamespace) {
            this.defaultCloudMapNamespace = defaultCloudMapNamespace;
            return this;
        }

        /**
         * Sets the value of {@link ClusterAttributes#getExecuteCommandConfiguration}
         * @param executeCommandConfiguration The execute command configuration for the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executeCommandConfiguration(software.amazon.awscdk.services.ecs.ExecuteCommandConfiguration executeCommandConfiguration) {
            this.executeCommandConfiguration = executeCommandConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link ClusterAttributes#getHasEc2Capacity}
         * @param hasEc2Capacity Specifies whether the cluster has EC2 instance capacity.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hasEc2Capacity(java.lang.Boolean hasEc2Capacity) {
            this.hasEc2Capacity = hasEc2Capacity;
            return this;
        }

        /**
         * Sets the value of {@link ClusterAttributes#getSecurityGroups}
         * @param securityGroups The security groups associated with the container instances registered to the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder securityGroups(java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)securityGroups;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ClusterAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ClusterAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ClusterAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClusterAttributes {
        private final java.lang.String clusterName;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;
        private final software.amazon.awscdk.services.autoscaling.IAutoScalingGroup autoscalingGroup;
        private final java.lang.String clusterArn;
        private final software.amazon.awscdk.services.servicediscovery.INamespace defaultCloudMapNamespace;
        private final software.amazon.awscdk.services.ecs.ExecuteCommandConfiguration executeCommandConfiguration;
        private final java.lang.Boolean hasEc2Capacity;
        private final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.clusterName = software.amazon.jsii.Kernel.get(this, "clusterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
            this.autoscalingGroup = software.amazon.jsii.Kernel.get(this, "autoscalingGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.IAutoScalingGroup.class));
            this.clusterArn = software.amazon.jsii.Kernel.get(this, "clusterArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.defaultCloudMapNamespace = software.amazon.jsii.Kernel.get(this, "defaultCloudMapNamespace", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicediscovery.INamespace.class));
            this.executeCommandConfiguration = software.amazon.jsii.Kernel.get(this, "executeCommandConfiguration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ExecuteCommandConfiguration.class));
            this.hasEc2Capacity = software.amazon.jsii.Kernel.get(this, "hasEc2Capacity", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.clusterName = java.util.Objects.requireNonNull(builder.clusterName, "clusterName is required");
            this.vpc = java.util.Objects.requireNonNull(builder.vpc, "vpc is required");
            this.autoscalingGroup = builder.autoscalingGroup;
            this.clusterArn = builder.clusterArn;
            this.defaultCloudMapNamespace = builder.defaultCloudMapNamespace;
            this.executeCommandConfiguration = builder.executeCommandConfiguration;
            this.hasEc2Capacity = builder.hasEc2Capacity;
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)builder.securityGroups;
        }

        @Override
        public final java.lang.String getClusterName() {
            return this.clusterName;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public final software.amazon.awscdk.services.autoscaling.IAutoScalingGroup getAutoscalingGroup() {
            return this.autoscalingGroup;
        }

        @Override
        public final java.lang.String getClusterArn() {
            return this.clusterArn;
        }

        @Override
        public final software.amazon.awscdk.services.servicediscovery.INamespace getDefaultCloudMapNamespace() {
            return this.defaultCloudMapNamespace;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.ExecuteCommandConfiguration getExecuteCommandConfiguration() {
            return this.executeCommandConfiguration;
        }

        @Override
        public final java.lang.Boolean getHasEc2Capacity() {
            return this.hasEc2Capacity;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("clusterName", om.valueToTree(this.getClusterName()));
            data.set("vpc", om.valueToTree(this.getVpc()));
            if (this.getAutoscalingGroup() != null) {
                data.set("autoscalingGroup", om.valueToTree(this.getAutoscalingGroup()));
            }
            if (this.getClusterArn() != null) {
                data.set("clusterArn", om.valueToTree(this.getClusterArn()));
            }
            if (this.getDefaultCloudMapNamespace() != null) {
                data.set("defaultCloudMapNamespace", om.valueToTree(this.getDefaultCloudMapNamespace()));
            }
            if (this.getExecuteCommandConfiguration() != null) {
                data.set("executeCommandConfiguration", om.valueToTree(this.getExecuteCommandConfiguration()));
            }
            if (this.getHasEc2Capacity() != null) {
                data.set("hasEc2Capacity", om.valueToTree(this.getHasEc2Capacity()));
            }
            if (this.getSecurityGroups() != null) {
                data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.ClusterAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ClusterAttributes.Jsii$Proxy that = (ClusterAttributes.Jsii$Proxy) o;

            if (!clusterName.equals(that.clusterName)) return false;
            if (!vpc.equals(that.vpc)) return false;
            if (this.autoscalingGroup != null ? !this.autoscalingGroup.equals(that.autoscalingGroup) : that.autoscalingGroup != null) return false;
            if (this.clusterArn != null ? !this.clusterArn.equals(that.clusterArn) : that.clusterArn != null) return false;
            if (this.defaultCloudMapNamespace != null ? !this.defaultCloudMapNamespace.equals(that.defaultCloudMapNamespace) : that.defaultCloudMapNamespace != null) return false;
            if (this.executeCommandConfiguration != null ? !this.executeCommandConfiguration.equals(that.executeCommandConfiguration) : that.executeCommandConfiguration != null) return false;
            if (this.hasEc2Capacity != null ? !this.hasEc2Capacity.equals(that.hasEc2Capacity) : that.hasEc2Capacity != null) return false;
            return this.securityGroups != null ? this.securityGroups.equals(that.securityGroups) : that.securityGroups == null;
        }

        @Override
        public final int hashCode() {
            int result = this.clusterName.hashCode();
            result = 31 * result + (this.vpc.hashCode());
            result = 31 * result + (this.autoscalingGroup != null ? this.autoscalingGroup.hashCode() : 0);
            result = 31 * result + (this.clusterArn != null ? this.clusterArn.hashCode() : 0);
            result = 31 * result + (this.defaultCloudMapNamespace != null ? this.defaultCloudMapNamespace.hashCode() : 0);
            result = 31 * result + (this.executeCommandConfiguration != null ? this.executeCommandConfiguration.hashCode() : 0);
            result = 31 * result + (this.hasEc2Capacity != null ? this.hasEc2Capacity.hashCode() : 0);
            result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
            return result;
        }
    }
}
