package software.amazon.awscdk.services.ecs.patterns;

/**
 * A Fargate service running on an ECS cluster fronted by an application load balancer.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.certificatemanager.Certificate;
 * import software.amazon.awscdk.services.ec2.InstanceType;
 * import software.amazon.awscdk.services.ecs.Cluster;
 * import software.amazon.awscdk.services.ecs.ContainerImage;
 * import software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol;
 * import software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy;
 * import software.amazon.awscdk.services.route53.PublicHostedZone;
 * Vpc vpc = Vpc.Builder.create(this, "Vpc").maxAzs(1).build();
 * ApplicationMultipleTargetGroupsFargateService loadBalancedFargateService = ApplicationMultipleTargetGroupsFargateService.Builder.create(this, "myService")
 *         .cluster(Cluster.Builder.create(this, "EcsCluster").vpc(vpc).build())
 *         .memoryLimitMiB(256)
 *         .taskImageOptions(ApplicationLoadBalancedTaskImageProps.builder()
 *                 .image(ContainerImage.fromRegistry("amazon/amazon-ecs-sample"))
 *                 .build())
 *         .enableExecuteCommand(true)
 *         .loadBalancers(List.of(ApplicationLoadBalancerProps.builder()
 *                 .name("lb")
 *                 .idleTimeout(Duration.seconds(400))
 *                 .domainName("api.example.com")
 *                 .domainZone(PublicHostedZone.Builder.create(this, "HostedZone").zoneName("example.com").build())
 *                 .listeners(List.of(ApplicationListenerProps.builder()
 *                         .name("listener")
 *                         .protocol(ApplicationProtocol.HTTPS)
 *                         .certificate(Certificate.fromCertificateArn(this, "Cert", "helloworld"))
 *                         .sslPolicy(SslPolicy.TLS12_EXT)
 *                         .build()))
 *                 .build(), ApplicationLoadBalancerProps.builder()
 *                 .name("lb2")
 *                 .idleTimeout(Duration.seconds(120))
 *                 .domainName("frontend.com")
 *                 .domainZone(PublicHostedZone.Builder.create(this, "HostedZone").zoneName("frontend.com").build())
 *                 .listeners(List.of(ApplicationListenerProps.builder()
 *                         .name("listener2")
 *                         .protocol(ApplicationProtocol.HTTPS)
 *                         .certificate(Certificate.fromCertificateArn(this, "Cert2", "helloworld"))
 *                         .sslPolicy(SslPolicy.TLS12_EXT)
 *                         .build()))
 *                 .build()))
 *         .targetGroups(List.of(ApplicationTargetProps.builder()
 *                 .containerPort(80)
 *                 .listener("listener")
 *                 .build(), ApplicationTargetProps.builder()
 *                 .containerPort(90)
 *                 .pathPattern("a/b/c")
 *                 .priority(10)
 *                 .listener("listener")
 *                 .build(), ApplicationTargetProps.builder()
 *                 .containerPort(443)
 *                 .listener("listener2")
 *                 .build(), ApplicationTargetProps.builder()
 *                 .containerPort(80)
 *                 .pathPattern("a/b/c")
 *                 .priority(10)
 *                 .listener("listener2")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:38.533Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs_patterns.ApplicationMultipleTargetGroupsFargateService")
public class ApplicationMultipleTargetGroupsFargateService extends software.amazon.awscdk.services.ecs.patterns.ApplicationMultipleTargetGroupsServiceBase {

    protected ApplicationMultipleTargetGroupsFargateService(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ApplicationMultipleTargetGroupsFargateService(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Constructs a new instance of the ApplicationMultipleTargetGroupsFargateService class.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ApplicationMultipleTargetGroupsFargateService(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.patterns.ApplicationMultipleTargetGroupsFargateServiceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Constructs a new instance of the ApplicationMultipleTargetGroupsFargateService class.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ApplicationMultipleTargetGroupsFargateService(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Determines whether the service will be assigned a public IP address.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getAssignPublicIp() {
        return software.amazon.jsii.Kernel.get(this, "assignPublicIp", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * The Fargate service in this construct.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.FargateService getService() {
        return software.amazon.jsii.Kernel.get(this, "service", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.FargateService.class));
    }

    /**
     * (deprecated) The default target group for the service.
     * <p>
     * @deprecated <ul>
     * <li>Use <code>targetGroups</code> instead.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationTargetGroup getTargetGroup() {
        return software.amazon.jsii.Kernel.get(this, "targetGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationTargetGroup.class));
    }

    /**
     * The Fargate task definition in this construct.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.FargateTaskDefinition getTaskDefinition() {
        return software.amazon.jsii.Kernel.get(this, "taskDefinition", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.FargateTaskDefinition.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ecs.patterns.ApplicationMultipleTargetGroupsFargateService}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ecs.patterns.ApplicationMultipleTargetGroupsFargateService> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.ecs.patterns.ApplicationMultipleTargetGroupsFargateServiceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The options for configuring an Amazon ECS service to use service discovery.
         * <p>
         * Default: - AWS Cloud Map service discovery is not enabled.
         * <p>
         * @return {@code this}
         * @param cloudMapOptions The options for configuring an Amazon ECS service to use service discovery. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudMapOptions(final software.amazon.awscdk.services.ecs.CloudMapOptions cloudMapOptions) {
            this.props().cloudMapOptions(cloudMapOptions);
            return this;
        }

        /**
         * The name of the cluster that hosts the service.
         * <p>
         * If a cluster is specified, the vpc construct should be omitted. Alternatively, you can omit both cluster and vpc.
         * <p>
         * Default: - create a new cluster; if both cluster and vpc are omitted, a new VPC will be created for you.
         * <p>
         * @return {@code this}
         * @param cluster The name of the cluster that hosts the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cluster(final software.amazon.awscdk.services.ecs.ICluster cluster) {
            this.props().cluster(cluster);
            return this;
        }

        /**
         * The desired number of instantiations of the task definition to keep running on the service.
         * <p>
         * Default: - The default is 1 for all new services and uses the existing service's desired count
         * when updating an existing service.
         * <p>
         * @return {@code this}
         * @param desiredCount The desired number of instantiations of the task definition to keep running on the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder desiredCount(final java.lang.Number desiredCount) {
            this.props().desiredCount(desiredCount);
            return this;
        }

        /**
         * Specifies whether to enable Amazon ECS managed tags for the tasks within the service.
         * <p>
         * For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS Resources</a>
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param enableEcsManagedTags Specifies whether to enable Amazon ECS managed tags for the tasks within the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableEcsManagedTags(final java.lang.Boolean enableEcsManagedTags) {
            this.props().enableEcsManagedTags(enableEcsManagedTags);
            return this;
        }

        /**
         * Whether ECS Exec should be enabled.
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @param enableExecuteCommand Whether ECS Exec should be enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableExecuteCommand(final java.lang.Boolean enableExecuteCommand) {
            this.props().enableExecuteCommand(enableExecuteCommand);
            return this;
        }

        /**
         * The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load Balancing target health checks after a task has first started.
         * <p>
         * Default: - defaults to 60 seconds if at least one load balancer is in-use and it is not already set
         * <p>
         * @return {@code this}
         * @param healthCheckGracePeriod The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load Balancing target health checks after a task has first started. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheckGracePeriod(final software.amazon.awscdk.Duration healthCheckGracePeriod) {
            this.props().healthCheckGracePeriod(healthCheckGracePeriod);
            return this;
        }

        /**
         * The application load balancer that will serve traffic to the service.
         * <p>
         * Default: - a new load balancer with a listener will be created.
         * <p>
         * @return {@code this}
         * @param loadBalancers The application load balancer that will serve traffic to the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancers(final java.util.List<? extends software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancerProps> loadBalancers) {
            this.props().loadBalancers(loadBalancers);
            return this;
        }

        /**
         * Specifies whether to propagate the tags from the task definition or the service to the tasks in the service.
         * <p>
         * Tags can only be propagated to the tasks within the service during service creation.
         * <p>
         * Default: - none
         * <p>
         * @return {@code this}
         * @param propagateTags Specifies whether to propagate the tags from the task definition or the service to the tasks in the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder propagateTags(final software.amazon.awscdk.services.ecs.PropagatedTagSource propagateTags) {
            this.props().propagateTags(propagateTags);
            return this;
        }

        /**
         * The name of the service.
         * <p>
         * Default: - CloudFormation-generated name.
         * <p>
         * @return {@code this}
         * @param serviceName The name of the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceName(final java.lang.String serviceName) {
            this.props().serviceName(serviceName);
            return this;
        }

        /**
         * Properties to specify ALB target groups.
         * <p>
         * Default: - default portMapping registered as target group and attached to the first defined listener
         * <p>
         * @return {@code this}
         * @param targetGroups Properties to specify ALB target groups. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetGroups(final java.util.List<? extends software.amazon.awscdk.services.ecs.patterns.ApplicationTargetProps> targetGroups) {
            this.props().targetGroups(targetGroups);
            return this;
        }

        /**
         * The properties required to create a new task definition.
         * <p>
         * Only one of TaskDefinition or TaskImageOptions must be specified.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param taskImageOptions The properties required to create a new task definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskImageOptions(final software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancedTaskImageProps taskImageOptions) {
            this.props().taskImageOptions(taskImageOptions);
            return this;
        }

        /**
         * The VPC where the container instances will be launched or the elastic network interfaces (ENIs) will be deployed.
         * <p>
         * If a vpc is specified, the cluster construct should be omitted. Alternatively, you can omit both vpc and cluster.
         * <p>
         * Default: - uses the VPC defined in the cluster or creates a new VPC.
         * <p>
         * @return {@code this}
         * @param vpc The VPC where the container instances will be launched or the elastic network interfaces (ENIs) will be deployed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props().vpc(vpc);
            return this;
        }

        /**
         * The number of cpu units used by the task.
         * <p>
         * Valid values, which determines your range of valid values for the memory parameter:
         * <p>
         * 256 (.25 vCPU) - Available memory values: 0.5GB, 1GB, 2GB
         * <p>
         * 512 (.5 vCPU) - Available memory values: 1GB, 2GB, 3GB, 4GB
         * <p>
         * 1024 (1 vCPU) - Available memory values: 2GB, 3GB, 4GB, 5GB, 6GB, 7GB, 8GB
         * <p>
         * 2048 (2 vCPU) - Available memory values: Between 4GB and 16GB in 1GB increments
         * <p>
         * 4096 (4 vCPU) - Available memory values: Between 8GB and 30GB in 1GB increments
         * <p>
         * 8192 (8 vCPU) - Available memory values: Between 16GB and 60GB in 4GB increments
         * <p>
         * 16384 (16 vCPU) - Available memory values: Between 32GB and 120GB in 8GB increments
         * <p>
         * This default is set in the underlying FargateTaskDefinition construct.
         * <p>
         * Default: 256
         * <p>
         * @return {@code this}
         * @param cpu The number of cpu units used by the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cpu(final java.lang.Number cpu) {
            this.props().cpu(cpu);
            return this;
        }

        /**
         * The amount (in GiB) of ephemeral storage to be allocated to the task.
         * <p>
         * The minimum supported value is <code>21</code> GiB and the maximum supported value is <code>200</code> GiB.
         * <p>
         * Only supported in Fargate platform version 1.4.0 or later.
         * <p>
         * Default: Undefined, in which case, the task will receive 20GiB ephemeral storage.
         * <p>
         * @return {@code this}
         * @param ephemeralStorageGiB The amount (in GiB) of ephemeral storage to be allocated to the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ephemeralStorageGiB(final java.lang.Number ephemeralStorageGiB) {
            this.props().ephemeralStorageGiB(ephemeralStorageGiB);
            return this;
        }

        /**
         * The amount (in MiB) of memory used by the task.
         * <p>
         * This field is required and you must use one of the following values, which determines your range of valid values
         * for the cpu parameter:
         * <p>
         * 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available cpu values: 256 (.25 vCPU)
         * <p>
         * 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available cpu values: 512 (.5 vCPU)
         * <p>
         * 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available cpu values: 1024 (1 vCPU)
         * <p>
         * Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available cpu values: 2048 (2 vCPU)
         * <p>
         * Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available cpu values: 4096 (4 vCPU)
         * <p>
         * Between 16384 (16 GB) and 61440 (60 GB) in increments of 4096 (4 GB) - Available cpu values: 8192 (8 vCPU)
         * <p>
         * Between 32768 (32 GB) and 122880 (120 GB) in increments of 8192 (8 GB) - Available cpu values: 16384 (16 vCPU)
         * <p>
         * This default is set in the underlying FargateTaskDefinition construct.
         * <p>
         * Default: 512
         * <p>
         * @return {@code this}
         * @param memoryLimitMiB The amount (in MiB) of memory used by the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memoryLimitMiB(final java.lang.Number memoryLimitMiB) {
            this.props().memoryLimitMiB(memoryLimitMiB);
            return this;
        }

        /**
         * The platform version on which to run your service.
         * <p>
         * If one is not specified, the LATEST platform version is used by default. For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">AWS Fargate Platform Versions</a>
         * in the Amazon Elastic Container Service Developer Guide.
         * <p>
         * Default: Latest
         * <p>
         * @return {@code this}
         * @param platformVersion The platform version on which to run your service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder platformVersion(final software.amazon.awscdk.services.ecs.FargatePlatformVersion platformVersion) {
            this.props().platformVersion(platformVersion);
            return this;
        }

        /**
         * The runtime platform of the task definition.
         * <p>
         * Default: - If the property is undefined, `operatingSystemFamily` is LINUX and `cpuArchitecture` is X86_64
         * <p>
         * @return {@code this}
         * @param runtimePlatform The runtime platform of the task definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtimePlatform(final software.amazon.awscdk.services.ecs.RuntimePlatform runtimePlatform) {
            this.props().runtimePlatform(runtimePlatform);
            return this;
        }

        /**
         * The task definition to use for tasks in the service. TaskDefinition or TaskImageOptions must be specified, but not both.
         * <p>
         * [disable-awslint:ref-via-interface]
         * <p>
         * Default: - none
         * <p>
         * @return {@code this}
         * @param taskDefinition The task definition to use for tasks in the service. TaskDefinition or TaskImageOptions must be specified, but not both. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskDefinition(final software.amazon.awscdk.services.ecs.FargateTaskDefinition taskDefinition) {
            this.props().taskDefinition(taskDefinition);
            return this;
        }

        /**
         * Determines whether the service will be assigned a public IP address.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param assignPublicIp Determines whether the service will be assigned a public IP address. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assignPublicIp(final java.lang.Boolean assignPublicIp) {
            this.props().assignPublicIp(assignPublicIp);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ecs.patterns.ApplicationMultipleTargetGroupsFargateService}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ecs.patterns.ApplicationMultipleTargetGroupsFargateService build() {
            return new software.amazon.awscdk.services.ecs.patterns.ApplicationMultipleTargetGroupsFargateService(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ecs.patterns.ApplicationMultipleTargetGroupsFargateServiceProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ecs.patterns.ApplicationMultipleTargetGroupsFargateServiceProps.Builder();
            }
            return this.props;
        }
    }
}
