package software.amazon.awscdk.services.eks;

/**
 * Represents an Amazon EKS Access Policy ARN.
 * <p>
 * Amazon EKS Access Policies are used to control access to Amazon EKS clusters.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.eks.*;
 * AccessPolicyArn accessPolicyArn = AccessPolicyArn.AMAZON_EKS_ADMIN_POLICY;
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/eks/latest/userguide/access-policies.html">https://docs.aws.amazon.com/eks/latest/userguide/access-policies.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:38.749Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.AccessPolicyArn")
public class AccessPolicyArn extends software.amazon.jsii.JsiiObject {

    protected AccessPolicyArn(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AccessPolicyArn(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        AMAZON_EKS_ADMIN_POLICY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.AccessPolicyArn.class, "AMAZON_EKS_ADMIN_POLICY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AccessPolicyArn.class));
        AMAZON_EKS_ADMIN_VIEW_POLICY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.AccessPolicyArn.class, "AMAZON_EKS_ADMIN_VIEW_POLICY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AccessPolicyArn.class));
        AMAZON_EKS_CLUSTER_ADMIN_POLICY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.AccessPolicyArn.class, "AMAZON_EKS_CLUSTER_ADMIN_POLICY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AccessPolicyArn.class));
        AMAZON_EKS_EDIT_POLICY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.AccessPolicyArn.class, "AMAZON_EKS_EDIT_POLICY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AccessPolicyArn.class));
        AMAZON_EKS_VIEW_POLICY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.AccessPolicyArn.class, "AMAZON_EKS_VIEW_POLICY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AccessPolicyArn.class));
    }

    /**
     * Constructs a new instance of the <code>AccessEntry</code> class.
     * <p>
     * @param policyName <ul><li>The name of the Amazon EKS access policy.</li></ul> This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AccessPolicyArn(final @org.jetbrains.annotations.NotNull java.lang.String policyName) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(policyName, "policyName is required") });
    }

    /**
     * Creates a new instance of the AccessPolicy class with the specified policy name.
     * <p>
     * @return A new instance of the AccessPolicy class.
     * @param policyName The name of the access policy. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.AccessPolicyArn of(final @org.jetbrains.annotations.NotNull java.lang.String policyName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.eks.AccessPolicyArn.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AccessPolicyArn.class), new Object[] { java.util.Objects.requireNonNull(policyName, "policyName is required") });
    }

    /**
     * The Amazon EKS Admin Policy.
     * <p>
     * This access policy includes permissions that grant an IAM principal
     * most permissions to resources. When associated to an access entry, its access scope is typically
     * one or more Kubernetes namespaces.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.AccessPolicyArn AMAZON_EKS_ADMIN_POLICY;

    /**
     * The Amazon EKS Admin View Policy.
     * <p>
     * This access policy includes permissions that grant an IAM principal
     * access to list/view all resources in a cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.AccessPolicyArn AMAZON_EKS_ADMIN_VIEW_POLICY;

    /**
     * The Amazon EKS Cluster Admin Policy.
     * <p>
     * This access policy includes permissions that grant an IAM
     * principal administrator access to a cluster. When associated to an access entry, its access scope
     * is typically the cluster, rather than a Kubernetes namespace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.AccessPolicyArn AMAZON_EKS_CLUSTER_ADMIN_POLICY;

    /**
     * The Amazon EKS Edit Policy.
     * <p>
     * This access policy includes permissions that allow an IAM principal
     * to edit most Kubernetes resources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.AccessPolicyArn AMAZON_EKS_EDIT_POLICY;

    /**
     * The Amazon EKS View Policy.
     * <p>
     * This access policy includes permissions that grant an IAM principal
     * access to list/view all resources in a cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.eks.AccessPolicyArn AMAZON_EKS_VIEW_POLICY;

    /**
     * The Amazon Resource Name (ARN) of the access policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPolicyArn() {
        return software.amazon.jsii.Kernel.get(this, "policyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * <ul><li>The name of the Amazon EKS access policy.</li></ul>
     * <p>
     * This is used to construct the policy ARN.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPolicyName() {
        return software.amazon.jsii.Kernel.get(this, "policyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
