package software.amazon.awscdk.services.emr;

/**
 * Use <code>InstanceGroupConfig</code> to define instance groups for an EMR cluster.
 * <p>
 * A cluster can not use both instance groups and instance fleets. For more information, see <a href="https://docs.aws.amazon.com//emr/latest/ManagementGuide/emr-instance-group-configuration.html">Create a Cluster with Instance Fleets or Uniform Instance Groups</a> in the <em>Amazon EMR Management Guide</em> .
 * <p>
 * <blockquote>
 * <p>
 * You can currently only add task instance groups to a cluster with this resource. If you use this resource, CloudFormation waits for the cluster launch to complete before adding the task instance group to the cluster. In order to add task instance groups to the cluster as part of the cluster launch and minimize delays in provisioning task nodes, use the <code>TaskInstanceGroups</code> subproperty for the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticmapreduce-cluster-jobflowinstancesconfig.html">AWS::EMR::Cluster JobFlowInstancesConfig</a> property instead. To use this subproperty, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticmapreduce-cluster.html">AWS::EMR::Cluster</a> for examples.
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.emr.*;
 * ConfigurationProperty configurationProperty_;
 * CfnInstanceGroupConfig cfnInstanceGroupConfig = CfnInstanceGroupConfig.Builder.create(this, "MyCfnInstanceGroupConfig")
 *         .instanceCount(123)
 *         .instanceRole("instanceRole")
 *         .instanceType("instanceType")
 *         .jobFlowId("jobFlowId")
 *         // the properties below are optional
 *         .autoScalingPolicy(AutoScalingPolicyProperty.builder()
 *                 .constraints(ScalingConstraintsProperty.builder()
 *                         .maxCapacity(123)
 *                         .minCapacity(123)
 *                         .build())
 *                 .rules(List.of(ScalingRuleProperty.builder()
 *                         .action(ScalingActionProperty.builder()
 *                                 .simpleScalingPolicyConfiguration(SimpleScalingPolicyConfigurationProperty.builder()
 *                                         .scalingAdjustment(123)
 *                                         // the properties below are optional
 *                                         .adjustmentType("adjustmentType")
 *                                         .coolDown(123)
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .market("market")
 *                                 .build())
 *                         .name("name")
 *                         .trigger(ScalingTriggerProperty.builder()
 *                                 .cloudWatchAlarmDefinition(CloudWatchAlarmDefinitionProperty.builder()
 *                                         .comparisonOperator("comparisonOperator")
 *                                         .metricName("metricName")
 *                                         .period(123)
 *                                         .threshold(123)
 *                                         // the properties below are optional
 *                                         .dimensions(List.of(MetricDimensionProperty.builder()
 *                                                 .key("key")
 *                                                 .value("value")
 *                                                 .build()))
 *                                         .evaluationPeriods(123)
 *                                         .namespace("namespace")
 *                                         .statistic("statistic")
 *                                         .unit("unit")
 *                                         .build())
 *                                 .build())
 *                         // the properties below are optional
 *                         .description("description")
 *                         .build()))
 *                 .build())
 *         .bidPrice("bidPrice")
 *         .configurations(List.of(ConfigurationProperty.builder()
 *                 .classification("classification")
 *                 .configurationProperties(Map.of(
 *                         "configurationPropertiesKey", "configurationProperties"))
 *                 .configurations(List.of(configurationProperty_))
 *                 .build()))
 *         .customAmiId("customAmiId")
 *         .ebsConfiguration(EbsConfigurationProperty.builder()
 *                 .ebsBlockDeviceConfigs(List.of(EbsBlockDeviceConfigProperty.builder()
 *                         .volumeSpecification(VolumeSpecificationProperty.builder()
 *                                 .sizeInGb(123)
 *                                 .volumeType("volumeType")
 *                                 // the properties below are optional
 *                                 .iops(123)
 *                                 .throughput(123)
 *                                 .build())
 *                         // the properties below are optional
 *                         .volumesPerInstance(123)
 *                         .build()))
 *                 .ebsOptimized(false)
 *                 .build())
 *         .market("market")
 *         .name("name")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancegroupconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancegroupconfig.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:40.014Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emr.CfnInstanceGroupConfig")
public class CfnInstanceGroupConfig extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnInstanceGroupConfig(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnInstanceGroupConfig(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.emr.CfnInstanceGroupConfig.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnInstanceGroupConfig(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.emr.CfnInstanceGroupConfigProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Target number of instances for the instance group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getInstanceCount() {
        return software.amazon.jsii.Kernel.get(this, "instanceCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Target number of instances for the instance group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceCount(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "instanceCount", java.util.Objects.requireNonNull(value, "instanceCount is required"));
    }

    /**
     * The role of the instance group in the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getInstanceRole() {
        return software.amazon.jsii.Kernel.get(this, "instanceRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The role of the instance group in the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceRole(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "instanceRole", java.util.Objects.requireNonNull(value, "instanceRole is required"));
    }

    /**
     * The Amazon EC2 instance type for all instances in the instance group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getInstanceType() {
        return software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon EC2 instance type for all instances in the instance group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "instanceType", java.util.Objects.requireNonNull(value, "instanceType is required"));
    }

    /**
     * The ID of an Amazon EMR cluster that you want to associate this instance group with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getJobFlowId() {
        return software.amazon.jsii.Kernel.get(this, "jobFlowId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of an Amazon EMR cluster that you want to associate this instance group with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setJobFlowId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "jobFlowId", java.util.Objects.requireNonNull(value, "jobFlowId is required"));
    }

    /**
     * <code>AutoScalingPolicy</code> is a subproperty of <code>InstanceGroupConfig</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAutoScalingPolicy() {
        return software.amazon.jsii.Kernel.get(this, "autoScalingPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * <code>AutoScalingPolicy</code> is a subproperty of <code>InstanceGroupConfig</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoScalingPolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "autoScalingPolicy", value);
    }

    /**
     * <code>AutoScalingPolicy</code> is a subproperty of <code>InstanceGroupConfig</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoScalingPolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.emr.CfnInstanceGroupConfig.AutoScalingPolicyProperty value) {
        software.amazon.jsii.Kernel.set(this, "autoScalingPolicy", value);
    }

    /**
     * If specified, indicates that the instance group uses Spot Instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getBidPrice() {
        return software.amazon.jsii.Kernel.get(this, "bidPrice", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * If specified, indicates that the instance group uses Spot Instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBidPrice(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "bidPrice", value);
    }

    /**
     * <blockquote><p>Amazon EMR releases 4.x or later.<p></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getConfigurations() {
        return software.amazon.jsii.Kernel.get(this, "configurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * <blockquote><p>Amazon EMR releases 4.x or later.<p></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfigurations(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "configurations", value);
    }

    /**
     * <blockquote><p>Amazon EMR releases 4.x or later.<p></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfigurations(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.emr.CfnInstanceGroupConfig.ConfigurationProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.emr.CfnInstanceGroupConfig.ConfigurationProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "configurations", value);
    }

    /**
     * The custom AMI ID to use for the provisioned instance group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCustomAmiId() {
        return software.amazon.jsii.Kernel.get(this, "customAmiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The custom AMI ID to use for the provisioned instance group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomAmiId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "customAmiId", value);
    }

    /**
     * <code>EbsConfiguration</code> determines the EBS volumes to attach to EMR cluster instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEbsConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "ebsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * <code>EbsConfiguration</code> determines the EBS volumes to attach to EMR cluster instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEbsConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "ebsConfiguration", value);
    }

    /**
     * <code>EbsConfiguration</code> determines the EBS volumes to attach to EMR cluster instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEbsConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.emr.CfnInstanceGroupConfig.EbsConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "ebsConfiguration", value);
    }

    /**
     * Market type of the Amazon EC2 instances used to create a cluster node.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getMarket() {
        return software.amazon.jsii.Kernel.get(this, "market", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Market type of the Amazon EC2 instances used to create a cluster node.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMarket(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "market", value);
    }

    /**
     * Friendly name given to the instance group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Friendly name given to the instance group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }
    /**
     * <code>AutoScalingPolicy</code> defines how an instance group dynamically adds and terminates EC2 instances in response to the value of a CloudWatch metric.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com//emr/latest/ManagementGuide/emr-automatic-scaling.html">Using Automatic Scaling in Amazon EMR</a> in the <em>Amazon EMR Management Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emr.*;
     * AutoScalingPolicyProperty autoScalingPolicyProperty = AutoScalingPolicyProperty.builder()
     *         .constraints(ScalingConstraintsProperty.builder()
     *                 .maxCapacity(123)
     *                 .minCapacity(123)
     *                 .build())
     *         .rules(List.of(ScalingRuleProperty.builder()
     *                 .action(ScalingActionProperty.builder()
     *                         .simpleScalingPolicyConfiguration(SimpleScalingPolicyConfigurationProperty.builder()
     *                                 .scalingAdjustment(123)
     *                                 // the properties below are optional
     *                                 .adjustmentType("adjustmentType")
     *                                 .coolDown(123)
     *                                 .build())
     *                         // the properties below are optional
     *                         .market("market")
     *                         .build())
     *                 .name("name")
     *                 .trigger(ScalingTriggerProperty.builder()
     *                         .cloudWatchAlarmDefinition(CloudWatchAlarmDefinitionProperty.builder()
     *                                 .comparisonOperator("comparisonOperator")
     *                                 .metricName("metricName")
     *                                 .period(123)
     *                                 .threshold(123)
     *                                 // the properties below are optional
     *                                 .dimensions(List.of(MetricDimensionProperty.builder()
     *                                         .key("key")
     *                                         .value("value")
     *                                         .build()))
     *                                 .evaluationPeriods(123)
     *                                 .namespace("namespace")
     *                                 .statistic("statistic")
     *                                 .unit("unit")
     *                                 .build())
     *                         .build())
     *                 // the properties below are optional
     *                 .description("description")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-autoscalingpolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-autoscalingpolicy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emr.CfnInstanceGroupConfig.AutoScalingPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(AutoScalingPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AutoScalingPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The upper and lower Amazon EC2 instance limits for an automatic scaling policy.
         * <p>
         * Automatic scaling activity will not cause an instance group to grow above or below these limits.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-autoscalingpolicy.html#cfn-emr-instancegroupconfig-autoscalingpolicy-constraints">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-autoscalingpolicy.html#cfn-emr-instancegroupconfig-autoscalingpolicy-constraints</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getConstraints();

        /**
         * The scale-in and scale-out rules that comprise the automatic scaling policy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-autoscalingpolicy.html#cfn-emr-instancegroupconfig-autoscalingpolicy-rules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-autoscalingpolicy.html#cfn-emr-instancegroupconfig-autoscalingpolicy-rules</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRules();

        /**
         * @return a {@link Builder} of {@link AutoScalingPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AutoScalingPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AutoScalingPolicyProperty> {
            java.lang.Object constraints;
            java.lang.Object rules;

            /**
             * Sets the value of {@link AutoScalingPolicyProperty#getConstraints}
             * @param constraints The upper and lower Amazon EC2 instance limits for an automatic scaling policy. This parameter is required.
             *                    Automatic scaling activity will not cause an instance group to grow above or below these limits.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder constraints(software.amazon.awscdk.IResolvable constraints) {
                this.constraints = constraints;
                return this;
            }

            /**
             * Sets the value of {@link AutoScalingPolicyProperty#getConstraints}
             * @param constraints The upper and lower Amazon EC2 instance limits for an automatic scaling policy. This parameter is required.
             *                    Automatic scaling activity will not cause an instance group to grow above or below these limits.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder constraints(software.amazon.awscdk.services.emr.CfnInstanceGroupConfig.ScalingConstraintsProperty constraints) {
                this.constraints = constraints;
                return this;
            }

            /**
             * Sets the value of {@link AutoScalingPolicyProperty#getRules}
             * @param rules The scale-in and scale-out rules that comprise the automatic scaling policy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rules(software.amazon.awscdk.IResolvable rules) {
                this.rules = rules;
                return this;
            }

            /**
             * Sets the value of {@link AutoScalingPolicyProperty#getRules}
             * @param rules The scale-in and scale-out rules that comprise the automatic scaling policy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rules(java.util.List<? extends java.lang.Object> rules) {
                this.rules = rules;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AutoScalingPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AutoScalingPolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AutoScalingPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AutoScalingPolicyProperty {
            private final java.lang.Object constraints;
            private final java.lang.Object rules;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.constraints = software.amazon.jsii.Kernel.get(this, "constraints", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rules = software.amazon.jsii.Kernel.get(this, "rules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.constraints = java.util.Objects.requireNonNull(builder.constraints, "constraints is required");
                this.rules = java.util.Objects.requireNonNull(builder.rules, "rules is required");
            }

            @Override
            public final java.lang.Object getConstraints() {
                return this.constraints;
            }

            @Override
            public final java.lang.Object getRules() {
                return this.rules;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("constraints", om.valueToTree(this.getConstraints()));
                data.set("rules", om.valueToTree(this.getRules()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_emr.CfnInstanceGroupConfig.AutoScalingPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AutoScalingPolicyProperty.Jsii$Proxy that = (AutoScalingPolicyProperty.Jsii$Proxy) o;

                if (!constraints.equals(that.constraints)) return false;
                return this.rules.equals(that.rules);
            }

            @Override
            public final int hashCode() {
                int result = this.constraints.hashCode();
                result = 31 * result + (this.rules.hashCode());
                return result;
            }
        }
    }
    /**
     * <code>CloudWatchAlarmDefinition</code> is a subproperty of the <code>ScalingTrigger</code> property, which determines when to trigger an automatic scaling activity.
     * <p>
     * Scaling activity begins when you satisfy the defined alarm conditions.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emr.*;
     * CloudWatchAlarmDefinitionProperty cloudWatchAlarmDefinitionProperty = CloudWatchAlarmDefinitionProperty.builder()
     *         .comparisonOperator("comparisonOperator")
     *         .metricName("metricName")
     *         .period(123)
     *         .threshold(123)
     *         // the properties below are optional
     *         .dimensions(List.of(MetricDimensionProperty.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .evaluationPeriods(123)
     *         .namespace("namespace")
     *         .statistic("statistic")
     *         .unit("unit")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-cloudwatchalarmdefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-cloudwatchalarmdefinition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emr.CfnInstanceGroupConfig.CloudWatchAlarmDefinitionProperty")
    @software.amazon.jsii.Jsii.Proxy(CloudWatchAlarmDefinitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CloudWatchAlarmDefinitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Determines how the metric specified by <code>MetricName</code> is compared to the value specified by <code>Threshold</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-cloudwatchalarmdefinition.html#cfn-emr-instancegroupconfig-cloudwatchalarmdefinition-comparisonoperator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-cloudwatchalarmdefinition.html#cfn-emr-instancegroupconfig-cloudwatchalarmdefinition-comparisonoperator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getComparisonOperator();

        /**
         * The name of the CloudWatch metric that is watched to determine an alarm condition.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-cloudwatchalarmdefinition.html#cfn-emr-instancegroupconfig-cloudwatchalarmdefinition-metricname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-cloudwatchalarmdefinition.html#cfn-emr-instancegroupconfig-cloudwatchalarmdefinition-metricname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMetricName();

        /**
         * The period, in seconds, over which the statistic is applied.
         * <p>
         * CloudWatch metrics for Amazon EMR are emitted every five minutes (300 seconds), so if you specify a CloudWatch metric, specify <code>300</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-cloudwatchalarmdefinition.html#cfn-emr-instancegroupconfig-cloudwatchalarmdefinition-period">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-cloudwatchalarmdefinition.html#cfn-emr-instancegroupconfig-cloudwatchalarmdefinition-period</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getPeriod();

        /**
         * The value against which the specified statistic is compared.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-cloudwatchalarmdefinition.html#cfn-emr-instancegroupconfig-cloudwatchalarmdefinition-threshold">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-cloudwatchalarmdefinition.html#cfn-emr-instancegroupconfig-cloudwatchalarmdefinition-threshold</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getThreshold();

        /**
         * A CloudWatch metric dimension.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-cloudwatchalarmdefinition.html#cfn-emr-instancegroupconfig-cloudwatchalarmdefinition-dimensions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-cloudwatchalarmdefinition.html#cfn-emr-instancegroupconfig-cloudwatchalarmdefinition-dimensions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDimensions() {
            return null;
        }

        /**
         * The number of periods, in five-minute increments, during which the alarm condition must exist before the alarm triggers automatic scaling activity.
         * <p>
         * The default value is <code>1</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-cloudwatchalarmdefinition.html#cfn-emr-instancegroupconfig-cloudwatchalarmdefinition-evaluationperiods">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-cloudwatchalarmdefinition.html#cfn-emr-instancegroupconfig-cloudwatchalarmdefinition-evaluationperiods</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getEvaluationPeriods() {
            return null;
        }

        /**
         * The namespace for the CloudWatch metric.
         * <p>
         * The default is <code>AWS/ElasticMapReduce</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-cloudwatchalarmdefinition.html#cfn-emr-instancegroupconfig-cloudwatchalarmdefinition-namespace">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-cloudwatchalarmdefinition.html#cfn-emr-instancegroupconfig-cloudwatchalarmdefinition-namespace</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNamespace() {
            return null;
        }

        /**
         * The statistic to apply to the metric associated with the alarm.
         * <p>
         * The default is <code>AVERAGE</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-cloudwatchalarmdefinition.html#cfn-emr-instancegroupconfig-cloudwatchalarmdefinition-statistic">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-cloudwatchalarmdefinition.html#cfn-emr-instancegroupconfig-cloudwatchalarmdefinition-statistic</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStatistic() {
            return null;
        }

        /**
         * The unit of measure associated with the CloudWatch metric being watched.
         * <p>
         * The value specified for <code>Unit</code> must correspond to the units specified in the CloudWatch metric.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-cloudwatchalarmdefinition.html#cfn-emr-instancegroupconfig-cloudwatchalarmdefinition-unit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-cloudwatchalarmdefinition.html#cfn-emr-instancegroupconfig-cloudwatchalarmdefinition-unit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUnit() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CloudWatchAlarmDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CloudWatchAlarmDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CloudWatchAlarmDefinitionProperty> {
            java.lang.String comparisonOperator;
            java.lang.String metricName;
            java.lang.Number period;
            java.lang.Number threshold;
            java.lang.Object dimensions;
            java.lang.Number evaluationPeriods;
            java.lang.String namespace;
            java.lang.String statistic;
            java.lang.String unit;

            /**
             * Sets the value of {@link CloudWatchAlarmDefinitionProperty#getComparisonOperator}
             * @param comparisonOperator Determines how the metric specified by <code>MetricName</code> is compared to the value specified by <code>Threshold</code> . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder comparisonOperator(java.lang.String comparisonOperator) {
                this.comparisonOperator = comparisonOperator;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchAlarmDefinitionProperty#getMetricName}
             * @param metricName The name of the CloudWatch metric that is watched to determine an alarm condition. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricName(java.lang.String metricName) {
                this.metricName = metricName;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchAlarmDefinitionProperty#getPeriod}
             * @param period The period, in seconds, over which the statistic is applied. This parameter is required.
             *               CloudWatch metrics for Amazon EMR are emitted every five minutes (300 seconds), so if you specify a CloudWatch metric, specify <code>300</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder period(java.lang.Number period) {
                this.period = period;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchAlarmDefinitionProperty#getThreshold}
             * @param threshold The value against which the specified statistic is compared. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder threshold(java.lang.Number threshold) {
                this.threshold = threshold;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchAlarmDefinitionProperty#getDimensions}
             * @param dimensions A CloudWatch metric dimension.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensions(software.amazon.awscdk.IResolvable dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchAlarmDefinitionProperty#getDimensions}
             * @param dimensions A CloudWatch metric dimension.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensions(java.util.List<? extends java.lang.Object> dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchAlarmDefinitionProperty#getEvaluationPeriods}
             * @param evaluationPeriods The number of periods, in five-minute increments, during which the alarm condition must exist before the alarm triggers automatic scaling activity.
             *                          The default value is <code>1</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder evaluationPeriods(java.lang.Number evaluationPeriods) {
                this.evaluationPeriods = evaluationPeriods;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchAlarmDefinitionProperty#getNamespace}
             * @param namespace The namespace for the CloudWatch metric.
             *                  The default is <code>AWS/ElasticMapReduce</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder namespace(java.lang.String namespace) {
                this.namespace = namespace;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchAlarmDefinitionProperty#getStatistic}
             * @param statistic The statistic to apply to the metric associated with the alarm.
             *                  The default is <code>AVERAGE</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statistic(java.lang.String statistic) {
                this.statistic = statistic;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchAlarmDefinitionProperty#getUnit}
             * @param unit The unit of measure associated with the CloudWatch metric being watched.
             *             The value specified for <code>Unit</code> must correspond to the units specified in the CloudWatch metric.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unit(java.lang.String unit) {
                this.unit = unit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CloudWatchAlarmDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CloudWatchAlarmDefinitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CloudWatchAlarmDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudWatchAlarmDefinitionProperty {
            private final java.lang.String comparisonOperator;
            private final java.lang.String metricName;
            private final java.lang.Number period;
            private final java.lang.Number threshold;
            private final java.lang.Object dimensions;
            private final java.lang.Number evaluationPeriods;
            private final java.lang.String namespace;
            private final java.lang.String statistic;
            private final java.lang.String unit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.comparisonOperator = software.amazon.jsii.Kernel.get(this, "comparisonOperator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.metricName = software.amazon.jsii.Kernel.get(this, "metricName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.period = software.amazon.jsii.Kernel.get(this, "period", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.threshold = software.amazon.jsii.Kernel.get(this, "threshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.dimensions = software.amazon.jsii.Kernel.get(this, "dimensions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.evaluationPeriods = software.amazon.jsii.Kernel.get(this, "evaluationPeriods", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.namespace = software.amazon.jsii.Kernel.get(this, "namespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.statistic = software.amazon.jsii.Kernel.get(this, "statistic", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.unit = software.amazon.jsii.Kernel.get(this, "unit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.comparisonOperator = java.util.Objects.requireNonNull(builder.comparisonOperator, "comparisonOperator is required");
                this.metricName = java.util.Objects.requireNonNull(builder.metricName, "metricName is required");
                this.period = java.util.Objects.requireNonNull(builder.period, "period is required");
                this.threshold = java.util.Objects.requireNonNull(builder.threshold, "threshold is required");
                this.dimensions = builder.dimensions;
                this.evaluationPeriods = builder.evaluationPeriods;
                this.namespace = builder.namespace;
                this.statistic = builder.statistic;
                this.unit = builder.unit;
            }

            @Override
            public final java.lang.String getComparisonOperator() {
                return this.comparisonOperator;
            }

            @Override
            public final java.lang.String getMetricName() {
                return this.metricName;
            }

            @Override
            public final java.lang.Number getPeriod() {
                return this.period;
            }

            @Override
            public final java.lang.Number getThreshold() {
                return this.threshold;
            }

            @Override
            public final java.lang.Object getDimensions() {
                return this.dimensions;
            }

            @Override
            public final java.lang.Number getEvaluationPeriods() {
                return this.evaluationPeriods;
            }

            @Override
            public final java.lang.String getNamespace() {
                return this.namespace;
            }

            @Override
            public final java.lang.String getStatistic() {
                return this.statistic;
            }

            @Override
            public final java.lang.String getUnit() {
                return this.unit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("comparisonOperator", om.valueToTree(this.getComparisonOperator()));
                data.set("metricName", om.valueToTree(this.getMetricName()));
                data.set("period", om.valueToTree(this.getPeriod()));
                data.set("threshold", om.valueToTree(this.getThreshold()));
                if (this.getDimensions() != null) {
                    data.set("dimensions", om.valueToTree(this.getDimensions()));
                }
                if (this.getEvaluationPeriods() != null) {
                    data.set("evaluationPeriods", om.valueToTree(this.getEvaluationPeriods()));
                }
                if (this.getNamespace() != null) {
                    data.set("namespace", om.valueToTree(this.getNamespace()));
                }
                if (this.getStatistic() != null) {
                    data.set("statistic", om.valueToTree(this.getStatistic()));
                }
                if (this.getUnit() != null) {
                    data.set("unit", om.valueToTree(this.getUnit()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_emr.CfnInstanceGroupConfig.CloudWatchAlarmDefinitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CloudWatchAlarmDefinitionProperty.Jsii$Proxy that = (CloudWatchAlarmDefinitionProperty.Jsii$Proxy) o;

                if (!comparisonOperator.equals(that.comparisonOperator)) return false;
                if (!metricName.equals(that.metricName)) return false;
                if (!period.equals(that.period)) return false;
                if (!threshold.equals(that.threshold)) return false;
                if (this.dimensions != null ? !this.dimensions.equals(that.dimensions) : that.dimensions != null) return false;
                if (this.evaluationPeriods != null ? !this.evaluationPeriods.equals(that.evaluationPeriods) : that.evaluationPeriods != null) return false;
                if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) return false;
                if (this.statistic != null ? !this.statistic.equals(that.statistic) : that.statistic != null) return false;
                return this.unit != null ? this.unit.equals(that.unit) : that.unit == null;
            }

            @Override
            public final int hashCode() {
                int result = this.comparisonOperator.hashCode();
                result = 31 * result + (this.metricName.hashCode());
                result = 31 * result + (this.period.hashCode());
                result = 31 * result + (this.threshold.hashCode());
                result = 31 * result + (this.dimensions != null ? this.dimensions.hashCode() : 0);
                result = 31 * result + (this.evaluationPeriods != null ? this.evaluationPeriods.hashCode() : 0);
                result = 31 * result + (this.namespace != null ? this.namespace.hashCode() : 0);
                result = 31 * result + (this.statistic != null ? this.statistic.hashCode() : 0);
                result = 31 * result + (this.unit != null ? this.unit.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <code>Configurations</code> is a property of the <code>AWS::EMR::Cluster</code> resource that specifies the configuration of applications on an Amazon EMR cluster.
     * <p>
     * Configurations are optional. You can use them to have EMR customize applications and software bundled with Amazon EMR when a cluster is created. A configuration consists of a classification, properties, and optional nested configurations. A classification refers to an application-specific configuration file. Properties are the settings you want to change in that file. For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-configure-apps.html">Configuring Applications</a> .
     * <p>
     * <blockquote>
     * <p>
     * Applies only to Amazon EMR releases 4.0 and later.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emr.*;
     * ConfigurationProperty configurationProperty_;
     * ConfigurationProperty configurationProperty = ConfigurationProperty.builder()
     *         .classification("classification")
     *         .configurationProperties(Map.of(
     *                 "configurationPropertiesKey", "configurationProperties"))
     *         .configurations(List.of(configurationProperty_))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-configuration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-configuration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emr.CfnInstanceGroupConfig.ConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The classification within a configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-configuration.html#cfn-emr-instancegroupconfig-configuration-classification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-configuration.html#cfn-emr-instancegroupconfig-configuration-classification</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getClassification() {
            return null;
        }

        /**
         * Within a configuration classification, a set of properties that represent the settings that you want to change in the configuration file.
         * <p>
         * Duplicates not allowed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-configuration.html#cfn-emr-instancegroupconfig-configuration-configurationproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-configuration.html#cfn-emr-instancegroupconfig-configuration-configurationproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConfigurationProperties() {
            return null;
        }

        /**
         * A list of additional configurations to apply within a configuration object.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-configuration.html#cfn-emr-instancegroupconfig-configuration-configurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-configuration.html#cfn-emr-instancegroupconfig-configuration-configurations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConfigurations() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConfigurationProperty> {
            java.lang.String classification;
            java.lang.Object configurationProperties;
            java.lang.Object configurations;

            /**
             * Sets the value of {@link ConfigurationProperty#getClassification}
             * @param classification The classification within a configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder classification(java.lang.String classification) {
                this.classification = classification;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationProperty#getConfigurationProperties}
             * @param configurationProperties Within a configuration classification, a set of properties that represent the settings that you want to change in the configuration file.
             *                                Duplicates not allowed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configurationProperties(java.util.Map<java.lang.String, java.lang.String> configurationProperties) {
                this.configurationProperties = configurationProperties;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationProperty#getConfigurationProperties}
             * @param configurationProperties Within a configuration classification, a set of properties that represent the settings that you want to change in the configuration file.
             *                                Duplicates not allowed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configurationProperties(software.amazon.awscdk.IResolvable configurationProperties) {
                this.configurationProperties = configurationProperties;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationProperty#getConfigurations}
             * @param configurations A list of additional configurations to apply within a configuration object.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configurations(software.amazon.awscdk.IResolvable configurations) {
                this.configurations = configurations;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationProperty#getConfigurations}
             * @param configurations A list of additional configurations to apply within a configuration object.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configurations(java.util.List<? extends java.lang.Object> configurations) {
                this.configurations = configurations;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConfigurationProperty {
            private final java.lang.String classification;
            private final java.lang.Object configurationProperties;
            private final java.lang.Object configurations;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.classification = software.amazon.jsii.Kernel.get(this, "classification", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.configurationProperties = software.amazon.jsii.Kernel.get(this, "configurationProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.configurations = software.amazon.jsii.Kernel.get(this, "configurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.classification = builder.classification;
                this.configurationProperties = builder.configurationProperties;
                this.configurations = builder.configurations;
            }

            @Override
            public final java.lang.String getClassification() {
                return this.classification;
            }

            @Override
            public final java.lang.Object getConfigurationProperties() {
                return this.configurationProperties;
            }

            @Override
            public final java.lang.Object getConfigurations() {
                return this.configurations;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getClassification() != null) {
                    data.set("classification", om.valueToTree(this.getClassification()));
                }
                if (this.getConfigurationProperties() != null) {
                    data.set("configurationProperties", om.valueToTree(this.getConfigurationProperties()));
                }
                if (this.getConfigurations() != null) {
                    data.set("configurations", om.valueToTree(this.getConfigurations()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_emr.CfnInstanceGroupConfig.ConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConfigurationProperty.Jsii$Proxy that = (ConfigurationProperty.Jsii$Proxy) o;

                if (this.classification != null ? !this.classification.equals(that.classification) : that.classification != null) return false;
                if (this.configurationProperties != null ? !this.configurationProperties.equals(that.configurationProperties) : that.configurationProperties != null) return false;
                return this.configurations != null ? this.configurations.equals(that.configurations) : that.configurations == null;
            }

            @Override
            public final int hashCode() {
                int result = this.classification != null ? this.classification.hashCode() : 0;
                result = 31 * result + (this.configurationProperties != null ? this.configurationProperties.hashCode() : 0);
                result = 31 * result + (this.configurations != null ? this.configurations.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration of requested EBS block device associated with the instance group with count of volumes that are associated to every instance.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emr.*;
     * EbsBlockDeviceConfigProperty ebsBlockDeviceConfigProperty = EbsBlockDeviceConfigProperty.builder()
     *         .volumeSpecification(VolumeSpecificationProperty.builder()
     *                 .sizeInGb(123)
     *                 .volumeType("volumeType")
     *                 // the properties below are optional
     *                 .iops(123)
     *                 .throughput(123)
     *                 .build())
     *         // the properties below are optional
     *         .volumesPerInstance(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-ebsblockdeviceconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-ebsblockdeviceconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emr.CfnInstanceGroupConfig.EbsBlockDeviceConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(EbsBlockDeviceConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EbsBlockDeviceConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * EBS volume specifications such as volume type, IOPS, size (GiB) and throughput (MiB/s) that are requested for the EBS volume attached to an Amazon EC2 instance in the cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-ebsblockdeviceconfig.html#cfn-emr-instancegroupconfig-ebsblockdeviceconfig-volumespecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-ebsblockdeviceconfig.html#cfn-emr-instancegroupconfig-ebsblockdeviceconfig-volumespecification</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getVolumeSpecification();

        /**
         * Number of EBS volumes with a specific volume configuration that are associated with every instance in the instance group.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-ebsblockdeviceconfig.html#cfn-emr-instancegroupconfig-ebsblockdeviceconfig-volumesperinstance">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-ebsblockdeviceconfig.html#cfn-emr-instancegroupconfig-ebsblockdeviceconfig-volumesperinstance</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getVolumesPerInstance() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EbsBlockDeviceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EbsBlockDeviceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EbsBlockDeviceConfigProperty> {
            java.lang.Object volumeSpecification;
            java.lang.Number volumesPerInstance;

            /**
             * Sets the value of {@link EbsBlockDeviceConfigProperty#getVolumeSpecification}
             * @param volumeSpecification EBS volume specifications such as volume type, IOPS, size (GiB) and throughput (MiB/s) that are requested for the EBS volume attached to an Amazon EC2 instance in the cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeSpecification(software.amazon.awscdk.IResolvable volumeSpecification) {
                this.volumeSpecification = volumeSpecification;
                return this;
            }

            /**
             * Sets the value of {@link EbsBlockDeviceConfigProperty#getVolumeSpecification}
             * @param volumeSpecification EBS volume specifications such as volume type, IOPS, size (GiB) and throughput (MiB/s) that are requested for the EBS volume attached to an Amazon EC2 instance in the cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeSpecification(software.amazon.awscdk.services.emr.CfnInstanceGroupConfig.VolumeSpecificationProperty volumeSpecification) {
                this.volumeSpecification = volumeSpecification;
                return this;
            }

            /**
             * Sets the value of {@link EbsBlockDeviceConfigProperty#getVolumesPerInstance}
             * @param volumesPerInstance Number of EBS volumes with a specific volume configuration that are associated with every instance in the instance group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumesPerInstance(java.lang.Number volumesPerInstance) {
                this.volumesPerInstance = volumesPerInstance;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EbsBlockDeviceConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EbsBlockDeviceConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EbsBlockDeviceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EbsBlockDeviceConfigProperty {
            private final java.lang.Object volumeSpecification;
            private final java.lang.Number volumesPerInstance;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.volumeSpecification = software.amazon.jsii.Kernel.get(this, "volumeSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.volumesPerInstance = software.amazon.jsii.Kernel.get(this, "volumesPerInstance", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.volumeSpecification = java.util.Objects.requireNonNull(builder.volumeSpecification, "volumeSpecification is required");
                this.volumesPerInstance = builder.volumesPerInstance;
            }

            @Override
            public final java.lang.Object getVolumeSpecification() {
                return this.volumeSpecification;
            }

            @Override
            public final java.lang.Number getVolumesPerInstance() {
                return this.volumesPerInstance;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("volumeSpecification", om.valueToTree(this.getVolumeSpecification()));
                if (this.getVolumesPerInstance() != null) {
                    data.set("volumesPerInstance", om.valueToTree(this.getVolumesPerInstance()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_emr.CfnInstanceGroupConfig.EbsBlockDeviceConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EbsBlockDeviceConfigProperty.Jsii$Proxy that = (EbsBlockDeviceConfigProperty.Jsii$Proxy) o;

                if (!volumeSpecification.equals(that.volumeSpecification)) return false;
                return this.volumesPerInstance != null ? this.volumesPerInstance.equals(that.volumesPerInstance) : that.volumesPerInstance == null;
            }

            @Override
            public final int hashCode() {
                int result = this.volumeSpecification.hashCode();
                result = 31 * result + (this.volumesPerInstance != null ? this.volumesPerInstance.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The Amazon EBS configuration of a cluster instance.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emr.*;
     * EbsConfigurationProperty ebsConfigurationProperty = EbsConfigurationProperty.builder()
     *         .ebsBlockDeviceConfigs(List.of(EbsBlockDeviceConfigProperty.builder()
     *                 .volumeSpecification(VolumeSpecificationProperty.builder()
     *                         .sizeInGb(123)
     *                         .volumeType("volumeType")
     *                         // the properties below are optional
     *                         .iops(123)
     *                         .throughput(123)
     *                         .build())
     *                 // the properties below are optional
     *                 .volumesPerInstance(123)
     *                 .build()))
     *         .ebsOptimized(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-ebsconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-ebsconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emr.CfnInstanceGroupConfig.EbsConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(EbsConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EbsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An array of Amazon EBS volume specifications attached to a cluster instance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-ebsconfiguration.html#cfn-emr-instancegroupconfig-ebsconfiguration-ebsblockdeviceconfigs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-ebsconfiguration.html#cfn-emr-instancegroupconfig-ebsconfiguration-ebsblockdeviceconfigs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEbsBlockDeviceConfigs() {
            return null;
        }

        /**
         * Indicates whether an Amazon EBS volume is EBS-optimized.
         * <p>
         * The default is false. You should explicitly set this value to true to enable the Amazon EBS-optimized setting for an EC2 instance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-ebsconfiguration.html#cfn-emr-instancegroupconfig-ebsconfiguration-ebsoptimized">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-ebsconfiguration.html#cfn-emr-instancegroupconfig-ebsconfiguration-ebsoptimized</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEbsOptimized() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EbsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EbsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EbsConfigurationProperty> {
            java.lang.Object ebsBlockDeviceConfigs;
            java.lang.Object ebsOptimized;

            /**
             * Sets the value of {@link EbsConfigurationProperty#getEbsBlockDeviceConfigs}
             * @param ebsBlockDeviceConfigs An array of Amazon EBS volume specifications attached to a cluster instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebsBlockDeviceConfigs(software.amazon.awscdk.IResolvable ebsBlockDeviceConfigs) {
                this.ebsBlockDeviceConfigs = ebsBlockDeviceConfigs;
                return this;
            }

            /**
             * Sets the value of {@link EbsConfigurationProperty#getEbsBlockDeviceConfigs}
             * @param ebsBlockDeviceConfigs An array of Amazon EBS volume specifications attached to a cluster instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebsBlockDeviceConfigs(java.util.List<? extends java.lang.Object> ebsBlockDeviceConfigs) {
                this.ebsBlockDeviceConfigs = ebsBlockDeviceConfigs;
                return this;
            }

            /**
             * Sets the value of {@link EbsConfigurationProperty#getEbsOptimized}
             * @param ebsOptimized Indicates whether an Amazon EBS volume is EBS-optimized.
             *                     The default is false. You should explicitly set this value to true to enable the Amazon EBS-optimized setting for an EC2 instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebsOptimized(java.lang.Boolean ebsOptimized) {
                this.ebsOptimized = ebsOptimized;
                return this;
            }

            /**
             * Sets the value of {@link EbsConfigurationProperty#getEbsOptimized}
             * @param ebsOptimized Indicates whether an Amazon EBS volume is EBS-optimized.
             *                     The default is false. You should explicitly set this value to true to enable the Amazon EBS-optimized setting for an EC2 instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebsOptimized(software.amazon.awscdk.IResolvable ebsOptimized) {
                this.ebsOptimized = ebsOptimized;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EbsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EbsConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EbsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EbsConfigurationProperty {
            private final java.lang.Object ebsBlockDeviceConfigs;
            private final java.lang.Object ebsOptimized;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ebsBlockDeviceConfigs = software.amazon.jsii.Kernel.get(this, "ebsBlockDeviceConfigs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ebsOptimized = software.amazon.jsii.Kernel.get(this, "ebsOptimized", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ebsBlockDeviceConfigs = builder.ebsBlockDeviceConfigs;
                this.ebsOptimized = builder.ebsOptimized;
            }

            @Override
            public final java.lang.Object getEbsBlockDeviceConfigs() {
                return this.ebsBlockDeviceConfigs;
            }

            @Override
            public final java.lang.Object getEbsOptimized() {
                return this.ebsOptimized;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEbsBlockDeviceConfigs() != null) {
                    data.set("ebsBlockDeviceConfigs", om.valueToTree(this.getEbsBlockDeviceConfigs()));
                }
                if (this.getEbsOptimized() != null) {
                    data.set("ebsOptimized", om.valueToTree(this.getEbsOptimized()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_emr.CfnInstanceGroupConfig.EbsConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EbsConfigurationProperty.Jsii$Proxy that = (EbsConfigurationProperty.Jsii$Proxy) o;

                if (this.ebsBlockDeviceConfigs != null ? !this.ebsBlockDeviceConfigs.equals(that.ebsBlockDeviceConfigs) : that.ebsBlockDeviceConfigs != null) return false;
                return this.ebsOptimized != null ? this.ebsOptimized.equals(that.ebsOptimized) : that.ebsOptimized == null;
            }

            @Override
            public final int hashCode() {
                int result = this.ebsBlockDeviceConfigs != null ? this.ebsBlockDeviceConfigs.hashCode() : 0;
                result = 31 * result + (this.ebsOptimized != null ? this.ebsOptimized.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <code>MetricDimension</code> is a subproperty of the <code>CloudWatchAlarmDefinition</code> property type.
     * <p>
     * <code>MetricDimension</code> specifies a CloudWatch dimension, which is specified with a <code>Key</code> <code>Value</code> pair. The key is known as a <code>Name</code> in CloudWatch. By default, Amazon EMR uses one dimension whose <code>Key</code> is <code>JobFlowID</code> and <code>Value</code> is a variable representing the cluster ID, which is <code>${emr.clusterId}</code> . This enables the automatic scaling rule for EMR to bootstrap when the cluster ID becomes available during cluster creation.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emr.*;
     * MetricDimensionProperty metricDimensionProperty = MetricDimensionProperty.builder()
     *         .key("key")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-metricdimension.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-metricdimension.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emr.CfnInstanceGroupConfig.MetricDimensionProperty")
    @software.amazon.jsii.Jsii.Proxy(MetricDimensionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MetricDimensionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The dimension name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-metricdimension.html#cfn-emr-instancegroupconfig-metricdimension-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-metricdimension.html#cfn-emr-instancegroupconfig-metricdimension-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * The dimension value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-metricdimension.html#cfn-emr-instancegroupconfig-metricdimension-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-metricdimension.html#cfn-emr-instancegroupconfig-metricdimension-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link MetricDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MetricDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MetricDimensionProperty> {
            java.lang.String key;
            java.lang.String value;

            /**
             * Sets the value of {@link MetricDimensionProperty#getKey}
             * @param key The dimension name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link MetricDimensionProperty#getValue}
             * @param value The dimension value. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetricDimensionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MetricDimensionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MetricDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetricDimensionProperty {
            private final java.lang.String key;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_emr.CfnInstanceGroupConfig.MetricDimensionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MetricDimensionProperty.Jsii$Proxy that = (MetricDimensionProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * <code>ScalingAction</code> is a subproperty of the <code>ScalingRule</code> property type.
     * <p>
     * <code>ScalingAction</code> determines the type of adjustment the automatic scaling activity makes when triggered, and the periodicity of the adjustment.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emr.*;
     * ScalingActionProperty scalingActionProperty = ScalingActionProperty.builder()
     *         .simpleScalingPolicyConfiguration(SimpleScalingPolicyConfigurationProperty.builder()
     *                 .scalingAdjustment(123)
     *                 // the properties below are optional
     *                 .adjustmentType("adjustmentType")
     *                 .coolDown(123)
     *                 .build())
     *         // the properties below are optional
     *         .market("market")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-scalingaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-scalingaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emr.CfnInstanceGroupConfig.ScalingActionProperty")
    @software.amazon.jsii.Jsii.Proxy(ScalingActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScalingActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of adjustment the automatic scaling activity makes when triggered, and the periodicity of the adjustment.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-scalingaction.html#cfn-emr-instancegroupconfig-scalingaction-simplescalingpolicyconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-scalingaction.html#cfn-emr-instancegroupconfig-scalingaction-simplescalingpolicyconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSimpleScalingPolicyConfiguration();

        /**
         * Not available for instance groups.
         * <p>
         * Instance groups use the market type specified for the group.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-scalingaction.html#cfn-emr-instancegroupconfig-scalingaction-market">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-scalingaction.html#cfn-emr-instancegroupconfig-scalingaction-market</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMarket() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ScalingActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScalingActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScalingActionProperty> {
            java.lang.Object simpleScalingPolicyConfiguration;
            java.lang.String market;

            /**
             * Sets the value of {@link ScalingActionProperty#getSimpleScalingPolicyConfiguration}
             * @param simpleScalingPolicyConfiguration The type of adjustment the automatic scaling activity makes when triggered, and the periodicity of the adjustment. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder simpleScalingPolicyConfiguration(software.amazon.awscdk.IResolvable simpleScalingPolicyConfiguration) {
                this.simpleScalingPolicyConfiguration = simpleScalingPolicyConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ScalingActionProperty#getSimpleScalingPolicyConfiguration}
             * @param simpleScalingPolicyConfiguration The type of adjustment the automatic scaling activity makes when triggered, and the periodicity of the adjustment. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder simpleScalingPolicyConfiguration(software.amazon.awscdk.services.emr.CfnInstanceGroupConfig.SimpleScalingPolicyConfigurationProperty simpleScalingPolicyConfiguration) {
                this.simpleScalingPolicyConfiguration = simpleScalingPolicyConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ScalingActionProperty#getMarket}
             * @param market Not available for instance groups.
             *               Instance groups use the market type specified for the group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder market(java.lang.String market) {
                this.market = market;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScalingActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScalingActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScalingActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScalingActionProperty {
            private final java.lang.Object simpleScalingPolicyConfiguration;
            private final java.lang.String market;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.simpleScalingPolicyConfiguration = software.amazon.jsii.Kernel.get(this, "simpleScalingPolicyConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.market = software.amazon.jsii.Kernel.get(this, "market", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.simpleScalingPolicyConfiguration = java.util.Objects.requireNonNull(builder.simpleScalingPolicyConfiguration, "simpleScalingPolicyConfiguration is required");
                this.market = builder.market;
            }

            @Override
            public final java.lang.Object getSimpleScalingPolicyConfiguration() {
                return this.simpleScalingPolicyConfiguration;
            }

            @Override
            public final java.lang.String getMarket() {
                return this.market;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("simpleScalingPolicyConfiguration", om.valueToTree(this.getSimpleScalingPolicyConfiguration()));
                if (this.getMarket() != null) {
                    data.set("market", om.valueToTree(this.getMarket()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_emr.CfnInstanceGroupConfig.ScalingActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScalingActionProperty.Jsii$Proxy that = (ScalingActionProperty.Jsii$Proxy) o;

                if (!simpleScalingPolicyConfiguration.equals(that.simpleScalingPolicyConfiguration)) return false;
                return this.market != null ? this.market.equals(that.market) : that.market == null;
            }

            @Override
            public final int hashCode() {
                int result = this.simpleScalingPolicyConfiguration.hashCode();
                result = 31 * result + (this.market != null ? this.market.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <code>ScalingConstraints</code> is a subproperty of the <code>AutoScalingPolicy</code> property type.
     * <p>
     * <code>ScalingConstraints</code> defines the upper and lower EC2 instance limits for an automatic scaling policy. Automatic scaling activities triggered by automatic scaling rules will not cause an instance group to grow above or shrink below these limits.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emr.*;
     * ScalingConstraintsProperty scalingConstraintsProperty = ScalingConstraintsProperty.builder()
     *         .maxCapacity(123)
     *         .minCapacity(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-scalingconstraints.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-scalingconstraints.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emr.CfnInstanceGroupConfig.ScalingConstraintsProperty")
    @software.amazon.jsii.Jsii.Proxy(ScalingConstraintsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScalingConstraintsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The upper boundary of Amazon EC2 instances in an instance group beyond which scaling activities are not allowed to grow.
         * <p>
         * Scale-out activities will not add instances beyond this boundary.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-scalingconstraints.html#cfn-emr-instancegroupconfig-scalingconstraints-maxcapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-scalingconstraints.html#cfn-emr-instancegroupconfig-scalingconstraints-maxcapacity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxCapacity();

        /**
         * The lower boundary of Amazon EC2 instances in an instance group below which scaling activities are not allowed to shrink.
         * <p>
         * Scale-in activities will not terminate instances below this boundary.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-scalingconstraints.html#cfn-emr-instancegroupconfig-scalingconstraints-mincapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-scalingconstraints.html#cfn-emr-instancegroupconfig-scalingconstraints-mincapacity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMinCapacity();

        /**
         * @return a {@link Builder} of {@link ScalingConstraintsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScalingConstraintsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScalingConstraintsProperty> {
            java.lang.Number maxCapacity;
            java.lang.Number minCapacity;

            /**
             * Sets the value of {@link ScalingConstraintsProperty#getMaxCapacity}
             * @param maxCapacity The upper boundary of Amazon EC2 instances in an instance group beyond which scaling activities are not allowed to grow. This parameter is required.
             *                    Scale-out activities will not add instances beyond this boundary.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxCapacity(java.lang.Number maxCapacity) {
                this.maxCapacity = maxCapacity;
                return this;
            }

            /**
             * Sets the value of {@link ScalingConstraintsProperty#getMinCapacity}
             * @param minCapacity The lower boundary of Amazon EC2 instances in an instance group below which scaling activities are not allowed to shrink. This parameter is required.
             *                    Scale-in activities will not terminate instances below this boundary.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minCapacity(java.lang.Number minCapacity) {
                this.minCapacity = minCapacity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScalingConstraintsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScalingConstraintsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScalingConstraintsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScalingConstraintsProperty {
            private final java.lang.Number maxCapacity;
            private final java.lang.Number minCapacity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxCapacity = software.amazon.jsii.Kernel.get(this, "maxCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minCapacity = software.amazon.jsii.Kernel.get(this, "minCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxCapacity = java.util.Objects.requireNonNull(builder.maxCapacity, "maxCapacity is required");
                this.minCapacity = java.util.Objects.requireNonNull(builder.minCapacity, "minCapacity is required");
            }

            @Override
            public final java.lang.Number getMaxCapacity() {
                return this.maxCapacity;
            }

            @Override
            public final java.lang.Number getMinCapacity() {
                return this.minCapacity;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("maxCapacity", om.valueToTree(this.getMaxCapacity()));
                data.set("minCapacity", om.valueToTree(this.getMinCapacity()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_emr.CfnInstanceGroupConfig.ScalingConstraintsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScalingConstraintsProperty.Jsii$Proxy that = (ScalingConstraintsProperty.Jsii$Proxy) o;

                if (!maxCapacity.equals(that.maxCapacity)) return false;
                return this.minCapacity.equals(that.minCapacity);
            }

            @Override
            public final int hashCode() {
                int result = this.maxCapacity.hashCode();
                result = 31 * result + (this.minCapacity.hashCode());
                return result;
            }
        }
    }
    /**
     * <code>ScalingRule</code> is a subproperty of the <code>AutoScalingPolicy</code> property type.
     * <p>
     * <code>ScalingRule</code> defines the scale-in or scale-out rules for scaling activity, including the CloudWatch metric alarm that triggers activity, how EC2 instances are added or removed, and the periodicity of adjustments. The automatic scaling policy for an instance group can comprise one or more automatic scaling rules.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emr.*;
     * ScalingRuleProperty scalingRuleProperty = ScalingRuleProperty.builder()
     *         .action(ScalingActionProperty.builder()
     *                 .simpleScalingPolicyConfiguration(SimpleScalingPolicyConfigurationProperty.builder()
     *                         .scalingAdjustment(123)
     *                         // the properties below are optional
     *                         .adjustmentType("adjustmentType")
     *                         .coolDown(123)
     *                         .build())
     *                 // the properties below are optional
     *                 .market("market")
     *                 .build())
     *         .name("name")
     *         .trigger(ScalingTriggerProperty.builder()
     *                 .cloudWatchAlarmDefinition(CloudWatchAlarmDefinitionProperty.builder()
     *                         .comparisonOperator("comparisonOperator")
     *                         .metricName("metricName")
     *                         .period(123)
     *                         .threshold(123)
     *                         // the properties below are optional
     *                         .dimensions(List.of(MetricDimensionProperty.builder()
     *                                 .key("key")
     *                                 .value("value")
     *                                 .build()))
     *                         .evaluationPeriods(123)
     *                         .namespace("namespace")
     *                         .statistic("statistic")
     *                         .unit("unit")
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .description("description")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-scalingrule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-scalingrule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emr.CfnInstanceGroupConfig.ScalingRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(ScalingRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScalingRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The conditions that trigger an automatic scaling activity.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-scalingrule.html#cfn-emr-instancegroupconfig-scalingrule-action">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-scalingrule.html#cfn-emr-instancegroupconfig-scalingrule-action</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getAction();

        /**
         * The name used to identify an automatic scaling rule.
         * <p>
         * Rule names must be unique within a scaling policy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-scalingrule.html#cfn-emr-instancegroupconfig-scalingrule-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-scalingrule.html#cfn-emr-instancegroupconfig-scalingrule-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The CloudWatch alarm definition that determines when automatic scaling activity is triggered.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-scalingrule.html#cfn-emr-instancegroupconfig-scalingrule-trigger">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-scalingrule.html#cfn-emr-instancegroupconfig-scalingrule-trigger</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTrigger();

        /**
         * A friendly, more verbose description of the automatic scaling rule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-scalingrule.html#cfn-emr-instancegroupconfig-scalingrule-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-scalingrule.html#cfn-emr-instancegroupconfig-scalingrule-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ScalingRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScalingRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScalingRuleProperty> {
            java.lang.Object action;
            java.lang.String name;
            java.lang.Object trigger;
            java.lang.String description;

            /**
             * Sets the value of {@link ScalingRuleProperty#getAction}
             * @param action The conditions that trigger an automatic scaling activity. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder action(software.amazon.awscdk.IResolvable action) {
                this.action = action;
                return this;
            }

            /**
             * Sets the value of {@link ScalingRuleProperty#getAction}
             * @param action The conditions that trigger an automatic scaling activity. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder action(software.amazon.awscdk.services.emr.CfnInstanceGroupConfig.ScalingActionProperty action) {
                this.action = action;
                return this;
            }

            /**
             * Sets the value of {@link ScalingRuleProperty#getName}
             * @param name The name used to identify an automatic scaling rule. This parameter is required.
             *             Rule names must be unique within a scaling policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link ScalingRuleProperty#getTrigger}
             * @param trigger The CloudWatch alarm definition that determines when automatic scaling activity is triggered. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trigger(software.amazon.awscdk.IResolvable trigger) {
                this.trigger = trigger;
                return this;
            }

            /**
             * Sets the value of {@link ScalingRuleProperty#getTrigger}
             * @param trigger The CloudWatch alarm definition that determines when automatic scaling activity is triggered. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trigger(software.amazon.awscdk.services.emr.CfnInstanceGroupConfig.ScalingTriggerProperty trigger) {
                this.trigger = trigger;
                return this;
            }

            /**
             * Sets the value of {@link ScalingRuleProperty#getDescription}
             * @param description A friendly, more verbose description of the automatic scaling rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScalingRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScalingRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScalingRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScalingRuleProperty {
            private final java.lang.Object action;
            private final java.lang.String name;
            private final java.lang.Object trigger;
            private final java.lang.String description;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.trigger = software.amazon.jsii.Kernel.get(this, "trigger", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.action = java.util.Objects.requireNonNull(builder.action, "action is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.trigger = java.util.Objects.requireNonNull(builder.trigger, "trigger is required");
                this.description = builder.description;
            }

            @Override
            public final java.lang.Object getAction() {
                return this.action;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getTrigger() {
                return this.trigger;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("action", om.valueToTree(this.getAction()));
                data.set("name", om.valueToTree(this.getName()));
                data.set("trigger", om.valueToTree(this.getTrigger()));
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_emr.CfnInstanceGroupConfig.ScalingRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScalingRuleProperty.Jsii$Proxy that = (ScalingRuleProperty.Jsii$Proxy) o;

                if (!action.equals(that.action)) return false;
                if (!name.equals(that.name)) return false;
                if (!trigger.equals(that.trigger)) return false;
                return this.description != null ? this.description.equals(that.description) : that.description == null;
            }

            @Override
            public final int hashCode() {
                int result = this.action.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.trigger.hashCode());
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <code>ScalingTrigger</code> is a subproperty of the <code>ScalingRule</code> property type.
     * <p>
     * <code>ScalingTrigger</code> determines the conditions that trigger an automatic scaling activity.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emr.*;
     * ScalingTriggerProperty scalingTriggerProperty = ScalingTriggerProperty.builder()
     *         .cloudWatchAlarmDefinition(CloudWatchAlarmDefinitionProperty.builder()
     *                 .comparisonOperator("comparisonOperator")
     *                 .metricName("metricName")
     *                 .period(123)
     *                 .threshold(123)
     *                 // the properties below are optional
     *                 .dimensions(List.of(MetricDimensionProperty.builder()
     *                         .key("key")
     *                         .value("value")
     *                         .build()))
     *                 .evaluationPeriods(123)
     *                 .namespace("namespace")
     *                 .statistic("statistic")
     *                 .unit("unit")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-scalingtrigger.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-scalingtrigger.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emr.CfnInstanceGroupConfig.ScalingTriggerProperty")
    @software.amazon.jsii.Jsii.Proxy(ScalingTriggerProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScalingTriggerProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The definition of a CloudWatch metric alarm.
         * <p>
         * When the defined alarm conditions are met along with other trigger parameters, scaling activity begins.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-scalingtrigger.html#cfn-emr-instancegroupconfig-scalingtrigger-cloudwatchalarmdefinition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-scalingtrigger.html#cfn-emr-instancegroupconfig-scalingtrigger-cloudwatchalarmdefinition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getCloudWatchAlarmDefinition();

        /**
         * @return a {@link Builder} of {@link ScalingTriggerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScalingTriggerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScalingTriggerProperty> {
            java.lang.Object cloudWatchAlarmDefinition;

            /**
             * Sets the value of {@link ScalingTriggerProperty#getCloudWatchAlarmDefinition}
             * @param cloudWatchAlarmDefinition The definition of a CloudWatch metric alarm. This parameter is required.
             *                                  When the defined alarm conditions are met along with other trigger parameters, scaling activity begins.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchAlarmDefinition(software.amazon.awscdk.IResolvable cloudWatchAlarmDefinition) {
                this.cloudWatchAlarmDefinition = cloudWatchAlarmDefinition;
                return this;
            }

            /**
             * Sets the value of {@link ScalingTriggerProperty#getCloudWatchAlarmDefinition}
             * @param cloudWatchAlarmDefinition The definition of a CloudWatch metric alarm. This parameter is required.
             *                                  When the defined alarm conditions are met along with other trigger parameters, scaling activity begins.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchAlarmDefinition(software.amazon.awscdk.services.emr.CfnInstanceGroupConfig.CloudWatchAlarmDefinitionProperty cloudWatchAlarmDefinition) {
                this.cloudWatchAlarmDefinition = cloudWatchAlarmDefinition;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScalingTriggerProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScalingTriggerProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScalingTriggerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScalingTriggerProperty {
            private final java.lang.Object cloudWatchAlarmDefinition;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cloudWatchAlarmDefinition = software.amazon.jsii.Kernel.get(this, "cloudWatchAlarmDefinition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cloudWatchAlarmDefinition = java.util.Objects.requireNonNull(builder.cloudWatchAlarmDefinition, "cloudWatchAlarmDefinition is required");
            }

            @Override
            public final java.lang.Object getCloudWatchAlarmDefinition() {
                return this.cloudWatchAlarmDefinition;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("cloudWatchAlarmDefinition", om.valueToTree(this.getCloudWatchAlarmDefinition()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_emr.CfnInstanceGroupConfig.ScalingTriggerProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScalingTriggerProperty.Jsii$Proxy that = (ScalingTriggerProperty.Jsii$Proxy) o;

                return this.cloudWatchAlarmDefinition.equals(that.cloudWatchAlarmDefinition);
            }

            @Override
            public final int hashCode() {
                int result = this.cloudWatchAlarmDefinition.hashCode();
                return result;
            }
        }
    }
    /**
     * <code>SimpleScalingPolicyConfiguration</code> is a subproperty of the <code>ScalingAction</code> property type.
     * <p>
     * <code>SimpleScalingPolicyConfiguration</code> determines how an automatic scaling action adds or removes instances, the cooldown period, and the number of EC2 instances that are added each time the CloudWatch metric alarm condition is satisfied.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emr.*;
     * SimpleScalingPolicyConfigurationProperty simpleScalingPolicyConfigurationProperty = SimpleScalingPolicyConfigurationProperty.builder()
     *         .scalingAdjustment(123)
     *         // the properties below are optional
     *         .adjustmentType("adjustmentType")
     *         .coolDown(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-simplescalingpolicyconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-simplescalingpolicyconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emr.CfnInstanceGroupConfig.SimpleScalingPolicyConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SimpleScalingPolicyConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SimpleScalingPolicyConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The amount by which to scale in or scale out, based on the specified <code>AdjustmentType</code> .
         * <p>
         * A positive value adds to the instance group's Amazon EC2 instance count while a negative number removes instances. If <code>AdjustmentType</code> is set to <code>EXACT_CAPACITY</code> , the number should only be a positive integer. If <code>AdjustmentType</code> is set to <code>PERCENT_CHANGE_IN_CAPACITY</code> , the value should express the percentage as an integer. For example, -20 indicates a decrease in 20% increments of cluster capacity.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-simplescalingpolicyconfiguration.html#cfn-emr-instancegroupconfig-simplescalingpolicyconfiguration-scalingadjustment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-simplescalingpolicyconfiguration.html#cfn-emr-instancegroupconfig-simplescalingpolicyconfiguration-scalingadjustment</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getScalingAdjustment();

        /**
         * The way in which Amazon EC2 instances are added (if <code>ScalingAdjustment</code> is a positive number) or terminated (if <code>ScalingAdjustment</code> is a negative number) each time the scaling activity is triggered.
         * <p>
         * <code>CHANGE_IN_CAPACITY</code> is the default. <code>CHANGE_IN_CAPACITY</code> indicates that the Amazon EC2 instance count increments or decrements by <code>ScalingAdjustment</code> , which should be expressed as an integer. <code>PERCENT_CHANGE_IN_CAPACITY</code> indicates the instance count increments or decrements by the percentage specified by <code>ScalingAdjustment</code> , which should be expressed as an integer. For example, 20 indicates an increase in 20% increments of cluster capacity. <code>EXACT_CAPACITY</code> indicates the scaling activity results in an instance group with the number of Amazon EC2 instances specified by <code>ScalingAdjustment</code> , which should be expressed as a positive integer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-simplescalingpolicyconfiguration.html#cfn-emr-instancegroupconfig-simplescalingpolicyconfiguration-adjustmenttype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-simplescalingpolicyconfiguration.html#cfn-emr-instancegroupconfig-simplescalingpolicyconfiguration-adjustmenttype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAdjustmentType() {
            return null;
        }

        /**
         * The amount of time, in seconds, after a scaling activity completes before any further trigger-related scaling activities can start.
         * <p>
         * The default value is 0.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-simplescalingpolicyconfiguration.html#cfn-emr-instancegroupconfig-simplescalingpolicyconfiguration-cooldown">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-simplescalingpolicyconfiguration.html#cfn-emr-instancegroupconfig-simplescalingpolicyconfiguration-cooldown</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCoolDown() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SimpleScalingPolicyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SimpleScalingPolicyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SimpleScalingPolicyConfigurationProperty> {
            java.lang.Number scalingAdjustment;
            java.lang.String adjustmentType;
            java.lang.Number coolDown;

            /**
             * Sets the value of {@link SimpleScalingPolicyConfigurationProperty#getScalingAdjustment}
             * @param scalingAdjustment The amount by which to scale in or scale out, based on the specified <code>AdjustmentType</code> . This parameter is required.
             *                          A positive value adds to the instance group's Amazon EC2 instance count while a negative number removes instances. If <code>AdjustmentType</code> is set to <code>EXACT_CAPACITY</code> , the number should only be a positive integer. If <code>AdjustmentType</code> is set to <code>PERCENT_CHANGE_IN_CAPACITY</code> , the value should express the percentage as an integer. For example, -20 indicates a decrease in 20% increments of cluster capacity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scalingAdjustment(java.lang.Number scalingAdjustment) {
                this.scalingAdjustment = scalingAdjustment;
                return this;
            }

            /**
             * Sets the value of {@link SimpleScalingPolicyConfigurationProperty#getAdjustmentType}
             * @param adjustmentType The way in which Amazon EC2 instances are added (if <code>ScalingAdjustment</code> is a positive number) or terminated (if <code>ScalingAdjustment</code> is a negative number) each time the scaling activity is triggered.
             *                       <code>CHANGE_IN_CAPACITY</code> is the default. <code>CHANGE_IN_CAPACITY</code> indicates that the Amazon EC2 instance count increments or decrements by <code>ScalingAdjustment</code> , which should be expressed as an integer. <code>PERCENT_CHANGE_IN_CAPACITY</code> indicates the instance count increments or decrements by the percentage specified by <code>ScalingAdjustment</code> , which should be expressed as an integer. For example, 20 indicates an increase in 20% increments of cluster capacity. <code>EXACT_CAPACITY</code> indicates the scaling activity results in an instance group with the number of Amazon EC2 instances specified by <code>ScalingAdjustment</code> , which should be expressed as a positive integer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder adjustmentType(java.lang.String adjustmentType) {
                this.adjustmentType = adjustmentType;
                return this;
            }

            /**
             * Sets the value of {@link SimpleScalingPolicyConfigurationProperty#getCoolDown}
             * @param coolDown The amount of time, in seconds, after a scaling activity completes before any further trigger-related scaling activities can start.
             *                 The default value is 0.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder coolDown(java.lang.Number coolDown) {
                this.coolDown = coolDown;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SimpleScalingPolicyConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SimpleScalingPolicyConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SimpleScalingPolicyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SimpleScalingPolicyConfigurationProperty {
            private final java.lang.Number scalingAdjustment;
            private final java.lang.String adjustmentType;
            private final java.lang.Number coolDown;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.scalingAdjustment = software.amazon.jsii.Kernel.get(this, "scalingAdjustment", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.adjustmentType = software.amazon.jsii.Kernel.get(this, "adjustmentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.coolDown = software.amazon.jsii.Kernel.get(this, "coolDown", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.scalingAdjustment = java.util.Objects.requireNonNull(builder.scalingAdjustment, "scalingAdjustment is required");
                this.adjustmentType = builder.adjustmentType;
                this.coolDown = builder.coolDown;
            }

            @Override
            public final java.lang.Number getScalingAdjustment() {
                return this.scalingAdjustment;
            }

            @Override
            public final java.lang.String getAdjustmentType() {
                return this.adjustmentType;
            }

            @Override
            public final java.lang.Number getCoolDown() {
                return this.coolDown;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("scalingAdjustment", om.valueToTree(this.getScalingAdjustment()));
                if (this.getAdjustmentType() != null) {
                    data.set("adjustmentType", om.valueToTree(this.getAdjustmentType()));
                }
                if (this.getCoolDown() != null) {
                    data.set("coolDown", om.valueToTree(this.getCoolDown()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_emr.CfnInstanceGroupConfig.SimpleScalingPolicyConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SimpleScalingPolicyConfigurationProperty.Jsii$Proxy that = (SimpleScalingPolicyConfigurationProperty.Jsii$Proxy) o;

                if (!scalingAdjustment.equals(that.scalingAdjustment)) return false;
                if (this.adjustmentType != null ? !this.adjustmentType.equals(that.adjustmentType) : that.adjustmentType != null) return false;
                return this.coolDown != null ? this.coolDown.equals(that.coolDown) : that.coolDown == null;
            }

            @Override
            public final int hashCode() {
                int result = this.scalingAdjustment.hashCode();
                result = 31 * result + (this.adjustmentType != null ? this.adjustmentType.hashCode() : 0);
                result = 31 * result + (this.coolDown != null ? this.coolDown.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <code>VolumeSpecification</code> is a subproperty of the <code>EbsBlockDeviceConfig</code> property type.
     * <p>
     * <code>VolumeSecification</code> determines the volume type, IOPS, and size (GiB) for EBS volumes attached to EC2 instances.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emr.*;
     * VolumeSpecificationProperty volumeSpecificationProperty = VolumeSpecificationProperty.builder()
     *         .sizeInGb(123)
     *         .volumeType("volumeType")
     *         // the properties below are optional
     *         .iops(123)
     *         .throughput(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-volumespecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-volumespecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emr.CfnInstanceGroupConfig.VolumeSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(VolumeSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VolumeSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The volume size, in gibibytes (GiB).
         * <p>
         * This can be a number from 1 - 1024. If the volume type is EBS-optimized, the minimum value is 10.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-volumespecification.html#cfn-emr-instancegroupconfig-volumespecification-sizeingb">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-volumespecification.html#cfn-emr-instancegroupconfig-volumespecification-sizeingb</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getSizeInGb();

        /**
         * The volume type.
         * <p>
         * Volume types supported are gp3, gp2, io1, st1, sc1, and standard.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-volumespecification.html#cfn-emr-instancegroupconfig-volumespecification-volumetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-volumespecification.html#cfn-emr-instancegroupconfig-volumespecification-volumetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getVolumeType();

        /**
         * The number of I/O operations per second (IOPS) that the volume supports.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-volumespecification.html#cfn-emr-instancegroupconfig-volumespecification-iops">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-volumespecification.html#cfn-emr-instancegroupconfig-volumespecification-iops</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIops() {
            return null;
        }

        /**
         * The throughput, in mebibyte per second (MiB/s).
         * <p>
         * This optional parameter can be a number from 125 - 1000 and is valid only for gp3 volumes.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-volumespecification.html#cfn-emr-instancegroupconfig-volumespecification-throughput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancegroupconfig-volumespecification.html#cfn-emr-instancegroupconfig-volumespecification-throughput</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getThroughput() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VolumeSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VolumeSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VolumeSpecificationProperty> {
            java.lang.Number sizeInGb;
            java.lang.String volumeType;
            java.lang.Number iops;
            java.lang.Number throughput;

            /**
             * Sets the value of {@link VolumeSpecificationProperty#getSizeInGb}
             * @param sizeInGb The volume size, in gibibytes (GiB). This parameter is required.
             *                 This can be a number from 1 - 1024. If the volume type is EBS-optimized, the minimum value is 10.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sizeInGb(java.lang.Number sizeInGb) {
                this.sizeInGb = sizeInGb;
                return this;
            }

            /**
             * Sets the value of {@link VolumeSpecificationProperty#getVolumeType}
             * @param volumeType The volume type. This parameter is required.
             *                   Volume types supported are gp3, gp2, io1, st1, sc1, and standard.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeType(java.lang.String volumeType) {
                this.volumeType = volumeType;
                return this;
            }

            /**
             * Sets the value of {@link VolumeSpecificationProperty#getIops}
             * @param iops The number of I/O operations per second (IOPS) that the volume supports.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iops(java.lang.Number iops) {
                this.iops = iops;
                return this;
            }

            /**
             * Sets the value of {@link VolumeSpecificationProperty#getThroughput}
             * @param throughput The throughput, in mebibyte per second (MiB/s).
             *                   This optional parameter can be a number from 125 - 1000 and is valid only for gp3 volumes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder throughput(java.lang.Number throughput) {
                this.throughput = throughput;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VolumeSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VolumeSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VolumeSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VolumeSpecificationProperty {
            private final java.lang.Number sizeInGb;
            private final java.lang.String volumeType;
            private final java.lang.Number iops;
            private final java.lang.Number throughput;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sizeInGb = software.amazon.jsii.Kernel.get(this, "sizeInGb", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.volumeType = software.amazon.jsii.Kernel.get(this, "volumeType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.iops = software.amazon.jsii.Kernel.get(this, "iops", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.throughput = software.amazon.jsii.Kernel.get(this, "throughput", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sizeInGb = java.util.Objects.requireNonNull(builder.sizeInGb, "sizeInGb is required");
                this.volumeType = java.util.Objects.requireNonNull(builder.volumeType, "volumeType is required");
                this.iops = builder.iops;
                this.throughput = builder.throughput;
            }

            @Override
            public final java.lang.Number getSizeInGb() {
                return this.sizeInGb;
            }

            @Override
            public final java.lang.String getVolumeType() {
                return this.volumeType;
            }

            @Override
            public final java.lang.Number getIops() {
                return this.iops;
            }

            @Override
            public final java.lang.Number getThroughput() {
                return this.throughput;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("sizeInGb", om.valueToTree(this.getSizeInGb()));
                data.set("volumeType", om.valueToTree(this.getVolumeType()));
                if (this.getIops() != null) {
                    data.set("iops", om.valueToTree(this.getIops()));
                }
                if (this.getThroughput() != null) {
                    data.set("throughput", om.valueToTree(this.getThroughput()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_emr.CfnInstanceGroupConfig.VolumeSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VolumeSpecificationProperty.Jsii$Proxy that = (VolumeSpecificationProperty.Jsii$Proxy) o;

                if (!sizeInGb.equals(that.sizeInGb)) return false;
                if (!volumeType.equals(that.volumeType)) return false;
                if (this.iops != null ? !this.iops.equals(that.iops) : that.iops != null) return false;
                return this.throughput != null ? this.throughput.equals(that.throughput) : that.throughput == null;
            }

            @Override
            public final int hashCode() {
                int result = this.sizeInGb.hashCode();
                result = 31 * result + (this.volumeType.hashCode());
                result = 31 * result + (this.iops != null ? this.iops.hashCode() : 0);
                result = 31 * result + (this.throughput != null ? this.throughput.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.emr.CfnInstanceGroupConfig}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.emr.CfnInstanceGroupConfig> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.emr.CfnInstanceGroupConfigProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.emr.CfnInstanceGroupConfigProps.Builder();
        }

        /**
         * Target number of instances for the instance group.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancegroupconfig.html#cfn-emr-instancegroupconfig-instancecount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancegroupconfig.html#cfn-emr-instancegroupconfig-instancecount</a>
         * @param instanceCount Target number of instances for the instance group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceCount(final java.lang.Number instanceCount) {
            this.props.instanceCount(instanceCount);
            return this;
        }

        /**
         * The role of the instance group in the cluster.
         * <p>
         * <em>Allowed Values</em> : TASK
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancegroupconfig.html#cfn-emr-instancegroupconfig-instancerole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancegroupconfig.html#cfn-emr-instancegroupconfig-instancerole</a>
         * @param instanceRole The role of the instance group in the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceRole(final java.lang.String instanceRole) {
            this.props.instanceRole(instanceRole);
            return this;
        }

        /**
         * The Amazon EC2 instance type for all instances in the instance group.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancegroupconfig.html#cfn-emr-instancegroupconfig-instancetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancegroupconfig.html#cfn-emr-instancegroupconfig-instancetype</a>
         * @param instanceType The Amazon EC2 instance type for all instances in the instance group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceType(final java.lang.String instanceType) {
            this.props.instanceType(instanceType);
            return this;
        }

        /**
         * The ID of an Amazon EMR cluster that you want to associate this instance group with.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancegroupconfig.html#cfn-emr-instancegroupconfig-jobflowid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancegroupconfig.html#cfn-emr-instancegroupconfig-jobflowid</a>
         * @param jobFlowId The ID of an Amazon EMR cluster that you want to associate this instance group with. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobFlowId(final java.lang.String jobFlowId) {
            this.props.jobFlowId(jobFlowId);
            return this;
        }

        /**
         * <code>AutoScalingPolicy</code> is a subproperty of <code>InstanceGroupConfig</code> .
         * <p>
         * <code>AutoScalingPolicy</code> defines how an instance group dynamically adds and terminates EC2 instances in response to the value of a CloudWatch metric. For more information, see <a href="https://docs.aws.amazon.com//emr/latest/ManagementGuide/emr-automatic-scaling.html">Using Automatic Scaling in Amazon EMR</a> in the <em>Amazon EMR Management Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancegroupconfig.html#cfn-emr-instancegroupconfig-autoscalingpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancegroupconfig.html#cfn-emr-instancegroupconfig-autoscalingpolicy</a>
         * @param autoScalingPolicy <code>AutoScalingPolicy</code> is a subproperty of <code>InstanceGroupConfig</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoScalingPolicy(final software.amazon.awscdk.IResolvable autoScalingPolicy) {
            this.props.autoScalingPolicy(autoScalingPolicy);
            return this;
        }
        /**
         * <code>AutoScalingPolicy</code> is a subproperty of <code>InstanceGroupConfig</code> .
         * <p>
         * <code>AutoScalingPolicy</code> defines how an instance group dynamically adds and terminates EC2 instances in response to the value of a CloudWatch metric. For more information, see <a href="https://docs.aws.amazon.com//emr/latest/ManagementGuide/emr-automatic-scaling.html">Using Automatic Scaling in Amazon EMR</a> in the <em>Amazon EMR Management Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancegroupconfig.html#cfn-emr-instancegroupconfig-autoscalingpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancegroupconfig.html#cfn-emr-instancegroupconfig-autoscalingpolicy</a>
         * @param autoScalingPolicy <code>AutoScalingPolicy</code> is a subproperty of <code>InstanceGroupConfig</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoScalingPolicy(final software.amazon.awscdk.services.emr.CfnInstanceGroupConfig.AutoScalingPolicyProperty autoScalingPolicy) {
            this.props.autoScalingPolicy(autoScalingPolicy);
            return this;
        }

        /**
         * If specified, indicates that the instance group uses Spot Instances.
         * <p>
         * This is the maximum price you are willing to pay for Spot Instances. Specify <code>OnDemandPrice</code> to set the amount equal to the On-Demand price, or specify an amount in USD.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancegroupconfig.html#cfn-emr-instancegroupconfig-bidprice">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancegroupconfig.html#cfn-emr-instancegroupconfig-bidprice</a>
         * @param bidPrice If specified, indicates that the instance group uses Spot Instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bidPrice(final java.lang.String bidPrice) {
            this.props.bidPrice(bidPrice);
            return this;
        }

        /**
         * <blockquote><p>Amazon EMR releases 4.x or later.<p></blockquote>
         * <p>
         * The list of configurations supplied for an Amazon EMR cluster instance group. You can specify a separate configuration for each instance group (master, core, and task).
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancegroupconfig.html#cfn-emr-instancegroupconfig-configurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancegroupconfig.html#cfn-emr-instancegroupconfig-configurations</a>
         * @param configurations <blockquote><p>Amazon EMR releases 4.x or later.<p></blockquote> This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurations(final software.amazon.awscdk.IResolvable configurations) {
            this.props.configurations(configurations);
            return this;
        }
        /**
         * <blockquote><p>Amazon EMR releases 4.x or later.<p></blockquote>
         * <p>
         * The list of configurations supplied for an Amazon EMR cluster instance group. You can specify a separate configuration for each instance group (master, core, and task).
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancegroupconfig.html#cfn-emr-instancegroupconfig-configurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancegroupconfig.html#cfn-emr-instancegroupconfig-configurations</a>
         * @param configurations <blockquote><p>Amazon EMR releases 4.x or later.<p></blockquote> This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurations(final java.util.List<? extends java.lang.Object> configurations) {
            this.props.configurations(configurations);
            return this;
        }

        /**
         * The custom AMI ID to use for the provisioned instance group.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancegroupconfig.html#cfn-emr-instancegroupconfig-customamiid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancegroupconfig.html#cfn-emr-instancegroupconfig-customamiid</a>
         * @param customAmiId The custom AMI ID to use for the provisioned instance group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customAmiId(final java.lang.String customAmiId) {
            this.props.customAmiId(customAmiId);
            return this;
        }

        /**
         * <code>EbsConfiguration</code> determines the EBS volumes to attach to EMR cluster instances.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancegroupconfig.html#cfn-emr-instancegroupconfig-ebsconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancegroupconfig.html#cfn-emr-instancegroupconfig-ebsconfiguration</a>
         * @param ebsConfiguration <code>EbsConfiguration</code> determines the EBS volumes to attach to EMR cluster instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ebsConfiguration(final software.amazon.awscdk.IResolvable ebsConfiguration) {
            this.props.ebsConfiguration(ebsConfiguration);
            return this;
        }
        /**
         * <code>EbsConfiguration</code> determines the EBS volumes to attach to EMR cluster instances.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancegroupconfig.html#cfn-emr-instancegroupconfig-ebsconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancegroupconfig.html#cfn-emr-instancegroupconfig-ebsconfiguration</a>
         * @param ebsConfiguration <code>EbsConfiguration</code> determines the EBS volumes to attach to EMR cluster instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ebsConfiguration(final software.amazon.awscdk.services.emr.CfnInstanceGroupConfig.EbsConfigurationProperty ebsConfiguration) {
            this.props.ebsConfiguration(ebsConfiguration);
            return this;
        }

        /**
         * Market type of the Amazon EC2 instances used to create a cluster node.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancegroupconfig.html#cfn-emr-instancegroupconfig-market">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancegroupconfig.html#cfn-emr-instancegroupconfig-market</a>
         * @param market Market type of the Amazon EC2 instances used to create a cluster node. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder market(final java.lang.String market) {
            this.props.market(market);
            return this;
        }

        /**
         * Friendly name given to the instance group.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancegroupconfig.html#cfn-emr-instancegroupconfig-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancegroupconfig.html#cfn-emr-instancegroupconfig-name</a>
         * @param name Friendly name given to the instance group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.emr.CfnInstanceGroupConfig}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.emr.CfnInstanceGroupConfig build() {
            return new software.amazon.awscdk.services.emr.CfnInstanceGroupConfig(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
