package software.amazon.awscdk.services.iam;

/**
 * Composite dependable.
 * <p>
 * Not as simple as eagerly getting the dependency roots from the
 * inner dependables, as they may be mutable so we need to defer
 * the query.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iam.*;
 * import software.constructs.*;
 * IDependable dependable;
 * CompositeDependable compositeDependable = new CompositeDependable(dependable);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:41.155Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iam.CompositeDependable")
public class CompositeDependable extends software.amazon.jsii.JsiiObject implements software.constructs.IDependable {

    protected CompositeDependable(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CompositeDependable(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param dependables This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CompositeDependable(final @org.jetbrains.annotations.NotNull software.constructs.IDependable... dependables) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.Arrays.<Object>stream(dependables).toArray(Object[]::new));
    }
}
