package software.amazon.awscdk.services.iam;

/**
 * The AWS::IAM::Policy resource associates an <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#inline">inline</a> IAM policy with IAM users, roles, or groups. For more information about IAM policies, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/policies_overview.html">Overview of IAM Policies</a> in the IAM User Guide guide.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Function postAuthFn;
 * UserPool userpool = UserPool.Builder.create(this, "myuserpool")
 *         .lambdaTriggers(UserPoolTriggers.builder()
 *                 .postAuthentication(postAuthFn)
 *                 .build())
 *         .build();
 * // provide permissions to describe the user pool scoped to the ARN the user pool
 * postAuthFn.role.attachInlinePolicy(Policy.Builder.create(this, "userpool-policy")
 *         .statements(List.of(PolicyStatement.Builder.create()
 *                 .actions(List.of("cognito-idp:DescribeUserPool"))
 *                 .resources(List.of(userpool.getUserPoolArn()))
 *                 .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:41.189Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iam.Policy")
public class Policy extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.iam.IPolicy, software.amazon.awscdk.services.iam.IGrantable {

    protected Policy(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Policy(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Policy(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.PolicyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Policy(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Import a policy in this app based on its name.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param policyName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPolicy fromPolicyName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String policyName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iam.Policy.class, "fromPolicyName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IPolicy.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(policyName, "policyName is required") });
    }

    /**
     * Adds a statement to the policy document.
     * <p>
     * @param statement This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addStatements(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement... statement) {
        software.amazon.jsii.Kernel.call(this, "addStatements", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(statement).toArray(Object[]::new));
    }

    /**
     * Attaches this policy to a group.
     * <p>
     * @param group This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void attachToGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGroup group) {
        software.amazon.jsii.Kernel.call(this, "attachToGroup", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(group, "group is required") });
    }

    /**
     * Attaches this policy to a role.
     * <p>
     * @param role This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void attachToRole(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole role) {
        software.amazon.jsii.Kernel.call(this, "attachToRole", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(role, "role is required") });
    }

    /**
     * Attaches this policy to a user.
     * <p>
     * @param user This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void attachToUser(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IUser user) {
        software.amazon.jsii.Kernel.call(this, "attachToUser", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(user, "user is required") });
    }

    /**
     * The policy document.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyDocument getDocument() {
        return software.amazon.jsii.Kernel.get(this, "document", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyDocument.class));
    }

    /**
     * The principal to grant permissions to.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
        return software.amazon.jsii.Kernel.get(this, "grantPrincipal", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IPrincipal.class));
    }

    /**
     * The name of this policy.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPolicyName() {
        return software.amazon.jsii.Kernel.get(this, "policyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iam.Policy}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iam.Policy> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.iam.PolicyProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * Initial PolicyDocument to use for this Policy.
         * <p>
         * If omited, any
         * <code>PolicyStatement</code> provided in the <code>statements</code> property will be applied
         * against the empty default <code>PolicyDocument</code>.
         * <p>
         * Default: - An empty policy.
         * <p>
         * @return {@code this}
         * @param document Initial PolicyDocument to use for this Policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder document(final software.amazon.awscdk.services.iam.PolicyDocument document) {
            this.props().document(document);
            return this;
        }

        /**
         * Force creation of an <code>AWS::IAM::Policy</code>.
         * <p>
         * Unless set to <code>true</code>, this <code>Policy</code> construct will not materialize to an
         * <code>AWS::IAM::Policy</code> CloudFormation resource in case it would have no effect
         * (for example, if it remains unattached to an IAM identity or if it has no
         * statements). This is generally desired behavior, since it prevents
         * creating invalid--and hence undeployable--CloudFormation templates.
         * <p>
         * In cases where you know the policy must be created and it is actually
         * an error if no statements have been added to it or it remains unattached to
         * an IAM identity, you can set this to <code>true</code>.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param force Force creation of an <code>AWS::IAM::Policy</code>. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder force(final java.lang.Boolean force) {
            this.props().force(force);
            return this;
        }

        /**
         * Groups to attach this policy to.
         * <p>
         * You can also use <code>attachToGroup(group)</code> to attach this policy to a group.
         * <p>
         * Default: - No groups.
         * <p>
         * @return {@code this}
         * @param groups Groups to attach this policy to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groups(final java.util.List<? extends software.amazon.awscdk.services.iam.IGroup> groups) {
            this.props().groups(groups);
            return this;
        }

        /**
         * The name of the policy.
         * <p>
         * If you specify multiple policies for an entity,
         * specify unique names. For example, if you specify a list of policies for
         * an IAM role, each policy must have a unique name.
         * <p>
         * Default: - Uses the logical ID of the policy resource, which is ensured
         * to be unique within the stack.
         * <p>
         * @return {@code this}
         * @param policyName The name of the policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyName(final java.lang.String policyName) {
            this.props().policyName(policyName);
            return this;
        }

        /**
         * Roles to attach this policy to.
         * <p>
         * You can also use <code>attachToRole(role)</code> to attach this policy to a role.
         * <p>
         * Default: - No roles.
         * <p>
         * @return {@code this}
         * @param roles Roles to attach this policy to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roles(final java.util.List<? extends software.amazon.awscdk.services.iam.IRole> roles) {
            this.props().roles(roles);
            return this;
        }

        /**
         * Initial set of permissions to add to this policy document.
         * <p>
         * You can also use <code>addStatements(...statement)</code> to add permissions later.
         * <p>
         * Default: - No statements.
         * <p>
         * @return {@code this}
         * @param statements Initial set of permissions to add to this policy document. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder statements(final java.util.List<? extends software.amazon.awscdk.services.iam.PolicyStatement> statements) {
            this.props().statements(statements);
            return this;
        }

        /**
         * Users to attach this policy to.
         * <p>
         * You can also use <code>attachToUser(user)</code> to attach this policy to a user.
         * <p>
         * Default: - No users.
         * <p>
         * @return {@code this}
         * @param users Users to attach this policy to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder users(final java.util.List<? extends software.amazon.awscdk.services.iam.IUser> users) {
            this.props().users(users);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.iam.Policy}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iam.Policy build() {
            return new software.amazon.awscdk.services.iam.Policy(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.iam.PolicyProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.iam.PolicyProps.Builder();
            }
            return this.props;
        }
    }
}
