package software.amazon.awscdk.services.iot;

/**
 * Properties for defining a <code>CfnSecurityProfile</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iot.*;
 * CfnSecurityProfileProps cfnSecurityProfileProps = CfnSecurityProfileProps.builder()
 *         .additionalMetricsToRetainV2(List.of(MetricToRetainProperty.builder()
 *                 .metric("metric")
 *                 // the properties below are optional
 *                 .exportMetric(false)
 *                 .metricDimension(MetricDimensionProperty.builder()
 *                         .dimensionName("dimensionName")
 *                         // the properties below are optional
 *                         .operator("operator")
 *                         .build())
 *                 .build()))
 *         .alertTargets(Map.of(
 *                 "alertTargetsKey", AlertTargetProperty.builder()
 *                         .alertTargetArn("alertTargetArn")
 *                         .roleArn("roleArn")
 *                         .build()))
 *         .behaviors(List.of(BehaviorProperty.builder()
 *                 .name("name")
 *                 // the properties below are optional
 *                 .criteria(BehaviorCriteriaProperty.builder()
 *                         .comparisonOperator("comparisonOperator")
 *                         .consecutiveDatapointsToAlarm(123)
 *                         .consecutiveDatapointsToClear(123)
 *                         .durationSeconds(123)
 *                         .mlDetectionConfig(MachineLearningDetectionConfigProperty.builder()
 *                                 .confidenceLevel("confidenceLevel")
 *                                 .build())
 *                         .statisticalThreshold(StatisticalThresholdProperty.builder()
 *                                 .statistic("statistic")
 *                                 .build())
 *                         .value(MetricValueProperty.builder()
 *                                 .cidrs(List.of("cidrs"))
 *                                 .count("count")
 *                                 .number(123)
 *                                 .numbers(List.of(123))
 *                                 .ports(List.of(123))
 *                                 .strings(List.of("strings"))
 *                                 .build())
 *                         .build())
 *                 .exportMetric(false)
 *                 .metric("metric")
 *                 .metricDimension(MetricDimensionProperty.builder()
 *                         .dimensionName("dimensionName")
 *                         // the properties below are optional
 *                         .operator("operator")
 *                         .build())
 *                 .suppressAlerts(false)
 *                 .build()))
 *         .metricsExportConfig(MetricsExportConfigProperty.builder()
 *                 .mqttTopic("mqttTopic")
 *                 .roleArn("roleArn")
 *                 .build())
 *         .securityProfileDescription("securityProfileDescription")
 *         .securityProfileName("securityProfileName")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .targetArns(List.of("targetArns"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:41.387Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnSecurityProfileProps")
@software.amazon.jsii.Jsii.Proxy(CfnSecurityProfileProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnSecurityProfileProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A list of metrics whose data is retained (stored).
     * <p>
     * By default, data is retained for any metric used in the profile's <code>behaviors</code> , but it's also retained for any metric specified here. Can be used with custom metrics; can't be used with dimensions.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html#cfn-iot-securityprofile-additionalmetricstoretainv2">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html#cfn-iot-securityprofile-additionalmetricstoretainv2</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAdditionalMetricsToRetainV2() {
        return null;
    }

    /**
     * Specifies the destinations to which alerts are sent.
     * <p>
     * (Alerts are always sent to the console.) Alerts are generated when a device (thing) violates a behavior.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html#cfn-iot-securityprofile-alerttargets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html#cfn-iot-securityprofile-alerttargets</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAlertTargets() {
        return null;
    }

    /**
     * Specifies the behaviors that, when violated by a device (thing), cause an alert.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html#cfn-iot-securityprofile-behaviors">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html#cfn-iot-securityprofile-behaviors</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getBehaviors() {
        return null;
    }

    /**
     * Specifies the MQTT topic and role ARN required for metric export.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html#cfn-iot-securityprofile-metricsexportconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html#cfn-iot-securityprofile-metricsexportconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMetricsExportConfig() {
        return null;
    }

    /**
     * A description of the security profile.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html#cfn-iot-securityprofile-securityprofiledescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html#cfn-iot-securityprofile-securityprofiledescription</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSecurityProfileDescription() {
        return null;
    }

    /**
     * The name you gave to the security profile.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html#cfn-iot-securityprofile-securityprofilename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html#cfn-iot-securityprofile-securityprofilename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSecurityProfileName() {
        return null;
    }

    /**
     * Metadata that can be used to manage the security profile.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html#cfn-iot-securityprofile-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html#cfn-iot-securityprofile-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The ARN of the target (thing group) to which the security profile is attached.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html#cfn-iot-securityprofile-targetarns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html#cfn-iot-securityprofile-targetarns</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTargetArns() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnSecurityProfileProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnSecurityProfileProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnSecurityProfileProps> {
        java.lang.Object additionalMetricsToRetainV2;
        java.lang.Object alertTargets;
        java.lang.Object behaviors;
        java.lang.Object metricsExportConfig;
        java.lang.String securityProfileDescription;
        java.lang.String securityProfileName;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.util.List<java.lang.String> targetArns;

        /**
         * Sets the value of {@link CfnSecurityProfileProps#getAdditionalMetricsToRetainV2}
         * @param additionalMetricsToRetainV2 A list of metrics whose data is retained (stored).
         *                                    By default, data is retained for any metric used in the profile's <code>behaviors</code> , but it's also retained for any metric specified here. Can be used with custom metrics; can't be used with dimensions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalMetricsToRetainV2(software.amazon.awscdk.IResolvable additionalMetricsToRetainV2) {
            this.additionalMetricsToRetainV2 = additionalMetricsToRetainV2;
            return this;
        }

        /**
         * Sets the value of {@link CfnSecurityProfileProps#getAdditionalMetricsToRetainV2}
         * @param additionalMetricsToRetainV2 A list of metrics whose data is retained (stored).
         *                                    By default, data is retained for any metric used in the profile's <code>behaviors</code> , but it's also retained for any metric specified here. Can be used with custom metrics; can't be used with dimensions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalMetricsToRetainV2(java.util.List<? extends java.lang.Object> additionalMetricsToRetainV2) {
            this.additionalMetricsToRetainV2 = additionalMetricsToRetainV2;
            return this;
        }

        /**
         * Sets the value of {@link CfnSecurityProfileProps#getAlertTargets}
         * @param alertTargets Specifies the destinations to which alerts are sent.
         *                     (Alerts are always sent to the console.) Alerts are generated when a device (thing) violates a behavior.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alertTargets(software.amazon.awscdk.IResolvable alertTargets) {
            this.alertTargets = alertTargets;
            return this;
        }

        /**
         * Sets the value of {@link CfnSecurityProfileProps#getAlertTargets}
         * @param alertTargets Specifies the destinations to which alerts are sent.
         *                     (Alerts are always sent to the console.) Alerts are generated when a device (thing) violates a behavior.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alertTargets(java.util.Map<java.lang.String, ? extends java.lang.Object> alertTargets) {
            this.alertTargets = alertTargets;
            return this;
        }

        /**
         * Sets the value of {@link CfnSecurityProfileProps#getBehaviors}
         * @param behaviors Specifies the behaviors that, when violated by a device (thing), cause an alert.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder behaviors(software.amazon.awscdk.IResolvable behaviors) {
            this.behaviors = behaviors;
            return this;
        }

        /**
         * Sets the value of {@link CfnSecurityProfileProps#getBehaviors}
         * @param behaviors Specifies the behaviors that, when violated by a device (thing), cause an alert.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder behaviors(java.util.List<? extends java.lang.Object> behaviors) {
            this.behaviors = behaviors;
            return this;
        }

        /**
         * Sets the value of {@link CfnSecurityProfileProps#getMetricsExportConfig}
         * @param metricsExportConfig Specifies the MQTT topic and role ARN required for metric export.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricsExportConfig(software.amazon.awscdk.IResolvable metricsExportConfig) {
            this.metricsExportConfig = metricsExportConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnSecurityProfileProps#getMetricsExportConfig}
         * @param metricsExportConfig Specifies the MQTT topic and role ARN required for metric export.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricsExportConfig(software.amazon.awscdk.services.iot.CfnSecurityProfile.MetricsExportConfigProperty metricsExportConfig) {
            this.metricsExportConfig = metricsExportConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnSecurityProfileProps#getSecurityProfileDescription}
         * @param securityProfileDescription A description of the security profile.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityProfileDescription(java.lang.String securityProfileDescription) {
            this.securityProfileDescription = securityProfileDescription;
            return this;
        }

        /**
         * Sets the value of {@link CfnSecurityProfileProps#getSecurityProfileName}
         * @param securityProfileName The name you gave to the security profile.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityProfileName(java.lang.String securityProfileName) {
            this.securityProfileName = securityProfileName;
            return this;
        }

        /**
         * Sets the value of {@link CfnSecurityProfileProps#getTags}
         * @param tags Metadata that can be used to manage the security profile.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnSecurityProfileProps#getTargetArns}
         * @param targetArns The ARN of the target (thing group) to which the security profile is attached.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetArns(java.util.List<java.lang.String> targetArns) {
            this.targetArns = targetArns;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnSecurityProfileProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnSecurityProfileProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnSecurityProfileProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnSecurityProfileProps {
        private final java.lang.Object additionalMetricsToRetainV2;
        private final java.lang.Object alertTargets;
        private final java.lang.Object behaviors;
        private final java.lang.Object metricsExportConfig;
        private final java.lang.String securityProfileDescription;
        private final java.lang.String securityProfileName;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.util.List<java.lang.String> targetArns;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.additionalMetricsToRetainV2 = software.amazon.jsii.Kernel.get(this, "additionalMetricsToRetainV2", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.alertTargets = software.amazon.jsii.Kernel.get(this, "alertTargets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.behaviors = software.amazon.jsii.Kernel.get(this, "behaviors", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.metricsExportConfig = software.amazon.jsii.Kernel.get(this, "metricsExportConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.securityProfileDescription = software.amazon.jsii.Kernel.get(this, "securityProfileDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.securityProfileName = software.amazon.jsii.Kernel.get(this, "securityProfileName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.targetArns = software.amazon.jsii.Kernel.get(this, "targetArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.additionalMetricsToRetainV2 = builder.additionalMetricsToRetainV2;
            this.alertTargets = builder.alertTargets;
            this.behaviors = builder.behaviors;
            this.metricsExportConfig = builder.metricsExportConfig;
            this.securityProfileDescription = builder.securityProfileDescription;
            this.securityProfileName = builder.securityProfileName;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.targetArns = builder.targetArns;
        }

        @Override
        public final java.lang.Object getAdditionalMetricsToRetainV2() {
            return this.additionalMetricsToRetainV2;
        }

        @Override
        public final java.lang.Object getAlertTargets() {
            return this.alertTargets;
        }

        @Override
        public final java.lang.Object getBehaviors() {
            return this.behaviors;
        }

        @Override
        public final java.lang.Object getMetricsExportConfig() {
            return this.metricsExportConfig;
        }

        @Override
        public final java.lang.String getSecurityProfileDescription() {
            return this.securityProfileDescription;
        }

        @Override
        public final java.lang.String getSecurityProfileName() {
            return this.securityProfileName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.util.List<java.lang.String> getTargetArns() {
            return this.targetArns;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAdditionalMetricsToRetainV2() != null) {
                data.set("additionalMetricsToRetainV2", om.valueToTree(this.getAdditionalMetricsToRetainV2()));
            }
            if (this.getAlertTargets() != null) {
                data.set("alertTargets", om.valueToTree(this.getAlertTargets()));
            }
            if (this.getBehaviors() != null) {
                data.set("behaviors", om.valueToTree(this.getBehaviors()));
            }
            if (this.getMetricsExportConfig() != null) {
                data.set("metricsExportConfig", om.valueToTree(this.getMetricsExportConfig()));
            }
            if (this.getSecurityProfileDescription() != null) {
                data.set("securityProfileDescription", om.valueToTree(this.getSecurityProfileDescription()));
            }
            if (this.getSecurityProfileName() != null) {
                data.set("securityProfileName", om.valueToTree(this.getSecurityProfileName()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTargetArns() != null) {
                data.set("targetArns", om.valueToTree(this.getTargetArns()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnSecurityProfileProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnSecurityProfileProps.Jsii$Proxy that = (CfnSecurityProfileProps.Jsii$Proxy) o;

            if (this.additionalMetricsToRetainV2 != null ? !this.additionalMetricsToRetainV2.equals(that.additionalMetricsToRetainV2) : that.additionalMetricsToRetainV2 != null) return false;
            if (this.alertTargets != null ? !this.alertTargets.equals(that.alertTargets) : that.alertTargets != null) return false;
            if (this.behaviors != null ? !this.behaviors.equals(that.behaviors) : that.behaviors != null) return false;
            if (this.metricsExportConfig != null ? !this.metricsExportConfig.equals(that.metricsExportConfig) : that.metricsExportConfig != null) return false;
            if (this.securityProfileDescription != null ? !this.securityProfileDescription.equals(that.securityProfileDescription) : that.securityProfileDescription != null) return false;
            if (this.securityProfileName != null ? !this.securityProfileName.equals(that.securityProfileName) : that.securityProfileName != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.targetArns != null ? this.targetArns.equals(that.targetArns) : that.targetArns == null;
        }

        @Override
        public final int hashCode() {
            int result = this.additionalMetricsToRetainV2 != null ? this.additionalMetricsToRetainV2.hashCode() : 0;
            result = 31 * result + (this.alertTargets != null ? this.alertTargets.hashCode() : 0);
            result = 31 * result + (this.behaviors != null ? this.behaviors.hashCode() : 0);
            result = 31 * result + (this.metricsExportConfig != null ? this.metricsExportConfig.hashCode() : 0);
            result = 31 * result + (this.securityProfileDescription != null ? this.securityProfileDescription.hashCode() : 0);
            result = 31 * result + (this.securityProfileName != null ? this.securityProfileName.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.targetArns != null ? this.targetArns.hashCode() : 0);
            return result;
        }
    }
}
