package software.amazon.awscdk.services.iotfleetwise;

/**
 * Properties for defining a <code>CfnStateTemplate</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotfleetwise.*;
 * CfnStateTemplateProps cfnStateTemplateProps = CfnStateTemplateProps.builder()
 *         .name("name")
 *         .signalCatalogArn("signalCatalogArn")
 *         .stateTemplateProperties(List.of("stateTemplateProperties"))
 *         // the properties below are optional
 *         .dataExtraDimensions(List.of("dataExtraDimensions"))
 *         .description("description")
 *         .metadataExtraDimensions(List.of("metadataExtraDimensions"))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-statetemplate.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-statetemplate.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:41.598Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotfleetwise.CfnStateTemplateProps")
@software.amazon.jsii.Jsii.Proxy(CfnStateTemplateProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnStateTemplateProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The unique alias of the state template.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-statetemplate.html#cfn-iotfleetwise-statetemplate-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-statetemplate.html#cfn-iotfleetwise-statetemplate-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The Amazon Resource Name (ARN) of the signal catalog associated with the state template.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-statetemplate.html#cfn-iotfleetwise-statetemplate-signalcatalogarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-statetemplate.html#cfn-iotfleetwise-statetemplate-signalcatalogarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSignalCatalogArn();

    /**
     * A list of signals from which data is collected.
     * <p>
     * The state template properties contain the fully qualified names of the signals.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-statetemplate.html#cfn-iotfleetwise-statetemplate-statetemplateproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-statetemplate.html#cfn-iotfleetwise-statetemplate-statetemplateproperties</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getStateTemplateProperties();

    /**
     * A list of vehicle attributes associated with the payload published on the state template's MQTT topic.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-statetemplate.html#cfn-iotfleetwise-statetemplate-dataextradimensions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-statetemplate.html#cfn-iotfleetwise-statetemplate-dataextradimensions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDataExtraDimensions() {
        return null;
    }

    /**
     * A brief description of the state template.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-statetemplate.html#cfn-iotfleetwise-statetemplate-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-statetemplate.html#cfn-iotfleetwise-statetemplate-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * A list of vehicle attributes to associate with the user properties of the messages published on the state template's MQTT topic.
     * <p>
     * For example, if you add <code>Vehicle.Attributes.Make</code> and <code>Vehicle.Attributes.Model</code> attributes, these attributes are included as user properties with the MQTT message.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-statetemplate.html#cfn-iotfleetwise-statetemplate-metadataextradimensions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-statetemplate.html#cfn-iotfleetwise-statetemplate-metadataextradimensions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getMetadataExtraDimensions() {
        return null;
    }

    /**
     * Metadata that can be used to manage the state template.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-statetemplate.html#cfn-iotfleetwise-statetemplate-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-statetemplate.html#cfn-iotfleetwise-statetemplate-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnStateTemplateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnStateTemplateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnStateTemplateProps> {
        java.lang.String name;
        java.lang.String signalCatalogArn;
        java.util.List<java.lang.String> stateTemplateProperties;
        java.util.List<java.lang.String> dataExtraDimensions;
        java.lang.String description;
        java.util.List<java.lang.String> metadataExtraDimensions;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnStateTemplateProps#getName}
         * @param name The unique alias of the state template. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnStateTemplateProps#getSignalCatalogArn}
         * @param signalCatalogArn The Amazon Resource Name (ARN) of the signal catalog associated with the state template. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder signalCatalogArn(java.lang.String signalCatalogArn) {
            this.signalCatalogArn = signalCatalogArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnStateTemplateProps#getStateTemplateProperties}
         * @param stateTemplateProperties A list of signals from which data is collected. This parameter is required.
         *                                The state template properties contain the fully qualified names of the signals.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stateTemplateProperties(java.util.List<java.lang.String> stateTemplateProperties) {
            this.stateTemplateProperties = stateTemplateProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnStateTemplateProps#getDataExtraDimensions}
         * @param dataExtraDimensions A list of vehicle attributes associated with the payload published on the state template's MQTT topic.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataExtraDimensions(java.util.List<java.lang.String> dataExtraDimensions) {
            this.dataExtraDimensions = dataExtraDimensions;
            return this;
        }

        /**
         * Sets the value of {@link CfnStateTemplateProps#getDescription}
         * @param description A brief description of the state template.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnStateTemplateProps#getMetadataExtraDimensions}
         * @param metadataExtraDimensions A list of vehicle attributes to associate with the user properties of the messages published on the state template's MQTT topic.
         *                                For example, if you add <code>Vehicle.Attributes.Make</code> and <code>Vehicle.Attributes.Model</code> attributes, these attributes are included as user properties with the MQTT message.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadataExtraDimensions(java.util.List<java.lang.String> metadataExtraDimensions) {
            this.metadataExtraDimensions = metadataExtraDimensions;
            return this;
        }

        /**
         * Sets the value of {@link CfnStateTemplateProps#getTags}
         * @param tags Metadata that can be used to manage the state template.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnStateTemplateProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnStateTemplateProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnStateTemplateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnStateTemplateProps {
        private final java.lang.String name;
        private final java.lang.String signalCatalogArn;
        private final java.util.List<java.lang.String> stateTemplateProperties;
        private final java.util.List<java.lang.String> dataExtraDimensions;
        private final java.lang.String description;
        private final java.util.List<java.lang.String> metadataExtraDimensions;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.signalCatalogArn = software.amazon.jsii.Kernel.get(this, "signalCatalogArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.stateTemplateProperties = software.amazon.jsii.Kernel.get(this, "stateTemplateProperties", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.dataExtraDimensions = software.amazon.jsii.Kernel.get(this, "dataExtraDimensions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.metadataExtraDimensions = software.amazon.jsii.Kernel.get(this, "metadataExtraDimensions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.signalCatalogArn = java.util.Objects.requireNonNull(builder.signalCatalogArn, "signalCatalogArn is required");
            this.stateTemplateProperties = java.util.Objects.requireNonNull(builder.stateTemplateProperties, "stateTemplateProperties is required");
            this.dataExtraDimensions = builder.dataExtraDimensions;
            this.description = builder.description;
            this.metadataExtraDimensions = builder.metadataExtraDimensions;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getSignalCatalogArn() {
            return this.signalCatalogArn;
        }

        @Override
        public final java.util.List<java.lang.String> getStateTemplateProperties() {
            return this.stateTemplateProperties;
        }

        @Override
        public final java.util.List<java.lang.String> getDataExtraDimensions() {
            return this.dataExtraDimensions;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.util.List<java.lang.String> getMetadataExtraDimensions() {
            return this.metadataExtraDimensions;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            data.set("signalCatalogArn", om.valueToTree(this.getSignalCatalogArn()));
            data.set("stateTemplateProperties", om.valueToTree(this.getStateTemplateProperties()));
            if (this.getDataExtraDimensions() != null) {
                data.set("dataExtraDimensions", om.valueToTree(this.getDataExtraDimensions()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getMetadataExtraDimensions() != null) {
                data.set("metadataExtraDimensions", om.valueToTree(this.getMetadataExtraDimensions()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotfleetwise.CfnStateTemplateProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnStateTemplateProps.Jsii$Proxy that = (CfnStateTemplateProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (!signalCatalogArn.equals(that.signalCatalogArn)) return false;
            if (!stateTemplateProperties.equals(that.stateTemplateProperties)) return false;
            if (this.dataExtraDimensions != null ? !this.dataExtraDimensions.equals(that.dataExtraDimensions) : that.dataExtraDimensions != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.metadataExtraDimensions != null ? !this.metadataExtraDimensions.equals(that.metadataExtraDimensions) : that.metadataExtraDimensions != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.signalCatalogArn.hashCode());
            result = 31 * result + (this.stateTemplateProperties.hashCode());
            result = 31 * result + (this.dataExtraDimensions != null ? this.dataExtraDimensions.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.metadataExtraDimensions != null ? this.metadataExtraDimensions.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
