package software.amazon.awscdk.services.kinesisfirehose;

/**
 * Common properties for defining a backup, intermediary, or final S3 destination for a Amazon Data Firehose delivery stream.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.kinesisfirehose.*;
 * import software.amazon.awscdk.services.kms.*;
 * Compression compression;
 * Key key;
 * Size size;
 * CommonDestinationS3Props commonDestinationS3Props = CommonDestinationS3Props.builder()
 *         .bufferingInterval(Duration.minutes(30))
 *         .bufferingSize(size)
 *         .compression(compression)
 *         .dataOutputPrefix("dataOutputPrefix")
 *         .encryptionKey(key)
 *         .errorOutputPrefix("errorOutputPrefix")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:42.064Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CommonDestinationS3Props")
@software.amazon.jsii.Jsii.Proxy(CommonDestinationS3Props.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CommonDestinationS3Props extends software.amazon.jsii.JsiiSerializable {

    /**
     * The length of time that Firehose buffers incoming data before delivering it to the S3 bucket.
     * <p>
     * Minimum: Duration.seconds(0)
     * Maximum: Duration.seconds(900)
     * <p>
     * Default: Duration.seconds(300)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getBufferingInterval() {
        return null;
    }

    /**
     * The size of the buffer that Amazon Data Firehose uses for incoming data before delivering it to the S3 bucket.
     * <p>
     * Minimum: Size.mebibytes(1)
     * Maximum: Size.mebibytes(128)
     * <p>
     * Default: Size.mebibytes(5)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Size getBufferingSize() {
        return null;
    }

    /**
     * The type of compression that Amazon Data Firehose uses to compress the data that it delivers to the Amazon S3 bucket.
     * <p>
     * The compression formats SNAPPY or ZIP cannot be specified for Amazon Redshift
     * destinations because they are not supported by the Amazon Redshift COPY operation
     * that reads from the S3 bucket.
     * <p>
     * Default: - UNCOMPRESSED
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisfirehose.Compression getCompression() {
        return null;
    }

    /**
     * A prefix that Amazon Data Firehose evaluates and adds to records before writing them to S3.
     * <p>
     * This prefix appears immediately following the bucket name.
     * <p>
     * Default: "YYYY/MM/DD/HH"
     * <p>
     * @see <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDataOutputPrefix() {
        return null;
    }

    /**
     * The AWS KMS key used to encrypt the data that it delivers to your Amazon S3 bucket.
     * <p>
     * Default: - Data is not encrypted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
        return null;
    }

    /**
     * A prefix that Amazon Data Firehose evaluates and adds to failed records before writing them to S3.
     * <p>
     * This prefix appears immediately following the bucket name.
     * <p>
     * Default: "YYYY/MM/DD/HH"
     * <p>
     * @see <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getErrorOutputPrefix() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CommonDestinationS3Props}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CommonDestinationS3Props}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CommonDestinationS3Props> {
        software.amazon.awscdk.Duration bufferingInterval;
        software.amazon.awscdk.Size bufferingSize;
        software.amazon.awscdk.services.kinesisfirehose.Compression compression;
        java.lang.String dataOutputPrefix;
        software.amazon.awscdk.services.kms.IKey encryptionKey;
        java.lang.String errorOutputPrefix;

        /**
         * Sets the value of {@link CommonDestinationS3Props#getBufferingInterval}
         * @param bufferingInterval The length of time that Firehose buffers incoming data before delivering it to the S3 bucket.
         *                          Minimum: Duration.seconds(0)
         *                          Maximum: Duration.seconds(900)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bufferingInterval(software.amazon.awscdk.Duration bufferingInterval) {
            this.bufferingInterval = bufferingInterval;
            return this;
        }

        /**
         * Sets the value of {@link CommonDestinationS3Props#getBufferingSize}
         * @param bufferingSize The size of the buffer that Amazon Data Firehose uses for incoming data before delivering it to the S3 bucket.
         *                      Minimum: Size.mebibytes(1)
         *                      Maximum: Size.mebibytes(128)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bufferingSize(software.amazon.awscdk.Size bufferingSize) {
            this.bufferingSize = bufferingSize;
            return this;
        }

        /**
         * Sets the value of {@link CommonDestinationS3Props#getCompression}
         * @param compression The type of compression that Amazon Data Firehose uses to compress the data that it delivers to the Amazon S3 bucket.
         *                    The compression formats SNAPPY or ZIP cannot be specified for Amazon Redshift
         *                    destinations because they are not supported by the Amazon Redshift COPY operation
         *                    that reads from the S3 bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compression(software.amazon.awscdk.services.kinesisfirehose.Compression compression) {
            this.compression = compression;
            return this;
        }

        /**
         * Sets the value of {@link CommonDestinationS3Props#getDataOutputPrefix}
         * @param dataOutputPrefix A prefix that Amazon Data Firehose evaluates and adds to records before writing them to S3.
         *                         This prefix appears immediately following the bucket name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataOutputPrefix(java.lang.String dataOutputPrefix) {
            this.dataOutputPrefix = dataOutputPrefix;
            return this;
        }

        /**
         * Sets the value of {@link CommonDestinationS3Props#getEncryptionKey}
         * @param encryptionKey The AWS KMS key used to encrypt the data that it delivers to your Amazon S3 bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionKey(software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        /**
         * Sets the value of {@link CommonDestinationS3Props#getErrorOutputPrefix}
         * @param errorOutputPrefix A prefix that Amazon Data Firehose evaluates and adds to failed records before writing them to S3.
         *                          This prefix appears immediately following the bucket name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder errorOutputPrefix(java.lang.String errorOutputPrefix) {
            this.errorOutputPrefix = errorOutputPrefix;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CommonDestinationS3Props}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CommonDestinationS3Props build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CommonDestinationS3Props}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CommonDestinationS3Props {
        private final software.amazon.awscdk.Duration bufferingInterval;
        private final software.amazon.awscdk.Size bufferingSize;
        private final software.amazon.awscdk.services.kinesisfirehose.Compression compression;
        private final java.lang.String dataOutputPrefix;
        private final software.amazon.awscdk.services.kms.IKey encryptionKey;
        private final java.lang.String errorOutputPrefix;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.bufferingInterval = software.amazon.jsii.Kernel.get(this, "bufferingInterval", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.bufferingSize = software.amazon.jsii.Kernel.get(this, "bufferingSize", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class));
            this.compression = software.amazon.jsii.Kernel.get(this, "compression", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.Compression.class));
            this.dataOutputPrefix = software.amazon.jsii.Kernel.get(this, "dataOutputPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.encryptionKey = software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.errorOutputPrefix = software.amazon.jsii.Kernel.get(this, "errorOutputPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bufferingInterval = builder.bufferingInterval;
            this.bufferingSize = builder.bufferingSize;
            this.compression = builder.compression;
            this.dataOutputPrefix = builder.dataOutputPrefix;
            this.encryptionKey = builder.encryptionKey;
            this.errorOutputPrefix = builder.errorOutputPrefix;
        }

        @Override
        public final software.amazon.awscdk.Duration getBufferingInterval() {
            return this.bufferingInterval;
        }

        @Override
        public final software.amazon.awscdk.Size getBufferingSize() {
            return this.bufferingSize;
        }

        @Override
        public final software.amazon.awscdk.services.kinesisfirehose.Compression getCompression() {
            return this.compression;
        }

        @Override
        public final java.lang.String getDataOutputPrefix() {
            return this.dataOutputPrefix;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
            return this.encryptionKey;
        }

        @Override
        public final java.lang.String getErrorOutputPrefix() {
            return this.errorOutputPrefix;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBufferingInterval() != null) {
                data.set("bufferingInterval", om.valueToTree(this.getBufferingInterval()));
            }
            if (this.getBufferingSize() != null) {
                data.set("bufferingSize", om.valueToTree(this.getBufferingSize()));
            }
            if (this.getCompression() != null) {
                data.set("compression", om.valueToTree(this.getCompression()));
            }
            if (this.getDataOutputPrefix() != null) {
                data.set("dataOutputPrefix", om.valueToTree(this.getDataOutputPrefix()));
            }
            if (this.getEncryptionKey() != null) {
                data.set("encryptionKey", om.valueToTree(this.getEncryptionKey()));
            }
            if (this.getErrorOutputPrefix() != null) {
                data.set("errorOutputPrefix", om.valueToTree(this.getErrorOutputPrefix()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CommonDestinationS3Props"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CommonDestinationS3Props.Jsii$Proxy that = (CommonDestinationS3Props.Jsii$Proxy) o;

            if (this.bufferingInterval != null ? !this.bufferingInterval.equals(that.bufferingInterval) : that.bufferingInterval != null) return false;
            if (this.bufferingSize != null ? !this.bufferingSize.equals(that.bufferingSize) : that.bufferingSize != null) return false;
            if (this.compression != null ? !this.compression.equals(that.compression) : that.compression != null) return false;
            if (this.dataOutputPrefix != null ? !this.dataOutputPrefix.equals(that.dataOutputPrefix) : that.dataOutputPrefix != null) return false;
            if (this.encryptionKey != null ? !this.encryptionKey.equals(that.encryptionKey) : that.encryptionKey != null) return false;
            return this.errorOutputPrefix != null ? this.errorOutputPrefix.equals(that.errorOutputPrefix) : that.errorOutputPrefix == null;
        }

        @Override
        public final int hashCode() {
            int result = this.bufferingInterval != null ? this.bufferingInterval.hashCode() : 0;
            result = 31 * result + (this.bufferingSize != null ? this.bufferingSize.hashCode() : 0);
            result = 31 * result + (this.compression != null ? this.compression.hashCode() : 0);
            result = 31 * result + (this.dataOutputPrefix != null ? this.dataOutputPrefix.hashCode() : 0);
            result = 31 * result + (this.encryptionKey != null ? this.encryptionKey.hashCode() : 0);
            result = 31 * result + (this.errorOutputPrefix != null ? this.errorOutputPrefix.hashCode() : 0);
            return result;
        }
    }
}
