package software.amazon.awscdk.services.lambda;

/**
 * Lambda service automatically captures logs generated by the function code (known as application logs) and sends these logs to a default CloudWatch log group named after the Lambda function.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.logs.ILogGroup;
 * ILogGroup logGroup;
 * Function.Builder.create(this, "Lambda")
 *         .code(new InlineCode("foo"))
 *         .handler("index.handler")
 *         .runtime(Runtime.NODEJS_18_X)
 *         .loggingFormat(LoggingFormat.JSON)
 *         .systemLogLevelV2(SystemLogLevel.INFO)
 *         .applicationLogLevelV2(ApplicationLogLevel.INFO)
 *         .logGroup(logGroup)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:42.196Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.ApplicationLogLevel")
public enum ApplicationLogLevel {
    /**
     * Lambda will capture only logs at info level.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    INFO,
    /**
     * Lambda will capture only logs at debug level.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DEBUG,
    /**
     * Lambda will capture only logs at warn level.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    WARN,
    /**
     * Lambda will capture only logs at trace level.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TRACE,
    /**
     * Lambda will capture only logs at error level.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ERROR,
    /**
     * Lambda will capture only logs at fatal level.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    FATAL,
}
