package software.amazon.awscdk.services.lambda;

/**
 * Properties for defining a <code>CfnCodeSigningConfig</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lambda.*;
 * CfnCodeSigningConfigProps cfnCodeSigningConfigProps = CfnCodeSigningConfigProps.builder()
 *         .allowedPublishers(AllowedPublishersProperty.builder()
 *                 .signingProfileVersionArns(List.of("signingProfileVersionArns"))
 *                 .build())
 *         // the properties below are optional
 *         .codeSigningPolicies(CodeSigningPoliciesProperty.builder()
 *                 .untrustedArtifactOnDeployment("untrustedArtifactOnDeployment")
 *                 .build())
 *         .description("description")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-codesigningconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-codesigningconfig.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:42.206Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.CfnCodeSigningConfigProps")
@software.amazon.jsii.Jsii.Proxy(CfnCodeSigningConfigProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnCodeSigningConfigProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * List of allowed publishers.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-codesigningconfig.html#cfn-lambda-codesigningconfig-allowedpublishers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-codesigningconfig.html#cfn-lambda-codesigningconfig-allowedpublishers</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getAllowedPublishers();

    /**
     * The code signing policy controls the validation failure action for signature mismatch or expiry.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-codesigningconfig.html#cfn-lambda-codesigningconfig-codesigningpolicies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-codesigningconfig.html#cfn-lambda-codesigningconfig-codesigningpolicies</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCodeSigningPolicies() {
        return null;
    }

    /**
     * Code signing configuration description.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-codesigningconfig.html#cfn-lambda-codesigningconfig-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-codesigningconfig.html#cfn-lambda-codesigningconfig-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * A list of tags to add to the code signing configuration.
     * <p>
     * <blockquote>
     * <p>
     * You must have the <code>lambda:TagResource</code> , <code>lambda:UntagResource</code> , and <code>lambda:ListTags</code> permissions for your <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html">IAM principal</a> to manage the AWS CloudFormation stack. If you don't have these permissions, there might be unexpected behavior with stack-level tags propagating to the resource during resource creation and update.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-codesigningconfig.html#cfn-lambda-codesigningconfig-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-codesigningconfig.html#cfn-lambda-codesigningconfig-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnCodeSigningConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnCodeSigningConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnCodeSigningConfigProps> {
        java.lang.Object allowedPublishers;
        java.lang.Object codeSigningPolicies;
        java.lang.String description;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnCodeSigningConfigProps#getAllowedPublishers}
         * @param allowedPublishers List of allowed publishers. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedPublishers(software.amazon.awscdk.IResolvable allowedPublishers) {
            this.allowedPublishers = allowedPublishers;
            return this;
        }

        /**
         * Sets the value of {@link CfnCodeSigningConfigProps#getAllowedPublishers}
         * @param allowedPublishers List of allowed publishers. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedPublishers(software.amazon.awscdk.services.lambda.CfnCodeSigningConfig.AllowedPublishersProperty allowedPublishers) {
            this.allowedPublishers = allowedPublishers;
            return this;
        }

        /**
         * Sets the value of {@link CfnCodeSigningConfigProps#getCodeSigningPolicies}
         * @param codeSigningPolicies The code signing policy controls the validation failure action for signature mismatch or expiry.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder codeSigningPolicies(software.amazon.awscdk.IResolvable codeSigningPolicies) {
            this.codeSigningPolicies = codeSigningPolicies;
            return this;
        }

        /**
         * Sets the value of {@link CfnCodeSigningConfigProps#getCodeSigningPolicies}
         * @param codeSigningPolicies The code signing policy controls the validation failure action for signature mismatch or expiry.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder codeSigningPolicies(software.amazon.awscdk.services.lambda.CfnCodeSigningConfig.CodeSigningPoliciesProperty codeSigningPolicies) {
            this.codeSigningPolicies = codeSigningPolicies;
            return this;
        }

        /**
         * Sets the value of {@link CfnCodeSigningConfigProps#getDescription}
         * @param description Code signing configuration description.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnCodeSigningConfigProps#getTags}
         * @param tags A list of tags to add to the code signing configuration.
         *             <blockquote>
         *             <p>
         *             You must have the <code>lambda:TagResource</code> , <code>lambda:UntagResource</code> , and <code>lambda:ListTags</code> permissions for your <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html">IAM principal</a> to manage the AWS CloudFormation stack. If you don't have these permissions, there might be unexpected behavior with stack-level tags propagating to the resource during resource creation and update.
         *             <p>
         *             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnCodeSigningConfigProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnCodeSigningConfigProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnCodeSigningConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnCodeSigningConfigProps {
        private final java.lang.Object allowedPublishers;
        private final java.lang.Object codeSigningPolicies;
        private final java.lang.String description;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.allowedPublishers = software.amazon.jsii.Kernel.get(this, "allowedPublishers", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.codeSigningPolicies = software.amazon.jsii.Kernel.get(this, "codeSigningPolicies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.allowedPublishers = java.util.Objects.requireNonNull(builder.allowedPublishers, "allowedPublishers is required");
            this.codeSigningPolicies = builder.codeSigningPolicies;
            this.description = builder.description;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getAllowedPublishers() {
            return this.allowedPublishers;
        }

        @Override
        public final java.lang.Object getCodeSigningPolicies() {
            return this.codeSigningPolicies;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("allowedPublishers", om.valueToTree(this.getAllowedPublishers()));
            if (this.getCodeSigningPolicies() != null) {
                data.set("codeSigningPolicies", om.valueToTree(this.getCodeSigningPolicies()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lambda.CfnCodeSigningConfigProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnCodeSigningConfigProps.Jsii$Proxy that = (CfnCodeSigningConfigProps.Jsii$Proxy) o;

            if (!allowedPublishers.equals(that.allowedPublishers)) return false;
            if (this.codeSigningPolicies != null ? !this.codeSigningPolicies.equals(that.codeSigningPolicies) : that.codeSigningPolicies != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.allowedPublishers.hashCode();
            result = 31 * result + (this.codeSigningPolicies != null ? this.codeSigningPolicies.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
