package software.amazon.awscdk.services.lambda;

/**
 * Result of the bind when an ECR image is used.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lambda.*;
 * CodeImageConfig codeImageConfig = CodeImageConfig.builder()
 *         .imageUri("imageUri")
 *         // the properties below are optional
 *         .cmd(List.of("cmd"))
 *         .entrypoint(List.of("entrypoint"))
 *         .workingDirectory("workingDirectory")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-09T19:59:42.268Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.CodeImageConfig")
@software.amazon.jsii.Jsii.Proxy(CodeImageConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CodeImageConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * URI to the Docker image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getImageUri();

    /**
     * Specify or override the CMD on the specified Docker image or Dockerfile.
     * <p>
     * This needs to be in the 'exec form', viz., <code>[ 'executable', 'param1', 'param2' ]</code>.
     * <p>
     * Default: - use the CMD specified in the docker image or Dockerfile.
     * <p>
     * @see <a href="https://docs.docker.com/engine/reference/builder/#cmd">https://docs.docker.com/engine/reference/builder/#cmd</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCmd() {
        return null;
    }

    /**
     * Specify or override the ENTRYPOINT on the specified Docker image or Dockerfile.
     * <p>
     * An ENTRYPOINT allows you to configure a container that will run as an executable.
     * This needs to be in the 'exec form', viz., <code>[ 'executable', 'param1', 'param2' ]</code>.
     * <p>
     * Default: - use the ENTRYPOINT in the docker image or Dockerfile.
     * <p>
     * @see <a href="https://docs.docker.com/engine/reference/builder/#entrypoint">https://docs.docker.com/engine/reference/builder/#entrypoint</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEntrypoint() {
        return null;
    }

    /**
     * Specify or override the WORKDIR on the specified Docker image or Dockerfile.
     * <p>
     * A WORKDIR allows you to configure the working directory the container will use.
     * <p>
     * Default: - use the WORKDIR in the docker image or Dockerfile.
     * <p>
     * @see <a href="https://docs.docker.com/engine/reference/builder/#workdir">https://docs.docker.com/engine/reference/builder/#workdir</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getWorkingDirectory() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CodeImageConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CodeImageConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CodeImageConfig> {
        java.lang.String imageUri;
        java.util.List<java.lang.String> cmd;
        java.util.List<java.lang.String> entrypoint;
        java.lang.String workingDirectory;

        /**
         * Sets the value of {@link CodeImageConfig#getImageUri}
         * @param imageUri URI to the Docker image. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageUri(java.lang.String imageUri) {
            this.imageUri = imageUri;
            return this;
        }

        /**
         * Sets the value of {@link CodeImageConfig#getCmd}
         * @param cmd Specify or override the CMD on the specified Docker image or Dockerfile.
         *            This needs to be in the 'exec form', viz., <code>[ 'executable', 'param1', 'param2' ]</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cmd(java.util.List<java.lang.String> cmd) {
            this.cmd = cmd;
            return this;
        }

        /**
         * Sets the value of {@link CodeImageConfig#getEntrypoint}
         * @param entrypoint Specify or override the ENTRYPOINT on the specified Docker image or Dockerfile.
         *                   An ENTRYPOINT allows you to configure a container that will run as an executable.
         *                   This needs to be in the 'exec form', viz., <code>[ 'executable', 'param1', 'param2' ]</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder entrypoint(java.util.List<java.lang.String> entrypoint) {
            this.entrypoint = entrypoint;
            return this;
        }

        /**
         * Sets the value of {@link CodeImageConfig#getWorkingDirectory}
         * @param workingDirectory Specify or override the WORKDIR on the specified Docker image or Dockerfile.
         *                         A WORKDIR allows you to configure the working directory the container will use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workingDirectory(java.lang.String workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CodeImageConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CodeImageConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CodeImageConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CodeImageConfig {
        private final java.lang.String imageUri;
        private final java.util.List<java.lang.String> cmd;
        private final java.util.List<java.lang.String> entrypoint;
        private final java.lang.String workingDirectory;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.imageUri = software.amazon.jsii.Kernel.get(this, "imageUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cmd = software.amazon.jsii.Kernel.get(this, "cmd", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.entrypoint = software.amazon.jsii.Kernel.get(this, "entrypoint", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.workingDirectory = software.amazon.jsii.Kernel.get(this, "workingDirectory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.imageUri = java.util.Objects.requireNonNull(builder.imageUri, "imageUri is required");
            this.cmd = builder.cmd;
            this.entrypoint = builder.entrypoint;
            this.workingDirectory = builder.workingDirectory;
        }

        @Override
        public final java.lang.String getImageUri() {
            return this.imageUri;
        }

        @Override
        public final java.util.List<java.lang.String> getCmd() {
            return this.cmd;
        }

        @Override
        public final java.util.List<java.lang.String> getEntrypoint() {
            return this.entrypoint;
        }

        @Override
        public final java.lang.String getWorkingDirectory() {
            return this.workingDirectory;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("imageUri", om.valueToTree(this.getImageUri()));
            if (this.getCmd() != null) {
                data.set("cmd", om.valueToTree(this.getCmd()));
            }
            if (this.getEntrypoint() != null) {
                data.set("entrypoint", om.valueToTree(this.getEntrypoint()));
            }
            if (this.getWorkingDirectory() != null) {
                data.set("workingDirectory", om.valueToTree(this.getWorkingDirectory()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lambda.CodeImageConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CodeImageConfig.Jsii$Proxy that = (CodeImageConfig.Jsii$Proxy) o;

            if (!imageUri.equals(that.imageUri)) return false;
            if (this.cmd != null ? !this.cmd.equals(that.cmd) : that.cmd != null) return false;
            if (this.entrypoint != null ? !this.entrypoint.equals(that.entrypoint) : that.entrypoint != null) return false;
            return this.workingDirectory != null ? this.workingDirectory.equals(that.workingDirectory) : that.workingDirectory == null;
        }

        @Override
        public final int hashCode() {
            int result = this.imageUri.hashCode();
            result = 31 * result + (this.cmd != null ? this.cmd.hashCode() : 0);
            result = 31 * result + (this.entrypoint != null ? this.entrypoint.hashCode() : 0);
            result = 31 * result + (this.workingDirectory != null ? this.workingDirectory.hashCode() : 0);
            return result;
        }
    }
}
